/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz62;
import asposewobfuscated.zz9X;
import asposewobfuscated.zzA0;
import asposewobfuscated.zzA2;
import asposewobfuscated.zzFD;
import asposewobfuscated.zzME;
import asposewobfuscated.zzT7;
import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.zz1R;
import java.io.EOFException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static zzFD zzZmk = new zzFD();
    private static zzFD zzZmj = new zzFD();
    private static zzFD zzZmi = new zzFD();
    private static zzFD zzZmh = new zzFD();
    private static zzFD zzZmg = new zzFD();
    private static zzFD zzZmf = new zzFD();

    private FileFormatUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzME.zzM(fileName, "fileName");
        zzA0 zzA02 = zzA2.zzXn(fileName);
        try {
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzZS(zzA02);
            return fileFormatInfo;
        }
        finally {
            if (zzA02 != null) {
                ((zz9X)zzA02).close();
            }
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzZS(zz62.zzY(stream));
    }

    static FileFormatInfo zzZS(zz9X zz9X2) throws Exception {
        if (zz9X2 == null) {
            throw new IllegalArgumentException("stream");
        }
        try {
            zz1R zz1R2 = new zz1R();
            return zz1R2.zzZU(zz9X2);
        }
        catch (Exception exception) {
            throw FileFormatUtil.zzY(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzIZ(zzT7.zzm(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzJ4(zzT7.zzm(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string = zzT7.zzY3(FileFormatUtil.zzJ2(loadFormat));
        if (zzME.zzZT(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzIZ(FileFormatUtil.zzJ1(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzJ4(FileFormatUtil.zzJ2(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzT7.zzY3(FileFormatUtil.zzJ1(saveFormat));
        if (zzME.zzZT(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new IllegalArgumentException("extension");
        }
        return FileFormatUtil.zzJ4(zzT7.zzl(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzT7.zzY3(FileFormatUtil.zzJ0(imageType));
    }

    static Exception zzY(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ParseException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzJ5(int n) {
        return zzT7.toString(FileFormatUtil.zzJ1(n));
    }

    static int zzJ4(int n) {
        Object object = zzZmg.get(n);
        return object == null ? 0 : (Integer)object;
    }

    static int zzJ3(int n) {
        Object object = zzZmf.get(n);
        return object != null ? (Integer)object : 1;
    }

    private static int zzJ2(int n) {
        Object object = zzZmk.get(n);
        return object == null ? 0 : (Integer)object;
    }

    static int zzJ1(int n) {
        Object object = zzZmj.get(n);
        return object == null ? 0 : (Integer)object;
    }

    private static int zzJ0(int n) {
        Object object = zzZmi.get(n);
        return object == null ? 0 : (Integer)object;
    }

    private static int zzIZ(int n) {
        Object object = zzZmh.get(n);
        return object == null ? 255 : (Integer)object;
    }

    private static void zzZ(Object ... objectArray) {
        for (int i = 0; i < objectArray.length; i += 4) {
            Object object = objectArray[i];
            Object object2 = objectArray[i + 1];
            Object object3 = objectArray[i + 2];
            Object object4 = objectArray[i + 3];
            if (object2 != null) {
                zzZmg.add((Integer)object, object2);
                zzZmj.add((Integer)object2, object);
            }
            if (object3 != null) {
                if (!zzZmh.contains((Integer)object)) {
                    zzZmh.add((Integer)object, object3);
                }
                zzZmk.add((Integer)object3, object);
            }
            if (object4 == null) continue;
            zzZmf.add((Integer)object, object4);
            zzZmi.add((Integer)object4, object);
        }
    }

    static {
        FileFormatUtil.zzZ(11, 10, 10, null, 11, null, 0, null, 12, 11, 11, null, 13, 20, 20, null, 13, null, 254, null, 14, 21, 21, null, 15, 22, 22, null, 16, 23, 23, null, 18, 24, 24, null, 19, 25, 25, null, 20, 26, 26, null, 21, 27, 27, null, 24, 30, 30, null, 17, 31, 31, null, 25, 50, 50, null, 26, 45, null, null, 27, 51, 51, null, 22, 60, 60, null, 23, 61, 61, null, 30, 40, null, null, 38, 47, null, null, 31, 41, null, null, 32, 46, null, null, 35, 42, null, null, 33, 43, null, null, 34, 44, null, null, 28, 52, null, null, 29, 70, 62, null, 36, 71, null, null, 8, 100, null, null, 6, 101, null, 6, 7, 102, null, 7, 5, 104, null, 5, 4, null, null, 4, 3, null, null, 3, 37, 72, null, null, 2, null, null, 2);
    }
}

