/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.asn1.sm2;

import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.sm2.TLV;
import cfca.sadk.org.bouncycastle.util.Arrays;
import cfca.sadk.org.bouncycastle.util.BigIntegers;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.util.Enumeration;

public final class ASN1SM2Signature
extends ASN1Object {
    private ASN1Integer r;
    private ASN1Integer s;

    public static ASN1SM2Signature getInstance(Object o) throws IllegalArgumentException {
        if (o == null) {
            throw new IllegalArgumentException("ASN1SM2Signature missing object for getInstance");
        }
        ASN1SM2Signature sign = o instanceof ASN1SM2Signature ? (ASN1SM2Signature)o : new ASN1SM2Signature(ASN1Sequence.getInstance(o));
        return sign;
    }

    public ASN1SM2Signature(BigInteger r, BigInteger s) {
        if (r == null) {
            throw new IllegalArgumentException("ASN1SM2Signature missing R:signR");
        }
        if (s == null) {
            throw new IllegalArgumentException("ASN1SM2Signature missing S:signS");
        }
        this.r = BigIntegers.formatXYRS(new ASN1Integer(r));
        this.s = BigIntegers.formatXYRS(new ASN1Integer(s));
    }

    public ASN1SM2Signature(ASN1Integer r, ASN1Integer s) {
        this.r = BigIntegers.formatXYRS(r);
        this.s = BigIntegers.formatXYRS(s);
    }

    public ASN1SM2Signature(ASN1Sequence seq) {
        this.decodedRS(seq);
    }

    public ASN1SM2Signature(byte[] signBytes) throws SecurityException {
        if (signBytes == null) {
            throw new SecurityException("ASN1SM2Signature signBytes missing");
        }
        if (signBytes.length < 58) {
            throw new SecurityException("ASN1SM2Signature signBytes required length>=58");
        }
        if (signBytes.length > 72) {
            throw new SecurityException("ASN1SM2Signature signBytes required length<=72");
        }
        if (ASN1SM2Signature.isASN1SignType(signBytes)) {
            ASN1InputStream asn1Is = null;
            ASN1Sequence seq = null;
            try {
                asn1Is = new ASN1InputStream(signBytes);
                seq = (ASN1Sequence)asn1Is.readObject();
            }
            catch (Exception e) {
                throw new SecurityException("ASN1SM2Signature Unknown  signature value:" + Hex.toHexString(signBytes), e);
            }
            finally {
                if (asn1Is != null) {
                    try {
                        asn1Is.close();
                    }
                    catch (Exception e) {}
                }
            }
            this.decodedRS(seq);
        } else if (signBytes.length == 64) {
            this.r = BigIntegers.formatXYRS(new ASN1Integer(Arrays.copyOfRange(signBytes, 0, 32)));
            this.s = BigIntegers.formatXYRS(new ASN1Integer(Arrays.copyOfRange(signBytes, 32, 64)));
        } else {
            throw new SecurityException("ASN1SM2Signature Unknown  signature value:" + Hex.toHexString(signBytes));
        }
    }

    private final void decodedRS(ASN1Sequence seq) {
        if (seq == null) {
            throw new IllegalArgumentException("ASN1SM2Signature missing seq");
        }
        if (seq.size() != 2) {
            throw new IllegalArgumentException("ASN1SM2Signature seq required size=2");
        }
        Enumeration e = seq.getObjects();
        this.r = BigIntegers.formatXYRS((ASN1Integer)e.nextElement());
        this.s = BigIntegers.formatXYRS((ASN1Integer)e.nextElement());
    }

    public static ASN1SM2Signature convertFrom64SignBytes(byte[] signBytes) {
        if (signBytes == null) {
            throw new IllegalArgumentException("ASN1SM2Signature signBytes missing");
        }
        if (signBytes.length != 64) {
            throw new IllegalArgumentException("ASN1SM2Signature signBytes required length=64");
        }
        ASN1Integer r = new ASN1Integer(Arrays.copyOfRange(signBytes, 0, 32));
        ASN1Integer s = new ASN1Integer(Arrays.copyOfRange(signBytes, 32, 64));
        return new ASN1SM2Signature(r, s);
    }

    public final byte[] getRSRaw64Bytes() {
        byte[] dest = new byte[64];
        System.arraycopy(BigIntegers.asUnsignedByteArray(32, this.r.getPositiveValue()), 0, dest, 0, 32);
        System.arraycopy(BigIntegers.asUnsignedByteArray(32, this.s.getPositiveValue()), 0, dest, 32, 32);
        return dest;
    }

    public ASN1Integer getR() {
        return this.r;
    }

    public ASN1Integer getS() {
        return this.s;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.r.formatToPositive(32));
        v.add(this.s.formatToPositive(32));
        return new DERSequence(v);
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("SM2Signature [r=");
        builder.append(this.r);
        builder.append(", s=");
        builder.append(this.s);
        builder.append(']');
        return builder.toString();
    }

    public static final boolean isASN1SignType(byte[] signBytes) {
        if (signBytes == null) {
            return false;
        }
        if (signBytes.length < 58 || signBytes.length > 80) {
            return false;
        }
        int offset = 0;
        TLV tlv = new TLV(signBytes, offset);
        if (tlv.failure || tlv.type != 48 || tlv.vLength < 56) {
            return false;
        }
        int maxLength = (offset += tlv.hLength) + tlv.vLength;
        if (signBytes.length != maxLength) {
            return false;
        }
        int num = 0;
        while (offset < maxLength) {
            tlv = new TLV(signBytes, offset);
            if (tlv.failure || tlv.type != 2 || tlv.vLength < 26) {
                return false;
            }
            offset += tlv.hLength;
            offset += tlv.vLength;
            if (++num != 2) continue;
        }
        return num == 2 && offset == maxLength;
    }
}

