/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.seal;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.ofd.base.asn1.SES_ESPictureInfo;
import cfca.sadk.ofd.base.asn1.SESeal;
import cfca.sadk.ofd.base.bean.appearance.GraphicAppearance;
import cfca.sadk.ofd.base.bean.appearance.TextAppearance;
import cfca.sadk.ofd.base.bean.attachments.Attachment;
import cfca.sadk.ofd.base.bean.attachments.Attachments;
import cfca.sadk.ofd.base.bean.signature.Provider;
import cfca.sadk.ofd.base.bean.signature.Reference;
import cfca.sadk.ofd.base.bean.signature.References;
import cfca.sadk.ofd.base.bean.signature.Seal;
import cfca.sadk.ofd.base.bean.signature.Signature;
import cfca.sadk.ofd.base.bean.signature.SignedInfo;
import cfca.sadk.ofd.base.bean.signature.StampAnnot;
import cfca.sadk.ofd.base.bean.signatures.Signatures;
import cfca.sadk.ofd.base.common.DateFormatUtil;
import cfca.sadk.ofd.base.common.Dom4jUtil;
import cfca.sadk.ofd.base.common.FileHashUtil;
import cfca.sadk.ofd.base.common.JaxbUtil;
import cfca.sadk.ofd.base.common.Matrix;
import cfca.sadk.ofd.base.common.MatrixUtil;
import cfca.sadk.ofd.base.common.MechanismUtil;
import cfca.sadk.ofd.base.common.ParamCheckUtil;
import cfca.sadk.ofd.base.common.StringUtil;
import cfca.sadk.ofd.base.common.XmlUtil;
import cfca.sadk.ofd.base.common.ZipUtil;
import cfca.sadk.ofd.base.config.SignAppearance;
import cfca.sadk.ofd.base.config.SignInfoConfig;
import cfca.sadk.ofd.base.exception.SealException;
import cfca.sadk.ofd.base.ofd.OFDConstants;
import cfca.sadk.ofd.base.ofd.Rectangle;
import cfca.sadk.ofd.util.SysEnv;
import cfca.sadk.org.bouncycastle.asn1.ASN1GeneralizedTime;
import cfca.sadk.org.bouncycastle.asn1.cms.Time;
import cfca.sadk.util.Base64;
import com.ibm.icu.text.SimpleDateFormat;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class SealXMLUtil {
    private static Logger businessLog = LoggerFactory.getLogger(SealXMLUtil.class);

    public static Element getDocument(Map<String, byte[]> filesMap, String baseDir) throws DocumentException {
        try {
            byte[] documentData = filesMap.get(baseDir + "Document.xml");
            Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(documentData));
            Element root = document.getRootElement();
            return root;
        }
        catch (Exception e) {
            throw new DocumentException("baseDir is " + baseDir, (Throwable)e);
        }
    }

    public static Element getCommonDocument(Map<String, byte[]> filesMap, String filePath) throws Exception {
        Element root = null;
        byte[] documentData = filesMap.get(filePath);
        if (null != documentData) {
            Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(documentData));
            root = document.getRootElement();
        }
        return root;
    }

    public static void updateOFD(Map<String, byte[]> filesMap, String OFDFileName, String signaturesValue) throws DocumentException, IOException {
        long updateOFDStart = System.currentTimeMillis();
        businessLog.info("update OFD.xml start...");
        Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(filesMap.get(OFDFileName)));
        Element root = document.getRootElement();
        Element body = root.element("DocBody");
        body.addElement("ofd:Signatures").setText(signaturesValue);
        ByteArrayOutputStream ofdStream = new ByteArrayOutputStream();
        XmlUtil.writeXml(document, ofdStream);
        filesMap.put(OFDFileName, ofdStream.toByteArray());
        long updateOFDEnd = System.currentTimeMillis();
        businessLog.info("update OFD.xml end...cost= " + (updateOFDEnd - updateOFDStart) + " ms");
    }

    public static String generateSiangtures(Map<String, byte[]> filesMap, String baseDir, String signaturesFileName, String defaultSignDir, String signatureFileName) throws SealException {
        long generateSigsStart = System.currentTimeMillis();
        businessLog.info("generate Signatures.xml start...");
        try {
            Signatures signatures = new Signatures();
            cfca.sadk.ofd.base.bean.signatures.Signature signature = new cfca.sadk.ofd.base.bean.signatures.Signature();
            signature.setID(new BigInteger("2"));
            signature.setType("Seal");
            signature.setBaseLoc(defaultSignDir + "2" + "/" + signatureFileName);
            signatures.setSignature(signature);
            signatures.setMaxSignId(new BigInteger("3"));
            ByteArrayOutputStream signaturesStream = new ByteArrayOutputStream();
            JaxbUtil.toXML(signatures, signaturesStream);
            filesMap.put(baseDir + signaturesFileName, signaturesStream.toByteArray());
            String string = "2";
            return string;
        }
        catch (Exception e) {
            businessLog.error("generateSiangtures failed", (Throwable)e);
            throw new SealException("generateSiangtures failed", e);
        }
        finally {
            long generateSigsEnd = System.currentTimeMillis();
            businessLog.info("generate Signatures.xml end...cost=" + (generateSigsEnd - generateSigsStart) + " ms");
        }
    }

    public static String updateSignatures(Map<String, byte[]> filesMap, String baseDir, String signaturesFileName, String newSignDir, String signatureFileName) throws SealException {
        long updateSignaturesStart = System.currentTimeMillis();
        businessLog.info("update signatures.xml start...");
        try {
            Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(filesMap.get(baseDir + signaturesFileName)));
            Element body = document.getRootElement();
            Element maxSignID = body.element("MaxSignId");
            String maxID = maxSignID.getStringValue();
            int newMaxID = Integer.parseInt(maxID) + 2;
            maxSignID.setText(String.valueOf(newMaxID));
            List list = body.elements("Signature");
            Element maxSig = (Element)list.get(list.size() - 1);
            String lastID = maxSig.attributeValue("ID");
            String lastBaseLoc = maxSig.attributeValue("BaseLoc");
            int sigNum = StringUtil.getSingleNum(lastBaseLoc);
            int newFileId = sigNum + 1;
            Element newSignature = body.addElement("ofd:Signature");
            newSignDir = lastBaseLoc.replaceAll(String.valueOf(sigNum), String.valueOf(newFileId));
            newSignature.addAttribute("ID", String.valueOf(Integer.parseInt(lastID) + 2));
            newSignature.addAttribute("Type", "Seal");
            newSignature.addAttribute("BaseLoc", newSignDir);
            ByteArrayOutputStream ofdStream = new ByteArrayOutputStream();
            XmlUtil.writeXml(document, ofdStream);
            filesMap.put(baseDir + signaturesFileName, ofdStream.toByteArray());
            String string = String.valueOf(newFileId);
            return string;
        }
        catch (Exception e) {
            businessLog.error("updateSignatures failed", (Throwable)e);
            throw new SealException("updateSignatures failed", e);
        }
        finally {
            long updateSignaturesEnd = System.currentTimeMillis();
            businessLog.info("update signatures.xml end...cost= " + (updateSignaturesEnd - updateSignaturesStart) + " ms");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HashMap<String, String> generateSignature(Map<String, byte[]> filesMap, Element root, Mechanism signAlg, SESeal eSseal, SignInfoConfig signInfo, SignAppearance appearance, String baseDir, String newSignDir, String signatureFileName, String signedValueFileName, Date signTime) throws SealException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        try {
            BigInteger id;
            List<Rectangle> keywordList;
            Map<String, String> pagesMap = SealXMLUtil.getPageRefIds(root, baseDir);
            Signature innerSignatue = new Signature();
            SignedInfo signedInfo = new SignedInfo();
            Provider provider = new Provider();
            provider.setCompany(appearance.getCompanyName());
            provider.setProviderName(appearance.getProviderName());
            provider.setVersion("3.0.0");
            signedInfo.setProvider(provider);
            String checkMethod = MechanismUtil.getDigestId(signAlg);
            String signedTime = null;
            if (SysEnv.getSignDateFormat() == 0) {
                ASN1GeneralizedTime newTime = new ASN1GeneralizedTime(signTime);
                signedTime = newTime.getTimeString();
            } else {
                DateFormatUtil formatUtil = new DateFormatUtil();
                signedTime = formatUtil.getSignTimeString(new Time(signTime).getDate());
            }
            String signatureMethod = MechanismUtil.getSignAlgId(signAlg);
            References references = new References();
            references.setCheckMethod(checkMethod);
            HashMap<String, String> fileHashMap = new HashMap<String, String>();
            long hashStart = System.currentTimeMillis();
            businessLog.info("calculateHash start...");
            for (Map.Entry<String, byte[]> entry : filesMap.entrySet()) {
                if (entry.getKey().contains("Sig")) continue;
                String hashValue = null;
                if (entry.getValue().length == 0) {
                    hashValue = "";
                } else {
                    byte[] oneEntryHash = FileHashUtil.calculateHash(entry.getValue(), signAlg, null);
                    hashValue = new String(Base64.encode((byte[])oneEntryHash), "UTF-8");
                }
                fileHashMap.put(entry.getKey(), hashValue);
            }
            long hashEnd = System.currentTimeMillis();
            businessLog.info("calculateHash end...cost=" + (hashEnd - hashStart) + " ms");
            for (Map.Entry entry : fileHashMap.entrySet()) {
                String fileRef = (String)entry.getKey();
                String checkValue = (String)entry.getValue();
                Reference reference = new Reference();
                reference.setFileRef("/" + fileRef);
                reference.setCheckValue(checkValue);
                references.getReference().add(reference);
            }
            signedInfo.setReferences(references);
            signedInfo.setSignatureDateTime(signedTime);
            signedInfo.setSignatureMethod(signatureMethod);
            long generateSignStart = System.currentTimeMillis();
            businessLog.info("generate Signature.xml start...");
            SES_ESPictureInfo picture = eSseal.getEsealInfo().getPicture();
            int height = appearance.getImageDisplayHeight();
            int width = appearance.getImageDisplayWidth();
            if (height <= 0) {
                height = picture.getHeight().getValue().intValue();
            }
            if (width <= 0) {
                width = picture.getWidth().getValue().intValue();
            }
            if (null == (keywordList = appearance.getKeywordLocationList()) || keywordList.isEmpty()) {
                if (appearance.isCrossSign()) {
                    int endPages;
                    if (appearance.getCrossStyle() != 6) throw new SealException("Only RIGHT_STRIPE is supported!");
                    id = SealXMLUtil.getMaxDataId(root, baseDir);
                    int totalPages = SealXMLUtil.getTotalPages(root);
                    int startPage = appearance.getStartPage();
                    ParamCheckUtil.checkPageNum(startPage, totalPages);
                    if (startPage >= 1) {
                        --startPage;
                    }
                    if ((endPages = appearance.getEndPage()) == -1) {
                        endPages = totalPages;
                    }
                    ParamCheckUtil.checkPageNum(endPages, totalPages);
                    if (startPage == endPages) {
                        throw new IllegalArgumentException("start page is equals to end page.");
                    }
                    int pages = endPages - startPage;
                    Rectangle pageSize = SealXMLUtil.getPageSize(filesMap, startPage + 1, baseDir);
                    float pageWidth = pageSize.getWidth();
                    int singleWidth = width / pages;
                    int remainder = width % pages;
                    float sumOffset = 0.0f;
                    int times = 0;
                    for (int i = startPage; i < endPages; ++i) {
                        float clipWidth = singleWidth;
                        if (times < remainder) {
                            clipWidth = 1 + singleWidth;
                            ++times;
                        }
                        sumOffset += clipWidth;
                        float offsetY = appearance.getY();
                        if (offsetY < 0.0f || offsetY + (float)height > pageSize.getHeight()) {
                            throw new IllegalArgumentException("The coordinates need to be within the range of the page: offsetY= " + offsetY);
                        }
                        StampAnnot stampAnnot = new StampAnnot();
                        String boundary = pageWidth - sumOffset + " " + appearance.getY() + " " + width + " " + height;
                        String pageRefID = pagesMap.get("Pages/Page_" + i + "/Content.xml");
                        if (null == pageRefID) {
                            String pageIDString = String.valueOf(i);
                            if (!pagesMap.containsValue(pageIDString)) throw new SealException("pageNo= " + (i + 1) + " is not exists!");
                            pageRefID = pageIDString;
                        }
                        BigInteger pageRef = new BigInteger(pageRefID);
                        stampAnnot.setID(id);
                        stampAnnot.setPageRef(pageRef);
                        stampAnnot.setBoundary(boundary);
                        stampAnnot.setAlpha(BigInteger.valueOf(appearance.getAlpha()));
                        String clip = sumOffset - clipWidth + " " + "0" + " " + clipWidth + " " + height;
                        stampAnnot.setClip(clip);
                        signedInfo.getStampAnnot().add(stampAnnot);
                        id = OFDConstants.interval.add(id);
                    }
                } else {
                    StampAnnot stampAnnot = new StampAnnot();
                    String boundary = appearance.getX() + " " + appearance.getY() + " " + width + " " + height;
                    BigInteger id2 = new BigInteger(appearance.getId());
                    String pageRefID = pagesMap.get("Pages/Page_" + (appearance.getPageNo() - 1) + "/Content.xml");
                    if (null == pageRefID) {
                        String pageIDString = String.valueOf(appearance.getPageNo());
                        if (!pagesMap.containsValue(pageIDString)) throw new SealException("pageNo= " + appearance.getPageNo() + " is not exists!");
                        pageRefID = pageIDString;
                    }
                    BigInteger pageRef = new BigInteger(pageRefID);
                    stampAnnot.setID(id2);
                    stampAnnot.setPageRef(pageRef);
                    stampAnnot.setBoundary(boundary);
                    stampAnnot.setAlpha(BigInteger.valueOf(appearance.getAlpha()));
                    String clip = "0 0 " + width + " " + height;
                    stampAnnot.setClip(clip);
                    signedInfo.getStampAnnot().add(stampAnnot);
                }
            } else {
                id = new BigInteger(appearance.getId());
                for (int i = 0; i < keywordList.size(); ++i) {
                    float offsetY;
                    Rectangle rect = keywordList.get(i);
                    StampAnnot stampAnnot = new StampAnnot();
                    float offsetX = 0.0f;
                    if (rect.getWidth() > 0.0f) {
                        offsetX = (float)width - rect.getWidth();
                    }
                    if ((offsetY = (float)height - rect.getHeight()) < 0.0f) {
                        offsetY = Math.abs(offsetY);
                    }
                    float realRectX = rect.getX() - offsetX / 2.0f;
                    float realRectY = rect.getY() - offsetY / 2.0f;
                    String boundary = (realRectX += appearance.getOffsetX()) + " " + (realRectY += appearance.getOffsetY()) + " " + width + " " + height;
                    String filePath = rect.getPageFilePath();
                    if (filePath != null && filePath.isEmpty()) {
                        filePath = "Pages/Page_" + (rect.getPageNum() - 1) + "/Content.xml";
                    }
                    String pageRefID = String.valueOf(rect.getPageNum());
                    BigInteger pageRef = new BigInteger(pageRefID);
                    stampAnnot.setID(id);
                    stampAnnot.setPageRef(pageRef);
                    stampAnnot.setBoundary(boundary);
                    stampAnnot.setAlpha(BigInteger.valueOf(appearance.getAlpha()));
                    String clip = "0 0 " + width + " " + height;
                    stampAnnot.setClip(clip);
                    signedInfo.getStampAnnot().add(stampAnnot);
                    id = OFDConstants.interval.add(id);
                }
            }
            int spec = signInfo.getSpecification();
            if (spec != -1 && spec != 3 || !SysEnv.isForTax()) {
                Seal seal = new Seal();
                seal.setBaseLoc("Seal.esl");
                signedInfo.setSeal(seal);
            }
            innerSignatue.setSignedInfo(signedInfo);
            innerSignatue.setSignedValue(signedValueFileName);
            String sourcePropertyPath = newSignDir + signatureFileName;
            String signaturePath = baseDir + sourcePropertyPath;
            ByteArrayOutputStream signatureStream = new ByteArrayOutputStream();
            JaxbUtil.toXML(innerSignatue, signatureStream);
            byte[] signDatas = signatureStream.toByteArray();
            filesMap.put(signaturePath, signDatas);
            signInfo.setSignedNum(signedInfo.getStampAnnot().size());
            resultMap.put("sourceProperty", "/" + signaturePath);
            resultMap.put("signaturePath", signaturePath);
            long generateSignEnd = System.currentTimeMillis();
            businessLog.info("generate Signature.xml end...cost=" + (generateSignEnd - generateSignStart) + " ms");
            return resultMap;
        }
        catch (SealException e) {
            businessLog.error("generate Signature.xml failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("generate Signature.xml failed", (Throwable)e);
            throw new SealException("generate Signature.xml failed", e);
        }
    }

    public static Element getDocumentRes(Map<String, byte[]> filesMap, String baseDir) throws DocumentException {
        Element rootElement = null;
        byte[] fileData = filesMap.get(baseDir + "DocumentRes.xml");
        if (fileData != null) {
            Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(fileData));
            rootElement = document.getRootElement();
        } else {
            rootElement = SealXMLUtil.getPublicRes(filesMap, baseDir);
        }
        return rootElement;
    }

    public static Element getPublicRes(Map<String, byte[]> filesMap, String baseDir) throws DocumentException {
        Element rootElement = null;
        byte[] fileData = filesMap.get(baseDir + "PublicRes.xml");
        if (fileData != null) {
            Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(fileData));
            rootElement = document.getRootElement();
        }
        return rootElement;
    }

    public static void updateDocumentRes(Map<String, byte[]> filesMap, String OFDFileName, String imageFileName, BigInteger maxID) throws DocumentException, IOException {
        Document document;
        Element root;
        Element body;
        long updateOFDStart = System.currentTimeMillis();
        businessLog.info("update OFD.xml start...");
        byte[] fileData = filesMap.get(OFDFileName);
        if (null == fileData) {
            fileData = filesMap.get(OFDFileName.replaceAll("PublicRes.xml", "DocumentRes.xml"));
        }
        if (null == (body = (root = (document = Dom4jUtil.parseFile(new ByteArrayInputStream(fileData))).getRootElement()).element("MultiMedias"))) {
            body = root.addElement("MultiMedias");
        }
        Element multiMedia = body.addElement("ofd:MultiMedia");
        multiMedia.addElement("ofd:MediaFile").setText(imageFileName);
        multiMedia.addAttribute("ID", maxID.toString());
        multiMedia.addAttribute("Type", "Image");
        ByteArrayOutputStream ofdStream = new ByteArrayOutputStream();
        XmlUtil.writeXml(document, ofdStream);
        filesMap.put(OFDFileName, ofdStream.toByteArray());
        long updateOFDEnd = System.currentTimeMillis();
        businessLog.info("update OFD.xml end...cost= " + (updateOFDEnd - updateOFDStart) + " ms");
    }

    public static void updateDocumentResFont(Map<String, byte[]> filesMap, String OFDFileName, String fontFileName, String fontName, BigInteger maxID) throws DocumentException, IOException {
        Document document;
        Element root;
        Element body;
        long updateOFDStart = System.currentTimeMillis();
        businessLog.info("update OFD.xml start...");
        byte[] fileData = filesMap.get(OFDFileName);
        if (null == fileData) {
            fileData = filesMap.get(OFDFileName.replaceAll("PublicRes.xml", "DocumentRes.xml"));
        }
        if (null == (body = (root = (document = Dom4jUtil.parseFile(new ByteArrayInputStream(fileData))).getRootElement()).element("Fonts"))) {
            body = root.addElement("Fonts");
        }
        Element multiMedia = body.addElement("ofd:Font");
        multiMedia.addElement("ofd:FontFile").setText(fontFileName);
        multiMedia.addAttribute("ID", maxID.toString());
        multiMedia.addAttribute("FontName", fontName);
        ByteArrayOutputStream ofdStream = new ByteArrayOutputStream();
        XmlUtil.writeXml(document, ofdStream);
        filesMap.put(OFDFileName, ofdStream.toByteArray());
        long updateOFDEnd = System.currentTimeMillis();
        businessLog.info("update OFD.xml end...cost= " + (updateOFDEnd - updateOFDStart) + " ms");
    }

    public static BigInteger getMaxDataId(Element root, String baseDir) throws DocumentException {
        Element body = root.element("CommonData");
        String maxID = body.element("MaxUnitID").getStringValue();
        BigInteger id = new BigInteger(maxID);
        return id.add(OFDConstants.interval);
    }

    public static void updateMaxDataId(Element root, String baseDir, BigInteger newMaxId) throws DocumentException {
        Element body = root.element("CommonData");
        body.element("MaxUnitID").setText(newMaxId.toString());
    }

    public static Map<String, String> getPageRefIds(Element root, String baseDir) throws DocumentException {
        long updateOFDStart = System.currentTimeMillis();
        businessLog.info("getPageRefIds start...");
        HashMap<String, String> pageInfoMap = new HashMap<String, String>();
        Element body = root.element("Pages");
        List pageList = body.elements("Page");
        for (int i = 0; i < pageList.size(); ++i) {
            Element element = (Element)pageList.get(i);
            String pagePath = element.attributeValue("BaseLoc");
            String pageID = element.attributeValue("ID");
            pageInfoMap.put(pagePath, pageID);
        }
        long updateOFDEnd = System.currentTimeMillis();
        businessLog.info("getPageRefIds cost=" + (updateOFDEnd - updateOFDStart) + " ms");
        return pageInfoMap;
    }

    public static Map<String, String> getPageIds(Element root, String baseDir) throws DocumentException {
        long updateOFDStart = System.currentTimeMillis();
        businessLog.info("getPageRefIds start...");
        HashMap<String, String> pageInfoMap = new HashMap<String, String>();
        Element body = root.element("Pages");
        List pageList = body.elements("Page");
        for (int i = 0; i < pageList.size(); ++i) {
            Element element = (Element)pageList.get(i);
            String pagePath = element.attributeValue("BaseLoc");
            int pageNo = StringUtil.getSingleNum(pagePath);
            String pageID = element.attributeValue("ID");
            pageInfoMap.put(pageID, String.valueOf(pageNo + 1));
        }
        long updateOFDEnd = System.currentTimeMillis();
        businessLog.info("getPageRefIds cost=" + (updateOFDEnd - updateOFDStart) + " ms");
        return pageInfoMap;
    }

    public static Map<String, String> getPageRefIds(Map<String, byte[]> filesMap, String baseDir) throws DocumentException {
        byte[] documentData = filesMap.get(baseDir + "Document.xml");
        Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(documentData));
        Element root = document.getRootElement();
        return SealXMLUtil.getPageRefIds(root, baseDir);
    }

    public static Map<String, String> getTemplates(Element root, String baseDir) throws DocumentException {
        List pageList1;
        long updateOFDStart = System.currentTimeMillis();
        businessLog.info("getTemplates start...");
        HashMap<String, String> pageInfoMap = new HashMap<String, String>();
        Element body1 = root.element("CommonData");
        if (body1 != null && (pageList1 = body1.elements("TemplatePage")) != null) {
            for (int i = 0; i < pageList1.size(); ++i) {
                Element element = (Element)pageList1.get(i);
                String pagePath = element.attributeValue("BaseLoc");
                String id = element.attributeValue("ID");
                String realPath = pagePath.replace("/Doc_0/", "");
                pageInfoMap.put(id, realPath);
            }
        }
        long updateOFDEnd = System.currentTimeMillis();
        businessLog.info("getTemplates cost=" + (updateOFDEnd - updateOFDStart) + " ms");
        return pageInfoMap;
    }

    public static void addImageObject(Map<String, byte[]> filesMap, String OFDFileName, BigInteger resID, BigInteger maxID, GraphicAppearance appearance) throws DocumentException, IOException, SealException {
        int alpha;
        Rectangle boundary;
        Element imageObj;
        Document document;
        long updateOFDStart = System.currentTimeMillis();
        businessLog.info("update Content.xml start...");
        byte[] fileData = filesMap.get(OFDFileName);
        if (fileData != null) {
            document = Dom4jUtil.parseFile(new ByteArrayInputStream(fileData));
            Element root = document.getRootElement();
            Element body = root.element("Content");
            Element layer = body.element("Layer");
            imageObj = layer.addElement("ofd:ImageObject");
            boundary = appearance.getBoundary();
            alpha = appearance.getAlpha();
            BigInteger layerID = maxID.add(OFDConstants.interval);
            imageObj.addAttribute("ID", layerID.add(OFDConstants.interval).toString());
            double rotation = appearance.getRotation();
            if (rotation == 0.0) {
                imageObj.addAttribute("CTM", boundary.getWidth() + " " + "0" + " " + "0" + " " + boundary.getHeight() + " " + "0" + " " + "0");
            } else {
                double offsetX = 0.0;
                double offsetY = 0.0;
                if (rotation > Math.PI || rotation < -Math.PI) {
                    throw new SealException("rotation must less than Math.PI or use negative rotation instead!");
                }
                if (rotation == 1.5707963267948966) {
                    float reverseHeight = boundary.getWidth();
                    float reverseWidth = boundary.getHeight();
                    boundary.setHeight(reverseHeight);
                    boundary.setWidth(reverseWidth);
                    offsetX = -1.0;
                    offsetY = -1.0;
                } else if (rotation == Math.PI) {
                    offsetX = 1.0;
                    offsetY = -1.5;
                }
                double sinValue = Math.sin(rotation);
                double cosValue = Math.cos(rotation);
                float originWidth = boundary.getWidth();
                float originHeight = boundary.getHeight();
                double rotationWidth = (double)originWidth * (sinValue + cosValue);
                double rotationHeight = (double)originHeight * (sinValue + cosValue);
                double e = rotationWidth / 2.0 - ((double)originWidth * cosValue - (double)(originWidth / 2.0f)) + offsetX;
                double f = -rotationHeight / 2.0 + (double)(originHeight / 2.0f) + offsetY;
                Matrix matrix = MatrixUtil.calculate(originWidth, originHeight, rotation);
                imageObj.addAttribute("CTM", matrix.get(0) + " " + matrix.get(1) + " " + matrix.get(3) + " " + matrix.get(4) + " " + e + " " + f);
            }
        } else {
            throw new SealException(OFDFileName + " is not exist!");
        }
        imageObj.addAttribute("Boundary", boundary.toBoundery());
        imageObj.addAttribute("Alpha", String.valueOf(alpha));
        imageObj.addAttribute("ResourceID", resID.toString());
        ByteArrayOutputStream ofdStream = new ByteArrayOutputStream();
        XmlUtil.writeXml(document, ofdStream);
        filesMap.put(OFDFileName, ofdStream.toByteArray());
        long updateOFDEnd = System.currentTimeMillis();
        businessLog.info("update Content.xml end...cost= " + (updateOFDEnd - updateOFDStart) + " ms");
    }

    public static void addTextObject(Map<String, byte[]> filesMap, String OFDFileName, BigInteger resID, BigInteger maxID, TextAppearance appearance) throws DocumentException, IOException, SealException {
        StringBuilder deltaX;
        Element textCode;
        Document document;
        long updateOFDStart = System.currentTimeMillis();
        businessLog.info("update Content.xml start...");
        byte[] fileData = filesMap.get(OFDFileName);
        if (fileData != null) {
            Color fontColor;
            document = Dom4jUtil.parseFile(new ByteArrayInputStream(fileData));
            Element root = document.getRootElement();
            Element body = root.element("Content");
            Element layer = body.element("Layer");
            Element textObj = layer.addElement("ofd:TextObject");
            Rectangle boundary = appearance.getBoundary();
            int alpha = appearance.getAlpha();
            BigInteger layerID = maxID.add(OFDConstants.interval);
            float fontSize = appearance.getFontSize();
            if (fontSize <= 0.0f) {
                throw new IllegalArgumentException("fontSize is null");
            }
            int wordCount = appearance.getFontFileWordCount();
            if (fontSize * (float)wordCount > boundary.getWidth()) {
                fontSize = boundary.getWidth() / (float)wordCount;
            }
            if (null == (fontColor = appearance.getFontColor())) {
                throw new IllegalArgumentException("fontColor is null");
            }
            textObj.addAttribute("ID", layerID.add(OFDConstants.interval).toString());
            double rotation = appearance.getRotation();
            if (rotation != 0.0) {
                if (rotation > Math.PI || rotation < -Math.PI) {
                    throw new SealException("rotation must less than Math.PI or use negative rotation instead!");
                }
                if (rotation == 1.5707963267948966) {
                    float reverseHeight = boundary.getWidth();
                    float reverseWidth = boundary.getHeight();
                    boundary.setHeight(reverseHeight);
                    boundary.setWidth(reverseWidth);
                }
                double sinValue = Math.sin(rotation);
                double cosValue = Math.cos(rotation);
                double offsetX = (double)boundary.getHeight() * Math.sin(Math.abs(rotation));
                double newWidth = (double)boundary.getWidth() * (1.0 + Math.sin(Math.abs(rotation)));
                double f = 0.0;
                double e = offsetX;
                if (rotation < 0.0) {
                    f = (double)boundary.getWidth() * Math.sin(Math.abs(rotation));
                    e = 0.0;
                }
                boundary.setWidth((float)newWidth);
                boundary.setHeight((float)newWidth);
                textObj.addAttribute("CTM", cosValue + " " + sinValue + " " + -sinValue + " " + cosValue + " " + e + " " + f);
            }
            textObj.addAttribute("Boundary", boundary.toBoundery());
            textObj.addAttribute("Font", String.valueOf(appearance.getFontID()));
            textObj.addAttribute("Bold", String.valueOf(appearance.isBold()));
            textObj.addAttribute("Italic", String.valueOf(appearance.isItalic()));
            textObj.addAttribute("Size", String.valueOf(fontSize));
            Element fillColor = textObj.addElement("ofd:FillColor");
            fillColor.addAttribute("Value", fontColor.getRed() + " " + fontColor.getGreen() + " " + fontColor.getBlue());
            fillColor.addAttribute("Alpha", String.valueOf(alpha));
            Element cgTransformEl = textObj.addElement("ofd:CGTransformEl");
            cgTransformEl.addAttribute("CodePosition", "0");
            String wordCountStr = String.valueOf(wordCount);
            cgTransformEl.addAttribute("CodeCount", wordCountStr);
            cgTransformEl.addAttribute("GlyphCount", wordCountStr);
            Element glyphsEl = cgTransformEl.addElement("ofd:GlyphsEl");
            glyphsEl.setText(appearance.getGlyphs());
            textCode = textObj.addElement("ofd:TextCode");
            textCode.addAttribute("X", appearance.getStartX());
            textCode.addAttribute("Y", appearance.getStartY());
            deltaX = new StringBuilder();
            for (int i = 0; i < wordCount - 1; ++i) {
                if (i == wordCount - 2) {
                    deltaX.append(fontSize);
                    continue;
                }
                deltaX.append(fontSize + " ");
            }
        } else {
            throw new SealException(OFDFileName + " is not exist!");
        }
        textCode.addAttribute("DeltaX", deltaX.toString());
        textCode.setText(appearance.getContent());
        ByteArrayOutputStream ofdStream = new ByteArrayOutputStream();
        XmlUtil.writeXml(document, ofdStream);
        filesMap.put(OFDFileName, ofdStream.toByteArray());
        long updateOFDEnd = System.currentTimeMillis();
        businessLog.info("update Content.xml end...cost= " + (updateOFDEnd - updateOFDStart) + " ms");
    }

    public static Rectangle getPageSize(Map<String, byte[]> filesMap, int pageNum, String baseDir) throws DocumentException {
        byte[] documentData = filesMap.get(baseDir + "Pages/Page_" + (pageNum - 1) + "/" + "Content.xml");
        String boundary = null;
        if (documentData != null) {
            Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(documentData));
            Element root = document.getRootElement();
            Element body = root.element("Area");
            if (null == body) {
                documentData = filesMap.get("Doc_0/Document.xml");
                Document document1 = Dom4jUtil.parseFile(new ByteArrayInputStream(documentData));
                Element root1 = document1.getRootElement();
                Element body1 = root1.element("CommonData").element("PageArea");
                boundary = body1.element("PhysicalBox").getStringValue();
            } else {
                boundary = body.element("PhysicalBox").getStringValue();
            }
            return new Rectangle(boundary);
        }
        return null;
    }

    public static Rectangle getPageSize(Map<String, byte[]> filesMap) throws DocumentException {
        byte[] documentData = filesMap.get("Pages/Page_0/Content.xml");
        if (documentData != null) {
            Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(documentData));
            Element root = document.getRootElement();
            Element body = root.element("Area");
            String boundary = body.element("PhysicalBox").getStringValue();
            return new Rectangle(boundary);
        }
        return null;
    }

    public static String getBaseDir(Map<String, byte[]> filesMap) {
        String baseDir = "Doc_0/";
        byte[] documentData = filesMap.get("Doc_0/Document.xml");
        if (null == documentData) {
            for (String fileName : filesMap.keySet()) {
                if (!fileName.contains("Document.xml")) continue;
                documentData = filesMap.get(fileName);
                int index = fileName.indexOf("/");
                baseDir = fileName.substring(0, index + 1);
            }
        }
        return baseDir;
    }

    public static int getTotalPages(Element root) {
        int totalNum = 0;
        Element body = root.element("Pages");
        List pageList = body.elements("Page");
        totalNum = pageList.size();
        return totalNum;
    }

    public static int getTotalPages(Map<String, byte[]> filesMap) {
        int totalNum = 0;
        byte[] documentData = filesMap.get("Doc_0/Document.xml");
        try {
            Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(documentData));
            Element root = document.getRootElement();
            Element body = root.element("Pages");
            List pageList = body.elements("Page");
            totalNum = pageList.size();
        }
        catch (DocumentException e) {
            businessLog.error("getTotalPages failed", (Throwable)e);
        }
        return totalNum;
    }

    public static String getDocId(Map<String, byte[]> filesMap) throws DocumentException {
        byte[] documentData = filesMap.get("OFD.xml");
        if (documentData != null) {
            Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(documentData));
            Element root = document.getRootElement();
            Element body = root.element("DocBody");
            Element docInfo = body.element("DocInfo");
            return docInfo.element("DocID").getStringValue();
        }
        return null;
    }

    public static Element getOFDRoot(Map<String, byte[]> filesMap) throws DocumentException {
        byte[] documentData = filesMap.get("OFD.xml");
        if (documentData != null) {
            Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(documentData));
            Element root = document.getRootElement();
            Element body = root.element("DocBody");
            return body;
        }
        throw new IllegalArgumentException("OFD.xml is not found");
    }

    public static String deleteLastSignatureNode(Map<String, byte[]> filesMap, String baseDir, String signaturesDir) throws SealException {
        long updateSignaturesStart = System.currentTimeMillis();
        businessLog.info("delete Signatures.xml node start...");
        try {
            Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(filesMap.get(baseDir + signaturesDir + "Signatures.xml")));
            Element body = document.getRootElement();
            Element maxSignID = body.element("MaxSignId");
            String maxID = maxSignID.getStringValue();
            String deletedFileId = "";
            List list = body.elements("Signature");
            if (list.size() > 1) {
                int newMaxID = Integer.parseInt(maxID) - 2;
                maxSignID.setText(String.valueOf(newMaxID));
                Element maxSig = (Element)list.get(list.size() - 1);
                String lastBaseLoc = maxSig.attributeValue("BaseLoc");
                deletedFileId = String.valueOf(StringUtil.getSingleNum(lastBaseLoc));
                body.remove(maxSig);
                businessLog.info("delete Signatures.xml node success...");
                ByteArrayOutputStream ofdStream = new ByteArrayOutputStream();
                XmlUtil.writeXml(document, ofdStream);
                filesMap.put(baseDir + signaturesDir + "Signatures.xml", ofdStream.toByteArray());
            } else {
                Element sigElement = (Element)list.get(0);
                String baseLoc = sigElement.attributeValue("BaseLoc");
                deletedFileId = String.valueOf(StringUtil.getSingleNum(baseLoc));
                SealXMLUtil.deteleSignatureFiles(filesMap, baseDir, signaturesDir);
            }
            String string = deletedFileId;
            return string;
        }
        catch (Exception e) {
            businessLog.error("delete Signatures.xml node failed", (Throwable)e);
            throw new SealException("delete Signatures.xml node failed", e);
        }
        finally {
            long updateSignaturesEnd = System.currentTimeMillis();
            businessLog.info("delete Signatures.xml node end...cost= " + (updateSignaturesEnd - updateSignaturesStart) + " ms");
        }
    }

    public static String[] getAllSignatureIds(Map<String, byte[]> filesMap, String baseDir, String signaturesDir) throws SealException {
        long updateSignaturesStart = System.currentTimeMillis();
        businessLog.info("get all Signatures.xml id start...");
        try {
            Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(filesMap.get(baseDir + signaturesDir + "Signatures.xml")));
            Element body = document.getRootElement();
            List list = body.elements("Signature");
            if (list == null || list.size() == 0) {
                throw new IllegalArgumentException("no signature exists!");
            }
            String[] deletedFileIds = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Element signElemenrt = (Element)list.get(i);
                String signBaseLoc = signElemenrt.attributeValue("BaseLoc");
                deletedFileIds[i] = String.valueOf(StringUtil.getSingleNum(signBaseLoc));
            }
            businessLog.info("get all Signatures.xml id success...");
            String[] stringArray = deletedFileIds;
            return stringArray;
        }
        catch (Exception e) {
            businessLog.error("get all Signatures.xml id failed", (Throwable)e);
            throw new SealException("get all Signatures.xml id failed", e);
        }
        finally {
            long updateSignaturesEnd = System.currentTimeMillis();
            businessLog.info("get all Signatures.xml id end...cost= " + (updateSignaturesEnd - updateSignaturesStart) + " ms");
        }
    }

    public static Map<String, byte[]> deteleSignatureFiles(Map<String, byte[]> filesMap, String baseDir, String signDir) throws DocumentException, IOException {
        filesMap.remove(baseDir + signDir + "Signatures.xml");
        filesMap.remove(baseDir + "Signs");
        Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(filesMap.get("OFD.xml")));
        Element body = document.getRootElement();
        Element docBody = body.element("DocBody");
        Element signatrues = docBody.element("Signatures");
        docBody.remove(signatrues);
        ByteArrayOutputStream ofdStream = new ByteArrayOutputStream();
        XmlUtil.writeXml(document, ofdStream);
        filesMap.put("OFD.xml", ofdStream.toByteArray());
        return filesMap;
    }

    public static void generateAttachments(Map<String, byte[]> filesMap, Map<String, byte[]> attachmentFiles, String baseDir) throws SealException {
        long generateSigsStart = System.currentTimeMillis();
        businessLog.info("generate Attachments.xml start...");
        try {
            BigInteger maxId;
            Attachments attachments = new Attachments();
            Iterator<String> it = attachmentFiles.keySet().iterator();
            ArrayList<Attachment> attaList = new ArrayList<Attachment>();
            Element root = SealXMLUtil.getDocument(filesMap, baseDir);
            BigInteger newMaxId = maxId = SealXMLUtil.getMaxDataId(root, baseDir);
            while (it.hasNext()) {
                Attachment attachment = new Attachment();
                String fileName = it.next();
                if (null == fileName || fileName.isEmpty()) {
                    throw new IllegalArgumentException("fileName is null");
                }
                attachment.setFileLoc(fileName);
                newMaxId = newMaxId.add(OFDConstants.interval);
                attachment.setID(newMaxId);
                attachment.setName(fileName.substring(0, fileName.lastIndexOf(".")));
                attachment.setFormat(fileName.substring(fileName.lastIndexOf(".") + 1));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                attachment.setCreationDate(sdf.format(new Date()));
                byte[] attachmentFile = attachmentFiles.get(fileName);
                if (null == attachmentFile) {
                    throw new IllegalArgumentException("attachmentFileData is null");
                }
                double fileSize = (double)attachmentFile.length / 1000.0;
                attachment.setSize(new BigDecimal(String.valueOf(fileSize)));
                attaList.add(attachment);
            }
            attachments.setAttachment(attaList);
            ByteArrayOutputStream attachmentsStream = new ByteArrayOutputStream();
            JaxbUtil.toXML(attachments, attachmentsStream);
            filesMap.put("Doc_0/Attachs/Attachments.xml", attachmentsStream.toByteArray());
            SealXMLUtil.updateMaxDataId(root, baseDir, newMaxId);
        }
        catch (Exception e) {
            businessLog.error("generate Attachments failed", (Throwable)e);
            throw new SealException("generate Attachments failed", e);
        }
        finally {
            long generateSigsEnd = System.currentTimeMillis();
            businessLog.info("generate Attachments.xml end...cost=" + (generateSigsEnd - generateSigsStart) + " ms");
        }
    }

    public static void updateAttachments(Map<String, byte[]> filesMap, Map<String, byte[]> attachmentFiles, String baseDir) throws SealException {
        long generateSigsStart = System.currentTimeMillis();
        businessLog.info("update Attachments.xml start...");
        try {
            String attachmentDir = "Doc_0/Attachs/";
            Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(filesMap.get(attachmentDir + "Attachments.xml")));
            Element body = document.getRootElement();
            List list = body.elements("Attachment");
            Element maxAtta = (Element)list.get(list.size() - 1);
            int lastID = Integer.parseInt(maxAtta.attributeValue("ID"));
            Iterator<String> it = attachmentFiles.keySet().iterator();
            ArrayList<Object> sameFileNames = new ArrayList<Object>();
            while (it.hasNext()) {
                String fileName = it.next();
                if (null == fileName || fileName.isEmpty()) {
                    throw new IllegalArgumentException("fileName is null");
                }
                byte[] byArray = filesMap.get(attachmentDir + (String)fileName);
                if (byArray != null && byArray.length > 0) {
                    businessLog.error("filename " + (String)fileName + " already exists!");
                    sameFileNames.add(fileName);
                    continue;
                }
                byte[] attachmentFile = attachmentFiles.get(fileName);
                if (null == attachmentFile) {
                    throw new IllegalArgumentException("attachmentFileData is null");
                }
                Element newAtta = body.addElement("ofd:Attachment");
                newAtta.addAttribute("ID", String.valueOf(++lastID));
                newAtta.addAttribute("Name", fileName.substring(0, fileName.lastIndexOf(".")));
                newAtta.addAttribute("Format", fileName.substring(fileName.lastIndexOf(".") + 1));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                newAtta.addAttribute("CreationDate", sdf.format(new Date()));
                double fileSize = (double)attachmentFile.length / 1000.0;
                newAtta.addAttribute("Size", String.valueOf(fileSize));
                Element fileLocElement = newAtta.addElement("ofd:FileLoc");
                fileLocElement.setText(fileName);
            }
            for (String string : sameFileNames) {
                attachmentFiles.remove(string);
            }
            ByteArrayOutputStream ofdStream = new ByteArrayOutputStream();
            XmlUtil.writeXml(document, ofdStream);
            filesMap.put("Doc_0/Attachs/Attachments.xml", ofdStream.toByteArray());
            Element element = SealXMLUtil.getDocument(filesMap, baseDir);
            SealXMLUtil.updateMaxDataId(element, baseDir, BigInteger.valueOf(lastID));
        }
        catch (Exception e) {
            businessLog.error("update Attachments failed", (Throwable)e);
            throw new SealException("update Attachments failed", e);
        }
        finally {
            long generateSigsEnd = System.currentTimeMillis();
            businessLog.info("update Attachments.xml end...cost=" + (generateSigsEnd - generateSigsStart) + " ms");
        }
    }

    public static void addAttahsInDocument(Map<String, byte[]> filesMap, String baseDir) throws DocumentException, IOException {
        Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(filesMap.get(baseDir + "Document.xml")));
        Element body = document.getRootElement();
        Element attaElement = body.addElement("ofd:Attachments");
        attaElement.setText("Attachs/Attachments.xml");
        ByteArrayOutputStream ofdStream = new ByteArrayOutputStream();
        XmlUtil.writeXml(document, ofdStream);
        filesMap.put(baseDir + "Document.xml", ofdStream.toByteArray());
    }

    public static void addAnnotsInDocument(Map<String, byte[]> filesMap, String baseDir) throws DocumentException, IOException {
        Document document = Dom4jUtil.parseFile(new ByteArrayInputStream(filesMap.get(baseDir + "Document.xml")));
        Element body = document.getRootElement();
        Element annotsElement = body.addElement("ofd:Annotations");
        annotsElement.setText("/" + baseDir + "Annots" + "/" + "Annotations.xml");
        ByteArrayOutputStream ofdStream = new ByteArrayOutputStream();
        XmlUtil.writeXml(document, ofdStream);
        filesMap.put(baseDir + "Document.xml", ofdStream.toByteArray());
    }

    public static HashMap<Integer, Integer> getPageTranslateMap(byte[] ofdDatas) throws Exception {
        if (null == ofdDatas) {
            throw new IllegalArgumentException("ofdDatas is null!");
        }
        HashMap<Integer, Integer> pageTranslateMap = new HashMap<Integer, Integer>();
        Map<String, byte[]> filesMap = ZipUtil.uncompress(new ByteArrayInputStream(ofdDatas));
        String baseDir = SealXMLUtil.getBaseDir(filesMap);
        Map<String, String> pageRefs = SealXMLUtil.getPageRefIds(filesMap, baseDir);
        for (Map.Entry<String, String> entry : pageRefs.entrySet()) {
            String oneFilePath = entry.getKey();
            int newPageNum = StringUtil.getSingleNum(oneFilePath);
            pageTranslateMap.put(newPageNum + 1, Integer.parseInt(entry.getValue()));
        }
        return pageTranslateMap;
    }
}

