/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.socket;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.timestamp.client.conf.TscLayeredConf;
import cfca.sadk.timestamp.client.logging.TscLogging;
import cfca.sadk.timestamp.client.socket.TscSSLContext;
import cfca.sadk.timestamp.client.utils.TscStrings;
import cfca.sadk.timestamp.exception.TSAException;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.util.Args;

public final class TscSSLContextManager {
    private final TscSSLContext context = new TscSSLContext();
    private final String keystoreType;
    private final boolean isGMSSL;
    private X509Cert sslClientCert = null;

    public TscSSLContextManager(boolean isGMSSL) {
        this.keystoreType = isGMSSL ? "BKS" : "JKS";
        this.isGMSSL = isGMSSL;
    }

    private final void initSSLKeyManager(TscLayeredConf tscLayeredConf) throws TSAException {
        TscLogging.SYSTEM_LOGGER.info("TscSSLContextManager@initSSLKeyManager starting {}", (Object)tscLayeredConf);
        Args.notNull((Object)tscLayeredConf, (String)"TscSSLContextManager@initSSLKeyManager tscLayeredConf");
        String jksKeyFilePath = (String)Args.notNull((Object)tscLayeredConf.getJksKeyStoreFilePath(), (String)"TscSSLContextManager@initSSLKeyManager jksKeyStoreFilePath");
        String jksKeyStoreFilePassword = (String)Args.notNull((Object)tscLayeredConf.getJksKeyStoreFilePassword(), (String)"TscSSLContextManager@initSSLKeyManager jksKeyStoreFilePassword");
        String managerAlgorithmType = tscLayeredConf.getKeyManagerAlgorithmType(this.isGMSSL);
        TscLogging.SYSTEM_LOGGER.info("TscSSLContextManager@initSSLKeyManager AlgorithmType={}, keystoreType={}", (Object)managerAlgorithmType, (Object)this.keystoreType);
        FileInputStream fis = null;
        try {
            char[] password = jksKeyStoreFilePassword.toCharArray();
            fis = new FileInputStream(jksKeyFilePath);
            KeyStore keyStore = KeyStore.getInstance(this.keystoreType);
            keyStore.load(fis, password);
            this.sslClientCert = this.readSSLClientCert(keyStore, password);
            KeyManagerFactory factory = KeyManagerFactory.getInstance(managerAlgorithmType);
            factory.init(keyStore, password);
            this.context.setKeyManager(factory);
            TscLogging.SYSTEM_LOGGER.info("TscSSLContextManager@initSSLKeyManager successulluy");
            for (int i = 0; i < password.length; ++i) {
                password[i] = '\u0000';
            }
            password = null;
        }
        catch (UnrecoverableKeyException e) {
            throw new TSAException("jksFilePassword invalid: " + jksKeyStoreFilePassword, (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new TSAException("jksKeyFilePath not found: " + jksKeyFilePath, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TSAException("NoSuchAlgorithm jksKeyFilePath: " + jksKeyFilePath, (Throwable)e);
        }
        catch (KeyStoreException e) {
            throw new TSAException("KeyStoreFailed jksKeyFilePath: " + jksKeyFilePath, (Throwable)e);
        }
        catch (CertificateException e) {
            throw new TSAException("CertificateFailed jksKeyFilePath: " + jksKeyFilePath, (Throwable)e);
        }
        catch (IOException e) {
            throw new TSAException("IOFailed jksKeyFilePath: " + jksKeyFilePath, (Throwable)e);
        }
        catch (Exception e) {
            throw new TSAException("ExceptionFailed jksKeyFilePath: " + jksKeyFilePath, (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    TscLogging.ERROR_LOGGER.warn("TscSSLContextManager@initSSLKeyManager not closed successfully! {}", (Object)jksKeyFilePath, (Object)e);
                }
            }
        }
    }

    final void initSSLTrustManager(TscLayeredConf layeredConf) throws TSAException {
        TscLogging.SYSTEM_LOGGER.info("TscSSLContextManager@initSSLTrustManager starting {}", (Object)layeredConf);
        Args.notNull((Object)layeredConf, (String)"TscSSLContextManager@initSSLKeyManager layeredConf");
        String jksTrustFilePath = (String)Args.notNull((Object)layeredConf.getJksTrustFilePath(), (String)"TscSSLContextManager@initSSLKeyManager JksTrustFilePath");
        String jksTrustFilePassword = (String)Args.notNull((Object)layeredConf.getJksTrustFilePassword(), (String)"TscSSLContextManager@initSSLKeyManager JksTrustFilePassword");
        String managerAlgorithmType = layeredConf.getTrustManagerAlgorithmType(this.isGMSSL);
        TscLogging.SYSTEM_LOGGER.info("TscSSLContextManager@initSSLTrustManager AlgorithmType={}, keystoreType={}", (Object)managerAlgorithmType, (Object)this.keystoreType);
        FileInputStream fis = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(this.keystoreType);
            fis = new FileInputStream(jksTrustFilePath);
            keyStore.load(fis, jksTrustFilePassword.toCharArray());
            TrustManagerFactory factory = TrustManagerFactory.getInstance(managerAlgorithmType);
            factory.init(keyStore);
            this.context.setTrustManager(factory);
            TscLogging.SYSTEM_LOGGER.info("TscSSLContextManager@initSSLTrustManager successulluy");
        }
        catch (FileNotFoundException e) {
            throw new TSAException("jksTrustFilePath not found: " + jksTrustFilePath, (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TSAException("NoSuchAlgorithm jksTrustFilePath: " + jksTrustFilePath, (Throwable)e);
        }
        catch (KeyStoreException e) {
            throw new TSAException("KeyStoreFailed jksTrustFilePath: " + jksTrustFilePath, (Throwable)e);
        }
        catch (CertificateException e) {
            throw new TSAException("CertificateFailed jksTrustFilePath: " + jksTrustFilePath, (Throwable)e);
        }
        catch (IOException e) {
            throw new TSAException("IOFailed jksTrustFilePath: " + jksTrustFilePath, (Throwable)e);
        }
        catch (Exception e) {
            throw new TSAException("ExceptionFailed jksTrustFilePath: " + jksTrustFilePath, (Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    TscLogging.ERROR_LOGGER.warn("TscSSLContextManager@initSSLTrustManager not closed successfully! {}", (Object)jksTrustFilePath, (Object)e);
                }
            }
        }
    }

    final void initSSLContext(String protocol) throws TSAException {
        this.context.initContext(protocol);
    }

    public static final TscSSLContextManager buildTscSSLContextManager(TscLayeredConf layeredConf) throws TSAException {
        Args.notNull((Object)layeredConf, (String)"TscSSLContextManager@buildTscSSLContextManager layeredConf");
        boolean isGMSSL = layeredConf.isGMSSL();
        TscSSLContextManager sslManager = new TscSSLContextManager(isGMSSL);
        if (!TscStrings.isEmpty(layeredConf.getJksTrustFilePath())) {
            TscLogging.SYSTEM_LOGGER.info("TscSSLContextManager@buildTscSSLContextManager running");
            sslManager.initSSLTrustManager(layeredConf);
            if (!TscStrings.isEmpty(layeredConf.getJksKeyStoreFilePath())) {
                sslManager.initSSLKeyManager(layeredConf);
            }
            sslManager.initSSLContext(layeredConf.getSslProtocol());
            TscLogging.SYSTEM_LOGGER.info("TscSSLContextManager@buildTscSSLContextManager successulluy");
        }
        return sslManager;
    }

    public final SSLContext sslContextWithNotExpiredCert() throws TSAException {
        this.verifyCertExpiredDate(this.sslClientCert);
        return this.context.getContext();
    }

    private final X509Cert readSSLClientCert(KeyStore keystore, char[] password) throws TSAException {
        X509Cert sslClientCert = null;
        if (keystore != null) {
            try {
                Enumeration<String> aliases = keystore.aliases();
                String alias = null;
                Key key = null;
                Certificate cert = null;
                boolean found = false;
                while (aliases.hasMoreElements()) {
                    alias = aliases.nextElement();
                    key = keystore.getKey(alias, password);
                    if (key == null) continue;
                    if (!this.isGMSSL && found) {
                        throw new TSAException("more than one cert for rsa-dual-ssl");
                    }
                    cert = keystore.getCertificate(alias);
                    found = true;
                }
                if (cert == null) {
                    throw new TSAException("less than one cert for dual-ssl");
                }
                sslClientCert = this.verifyCertExpiredDate(new X509Cert(cert.getEncoded()));
            }
            catch (UnrecoverableKeyException e) {
                throw new TSAException("readSSLClientCert failed", (Throwable)e);
            }
            catch (CertificateEncodingException e) {
                throw new TSAException("readSSLClientCert failed", (Throwable)e);
            }
            catch (KeyStoreException e) {
                throw new TSAException("readSSLClientCert failed", (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new TSAException("readSSLClientCert failed", (Throwable)e);
            }
            catch (PKIException e) {
                throw new TSAException("readSSLClientCert failed", (Throwable)e);
            }
        }
        return sslClientCert;
    }

    private final X509Cert verifyCertExpiredDate(X509Cert cert) throws TSAException {
        Date nowDate;
        if (cert != null && (nowDate = new Date()).after(cert.getNotAfter())) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ");
            String notBefore = dateFormat.format(cert.getNotBefore());
            String notAfter = dateFormat.format(cert.getNotAfter());
            throw new TSAException(String.format("cert-%s has expired,<%s, %s>: %s", cert.getStringSerialNumber(), notBefore, notAfter, cert.getSubject()));
        }
        return cert;
    }
}

