/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.util;

import cfca.sadk.tls.java.security.CFCAAlgorithmConstraints;
import cfca.sadk.tls.javax.net.ssl.CFCAExtendedSSLSession;
import cfca.sadk.tls.javax.net.ssl.CFCASSLTransfer;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.sec.SSLAlgorithmConstraints;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLSession;

public final class CFCAAlgorithmConstraintsHelper {
    private CFCAAlgorithmConstraintsHelper() {
    }

    public static final CFCAAlgorithmConstraints createAlgorithmConstraintsForTrustManager(CFCASSLTransfer transfer) throws CertificateException {
        return CFCAAlgorithmConstraintsHelper.createAlgorithmConstraints(transfer, false);
    }

    public static final CFCAAlgorithmConstraints createAlgorithmConstraintsKeyManager(CFCASSLTransfer transfer) {
        return CFCAAlgorithmConstraintsHelper.createAlgorithmConstraints(transfer, true);
    }

    public static final CFCAAlgorithmConstraints createAlgorithmConstraints(CFCASSLTransfer transfer, boolean withDefaultCertPathConstraints) {
        ProtocolVersion protocolVersion;
        SSLSession session;
        SSLAlgorithmConstraints constraints = null;
        if (transfer != null && (session = transfer.getHandshakeSession()) != null && (protocolVersion = ProtocolVersion.valueOf(session.getProtocol())).isStandardTLS12()) {
            String[] peerSupportedSignAlgs = null;
            if (session instanceof CFCAExtendedSSLSession) {
                CFCAExtendedSSLSession extSession = (CFCAExtendedSSLSession)session;
                peerSupportedSignAlgs = extSession.getPeerSupportedSignatureAlgorithms();
            }
            constraints = new SSLAlgorithmConstraints(transfer, peerSupportedSignAlgs, withDefaultCertPathConstraints);
        }
        if (constraints == null) {
            constraints = new SSLAlgorithmConstraints(transfer, withDefaultCertPathConstraints);
        }
        return constraints;
    }
}

