/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.table.truetype;

import cfca.sadk.com.google.typography.font.sfntly.data.FontData;
import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.sadk.com.google.typography.font.sfntly.table.Header;
import cfca.sadk.com.google.typography.font.sfntly.table.Table;
import cfca.sadk.com.google.typography.font.sfntly.table.core.FontHeaderTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class LocaTable
extends Table {
    private FontHeaderTable.IndexToLocFormat version;
    private int numGlyphs;

    private LocaTable(Header header, ReadableFontData data, FontHeaderTable.IndexToLocFormat version, int numGlyphs) {
        super(header, data);
        this.version = version;
        this.numGlyphs = numGlyphs;
    }

    public FontHeaderTable.IndexToLocFormat formatVersion() {
        return this.version;
    }

    public int numGlyphs() {
        return this.numGlyphs;
    }

    public int glyphOffset(int glyphId) {
        if (glyphId < 0 || glyphId >= this.numGlyphs) {
            throw new IndexOutOfBoundsException("Glyph ID is out of bounds.");
        }
        return this.loca(glyphId);
    }

    public int glyphLength(int glyphId) {
        if (glyphId < 0 || glyphId >= this.numGlyphs) {
            throw new IndexOutOfBoundsException("Glyph ID is out of bounds.");
        }
        return this.loca(glyphId + 1) - this.loca(glyphId);
    }

    public int numLocas() {
        return this.numGlyphs + 1;
    }

    public int loca(int index) {
        if (index > this.numGlyphs) {
            throw new IndexOutOfBoundsException();
        }
        if (this.version == FontHeaderTable.IndexToLocFormat.shortOffset) {
            return 2 * this.data.readUShort(index * FontData.DataSize.USHORT.size());
        }
        return this.data.readULongAsInt(index * FontData.DataSize.ULONG.size());
    }

    Iterator<Integer> iterator() {
        return new LocaIterator();
    }

    public static class Builder
    extends Table.Builder<LocaTable> {
        private FontHeaderTable.IndexToLocFormat formatVersion = FontHeaderTable.IndexToLocFormat.longOffset;
        private int numGlyphs = -1;
        private List<Integer> loca;

        public static Builder createBuilder(Header header, WritableFontData data) {
            return new Builder(header, data);
        }

        private Builder(Header header, WritableFontData data) {
            super(header, data);
        }

        private Builder(Header header, ReadableFontData data) {
            super(header, data);
        }

        private void initialize(ReadableFontData data) {
            this.clearLoca(false);
            if (this.loca == null) {
                this.loca = new ArrayList<Integer>();
            }
            if (data != null) {
                if (this.numGlyphs < 0) {
                    throw new IllegalStateException("numglyphs not set on LocaTable Builder.");
                }
                LocaTable table = new LocaTable(this.header(), data, this.formatVersion, this.numGlyphs);
                Iterator<Integer> locaIter = table.iterator();
                while (locaIter.hasNext()) {
                    this.loca.add(locaIter.next());
                }
            }
        }

        private int checkGlyphRange(int glyphId) {
            if (glyphId < 0 || glyphId > this.lastGlyphIndex()) {
                throw new IndexOutOfBoundsException("Glyph ID is outside of the allowed range.");
            }
            return glyphId;
        }

        private int lastGlyphIndex() {
            return this.loca != null ? this.loca.size() - 2 : this.numGlyphs - 1;
        }

        private List<Integer> getLocaList() {
            if (this.loca == null) {
                this.initialize(this.internalReadData());
                this.setModelChanged();
            }
            return this.loca;
        }

        private void clearLoca(boolean nullify) {
            if (this.loca != null) {
                this.loca.clear();
            }
            if (nullify) {
                this.loca = null;
            }
            this.setModelChanged(false);
        }

        public FontHeaderTable.IndexToLocFormat formatVersion() {
            return this.formatVersion;
        }

        public void setFormatVersion(FontHeaderTable.IndexToLocFormat formatVersion) {
            this.formatVersion = formatVersion;
        }

        public List<Integer> locaList() {
            return this.getLocaList();
        }

        public void setLocaList(List<Integer> list) {
            this.loca = list;
            this.setModelChanged();
        }

        public int glyphOffset(int glyphId) {
            this.checkGlyphRange(glyphId);
            return this.getLocaList().get(glyphId);
        }

        public int glyphLength(int glyphId) {
            this.checkGlyphRange(glyphId);
            return this.getLocaList().get(glyphId + 1) - this.getLocaList().get(glyphId);
        }

        public void setNumGlyphs(int numGlyphs) {
            this.numGlyphs = numGlyphs;
        }

        public int numGlyphs() {
            return this.lastGlyphIndex() + 1;
        }

        public void revert() {
            this.loca = null;
            this.setModelChanged(false);
        }

        public int numLocas() {
            return this.getLocaList().size();
        }

        public int loca(int index) {
            return this.getLocaList().get(index);
        }

        @Override
        protected LocaTable subBuildTable(ReadableFontData data) {
            return new LocaTable(this.header(), data, this.formatVersion, this.numGlyphs);
        }

        @Override
        protected void subDataSet() {
            this.initialize(this.internalReadData());
        }

        @Override
        protected int subDataSizeToSerialize() {
            if (this.loca == null) {
                return 0;
            }
            if (this.formatVersion == FontHeaderTable.IndexToLocFormat.longOffset) {
                return this.loca.size() * FontData.DataSize.ULONG.size();
            }
            return this.loca.size() * FontData.DataSize.USHORT.size();
        }

        @Override
        protected boolean subReadyToSerialize() {
            return this.loca != null;
        }

        @Override
        protected int subSerialize(WritableFontData newData) {
            int size = 0;
            for (int l : this.loca) {
                if (this.formatVersion == FontHeaderTable.IndexToLocFormat.longOffset) {
                    size += newData.writeULong(size, l);
                    continue;
                }
                size += newData.writeUShort(size, l / 2);
            }
            this.numGlyphs = this.loca.size() - 1;
            return size;
        }
    }

    private final class LocaIterator
    implements Iterator<Integer> {
        int index;

        private LocaIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index <= LocaTable.this.numGlyphs;
        }

        @Override
        public Integer next() {
            return LocaTable.this.loca(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

