/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.common;

import cfca.sadk.ofd.base.exception.SealException;
import cfca.sadk.ofd.util.SysEnv;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.DLSequence;
import cfca.sadk.org.bouncycastle.asn1.cmp.PKIStatusInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.tsp.TimeStampResp;
import cfca.sadk.org.bouncycastle.cms.CMSException;
import cfca.sadk.org.bouncycastle.cms.CMSSignedData;
import cfca.sadk.org.bouncycastle.tsp.TSPException;
import cfca.sadk.org.bouncycastle.tsp.TSPValidationException;
import cfca.sadk.org.bouncycastle.tsp.TimeStampToken;
import cfca.sadk.org.bouncycastle.tsp.TimeStampTokenInfo;
import cfca.sadk.timestamp.client.TimestampFactory;
import cfca.sadk.timestamp.client.api.Timestamp;
import cfca.sadk.timestamp.client.api.TimestampClient;
import cfca.sadk.timestamp.client.api.TimestampConfig;
import cfca.sadk.timestamp.client.bean.HashAlgorithm;
import cfca.sadk.timestamp.exception.TSAErrorCode;
import cfca.sadk.timestamp.exception.TSAException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import java.util.Enumeration;

public class CFCATSAClient {
    private HashAlgorithm hashAlg;
    private TimestampClient client = null;
    private byte[] contentInfoBytes = null;

    public CFCATSAClient(HashAlgorithm hashAlg, TimestampConfig config) throws TSAException {
        if (config == null) {
            throw new TSAException(TSAErrorCode.timestampTSASignedDataInvalid, "TimestampConfig can not be null");
        }
        this.hashAlg = hashAlg;
        this.client = TimestampFactory.newTimestampClient((TimestampConfig)config);
    }

    public byte[] getTimeStampToken(byte[] imprint) throws TSAException, TSAException, IOException {
        TimeStampResp timestampResp;
        if (this.client == null) {
            throw new TSAException(TSAErrorCode.timestampTSASignedDataInvalid, "TimestampClient can not be null");
        }
        Timestamp timestamp = this.client.requestTimestamp(this.hashAlg, imprint);
        try {
            timestampResp = TimeStampResp.getInstance((Object)timestamp.getTimestampResponseBytes());
        }
        catch (Exception e) {
            throw new TSAException(TSAErrorCode.timestampTSASignedDataInvalid, "timestamp TSASignedData decode failure", (Throwable)e);
        }
        PKIStatusInfo statusInfo = timestampResp.getStatus();
        BigInteger statusCode = statusInfo.getStatus();
        if (statusCode.intValue() != 0) {
            DERBitString failInfo = statusInfo.getFailInfo();
            if (null != failInfo) {
                throw new TSAException(TSAErrorCode.timestampTSASignedDataInvalid, new String(failInfo.getBytes(), "UTF-8"));
            }
            throw new TSAException(TSAErrorCode.timestampTSASignedDataInvalid, "timestamp statusCode is " + statusCode.intValue());
        }
        if (timestampResp.getTimeStampToken() == null) {
            throw new TSAException(TSAErrorCode.timestampTSASignedDataInvalid, "TimeStampToken is null");
        }
        this.contentInfoBytes = timestampResp.getTimeStampToken().getEncoded();
        return this.contentInfoBytes;
    }

    public byte[] getGM20520Token(byte[] imprint) throws TSAException, TSAException, IOException {
        if (this.client == null) {
            throw new TSAException(TSAErrorCode.timestampTSASignedDataInvalid, "TimestampClient can not be null");
        }
        Timestamp timestamp = this.client.requestTimestamp(this.hashAlg, imprint);
        if (SysEnv.isContainTSAStatus()) {
            this.contentInfoBytes = timestamp.getTimestampResponseBytes();
        } else {
            ASN1Sequence tsaRes = ASN1Sequence.getInstance((Object)timestamp.getTimestampResponseBytes());
            Enumeration e = tsaRes.getObjects();
            e.nextElement();
            this.contentInfoBytes = ASN1Sequence.getInstance(e.nextElement()).getEncoded();
        }
        return this.contentInfoBytes;
    }

    public static final Date parseTime(byte[] timeStampToken) throws SealException, IOException {
        ASN1Sequence tsaRes = ASN1Sequence.getInstance((Object)timeStampToken);
        Enumeration e = tsaRes.getObjects();
        Object firstElement = e.nextElement();
        Object secondElement = e.nextElement();
        byte[] realTokenData = null;
        realTokenData = firstElement instanceof DLSequence && secondElement instanceof DLSequence ? ASN1Sequence.getInstance(secondElement).getEncoded() : tsaRes.getEncoded();
        TimeStampToken token = CFCATSAClient.parseToken(realTokenData);
        if (null != token) {
            return CFCATSAClient.parseTime(token);
        }
        throw new SealException("invalid timeStampToken");
    }

    public static final TimeStampToken parseToken(byte[] tokenEncodable) throws SealException {
        CMSSignedData signedData;
        ContentInfo tokenContentInfo = ContentInfo.getInstance((Object)tokenEncodable);
        try {
            signedData = new CMSSignedData(tokenContentInfo);
        }
        catch (CMSException e) {
            throw new SealException("invalid tokenContentInfo", e);
        }
        TimeStampToken timeStampToken = null;
        try {
            timeStampToken = new TimeStampToken(signedData);
        }
        catch (TSPValidationException e) {
            throw new SealException("invalid timeStampToken", e);
        }
        catch (TSPException e) {
            throw new SealException("invalid timeStampToken", e);
        }
        catch (Exception e) {
            throw new SealException("invalid timeStampToken", e);
        }
        return timeStampToken;
    }

    public static final Date parseTime(TimeStampToken timeStampToken) throws SealException {
        TimeStampTokenInfo tokenInfo;
        Date genTime = null;
        if (timeStampToken != null && (tokenInfo = timeStampToken.getTimeStampInfo()) != null) {
            genTime = tokenInfo.getGenTime();
        }
        return genTime;
    }
}

