/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.utils;

import cfca.sadk.timestamp.client.logging.TscLogging;
import java.util.Properties;
import org.apache.http.util.Args;
import org.apache.http.util.TextUtils;

public final class TscPropsUtil {
    private TscPropsUtil() {
    }

    public static String getString(Properties props, String key, String defaultValue) {
        Args.notNull((Object)props, (String)"properties");
        String value = props.getProperty(key);
        if (TextUtils.isEmpty((CharSequence)value)) {
            value = defaultValue;
        }
        return value;
    }

    public static String[] getStrings(Properties props, String key, String[] defaultValue) {
        Args.notNull((Object)props, (String)"properties");
        String[] values = defaultValue;
        String value = props.getProperty(key);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            values = value.split(",");
        }
        return values;
    }

    public static boolean getBoolean(Properties props, String key, boolean defaultValue) {
        Args.notNull((Object)props, (String)"properties");
        String value = props.getProperty(key);
        boolean val = defaultValue;
        if (!TextUtils.isBlank((CharSequence)value)) {
            val = Boolean.parseBoolean(value);
        }
        return val;
    }

    public static int getInt(Properties props, String key, int defaultValue) {
        Args.notNull((Object)props, (String)"properties");
        String value = props.getProperty(key);
        int val = defaultValue;
        if (!TextUtils.isBlank((CharSequence)value)) {
            try {
                val = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                TscLogging.ERROR_LOGGER.error("convert to int failed: {}={}", new Object[]{key, value, e});
            }
        }
        return val;
    }
}

