/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener;

import cfca.sadk.com.itextpdf.kernel.geom.LineSegment;
import cfca.sadk.com.itextpdf.kernel.geom.Matrix;
import cfca.sadk.com.itextpdf.kernel.geom.Vector;
import cfca.sadk.com.itextpdf.kernel.jdk7.CommonUtils;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.CanvasTag;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.EventType;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.data.IEventData;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.ITextExtractionStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class LocationTextExtractionStrategy
implements ITextExtractionStrategy {
    private static boolean DUMP_STATE = false;
    private static final float DIACRITICAL_MARKS_ALLOWED_VERTICAL_DEVIATION = 2.0f;
    private final List<TextChunk> locationalResult = new ArrayList<TextChunk>();
    private final ITextChunkLocationStrategy tclStrat;
    private boolean useActualText = false;
    private boolean rightToLeftRunDirection = false;
    private TextRenderInfo lastTextRenderInfo;

    public LocationTextExtractionStrategy() {
        this(new ITextChunkLocationStrategy(){

            @Override
            public ITextChunkLocation createLocation(TextRenderInfo renderInfo, LineSegment baseline) {
                return new TextChunkLocationDefaultImp(baseline.getStartPoint(), baseline.getEndPoint(), renderInfo.getSingleSpaceWidth());
            }
        });
    }

    public LocationTextExtractionStrategy(ITextChunkLocationStrategy strat) {
        this.tclStrat = strat;
    }

    public LocationTextExtractionStrategy setUseActualText(boolean useActualText) {
        this.useActualText = useActualText;
        return this;
    }

    public LocationTextExtractionStrategy setRightToLeftRunDirection(boolean rightToLeftRunDirection) {
        this.rightToLeftRunDirection = rightToLeftRunDirection;
        return this;
    }

    public boolean isUseActualText() {
        return this.useActualText;
    }

    @Override
    public void eventOccurred(IEventData data, EventType type) {
        if (type.equals((Object)EventType.RENDER_TEXT)) {
            TextRenderInfo renderInfo = (TextRenderInfo)data;
            LineSegment segment = renderInfo.getBaseline();
            if (renderInfo.getRise() != 0.0f) {
                Matrix riseOffsetTransform = new Matrix(0.0f, -renderInfo.getRise());
                segment = segment.transformBy(riseOffsetTransform);
            }
            if (this.useActualText) {
                CanvasTag lastTagWithActualText;
                CanvasTag canvasTag = lastTagWithActualText = this.lastTextRenderInfo != null ? this.findLastTagWithActualText(this.lastTextRenderInfo.getCanvasTagHierarchy()) : null;
                if (lastTagWithActualText != null && lastTagWithActualText == this.findLastTagWithActualText(renderInfo.getCanvasTagHierarchy())) {
                    TextChunk lastTextChunk = this.locationalResult.get(this.locationalResult.size() - 1);
                    Vector mergedStart = new Vector(Math.min(lastTextChunk.getLocation().getStartLocation().get(0), segment.getStartPoint().get(0)), Math.min(lastTextChunk.getLocation().getStartLocation().get(1), segment.getStartPoint().get(1)), Math.min(lastTextChunk.getLocation().getStartLocation().get(2), segment.getStartPoint().get(2)));
                    Vector mergedEnd = new Vector(Math.max(lastTextChunk.getLocation().getEndLocation().get(0), segment.getEndPoint().get(0)), Math.max(lastTextChunk.getLocation().getEndLocation().get(1), segment.getEndPoint().get(1)), Math.max(lastTextChunk.getLocation().getEndLocation().get(2), segment.getEndPoint().get(2)));
                    TextChunk merged = new TextChunk(lastTextChunk.getText(), this.tclStrat.createLocation(renderInfo, new LineSegment(mergedStart, mergedEnd)));
                    this.locationalResult.set(this.locationalResult.size() - 1, merged);
                } else {
                    String actualText = renderInfo.getActualText();
                    TextChunk tc = new TextChunk(actualText != null ? actualText : renderInfo.getText(), this.tclStrat.createLocation(renderInfo, segment));
                    this.locationalResult.add(tc);
                }
            } else {
                TextChunk tc = new TextChunk(renderInfo.getText(), this.tclStrat.createLocation(renderInfo, segment));
                this.locationalResult.add(tc);
            }
            this.lastTextRenderInfo = renderInfo;
        }
    }

    @Override
    public Set<EventType> getSupportedEvents() {
        return null;
    }

    @Override
    public String getResultantText() {
        if (DUMP_STATE) {
            this.dumpState();
        }
        ArrayList<TextChunk> textChunks = new ArrayList<TextChunk>(this.locationalResult);
        this.sortWithMarks(textChunks);
        StringBuilder sb = new StringBuilder();
        TextChunk lastChunk = null;
        for (TextChunk chunk : textChunks) {
            if (lastChunk == null) {
                sb.append(chunk.text);
            } else if (chunk.sameLine(lastChunk)) {
                if (this.isChunkAtWordBoundary(chunk, lastChunk) && !this.startsWithSpace(chunk.text) && !this.endsWithSpace(lastChunk.text)) {
                    sb.append(' ');
                }
                sb.append(chunk.text);
            } else {
                sb.append('\n');
                sb.append(chunk.text);
            }
            lastChunk = chunk;
        }
        return sb.toString();
    }

    protected boolean isChunkAtWordBoundary(TextChunk chunk, TextChunk previousChunk) {
        return chunk.getLocation().isAtWordBoundary(previousChunk.getLocation());
    }

    private boolean startsWithSpace(String str) {
        return str.length() != 0 && str.charAt(0) == ' ';
    }

    private boolean endsWithSpace(String str) {
        return str.length() != 0 && str.charAt(str.length() - 1) == ' ';
    }

    private void dumpState() {
        for (TextChunk location : this.locationalResult) {
            location.printDiagnostics();
            System.out.println();
        }
    }

    private CanvasTag findLastTagWithActualText(List<CanvasTag> canvasTagHierarchy) {
        CanvasTag lastActualText = null;
        for (CanvasTag tag : canvasTagHierarchy) {
            if (tag.getActualText() == null) continue;
            lastActualText = tag;
            break;
        }
        return lastActualText;
    }

    private void sortWithMarks(List<TextChunk> textChunks) {
        HashMap<TextChunk, TextChunkMarks> marks = new HashMap<TextChunk, TextChunkMarks>();
        ArrayList<TextChunk> toSort = new ArrayList<TextChunk>();
        for (int markInd = 0; markInd < textChunks.size(); ++markInd) {
            ITextChunkLocation location = textChunks.get(markInd).getLocation();
            if (location.getStartLocation().equals(location.getEndLocation())) {
                boolean foundBaseToAttachTo = false;
                for (int baseInd = 0; baseInd < textChunks.size(); ++baseInd) {
                    ITextChunkLocation baseLocation;
                    if (markInd == baseInd || (baseLocation = textChunks.get(baseInd).getLocation()).getStartLocation().equals(baseLocation.getEndLocation()) || !this.containsMark(baseLocation, location)) continue;
                    TextChunkMarks currentMarks = (TextChunkMarks)marks.get(textChunks.get(baseInd));
                    if (currentMarks == null) {
                        currentMarks = new TextChunkMarks();
                        marks.put(textChunks.get(baseInd), currentMarks);
                    }
                    if (markInd < baseInd) {
                        currentMarks.preceding.add(textChunks.get(markInd));
                    } else {
                        currentMarks.succeeding.add(textChunks.get(markInd));
                    }
                    foundBaseToAttachTo = true;
                    break;
                }
                if (foundBaseToAttachTo) continue;
                toSort.add(textChunks.get(markInd));
                continue;
            }
            toSort.add(textChunks.get(markInd));
        }
        if (this.rightToLeftRunDirection) {
            Collections.sort(toSort, new TextChunkComparator(new TextChunkLocationComparator(false)));
        } else {
            Collections.sort(toSort);
        }
        textChunks.clear();
        for (TextChunk current : toSort) {
            int j;
            TextChunkMarks currentMarks = (TextChunkMarks)marks.get(current);
            if (currentMarks != null) {
                if (!this.rightToLeftRunDirection) {
                    for (j = 0; j < currentMarks.preceding.size(); ++j) {
                        textChunks.add(currentMarks.preceding.get(j));
                    }
                } else {
                    for (j = currentMarks.succeeding.size() - 1; j >= 0; --j) {
                        textChunks.add(currentMarks.succeeding.get(j));
                    }
                }
            }
            textChunks.add(current);
            if (currentMarks == null) continue;
            if (!this.rightToLeftRunDirection) {
                for (j = 0; j < currentMarks.succeeding.size(); ++j) {
                    textChunks.add(currentMarks.succeeding.get(j));
                }
                continue;
            }
            for (j = currentMarks.preceding.size() - 1; j >= 0; --j) {
                textChunks.add(currentMarks.preceding.get(j));
            }
        }
    }

    private boolean containsMark(ITextChunkLocation baseLocation, ITextChunkLocation markLocation) {
        return baseLocation.getStartLocation().get(0) <= markLocation.getStartLocation().get(0) && baseLocation.getEndLocation().get(0) >= markLocation.getEndLocation().get(0) && (float)Math.abs(baseLocation.distPerpendicular() - markLocation.distPerpendicular()) <= 2.0f;
    }

    private static class TextChunkMarks {
        List<TextChunk> preceding = new ArrayList<TextChunk>();
        List<TextChunk> succeeding = new ArrayList<TextChunk>();

        private TextChunkMarks() {
        }
    }

    private static class TextChunkLocationComparator
    implements Comparator<ITextChunkLocation> {
        private boolean leftToRight = true;

        public TextChunkLocationComparator() {
        }

        public TextChunkLocationComparator(boolean leftToRight) {
            this.leftToRight = leftToRight;
        }

        @Override
        public int compare(ITextChunkLocation first, ITextChunkLocation second) {
            if (first == second) {
                return 0;
            }
            int result = CommonUtils.compare(first.orientationMagnitude(), second.orientationMagnitude());
            if (result != 0) {
                return result;
            }
            int distPerpendicularDiff = first.distPerpendicular() - second.distPerpendicular();
            if (distPerpendicularDiff != 0) {
                return distPerpendicularDiff;
            }
            return this.leftToRight ? Float.compare(first.distParallelStart(), second.distParallelStart()) : -Float.compare(first.distParallelEnd(), second.distParallelEnd());
        }
    }

    private static class TextChunkComparator
    implements Comparator<TextChunk> {
        private Comparator<ITextChunkLocation> locationComparator;

        public TextChunkComparator(Comparator<ITextChunkLocation> locationComparator) {
            this.locationComparator = locationComparator;
        }

        @Override
        public int compare(TextChunk o1, TextChunk o2) {
            return this.locationComparator.compare(o1.location, o2.location);
        }
    }

    public static class TextChunkLocationDefaultImp
    implements ITextChunkLocation {
        private static final TextChunkLocationComparator defaultComparator = new TextChunkLocationComparator();
        private final Vector startLocation;
        private final Vector endLocation;
        private final Vector orientationVector;
        private final int orientationMagnitude;
        private final int distPerpendicular;
        private final float distParallelStart;
        private final float distParallelEnd;
        private final float charSpaceWidth;

        public TextChunkLocationDefaultImp(Vector startLocation, Vector endLocation, float charSpaceWidth) {
            this.startLocation = startLocation;
            this.endLocation = endLocation;
            this.charSpaceWidth = charSpaceWidth;
            Vector oVector = endLocation.subtract(startLocation);
            if (oVector.length() == 0.0f) {
                oVector = new Vector(1.0f, 0.0f, 0.0f);
            }
            this.orientationVector = oVector.normalize();
            this.orientationMagnitude = (int)(Math.atan2(this.orientationVector.get(1), this.orientationVector.get(0)) * 1000.0);
            Vector origin = new Vector(0.0f, 0.0f, 1.0f);
            this.distPerpendicular = (int)startLocation.subtract(origin).cross(this.orientationVector).get(2);
            this.distParallelStart = this.orientationVector.dot(startLocation);
            this.distParallelEnd = this.orientationVector.dot(endLocation);
        }

        @Override
        public int orientationMagnitude() {
            return this.orientationMagnitude;
        }

        @Override
        public int distPerpendicular() {
            return this.distPerpendicular;
        }

        @Override
        public float distParallelStart() {
            return this.distParallelStart;
        }

        @Override
        public float distParallelEnd() {
            return this.distParallelEnd;
        }

        @Override
        public Vector getStartLocation() {
            return this.startLocation;
        }

        @Override
        public Vector getEndLocation() {
            return this.endLocation;
        }

        @Override
        public float getCharSpaceWidth() {
            return this.charSpaceWidth;
        }

        @Override
        public boolean sameLine(ITextChunkLocation as) {
            if (this.orientationMagnitude() != as.orientationMagnitude()) {
                return false;
            }
            float distPerpendicularDiff = this.distPerpendicular() - as.distPerpendicular();
            if (distPerpendicularDiff == 0.0f) {
                return true;
            }
            LineSegment mySegment = new LineSegment(this.startLocation, this.endLocation);
            LineSegment otherSegment = new LineSegment(as.getStartLocation(), as.getEndLocation());
            return Math.abs(distPerpendicularDiff) <= 2.0f && (mySegment.getLength() == 0.0f || otherSegment.getLength() == 0.0f);
        }

        @Override
        public float distanceFromEndOf(ITextChunkLocation other) {
            return this.distParallelStart() - other.distParallelEnd();
        }

        @Override
        public boolean isAtWordBoundary(ITextChunkLocation previous) {
            if (this.getCharSpaceWidth() < 0.1f) {
                return false;
            }
            if (this.startLocation.equals(this.endLocation) || previous.getEndLocation().equals(previous.getStartLocation())) {
                return false;
            }
            float dist = this.distanceFromEndOf(previous);
            return dist < -this.getCharSpaceWidth() || dist > this.getCharSpaceWidth() / 2.0f;
        }

        @Override
        public int compareTo(ITextChunkLocation other) {
            return defaultComparator.compare(this, other);
        }
    }

    public static class TextChunk
    implements Comparable<TextChunk> {
        protected final String text;
        protected final ITextChunkLocation location;

        public TextChunk(String string, ITextChunkLocation loc) {
            this.text = string;
            this.location = loc;
        }

        public String getText() {
            return this.text;
        }

        public ITextChunkLocation getLocation() {
            return this.location;
        }

        @Override
        public int compareTo(TextChunk rhs) {
            return this.location.compareTo(rhs.location);
        }

        void printDiagnostics() {
            System.out.println("Text (@" + this.location.getStartLocation() + " -> " + this.location.getEndLocation() + "): " + this.text);
            System.out.println("orientationMagnitude: " + this.location.orientationMagnitude());
            System.out.println("distPerpendicular: " + this.location.distPerpendicular());
            System.out.println("distParallel: " + this.location.distParallelStart());
        }

        boolean sameLine(TextChunk lastChunk) {
            return this.getLocation().sameLine(lastChunk.getLocation());
        }
    }

    public static interface ITextChunkLocation
    extends Comparable<ITextChunkLocation> {
        public float distParallelEnd();

        public float distParallelStart();

        public int distPerpendicular();

        public float getCharSpaceWidth();

        public Vector getEndLocation();

        public Vector getStartLocation();

        public int orientationMagnitude();

        public boolean sameLine(ITextChunkLocation var1);

        public float distanceFromEndOf(ITextChunkLocation var1);

        public boolean isAtWordBoundary(ITextChunkLocation var1);
    }

    public static interface ITextChunkLocationStrategy {
        public ITextChunkLocation createLocation(TextRenderInfo var1, LineSegment var2);
    }
}

