/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.cms.bc;

import cfca.sadk.org.bouncycastle.asn1.ASN1Null;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.misc.CAST5CBCParameters;
import cfca.sadk.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.pkcs.RC2CBCParameter;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.cms.CMSAlgorithm;
import cfca.sadk.org.bouncycastle.cms.CMSException;
import cfca.sadk.org.bouncycastle.crypto.BufferedBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.CipherKeyGenerator;
import cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import cfca.sadk.org.bouncycastle.crypto.KeyGenerationParameters;
import cfca.sadk.org.bouncycastle.crypto.Wrapper;
import cfca.sadk.org.bouncycastle.crypto.engines.AESEngine;
import cfca.sadk.org.bouncycastle.crypto.engines.DESEngine;
import cfca.sadk.org.bouncycastle.crypto.engines.DESedeEngine;
import cfca.sadk.org.bouncycastle.crypto.engines.RC2Engine;
import cfca.sadk.org.bouncycastle.crypto.engines.RC4Engine;
import cfca.sadk.org.bouncycastle.crypto.engines.RFC3211WrapEngine;
import cfca.sadk.org.bouncycastle.crypto.generators.DESKeyGenerator;
import cfca.sadk.org.bouncycastle.crypto.generators.DESedeKeyGenerator;
import cfca.sadk.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.sadk.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.sadk.org.bouncycastle.crypto.params.RC2Parameters;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;

class EnvelopedDataHelper {
    protected static final Map BASE_CIPHER_NAMES = new HashMap();
    protected static final Map CIPHER_ALG_NAMES = new HashMap();
    protected static final Map MAC_ALG_NAMES = new HashMap();
    private static final short[] rc2Ekb;

    EnvelopedDataHelper() {
    }

    String getBaseCipherName(ASN1ObjectIdentifier algorithm) {
        String name = (String)BASE_CIPHER_NAMES.get(algorithm);
        if (name == null) {
            return algorithm.getId();
        }
        return name;
    }

    static BufferedBlockCipher createCipher(ASN1ObjectIdentifier algorithm) throws CMSException {
        CBCBlockCipher cipher;
        if (NISTObjectIdentifiers.id_aes128_CBC.equals(algorithm) || NISTObjectIdentifiers.id_aes192_CBC.equals(algorithm) || NISTObjectIdentifiers.id_aes256_CBC.equals(algorithm)) {
            cipher = new CBCBlockCipher(new AESEngine());
        } else if (PKCSObjectIdentifiers.des_EDE3_CBC.equals(algorithm)) {
            cipher = new CBCBlockCipher(new DESedeEngine());
        } else if (OIWObjectIdentifiers.desCBC.equals(algorithm)) {
            cipher = new CBCBlockCipher(new DESEngine());
        } else if (PKCSObjectIdentifiers.RC2_CBC.equals(algorithm)) {
            cipher = new CBCBlockCipher(new RC2Engine());
        } else {
            throw new CMSException("cannot recognise cipher: " + algorithm);
        }
        return new PaddedBufferedBlockCipher(cipher, new PKCS7Padding());
    }

    static Wrapper createRFC3211Wrapper(ASN1ObjectIdentifier algorithm) throws CMSException {
        if (NISTObjectIdentifiers.id_aes128_CBC.equals(algorithm) || NISTObjectIdentifiers.id_aes192_CBC.equals(algorithm) || NISTObjectIdentifiers.id_aes256_CBC.equals(algorithm)) {
            return new RFC3211WrapEngine(new AESEngine());
        }
        if (PKCSObjectIdentifiers.des_EDE3_CBC.equals(algorithm)) {
            return new RFC3211WrapEngine(new DESedeEngine());
        }
        if (OIWObjectIdentifiers.desCBC.equals(algorithm)) {
            return new RFC3211WrapEngine(new DESEngine());
        }
        if (PKCSObjectIdentifiers.RC2_CBC.equals(algorithm)) {
            return new RFC3211WrapEngine(new RC2Engine());
        }
        throw new CMSException("cannot recognise wrapper: " + algorithm);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Object createContentCipher(boolean forEncryption, CipherParameters encKey, AlgorithmIdentifier encryptionAlgID) throws CMSException {
        ASN1ObjectIdentifier encAlg = encryptionAlgID.getAlgorithm();
        if (encAlg.equals(PKCSObjectIdentifiers.rc4)) {
            RC4Engine cipher = new RC4Engine();
            cipher.init(forEncryption, encKey);
            return cipher;
        }
        BufferedBlockCipher cipher = EnvelopedDataHelper.createCipher(encryptionAlgID.getAlgorithm());
        ASN1Primitive sParams = encryptionAlgID.getParameters().toASN1Primitive();
        if (sParams != null && !(sParams instanceof ASN1Null)) {
            if (encAlg.equals(CMSAlgorithm.DES_EDE3_CBC) || encAlg.equals(CMSAlgorithm.IDEA_CBC) || encAlg.equals(CMSAlgorithm.AES128_CBC) || encAlg.equals(CMSAlgorithm.AES192_CBC) || encAlg.equals(CMSAlgorithm.AES256_CBC) || encAlg.equals(CMSAlgorithm.CAMELLIA128_CBC) || encAlg.equals(CMSAlgorithm.CAMELLIA192_CBC) || encAlg.equals(CMSAlgorithm.CAMELLIA256_CBC) || encAlg.equals(CMSAlgorithm.SEED_CBC) || encAlg.equals(OIWObjectIdentifiers.desCBC)) {
                cipher.init(forEncryption, new ParametersWithIV(encKey, ASN1OctetString.getInstance(sParams).getOctets()));
                return cipher;
            } else if (encAlg.equals(CMSAlgorithm.CAST5_CBC)) {
                CAST5CBCParameters cbcParams = CAST5CBCParameters.getInstance(sParams);
                cipher.init(forEncryption, new ParametersWithIV(encKey, cbcParams.getIV()));
                return cipher;
            } else {
                if (!encAlg.equals(CMSAlgorithm.RC2_CBC)) throw new CMSException("cannot match parameters");
                RC2CBCParameter cbcParams = RC2CBCParameter.getInstance(sParams);
                cipher.init(forEncryption, new ParametersWithIV(new RC2Parameters(((KeyParameter)encKey).getKey(), rc2Ekb[cbcParams.getRC2ParameterVersion().intValue()]), cbcParams.getIV()));
            }
            return cipher;
        } else if (encAlg.equals(CMSAlgorithm.DES_EDE3_CBC) || encAlg.equals(CMSAlgorithm.IDEA_CBC) || encAlg.equals(CMSAlgorithm.CAST5_CBC)) {
            cipher.init(forEncryption, new ParametersWithIV(encKey, new byte[8]));
            return cipher;
        } else {
            cipher.init(forEncryption, encKey);
        }
        return cipher;
    }

    AlgorithmIdentifier generateAlgorithmIdentifier(ASN1ObjectIdentifier encryptionOID, CipherParameters encKey, SecureRandom random) throws CMSException {
        if (encryptionOID.equals(CMSAlgorithm.AES128_CBC) || encryptionOID.equals(CMSAlgorithm.AES192_CBC) || encryptionOID.equals(CMSAlgorithm.AES256_CBC) || encryptionOID.equals(CMSAlgorithm.CAMELLIA128_CBC) || encryptionOID.equals(CMSAlgorithm.CAMELLIA192_CBC) || encryptionOID.equals(CMSAlgorithm.CAMELLIA256_CBC) || encryptionOID.equals(CMSAlgorithm.SEED_CBC)) {
            byte[] iv = new byte[16];
            random.nextBytes(iv);
            return new AlgorithmIdentifier(encryptionOID, new DEROctetString(iv));
        }
        if (encryptionOID.equals(CMSAlgorithm.DES_EDE3_CBC) || encryptionOID.equals(CMSAlgorithm.IDEA_CBC) || encryptionOID.equals(OIWObjectIdentifiers.desCBC)) {
            byte[] iv = new byte[8];
            random.nextBytes(iv);
            return new AlgorithmIdentifier(encryptionOID, new DEROctetString(iv));
        }
        if (encryptionOID.equals(CMSAlgorithm.CAST5_CBC)) {
            byte[] iv = new byte[8];
            random.nextBytes(iv);
            CAST5CBCParameters cbcParams = new CAST5CBCParameters(iv, ((KeyParameter)encKey).getKey().length * 8);
            return new AlgorithmIdentifier(encryptionOID, cbcParams);
        }
        if (encryptionOID.equals(PKCSObjectIdentifiers.rc4)) {
            return new AlgorithmIdentifier(encryptionOID, DERNull.INSTANCE);
        }
        throw new CMSException("unable to match algorithm");
    }

    CipherKeyGenerator createKeyGenerator(ASN1ObjectIdentifier algorithm, SecureRandom random) throws CMSException {
        if (NISTObjectIdentifiers.id_aes128_CBC.equals(algorithm)) {
            return this.createCipherKeyGenerator(random, 128);
        }
        if (NISTObjectIdentifiers.id_aes192_CBC.equals(algorithm)) {
            return this.createCipherKeyGenerator(random, 192);
        }
        if (NISTObjectIdentifiers.id_aes256_CBC.equals(algorithm)) {
            return this.createCipherKeyGenerator(random, 256);
        }
        if (PKCSObjectIdentifiers.des_EDE3_CBC.equals(algorithm)) {
            DESedeKeyGenerator keyGen = new DESedeKeyGenerator();
            keyGen.init(new KeyGenerationParameters(random, 192));
            return keyGen;
        }
        if (NTTObjectIdentifiers.id_camellia128_cbc.equals(algorithm)) {
            return this.createCipherKeyGenerator(random, 128);
        }
        if (NTTObjectIdentifiers.id_camellia192_cbc.equals(algorithm)) {
            return this.createCipherKeyGenerator(random, 192);
        }
        if (NTTObjectIdentifiers.id_camellia256_cbc.equals(algorithm)) {
            return this.createCipherKeyGenerator(random, 256);
        }
        if (KISAObjectIdentifiers.id_seedCBC.equals(algorithm)) {
            return this.createCipherKeyGenerator(random, 128);
        }
        if (CMSAlgorithm.CAST5_CBC.equals(algorithm)) {
            return this.createCipherKeyGenerator(random, 128);
        }
        if (OIWObjectIdentifiers.desCBC.equals(algorithm)) {
            DESKeyGenerator keyGen = new DESKeyGenerator();
            keyGen.init(new KeyGenerationParameters(random, 64));
            return keyGen;
        }
        if (PKCSObjectIdentifiers.rc4.equals(algorithm)) {
            return this.createCipherKeyGenerator(random, 128);
        }
        throw new CMSException("cannot recognise cipher: " + algorithm);
    }

    private CipherKeyGenerator createCipherKeyGenerator(SecureRandom random, int keySize) {
        CipherKeyGenerator keyGen = new CipherKeyGenerator();
        keyGen.init(new KeyGenerationParameters(random, keySize));
        return keyGen;
    }

    static {
        BASE_CIPHER_NAMES.put(CMSAlgorithm.DES_EDE3_CBC, "DESEDE");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.AES128_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.AES192_CBC, "AES");
        BASE_CIPHER_NAMES.put(CMSAlgorithm.AES256_CBC, "AES");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.DES_EDE3_CBC, "DESEDE/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.AES128_CBC, "AES/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.AES192_CBC, "AES/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.AES256_CBC, "AES/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(new ASN1ObjectIdentifier(PKCSObjectIdentifiers.rsaEncryption.getId()), "RSA/ECB/PKCS1Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.CAST5_CBC, "CAST5/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.CAMELLIA128_CBC, "Camellia/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.CAMELLIA192_CBC, "Camellia/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.CAMELLIA256_CBC, "Camellia/CBC/PKCS5Padding");
        CIPHER_ALG_NAMES.put(CMSAlgorithm.SEED_CBC, "SEED/CBC/PKCS5Padding");
        MAC_ALG_NAMES.put(CMSAlgorithm.DES_EDE3_CBC, "DESEDEMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.AES128_CBC, "AESMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.AES192_CBC, "AESMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.AES256_CBC, "AESMac");
        MAC_ALG_NAMES.put(CMSAlgorithm.RC2_CBC, "RC2Mac");
        rc2Ekb = new short[]{93, 190, 155, 139, 17, 153, 110, 77, 89, 243, 133, 166, 63, 183, 131, 197, 228, 115, 107, 58, 104, 90, 192, 71, 160, 100, 52, 12, 241, 208, 82, 165, 185, 30, 150, 67, 65, 216, 212, 44, 219, 248, 7, 119, 42, 202, 235, 239, 16, 28, 22, 13, 56, 114, 47, 137, 193, 249, 128, 196, 109, 174, 48, 61, 206, 32, 99, 254, 230, 26, 199, 184, 80, 232, 36, 23, 252, 37, 111, 187, 106, 163, 68, 83, 217, 162, 1, 171, 188, 182, 31, 152, 238, 154, 167, 45, 79, 158, 142, 172, 224, 198, 73, 70, 41, 244, 148, 138, 175, 225, 91, 195, 179, 123, 87, 209, 124, 156, 237, 135, 64, 140, 226, 203, 147, 20, 201, 97, 46, 229, 204, 246, 94, 168, 92, 214, 117, 141, 98, 149, 88, 105, 118, 161, 74, 181, 85, 9, 120, 51, 130, 215, 221, 121, 245, 27, 11, 222, 38, 33, 40, 116, 4, 151, 86, 223, 60, 240, 55, 57, 220, 255, 6, 164, 234, 66, 8, 218, 180, 113, 176, 207, 18, 122, 78, 250, 108, 29, 132, 0, 200, 127, 145, 69, 170, 43, 194, 177, 143, 213, 186, 242, 173, 25, 178, 103, 54, 247, 15, 10, 146, 125, 227, 157, 233, 144, 62, 35, 39, 102, 19, 236, 129, 21, 189, 34, 191, 159, 126, 169, 81, 75, 76, 251, 2, 211, 112, 134, 49, 231, 59, 5, 3, 84, 96, 72, 101, 24, 210, 205, 95, 50, 136, 14, 53, 253};
    }
}

