/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client;

import cfca.sadk.lib.crypto.Session;
import cfca.sadk.timestamp.client.BusinessTrustCerts;
import cfca.sadk.timestamp.client.TSASignedData;
import cfca.sadk.timestamp.client.api.Timestamp;
import cfca.sadk.timestamp.client.api.TimestampConfig;
import cfca.sadk.timestamp.client.api.TimestampHelper;
import cfca.sadk.timestamp.client.env.DefaultSessionLib;
import cfca.sadk.timestamp.client.logging.TscLogging;
import cfca.sadk.timestamp.client.utils.TscStrings;
import cfca.sadk.timestamp.exception.TSAErrorCode;
import cfca.sadk.timestamp.exception.TSAException;
import cfca.sadk.x509.certificate.X509Cert;
import org.apache.http.util.Args;

final class StandardTimestampHelper
implements TimestampHelper {
    private final long warningThresholdTime;
    private final BusinessTrustCerts trustCerts;
    private Session session;
    private X509Cert signCert = null;

    public StandardTimestampHelper(TimestampConfig config) throws TSAException {
        TscLogging.SYSTEM_LOGGER.info("TimestampHelper instance running...");
        if (config == null) {
            TscLogging.ERROR_LOGGER.error("TimestampHelper missing parameter@timestampConfig");
            throw new TSAException(TSAErrorCode.timestampHelperMissingTimestampConfig, "required parameter timestampConfig");
        }
        TscLogging.SYSTEM_LOGGER.info("TimestampHelper config {}", (Object)config);
        this.warningThresholdTime = config.getWarningThresholdTime();
        try {
            this.trustCerts = new BusinessTrustCerts(config.getHttpAuthInfoConf());
        }
        catch (TSAException e) {
            TscLogging.ERROR_LOGGER.error("TimestampHelper@BusinessTrustCerts failure: {}", (Object)config, (Object)e);
            throw e;
        }
        this.session = DefaultSessionLib.SESSION;
        TscLogging.SYSTEM_LOGGER.info("TimestampHelper instance finished");
    }

    @Override
    public void setSession(Session session) {
        this.session = session == null ? DefaultSessionLib.SESSION : session;
    }

    @Override
    public BusinessTrustCerts currentBusinessTrustCerts() {
        return this.trustCerts;
    }

    @Override
    public void setSignCert(X509Cert signCert) {
        this.signCert = signCert;
    }

    @Override
    public boolean verifyTimestamp(byte[] responseTimestampData) throws TSAException {
        boolean verifiedResult;
        TscLogging.SYSTEM_LOGGER.info("TimestampHelper@verifyTimestamp running...");
        long startTime = System.currentTimeMillis();
        TSASignedData signedData = this.decodeTimestamp(responseTimestampData);
        try {
            verifiedResult = signedData.verifySignedData(this.trustCerts, this.session);
        }
        catch (TSAException e) {
            TscLogging.ERROR_LOGGER.error("TimestampHelper@verifyTimestamp check signedData/signedCert failure", (Throwable)e);
            throw e;
        }
        long callTime = System.currentTimeMillis() - startTime;
        if (callTime > this.warningThresholdTime) {
            TscLogging.ERROR_LOGGER.error("TimestampHelper@verifyTimestamp finished, verifyResult={}, longTime={}ms", (Object)verifiedResult, (Object)callTime);
        } else {
            TscLogging.SYSTEM_LOGGER.info("TimestampHelper@verifyTimestamp finished, verifyResult={}, time={}ms", (Object)verifiedResult, (Object)callTime);
        }
        return verifiedResult;
    }

    @Override
    public Timestamp getTimestamp(byte[] responseTimestampData) throws TSAException {
        TscLogging.SYSTEM_LOGGER.info("TimestampHelper@getTimestamp running...");
        long startTime = System.currentTimeMillis();
        TSASignedData signedData = this.decodeTimestamp(responseTimestampData);
        Timestamp timestamp = signedData.getTimeStamp();
        long callTime = System.currentTimeMillis() - startTime;
        if (callTime > this.warningThresholdTime) {
            TscLogging.ERROR_LOGGER.error("TimestampHelper@getTimestamp finished,  longTime={}ms", (Object)callTime);
        } else {
            TscLogging.SYSTEM_LOGGER.info("TimestampHelper@getTimestamp finished,  time={}ms", (Object)callTime);
        }
        return timestamp;
    }

    private TSASignedData decodeTimestamp(byte[] responseTimestampData) throws TSAException {
        TSASignedData signedData;
        Args.notNull((Object)responseTimestampData, (String)"responseTimestampData");
        try {
            signedData = new TSASignedData(null, responseTimestampData, false, this.signCert);
        }
        catch (TSAException e) {
            TscLogging.ERROR_LOGGER.error("TimestampHelper@decodeTimestamp invalid response: {}", (Object)TscStrings.toBase64String(responseTimestampData), (Object)e);
            throw e;
        }
        return signedData;
    }
}

