/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client.sdk;

import cfca.paperless.base.util.ImageUtil;
import cfca.paperless.base.util.ProofHashUtil;
import cfca.paperless.base.util.StringUtil;
import cfca.paperless.client.util.CheckPdfUtil;
import cfca.paperless.dto.ResponseHead;
import cfca.paperless.dto.bean.WaterMarkStrategy;
import cfca.paperless.dto.request.requestbody.tx10.AddWaterMarkToPdfRequestBody;
import cfca.paperless.dto.request.tx10.AddWaterMarkToPdfRequest;
import cfca.paperless.dto.response.responsebody.tx10.AddWaterMarkToPdfResponseBody;
import cfca.paperless.dto.response.tx10.AddWaterMarkToPdfResponse;
import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.color.DeviceRgb;
import cfca.sadk.com.itextpdf.layout.property.TextAlignment;
import cfca.sadk.seal.base.util.PDFUtil;
import cfca.sadk.seal.util.WatermarkUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddWaterMarkToPdfProcess {
    private static final Logger logger = LoggerFactory.getLogger(AddWaterMarkToPdfProcess.class);

    public AddWaterMarkToPdfResponse process(AddWaterMarkToPdfRequest requestBean) throws Exception {
        long start = System.currentTimeMillis();
        logger.info("AddWaterMarkToPdfProcess.process start.");
        AddWaterMarkToPdfRequestBody requestBody = requestBean.getBody();
        byte[] pdfData = new byte[]{};
        if (!"1".equals(requestBody.getInputType()) && !"2".equals(requestBody.getInputType())) {
            throw new Exception("invalid inputType");
        }
        if ("1".equals(requestBody.getInputType())) {
            if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
                throw new Exception("inputSource is null");
            }
            pdfData = FileUtils.readFileToByteArray((File)new File(requestBody.getInputSource()));
        } else if ("2".equals(requestBody.getInputType())) {
            if (requestBody.getPdfData() == null) {
                throw new Exception("pdfData is null");
            }
            pdfData = requestBody.getPdfData();
        }
        CheckPdfUtil.checkPdfData(pdfData, false);
        int pageCount = PDFUtil.getPageNums((byte[])pdfData);
        logger.info("PDF\u6587\u4ef6\u9875\u6570\uff1a" + pageCount);
        WaterMarkStrategy waterMarkStrategy = requestBody.getWaterMarkStrategy();
        if ("0".equals(waterMarkStrategy.getFromPage())) {
            waterMarkStrategy.setFromPage("1");
            waterMarkStrategy.setToPage(pageCount + "");
        }
        int fromPage = Integer.parseInt(waterMarkStrategy.getFromPage());
        int toPage = Integer.parseInt(waterMarkStrategy.getToPage());
        if (StringUtil.isEmpty((String)waterMarkStrategy.getAbsoluteX())) {
            waterMarkStrategy.setAbsoluteX("0");
        }
        if (StringUtil.isEmpty((String)waterMarkStrategy.getAbsoluteY())) {
            waterMarkStrategy.setAbsoluteY("0");
        }
        if (StringUtil.isEmpty((String)waterMarkStrategy.getApartX())) {
            waterMarkStrategy.setApartX("-1");
        }
        if (StringUtil.isEmpty((String)waterMarkStrategy.getApartY())) {
            waterMarkStrategy.setApartY("-1");
        }
        WatermarkUtil.PageRangeOption pageRangeOption = WatermarkUtil.PageRangeOption.build((int)fromPage, (int)toPage, (int)0);
        Color fontColor = Color.BLACK;
        if (StringUtil.isNotEmpty((String)waterMarkStrategy.getColor())) {
            DeviceRgb businessColor = ImageUtil.hex2RGB((String)waterMarkStrategy.getColor());
            fontColor = Color.convertRgbToCmyk((DeviceRgb)businessColor);
        }
        float fontSize = 12.0f;
        if (StringUtil.isNotEmpty((String)waterMarkStrategy.getFontSize())) {
            fontSize = Float.parseFloat(waterMarkStrategy.getFontSize());
        }
        boolean isAboveText = !"1".equals(waterMarkStrategy.getIsAboveText());
        ByteArrayInputStream bais = new ByteArrayInputStream(pdfData);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (StringUtil.isEmpty((String)waterMarkStrategy.getWaterMarkText()) && waterMarkStrategy.getWaterMarkImageData() == null) {
            throw new Exception("\u6dfb\u52a0\u6c34\u5370\u7b56\u7565\u4e2d \u6587\u672c \u4e0e \u56fe\u7247 \u6570\u636e \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (StringUtil.isNotEmpty((String)waterMarkStrategy.getWaterMarkText())) {
            logger.info("PDF\u6587\u4ef6\u6dfb\u52a0\u6c34\u5370\u6587\u672c");
            String waterMarkText = waterMarkStrategy.getWaterMarkText();
            WatermarkUtil.WatermarkOption waterMarkOption = WatermarkUtil.WatermarkOption.buildTextOption((boolean)isAboveText, (float)Float.parseFloat(waterMarkStrategy.getAbsoluteX()), (float)Float.parseFloat(waterMarkStrategy.getAbsoluteY()), (float)Float.parseFloat(waterMarkStrategy.getApartX()), (float)Float.parseFloat(waterMarkStrategy.getApartY()), (float)Float.parseFloat(waterMarkStrategy.getRotationDegree()), (float)Float.parseFloat(waterMarkStrategy.getAlpha()), (Color)fontColor, null, (float)fontSize, (TextAlignment)TextAlignment.LEFT);
            WatermarkUtil.addWatermark((InputStream)bais, (OutputStream)baos, (String)waterMarkText, (WatermarkUtil.PageRangeOption)pageRangeOption, (WatermarkUtil.WatermarkOption)waterMarkOption);
        } else if (waterMarkStrategy.getWaterMarkImageData() != null) {
            logger.info("PDF\u6587\u4ef6\u6dfb\u52a0\u6c34\u5370\u56fe\u7247");
            WatermarkUtil.WatermarkOption waterMarkOption = WatermarkUtil.WatermarkOption.buildImageOption((boolean)isAboveText, (float)Float.parseFloat(waterMarkStrategy.getAbsoluteX()), (float)Float.parseFloat(waterMarkStrategy.getAbsoluteY()), (float)Float.parseFloat(waterMarkStrategy.getApartX()), (float)Float.parseFloat(waterMarkStrategy.getApartY()), (float)Float.parseFloat(waterMarkStrategy.getRotationDegree()), (float)Float.parseFloat(waterMarkStrategy.getAlpha()), (float)Float.parseFloat(waterMarkStrategy.getFitWidth()), (float)Float.parseFloat(waterMarkStrategy.getFitHeight()));
            byte[] imageData = waterMarkStrategy.getWaterMarkImageData();
            WatermarkUtil.addWatermark((InputStream)bais, (OutputStream)baos, (byte[])imageData, (WatermarkUtil.PageRangeOption)pageRangeOption, (WatermarkUtil.WatermarkOption)waterMarkOption);
        }
        if (null != baos && baos.size() > 0) {
            pdfData = baos.toByteArray();
        }
        String pdfFileDataHash = ProofHashUtil.digestAndHex((byte[])pdfData);
        ResponseHead head = new ResponseHead();
        head.setTransactionNo(requestBean.getHead().getTransactionNo());
        AddWaterMarkToPdfResponseBody body = new AddWaterMarkToPdfResponseBody();
        body.setPdf(pdfData);
        body.setPdfFileDataHash(pdfFileDataHash);
        AddWaterMarkToPdfResponse responseBean = new AddWaterMarkToPdfResponse();
        responseBean.setHead(head);
        responseBean.setBody(body);
        long end = System.currentTimeMillis();
        logger.info("AddWaterMarkToPdfProcess.process end. time-taken={}ms", (Object)(end - start));
        return responseBean;
    }
}

