/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.styledxmlparser.css;

import cfca.sadk.com.itextpdf.styledxmlparser.css.CssFontFaceRule;
import cfca.sadk.com.itextpdf.styledxmlparser.css.CssNestedAtRule;
import cfca.sadk.com.itextpdf.styledxmlparser.css.media.CssMediaRule;
import cfca.sadk.com.itextpdf.styledxmlparser.css.page.CssMarginRule;
import cfca.sadk.com.itextpdf.styledxmlparser.css.page.CssPageRule;
import java.util.HashMap;

public final class CssNestedAtRuleFactory {
    private static HashMap<String, Integer> ruleNameSequenceMap = new HashMap();
    private static int rulesequence = 0;

    private CssNestedAtRuleFactory() {
    }

    public static CssNestedAtRule createNestedRule(String ruleDeclaration) {
        ruleDeclaration = ruleDeclaration.trim();
        String ruleName = CssNestedAtRuleFactory.extractRuleNameFromDeclaration(ruleDeclaration);
        String ruleParameters = ruleDeclaration.substring(ruleName.length()).trim();
        int ruleSequence = ruleNameSequenceMap.get(ruleName);
        switch (ruleSequence) {
            case 0: {
                return new CssMediaRule(ruleParameters);
            }
            case 1: {
                return new CssPageRule(ruleParameters);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return new CssMarginRule(ruleName, ruleParameters);
            }
            case 18: {
                return new CssFontFaceRule(ruleParameters);
            }
        }
        return new CssNestedAtRule(ruleName, ruleParameters);
    }

    static String extractRuleNameFromDeclaration(String ruleDeclaration) {
        int spaceIndex = ruleDeclaration.indexOf(32);
        int colonIndex = ruleDeclaration.indexOf(58);
        int separatorIndex = spaceIndex == -1 ? colonIndex : (colonIndex == -1 ? spaceIndex : Math.min(spaceIndex, colonIndex));
        return separatorIndex == -1 ? ruleDeclaration : ruleDeclaration.substring(0, separatorIndex);
    }

    static {
        ruleNameSequenceMap.put("media", rulesequence++);
        ruleNameSequenceMap.put("page", rulesequence++);
        ruleNameSequenceMap.put("top-left-corner", rulesequence++);
        ruleNameSequenceMap.put("top-left", rulesequence++);
        ruleNameSequenceMap.put("top-center", rulesequence++);
        ruleNameSequenceMap.put("top-right", rulesequence++);
        ruleNameSequenceMap.put("top-right-corner", rulesequence++);
        ruleNameSequenceMap.put("left-top", rulesequence++);
        ruleNameSequenceMap.put("left-middle", rulesequence++);
        ruleNameSequenceMap.put("left-bottom", rulesequence++);
        ruleNameSequenceMap.put("right-top", rulesequence++);
        ruleNameSequenceMap.put("right-middle", rulesequence++);
        ruleNameSequenceMap.put("right-bottom", rulesequence++);
        ruleNameSequenceMap.put("bottom-left-corner", rulesequence++);
        ruleNameSequenceMap.put("bottom-left", rulesequence++);
        ruleNameSequenceMap.put("bottom-center", rulesequence++);
        ruleNameSequenceMap.put("bottom-right", rulesequence++);
        ruleNameSequenceMap.put("bottom-right-corner", rulesequence++);
        ruleNameSequenceMap.put("font-face", rulesequence++);
    }
}

