/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.asn1;

import cfca.sadk.ofd.base.asn1.ExtensionDatas;
import cfca.sadk.ofd.base.asn1.SES_ESPictureInfo;
import cfca.sadk.ofd.base.asn1.SES_ESPropertyInfo;
import cfca.sadk.ofd.base.asn1.SES_Header;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERIA5String;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import java.util.Enumeration;

public class SES_SealInfo
extends ASN1Object
implements PKCSObjectIdentifiers {
    private SES_Header header;
    private DERIA5String esID;
    private SES_ESPropertyInfo property;
    private SES_ESPictureInfo picture;
    private ExtensionDatas extDatas;
    private ASN1OctetString cert;
    private ASN1ObjectIdentifier signatureAlgorithm;

    public static SES_SealInfo getInstance(Object o) {
        if (null != o) {
            if (o instanceof SES_SealInfo) {
                return (SES_SealInfo)((Object)o);
            }
            if (o instanceof ASN1Sequence || o instanceof byte[]) {
                return new SES_SealInfo(ASN1Sequence.getInstance((Object)o));
            }
        }
        return null;
    }

    public SES_SealInfo(SES_Header header, DERIA5String esID, SES_ESPropertyInfo property, SES_ESPictureInfo picture, ExtensionDatas extDatas, ASN1OctetString cert, ASN1ObjectIdentifier signatureAlgorithm) {
        this.header = header;
        this.esID = esID;
        this.property = property;
        this.picture = picture;
        this.extDatas = extDatas;
        this.cert = cert;
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public SES_SealInfo(ASN1Sequence instance) {
        Enumeration e = instance.getObjects();
        this.header = SES_Header.getInstance(e.nextElement());
        this.esID = DERIA5String.getInstance(e.nextElement());
        this.property = SES_ESPropertyInfo.getInstance(e.nextElement());
        this.picture = SES_ESPictureInfo.getInstance(e.nextElement());
        if (e.hasMoreElements()) {
            Object extOrCert = e.nextElement();
            if (extOrCert instanceof ASN1Sequence) {
                this.extDatas = ExtensionDatas.getInstance(extOrCert);
            } else {
                this.cert = ASN1OctetString.getInstance(extOrCert);
                this.signatureAlgorithm = ASN1ObjectIdentifier.getInstance(e.nextElement());
            }
        }
    }

    public SES_Header getHeader() {
        return this.header;
    }

    public DERIA5String getEsID() {
        return this.esID;
    }

    public SES_ESPropertyInfo getProperty() {
        return this.property;
    }

    public SES_ESPictureInfo getPicture() {
        return this.picture;
    }

    public ExtensionDatas getExtDatas() {
        return this.extDatas;
    }

    public ASN1ObjectIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public ASN1OctetString getCert() {
        return this.cert;
    }

    public void setHeader(SES_Header header) {
        this.header = header;
    }

    public void setEsID(DERIA5String esID) {
        this.esID = esID;
    }

    public void setProperty(SES_ESPropertyInfo property) {
        this.property = property;
    }

    public void setPicture(SES_ESPictureInfo picture) {
        this.picture = picture;
    }

    public void setExtDatas(ExtensionDatas extDatas) {
        this.extDatas = extDatas;
    }

    public void setCert(ASN1OctetString cert) {
        this.cert = cert;
    }

    public void setSignatureAlgorithm(ASN1ObjectIdentifier signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.header);
        v.add((ASN1Encodable)this.esID);
        v.add((ASN1Encodable)this.property);
        v.add((ASN1Encodable)this.picture);
        if (null != this.extDatas) {
            v.add((ASN1Encodable)this.extDatas);
        }
        if (null != this.cert) {
            v.add((ASN1Encodable)this.cert);
        }
        if (null != this.signatureAlgorithm) {
            v.add((ASN1Encodable)this.signatureAlgorithm);
        }
        return new DERSequence(v);
    }
}

