/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.asn1;

import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERPrintableString;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import java.util.Enumeration;

public class CertDigestObj
extends ASN1Object
implements PKCSObjectIdentifiers {
    private DERPrintableString objType;
    private ASN1OctetString certDigestValue;

    public static CertDigestObj getInstance(Object o) {
        if (o instanceof CertDigestObj) {
            return (CertDigestObj)((Object)o);
        }
        if (o != null) {
            return new CertDigestObj(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public CertDigestObj(DERPrintableString objType, ASN1OctetString certDigestValue) {
        this.objType = objType;
        this.certDigestValue = certDigestValue;
    }

    public CertDigestObj(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.objType = DERPrintableString.getInstance(e.nextElement());
        this.certDigestValue = ASN1OctetString.getInstance(e.nextElement());
    }

    public DERPrintableString getObjType() {
        return this.objType;
    }

    public ASN1OctetString getCertDigestValue() {
        return this.certDigestValue;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.objType);
        v.add((ASN1Encodable)this.certDigestValue);
        return new DERSequence(v);
    }
}

