/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text.log;

import cfca.com.itextpdf.text.log.Appender;
import cfca.com.itextpdf.text.log.Level;
import cfca.com.itextpdf.text.log.Logger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysoLogger
implements Logger {
    private String klassName;
    private final int shorten;
    private ArrayList<Appender> appenderList;
    private int level;
    Date date = new Date();
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public SysoLogger() {
        this(1);
    }

    public SysoLogger(int packageReduce) {
        this.shorten = packageReduce;
    }

    protected SysoLogger(String klassName, int shorten) {
        this.shorten = shorten;
        this.klassName = klassName;
    }

    @Override
    public Logger getLogger(Class<?> klass) {
        return new SysoLogger(klass.getName(), this.shorten);
    }

    @Override
    public Logger getLogger(String name) {
        return new SysoLogger("[itext]", 0);
    }

    @Override
    public boolean isLogging(Level level) {
        return true;
    }

    @Override
    public void warn(String message) {
        StackTraceElement[] t = Thread.currentThread().getStackTrace();
        if (this.level <= Level.WARN.ordinal()) {
            String logString = String.format("[%s] [%s] %s.%s:%s DEBUG %s", this.sdf.format(this.date), Thread.currentThread().getName(), this.shorten(this.klassName), t[2].getMethodName(), t[2].getLineNumber(), message);
            for (Appender appender : this.appenderList) {
                appender.appendString(logString);
            }
        }
    }

    private String shorten(String className) {
        if (this.shorten != 0) {
            StringBuilder target = new StringBuilder();
            String name = className;
            int fromIndex = className.indexOf(46);
            while (fromIndex != -1) {
                int parseTo = fromIndex < this.shorten ? fromIndex : this.shorten;
                target.append(name.substring(0, parseTo));
                target.append('.');
                name = name.substring(fromIndex + 1);
                fromIndex = name.indexOf(46);
            }
            target.append(className.substring(className.lastIndexOf(46) + 1));
            return target.toString();
        }
        return className;
    }

    @Override
    public void trace(String message) {
        StackTraceElement[] t = Thread.currentThread().getStackTrace();
        if (this.level <= Level.TRACE.ordinal()) {
            String logString = String.format("[%s] [%s] %s.%s:%s DEBUG %s", this.sdf.format(this.date), Thread.currentThread().getName(), this.shorten(this.klassName), t[2].getMethodName(), t[2].getLineNumber(), message);
            for (Appender appender : this.appenderList) {
                appender.appendString(logString);
            }
        }
    }

    @Override
    public void debug(String message) {
        StackTraceElement[] t = Thread.currentThread().getStackTrace();
        if (this.level <= Level.DEBUG.ordinal()) {
            String logString = String.format("[%s] [%s] %s.%s:%s DEBUG %s", this.sdf.format(this.date), Thread.currentThread().getName(), this.shorten(this.klassName), t[2].getMethodName(), t[2].getLineNumber(), message);
            for (Appender appender : this.appenderList) {
                appender.appendString(logString);
            }
        }
    }

    @Override
    public void info(String message) {
        StackTraceElement[] t = Thread.currentThread().getStackTrace();
        if (this.level <= Level.INFO.ordinal()) {
            String logString = String.format("[%s] [%s] %s.%s:%s DEBUG %s", this.sdf.format(this.date), Thread.currentThread().getName(), this.shorten(this.klassName), t[2].getMethodName(), t[2].getLineNumber(), message);
            for (Appender appender : this.appenderList) {
                appender.appendString(logString);
            }
        }
    }

    @Override
    public void error(String message) {
        StackTraceElement[] t = Thread.currentThread().getStackTrace();
        if (this.level <= Level.ERROR.ordinal()) {
            String logString = String.format("[%s] [%s] %s.%s:%s DEBUG %s", this.sdf.format(this.date), Thread.currentThread().getName(), this.shorten(this.klassName), t[2].getMethodName(), t[2].getLineNumber(), message);
            for (Appender appender : this.appenderList) {
                appender.appendString(logString);
            }
        }
    }

    @Override
    public void error(String message, Exception e) {
        StackTraceElement[] t = Thread.currentThread().getStackTrace();
        if (this.level <= Level.ERROR.ordinal()) {
            String logString = String.format("[%s] [%s] %s.%s:%s DEBUG %s", this.sdf.format(this.date), Thread.currentThread().getName(), this.shorten(this.klassName), t[2].getMethodName(), t[2].getLineNumber(), message);
            for (Appender appender : this.appenderList) {
                appender.appendString(logString);
            }
            e.printStackTrace(System.out);
        }
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public void setAppenderList(ArrayList<Appender> appenderList) {
        this.appenderList = appenderList;
    }
}

