/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.tool.xml.pipeline;

import cfca.com.itextpdf.tool.xml.CustomContext;
import cfca.com.itextpdf.tool.xml.NoCustomContextException;
import cfca.com.itextpdf.tool.xml.Pipeline;
import cfca.com.itextpdf.tool.xml.PipelineException;
import cfca.com.itextpdf.tool.xml.ProcessObject;
import cfca.com.itextpdf.tool.xml.Tag;
import cfca.com.itextpdf.tool.xml.WorkerContext;
import cfca.com.itextpdf.tool.xml.exceptions.LocaleMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPipeline<T extends CustomContext>
implements Pipeline<T> {
    private Pipeline<?> next;

    public AbstractPipeline(Pipeline<?> next) {
        this.setNext(next);
    }

    @Override
    public Pipeline<?> getNext() {
        return this.next;
    }

    @Override
    public Pipeline<?> open(WorkerContext context, Tag t, ProcessObject po) throws PipelineException {
        return this.getNext();
    }

    @Override
    public Pipeline<?> content(WorkerContext ctx, Tag currentTag, String text, ProcessObject po) throws PipelineException {
        return this.getNext();
    }

    @Override
    public Pipeline<?> close(WorkerContext context, Tag t, ProcessObject po) throws PipelineException {
        return this.getNext();
    }

    public T getLocalContext(WorkerContext context) throws PipelineException {
        try {
            CustomContext cc = context.get(this.getContextKey());
            if (null != cc) {
                return (T)cc;
            }
            throw new PipelineException(String.format(LocaleMessages.getInstance().getMessage("pipeline.owncontextmissing"), this.getClass().getName()));
        }
        catch (NoCustomContextException e) {
            throw new PipelineException(String.format(LocaleMessages.getInstance().getMessage("pipeline.owncontextmissing"), this.getClass().getName()), e);
        }
    }

    public void setNext(Pipeline<?> next) {
        this.next = next;
    }

    public String getContextKey() {
        return this.getClass().getName();
    }

    @Override
    public Pipeline<?> init(WorkerContext context) throws PipelineException {
        return this.getNext();
    }
}

