/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.maker.util;

public class EndianUtil {
    public static byte[] intToBytes(int number) {
        byte[] bytes = new byte[]{(byte)(0xFF & number >> 0), (byte)(0xFF & number >> 8), (byte)(0xFF & number >> 16), (byte)(0xFF & number >> 24)};
        return bytes;
    }

    public static byte[] doubleToByte(double d) {
        byte[] b = new byte[8];
        long l = Double.doubleToLongBits(d);
        b = EndianUtil.longToBytes(l);
        return b;
    }

    public static byte[] longToBytes(long number) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(0xFFL & number >> i * 8);
        }
        return bytes;
    }

    public static int bytesToInt(byte[] data) {
        int num = 0;
        int temp = (0xFF & data[0]) << 0;
        num |= temp;
        temp = (0xFF & data[1]) << 8;
        num |= temp;
        temp = (0xFF & data[2]) << 16;
        num |= temp;
        temp = (0xFF & data[3]) << 24;
        return num |= temp;
    }

    public static long bytesToLong(byte[] data) {
        long num = 0L;
        for (int i = 0; i < 8; ++i) {
            int temp = (0xFF & data[i]) << 8 * i;
            num |= (long)temp;
        }
        return num;
    }
}

