/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.sadk.cert;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.jce.X509Principal;
import cfca.sadk.x509.certificate.X509Cert;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfX509Certificate
extends X509Certificate {
    private X509Cert x509Cert;

    public PdfX509Certificate(X509Cert x509Cert) {
        this.x509Cert = x509Cert;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        return null;
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        return null;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        return null;
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        Date notAfter = this.x509Cert.getNotAfter();
        Date now = new Date();
        Date notBefore = this.x509Cert.getNotBefore();
        if (now.before(notBefore)) {
            throw new CertificateNotYetValidException("cert not yet valid!");
        }
        if (now.after(notAfter)) {
            throw new CertificateExpiredException("cert expired!");
        }
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        Date notAfter = this.x509Cert.getNotAfter();
        Date notBefore = this.x509Cert.getNotBefore();
        if (date.before(notBefore)) {
            throw new CertificateNotYetValidException("cert not yet valid!");
        }
        if (date.after(notAfter)) {
            throw new CertificateExpiredException("cert expired!");
        }
    }

    @Override
    public int getVersion() {
        return this.x509Cert.getVersion().getValue().intValue();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.x509Cert.getSerialNumber();
    }

    @Override
    public Principal getIssuerDN() {
        String issuerDNString = this.x509Cert.getIssuer();
        X509Principal x509Principal = new X509Principal(issuerDNString);
        return x509Principal;
    }

    @Override
    public Principal getSubjectDN() {
        String issuerString = this.x509Cert.getSubject();
        return new X509Principal(issuerString);
    }

    @Override
    public Date getNotBefore() {
        return this.x509Cert.getNotBefore();
    }

    @Override
    public Date getNotAfter() {
        return this.x509Cert.getNotAfter();
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            return this.x509Cert.getTBSCertificate();
        }
        catch (PKIException e) {
            throw new CertificateEncodingException("cert encoding exception!");
        }
    }

    @Override
    public byte[] getSignature() {
        return this.x509Cert.getSignature();
    }

    @Override
    public String getSigAlgName() {
        return this.x509Cert.getSignatureAlgName();
    }

    @Override
    public String getSigAlgOID() {
        return "";
    }

    @Override
    public byte[] getSigAlgParams() {
        return null;
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        return null;
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        return null;
    }

    @Override
    public boolean[] getKeyUsage() {
        return null;
    }

    @Override
    public int getBasicConstraints() {
        return 0;
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.x509Cert.getEncoded();
        }
        catch (PKIException e) {
            throw new CertificateEncodingException("cert encoding exception!");
        }
    }

    @Override
    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            this.x509Cert.verify(key);
        }
        catch (PKIException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
    }

    @Override
    public String toString() {
        return this.x509Cert.toString();
    }

    @Override
    public PublicKey getPublicKey() {
        try {
            return this.x509Cert.getPublicKey();
        }
        catch (PKIException e) {
            e.printStackTrace();
            return null;
        }
    }

    public X509Cert getX509Cert() {
        return this.x509Cert;
    }
}

