/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.sadk.security.external;

import cfca.com.itextpdf.text.pdf.security.DigestAlgorithms;
import cfca.com.itextpdf.text.pdf.security.ExternalSignature;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;

public class ExternalBlankPrivateSignature
implements ExternalSignature {
    private String hashAlgorithm;
    private String encryptionAlgorithm;
    private PrivateKey privateKey;
    private Certificate[] chain;

    public ExternalBlankPrivateSignature(PrivateKey privateKey, Certificate[] chain, String encryptionAlgorithm, String hashAlgorithm, String provider) {
        this.privateKey = privateKey;
        this.chain = chain;
        this.hashAlgorithm = DigestAlgorithms.getDigest(DigestAlgorithms.getAllowedDigests(hashAlgorithm));
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public byte[] sign(byte[] message) throws GeneralSecurityException {
        throw new GeneralSecurityException("Not support sign operation!");
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public Certificate[] getCertificateChain() {
        return this.chain;
    }
}

