/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.asn1.pkcs;

import cfca.sadk.algorithm.common.GMObjectIdentifiers;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.common.X9ObjectIdentifiers;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DERPrintableString;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.org.bouncycastle.asn1.pkcs.RSAPublicKey;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ECParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.util.PublicKeyFactory;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.ECCSuportedCurves;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.system.Mechanisms;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;

abstract class CSRPublicKeyHelper {
    CSRPublicKeyHelper() {
    }

    static String buildCurveNameFrom(Mechanism mechanism) throws PKIException {
        String curveName = mechanism.getCurveName();
        if (curveName == null) {
            curveName = "prime256v1";
        } else if (!ECCSuportedCurves.isSupportedCurve(curveName)) {
            throw new PKIException("buildCurveNameFrom Failure: unsupported curveName: " + curveName);
        }
        return curveName;
    }

    static SubjectPublicKeyInfo buildSubjectPublicKeyInfoFrom(PublicKey publicKey) throws PKIException {
        if (publicKey == null) {
            throw new IllegalArgumentException("buildSubjectPublicKeyInfoFrom parameter invalid: publicKey ==null");
        }
        byte[] encoding = publicKey.getEncoded();
        if (encoding == null) {
            throw new IllegalArgumentException("buildSubjectPublicKeyInfoFrom parameter invalid: encoding of publicKey ==null");
        }
        return SubjectPublicKeyInfo.getInstance(encoding);
    }

    static DERSet buildTemporaryPublicKeyP10Attributes(PublicKey temporaryPublicKey, String challengePassword, String keyType) throws PKIException {
        if (temporaryPublicKey == null) {
            throw new PKIException("buildTemporaryPublicKeyP10Attributes parameter invalid: temporaryPublicKey=null");
        }
        if (challengePassword == null) {
            throw new PKIException("buildTemporaryPublicKeyP10Attributes parameter invalid: challengePassword=null");
        }
        if (keyType == null) {
            throw new PKIException("buildTemporaryPublicKeyP10Attributes parameter invalid: keyType=null");
        }
        SubjectPublicKeyInfo temporaryPublicKeyInfo = SubjectPublicKeyInfo.getInstance(temporaryPublicKey.getEncoded());
        ASN1EncodableVector challengePasswordVector = new ASN1EncodableVector();
        DERPrintableString challengePasswordValue = new DERPrintableString(challengePassword);
        challengePasswordVector.add(PKCSObjectIdentifiers.pkcs_9_at_challengePassword);
        challengePasswordVector.add(challengePasswordValue);
        DERSequence challengePasswordSeq = new DERSequence(challengePasswordVector);
        ASN1EncodableVector tempPublicKeyVector = new ASN1EncodableVector();
        tempPublicKeyVector.add(PKCSObjectIdentifiers.pkcs_9_at_tempPublicKey);
        ASN1Integer derInt = new ASN1Integer(1L);
        DEROctetString tempOctetString = null;
        if ("RSA".equals(keyType)) {
            try {
                tempOctetString = new DEROctetString(temporaryPublicKeyInfo.parsePublicKey());
            }
            catch (IOException e) {
                throw new PKIException("buildTemporaryPublicKeyP10Attributes Failure: temporaryPublicKeyInfo to ASN1Object failure", e);
            }
        } else if ("SM2".equals(keyType)) {
            byte[] sm2PublicKeyData = CSRPublicKeyHelper.buildTemporaryPublicKeySM2Data(temporaryPublicKeyInfo);
            tempOctetString = new DEROctetString(sm2PublicKeyData);
        } else {
            if ("ECC".equals(keyType)) {
                throw new PKIException("buildTemporaryPublicKeyP10Attributes do not support keyType=ECC ");
            }
            throw new PKIException("buildTemporaryPublicKeyP10Attributes do not support  keyType=" + keyType);
        }
        ASN1EncodableVector intAndPublicKeyVector = new ASN1EncodableVector();
        intAndPublicKeyVector.add(derInt);
        intAndPublicKeyVector.add(tempOctetString);
        DERSequence tempPublicKeyInfoSeq = new DERSequence(intAndPublicKeyVector);
        DEROctetString intAndPublicKeyOctetString = null;
        try {
            intAndPublicKeyOctetString = new DEROctetString(tempPublicKeyInfoSeq);
        }
        catch (IOException e) {
            throw new PKIException("buildTemporaryPublicKeyP10Attributes temporaryPublicKeyInfo to OctetString failure", e);
        }
        tempPublicKeyVector.add(intAndPublicKeyOctetString);
        DERSequence tempPubKeySeq = new DERSequence(tempPublicKeyVector);
        ASN1EncodableVector chaPasswordAndPubKeyVector = new ASN1EncodableVector();
        chaPasswordAndPubKeyVector.add(challengePasswordSeq);
        chaPasswordAndPubKeyVector.add(tempPubKeySeq);
        DERSet attributes = new DERSet(chaPasswordAndPubKeyVector);
        return attributes;
    }

    static byte[] buildTemporaryPublicKeySM2Data(SubjectPublicKeyInfo temporaryPublicKeyInfo) {
        byte[] tempPublicKeyData = new byte[136];
        byte[] temporaryPublicKeyData = temporaryPublicKeyInfo.getPublicKeyData().getBytes();
        byte[] temporaryPublicKeyX = new byte[32];
        byte[] temporaryPublicKeyY = new byte[32];
        System.arraycopy(temporaryPublicKeyData, 1, temporaryPublicKeyX, 0, 32);
        System.arraycopy(temporaryPublicKeyData, 33, temporaryPublicKeyY, 0, 32);
        byte[] CONST1 = new byte[]{0, -76, 0, 0};
        byte[] CONST2 = new byte[]{0, 1, 0, 0};
        System.arraycopy(CONST1, 0, tempPublicKeyData, 0, 4);
        System.arraycopy(CONST2, 0, tempPublicKeyData, 4, 4);
        System.arraycopy(temporaryPublicKeyX, 0, tempPublicKeyData, 8, 32);
        System.arraycopy(temporaryPublicKeyY, 0, tempPublicKeyData, 72, 32);
        return tempPublicKeyData;
    }

    static byte[] buildTemporaryPublicKeyDataFromP10(ASN1Set attributes) throws PKIException {
        ASN1Sequence sequence;
        ASN1ObjectIdentifier oid;
        byte[] tempPublicKeyBytes = null;
        if (attributes != null && attributes.size() >= 2 && PKCSObjectIdentifiers.pkcs_9_at_tempPublicKey.equals(oid = ASN1ObjectIdentifier.getInstance((sequence = (ASN1Sequence)attributes.getObjectAt(1)).getObjectAt(0)))) {
            ASN1OctetString asn1oct = ASN1OctetString.getInstance(sequence.getObjectAt(1));
            sequence = ASN1Parser.parseOCT2SEQ(asn1oct);
            tempPublicKeyBytes = ((ASN1OctetString)sequence.getObjectAt(1)).getOctets();
        }
        return tempPublicKeyBytes;
    }

    static PublicKey buildPublicKeyFrom(SubjectPublicKeyInfo subjectPublicKeyInfo) throws PKIException {
        if (subjectPublicKeyInfo == null) {
            throw new IllegalArgumentException("buildPublicKeyFrom parameter invalid: subjectPublicKeyInfo ==null");
        }
        PublicKey publicKey = null;
        AlgorithmIdentifier algorithm = subjectPublicKeyInfo.getAlgorithm();
        if (Mechanisms.isSM2PublicKey(algorithm)) {
            publicKey = CSRPublicKeyHelper.buildSM2PublicKeyFrom(subjectPublicKeyInfo);
        } else if (Mechanisms.isRSAPublicKey(algorithm)) {
            publicKey = CSRPublicKeyHelper.buildRSAPublicKeyFrom(subjectPublicKeyInfo);
        } else if (Mechanisms.isECCPublicKey(algorithm)) {
            publicKey = CSRPublicKeyHelper.buildECCPublicKeyFrom(subjectPublicKeyInfo);
        } else {
            String encoding;
            try {
                encoding = Hex.toHexString(subjectPublicKeyInfo.getEncoded());
            }
            catch (IOException e) {
                throw new PKIException("buildPublicKeyFrom failure when get subjectPublicKeyInfo asn1-encoding");
            }
            throw new PKIException("buildPublicKeyFrom failure: can not support this key type: " + encoding);
        }
        return publicKey;
    }

    private static PublicKey buildECCPublicKeyFrom(SubjectPublicKeyInfo subjectPublicKeyInfo) throws PKIException {
        ECPublicKeyParameters params;
        if (subjectPublicKeyInfo == null) {
            throw new PKIException("buildECCPublicKeyFrom parameter invalid: subjectPublicKeyInfo ==null");
        }
        try {
            params = (ECPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
        }
        catch (IOException e) {
            throw new PKIException("buildECCPublicKeyFrom convert to ECPublicKeyParameters failed", e);
        }
        BCECPublicKey publicKey = null;
        if (params.getParameters() instanceof ECNamedDomainParameters) {
            ECNamedDomainParameters domainParams = (ECNamedDomainParameters)params.getParameters();
            ECNamedCurveParameterSpec spec = new ECNamedCurveParameterSpec(domainParams.getName().getId(), domainParams.getCurve(), domainParams.getG(), domainParams.getN(), domainParams.getH(), domainParams.getSeed());
            publicKey = new BCECPublicKey("EC", params, spec);
        } else if (params.getParameters() instanceof ECDomainParameters) {
            ECDomainParameters domainParams = params.getParameters();
            ECParameterSpec spec = new ECParameterSpec(domainParams.getCurve(), domainParams.getG(), domainParams.getN(), domainParams.getH(), domainParams.getSeed());
            publicKey = new BCECPublicKey("EC", params, spec);
        } else {
            throw new PKIException("buildECCPublicKeyFrom invalid algorithm&parameters: " + params.getParameters());
        }
        return publicKey;
    }

    private static PublicKey buildSM2PublicKeyFrom(SubjectPublicKeyInfo subjectPublicKeyInfo) throws PKIException {
        if (subjectPublicKeyInfo == null) {
            throw new PKIException("buildSM2PublicKeyFrom parameter invalid: subjectPublicKeyInfo ==null");
        }
        byte[] publicKeyData = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        if (publicKeyData.length != 65) {
            throw new PKIException("buildSM2PublicKeyFrom Failure: PublicKeyData[bitstring] required 65-bytes and start with 0x04");
        }
        return new SM2PublicKey(publicKeyData);
    }

    private static PublicKey buildRSAPublicKeyFrom(SubjectPublicKeyInfo subjectPublicKeyInfo) throws PKIException {
        RSAKeyParameters param;
        if (subjectPublicKeyInfo == null) {
            throw new PKIException("buildRSAPublicKeyFrom parameter invalid: subjectPublicKeyInfo ==null");
        }
        try {
            param = (RSAKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
        }
        catch (IOException e) {
            throw new PKIException("buildRSAPublicKeyFrom convert to RSAKeyParameters failed", e);
        }
        return new BCRSAPublicKey(param);
    }

    static PublicKey buildTemporaryPublicKeyFromP10(ASN1Set attributes, PublicKey publicKey) throws PKIException {
        PublicKey temporaryPublicKey = null;
        byte[] temporaryPublickeyData = CSRPublicKeyHelper.buildTemporaryPublicKeyDataFromP10(attributes);
        if (temporaryPublickeyData != null) {
            String keyType = CSRPublicKeyHelper.decodeP10PublicKeyType(publicKey);
            if ("RSA".equals(keyType)) {
                RSAPublicKey rsaPubKey = RSAPublicKey.getInstance(temporaryPublickeyData);
                RSAKeyParameters rsaKeyParams = new RSAKeyParameters(false, rsaPubKey.getModulus(), rsaPubKey.getPublicExponent());
                temporaryPublicKey = new BCRSAPublicKey(rsaKeyParams);
            } else if ("SM2".equals(keyType)) {
                byte[] tempPublicKeyX = new byte[32];
                byte[] tempPublicKeyY = new byte[32];
                System.arraycopy(temporaryPublickeyData, 8, tempPublicKeyX, 0, 32);
                System.arraycopy(temporaryPublickeyData, 72, tempPublicKeyY, 0, 32);
                temporaryPublicKey = new SM2PublicKey(tempPublicKeyX, tempPublicKeyY);
            } else if (!"ECC".equals(keyType)) {
                throw new PKIException("buildTemporaryPublicKeyFromP10 failed: do not supprt PublicKey-->" + publicKey.getClass());
            }
        }
        return temporaryPublicKey;
    }

    static int buildP10PublicKeySize(PublicKey publicKey) throws PKIException {
        if (publicKey == null) {
            throw new PKIException("buildP10PublicKeySize parameter invalid: publicKey ==null");
        }
        int keySize = CSRPublicKeyHelper.buildP10RecognizablePublicKeySize(publicKey);
        if (keySize == 0) {
            SubjectPublicKeyInfo subjectPublicKeyInfo = CSRPublicKeyHelper.buildSubjectPublicKeyInfoFrom(publicKey);
            PublicKey localPublicKey = CSRPublicKeyHelper.buildPublicKeyFrom(subjectPublicKeyInfo);
            keySize = CSRPublicKeyHelper.buildP10RecognizablePublicKeySize(localPublicKey);
        }
        if (keySize == 0) {
            throw new PKIException("buildP10PublicKeySize parameter invalid keyType: " + publicKey.getClass());
        }
        return keySize;
    }

    private static int buildP10RecognizablePublicKeySize(PublicKey publicKey) throws PKIException {
        if (publicKey == null) {
            throw new PKIException("buildP10PublicKeySize parameter invalid: publicKey ==null");
        }
        int keySize = 0;
        if (publicKey instanceof SM2PublicKey) {
            keySize = 256;
        } else if (publicKey instanceof java.security.interfaces.RSAPublicKey) {
            java.security.interfaces.RSAPublicKey bcPublicKey = (java.security.interfaces.RSAPublicKey)publicKey;
            BigInteger n = bcPublicKey.getModulus();
            keySize = n.bitLength();
        } else if (publicKey instanceof BCECPublicKey) {
            BCECPublicKey bcPublicKey = (BCECPublicKey)publicKey;
            keySize = bcPublicKey.getQ().getCurve().getFieldSize();
        } else if ("SM2".equalsIgnoreCase(publicKey.getAlgorithm())) {
            keySize = 256;
        }
        return keySize;
    }

    static String buildP10PublicKeyType(SubjectPublicKeyInfo subjectPublicKeyInfo) throws PKIException {
        String keyType;
        if (subjectPublicKeyInfo == null) {
            throw new PKIException("buildP10PublicKeyType parameter invalid: subjectPublicKeyInfo ==null");
        }
        AlgorithmIdentifier keyAlgorithm = subjectPublicKeyInfo.getAlgorithm();
        ASN1ObjectIdentifier oidAlgorithm = keyAlgorithm.getAlgorithm();
        if (PKCSObjectIdentifiers.rsaEncryption.equals(oidAlgorithm)) {
            keyType = "RSA";
        } else if (GMObjectIdentifiers.sm2.equals(oidAlgorithm) || GMObjectIdentifiers.sm2_old.equals(oidAlgorithm)) {
            keyType = "SM2";
        } else if (X9ObjectIdentifiers.id_ecPublicKey.equals(oidAlgorithm)) {
            boolean smFlag;
            ASN1Primitive parameters = keyAlgorithm.getParameters().toASN1Primitive();
            boolean isConstructed = parameters.isConstructed();
            if (isConstructed) {
                ECParameterSpec smParams = SM2Params.sm2ParameterSpec;
                X9ECParameters params = X9ECParameters.getInstance(DERSequence.getInstance(parameters));
                smFlag = params.getG().equals(smParams.getG()) && params.getCurve().equals(smParams.getCurve());
            } else {
                smFlag = parameters.equals(X9ObjectIdentifiers.sm2PubKey) || parameters.equals(X9ObjectIdentifiers.sm2PubKey_OLD);
            }
            keyType = smFlag ? "SM2" : "ECC";
        } else {
            throw new PKIException("buildP10PublicKeyType parameter invalid oidAlgorithm: " + oidAlgorithm.getId());
        }
        return keyType;
    }

    static String decodeP10PublicKeyType(PublicKey publicKey) throws PKIException {
        String keyType;
        if (publicKey == null) {
            throw new PKIException("buildP10PublicKeyType parameter invalid: publicKey ==null");
        }
        String keyAlgorithm = publicKey.getAlgorithm();
        if (publicKey instanceof SM2PublicKey) {
            keyType = "SM2";
        } else if (publicKey instanceof java.security.interfaces.RSAPublicKey) {
            keyType = "RSA";
        } else if (publicKey instanceof BCECPublicKey) {
            keyType = "ECC";
        } else if ("SM2".equalsIgnoreCase(keyAlgorithm)) {
            keyType = "SM2";
        } else if ("RSA".equalsIgnoreCase(keyAlgorithm)) {
            keyType = "RSA";
        } else if ("ECC".equalsIgnoreCase(keyAlgorithm)) {
            keyType = "SM2";
        } else {
            SubjectPublicKeyInfo subjectPublicKeyInfo = CSRPublicKeyHelper.buildSubjectPublicKeyInfoFrom(publicKey);
            keyType = CSRPublicKeyHelper.buildP10PublicKeyType(subjectPublicKeyInfo);
        }
        return keyType;
    }
}

