/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.ecc;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;

final class ECCCardBigIntegers {
    private ECCCardBigIntegers() {
    }

    static int parseInt(byte[] data, int offset) throws CryptoException {
        if (data == null || data.length - offset < 4) {
            throw new CryptoParameterException("parseInt failure with data is null/not enough length");
        }
        int starter = offset;
        int length = (data[starter++] & 0xFF) << 24 | (data[starter++] & 0xFF) << 16 | (data[starter++] & 0xFF) << 8 | data[starter++] & 0xFF;
        return length;
    }

    static int parseBitLength(byte[] eccKeyData) throws CryptoException {
        int bitLength;
        int offset = 4;
        if (eccKeyData == null || eccKeyData.length < 4 + offset) {
            throw new CryptoParameterException("parseBitLength failure with eccKeyData is null/not enough length");
        }
        if (eccKeyData[offset++] != 0 || eccKeyData[offset++] != 0) {
            throw new CryptoParameterException("parseBitLength failure with eccKeyData[4/5] invalid");
        }
        if ((bitLength = (eccKeyData[offset++] & 0xFF) << 8 | eccKeyData[offset++] & 0xFF) > 521) {
            throw new CryptoParameterException("parseBitLength failure with eccKeyData[6/7] invalid");
        }
        return bitLength;
    }

    static byte[] parseBytes(byte[] eccKeyData, int offset, int length) throws CryptoException {
        if (eccKeyData == null || eccKeyData.length < offset + length) {
            throw new CryptoParameterException("parseBytes failure with eccKeyData is null/not enough length");
        }
        byte[] bytes = new byte[length];
        System.arraycopy(eccKeyData, offset, bytes, 0, bytes.length);
        return bytes;
    }

    static int copyBytes(String paramName, byte[] input, byte[] output, int offset) throws CryptoException {
        if (input == null) {
            throw new CryptoParameterException(String.format("copyBytes[%s] failure with input is null", paramName));
        }
        if (input.length > 66) {
            throw new CryptoParameterException(String.format("copyBytes[%s] failure with input length invalid", paramName));
        }
        if (output == null || output.length < input.length + offset) {
            throw new CryptoParameterException(String.format("copyBytes[%s] failure with output is null/not enough space", paramName));
        }
        System.arraycopy(input, 0, output, offset, input.length);
        return input.length;
    }

    static int copyInteger(int length, byte[] output, int offset) throws CryptoException {
        if (output == null || output.length < offset + 4) {
            throw new CryptoParameterException("copyInteger failure with output is null/not enough length");
        }
        int starter = offset;
        output[starter++] = (byte)(length >> 24 & 0xFF);
        output[starter++] = (byte)(length >> 16 & 0xFF);
        output[starter++] = (byte)(length >> 8 & 0xFF);
        output[starter++] = (byte)(length & 0xFF);
        return 4;
    }

    static byte[] fillBytes(String paramName, byte[] input, int filledLength) throws CryptoException {
        if (input == null) {
            throw new CryptoParameterException(String.format("fillBytes[%s] failure with input is null", paramName));
        }
        if (input.length > filledLength) {
            throw new CryptoParameterException(String.format("fillBytes[%s] failure with input length invalid", paramName));
        }
        byte[] outBytes = new byte[filledLength];
        System.arraycopy(input, 0, outBytes, outBytes.length - input.length, input.length);
        return outBytes;
    }
}

