/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.rsa;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardBigIntegers;
import cfca.sadk.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import java.math.BigInteger;

final class RSACardRefPrivateKeyParams {
    final byte[] keyData;
    final int bitLength;
    final RSAPrivateCrtKeyParameters params;

    RSACardRefPrivateKeyParams(byte[] keyData) throws CryptoException {
        int bitLength = RSACardBigIntegers.parseBitLength(keyData);
        if (keyData.length < 2820) {
            throw new CryptoParameterException("RSACardRefPrivateKeyParams failure with invalid param#keyData");
        }
        int eMaxBitLength = 32;
        int maxLength = 512;
        int offset = 4;
        BigInteger modulus = RSACardBigIntegers.parseBigInteger(keyData, offset, 512, bitLength);
        BigInteger publicExponent = RSACardBigIntegers.parseBigInteger(keyData, offset += 512, 512, 32);
        BigInteger privateExponent = RSACardBigIntegers.parseBigInteger(keyData, offset += 512, 512, bitLength);
        int othersLength = 256;
        int othersBitLength = bitLength >> 1;
        BigInteger primeP = RSACardBigIntegers.parseBigInteger(keyData, offset += 512, 256, othersBitLength);
        BigInteger primeQ = RSACardBigIntegers.parseBigInteger(keyData, offset += 256, 256, othersBitLength);
        BigInteger exponentP = RSACardBigIntegers.parseBigInteger(keyData, offset += 256, 256, othersBitLength);
        BigInteger exponentQ = RSACardBigIntegers.parseBigInteger(keyData, offset += 256, 256, othersBitLength);
        BigInteger coefficient = RSACardBigIntegers.parseBigInteger(keyData, offset += 256, 256, othersBitLength);
        this.keyData = keyData;
        this.bitLength = bitLength;
        this.params = new RSAPrivateCrtKeyParameters(modulus, publicExponent, privateExponent, primeP, primeQ, exponentP, exponentQ, coefficient);
    }

    RSACardRefPrivateKeyParams(RSAPrivateCrtKeyParameters params) throws CryptoException {
        if (params == null) {
            throw new CryptoParameterException("RSACardRefPrivateKeyParams failure with invalid param#params");
        }
        BigInteger modulus = params.getModulus();
        int bitLength = RSACardBigIntegers.parseModulusBitLength(modulus);
        byte[] keyData = this.buildKeyData(bitLength, params);
        this.params = params;
        this.bitLength = bitLength;
        this.keyData = keyData;
    }

    private byte[] buildKeyData(int bitLength, RSAPrivateCrtKeyParameters params) throws CryptoException {
        byte[] keyData = new byte[2820];
        int offset = RSACardBigIntegers.copyBitLength(bitLength, keyData, 0);
        int maxLength = 512;
        RSACardBigIntegers.copyBigInteger("params#modulus", params.getModulus(), 512, keyData, offset);
        RSACardBigIntegers.copyBigInteger("params#publicExponent", params.getPublicExponent(), 512, keyData, offset += 512);
        RSACardBigIntegers.copyBigInteger("params#privateExponent", params.getExponent(), 512, keyData, offset += 512);
        int othersLength = 256;
        RSACardBigIntegers.copyBigInteger("params#primeP", params.getP(), 256, keyData, offset += 512);
        RSACardBigIntegers.copyBigInteger("params#primeQ", params.getQ(), 256, keyData, offset += 256);
        RSACardBigIntegers.copyBigInteger("params#exponentP", params.getDP(), 256, keyData, offset += 256);
        RSACardBigIntegers.copyBigInteger("params#exponentQ", params.getDQ(), 256, keyData, offset += 256);
        RSACardBigIntegers.copyBigInteger("params#coefficient", params.getQInv(), 256, keyData, offset += 256);
        if ((offset += 256) != keyData.length) {
            throw new CryptoParameterException("RSACardRefPrivateKeyParams buildKeyData failure with invalid offset");
        }
        return keyData;
    }
}

