/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.asn1.ecc;

import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ECParameters;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ECParametersHolder;
import cfca.sadk.org.bouncycastle.util.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;

public final class NamedCurves {
    private NamedCurves() {
    }

    public static final X9ECParameters getByName(HashMap curves, HashMap objIds, String name) {
        ASN1ObjectIdentifier oid;
        X9ECParameters param = null;
        if (name != null && (oid = (ASN1ObjectIdentifier)objIds.get(Strings.toLowerCase(name))) != null) {
            param = NamedCurves.getByOID(curves, oid);
        }
        return param;
    }

    public static final X9ECParameters getByOID(HashMap curves, ASN1ObjectIdentifier oid) {
        X9ECParametersHolder holder;
        X9ECParameters param = null;
        if (oid != null && (holder = (X9ECParametersHolder)curves.get(oid)) != null) {
            param = holder.getParameters();
        }
        return param;
    }

    public static final ASN1ObjectIdentifier getOID(HashMap objIds, String name) {
        ASN1ObjectIdentifier oid = null;
        if (name != null) {
            oid = (ASN1ObjectIdentifier)objIds.get(Strings.toLowerCase(name));
        }
        return oid;
    }

    public static final String getName(HashMap names, ASN1ObjectIdentifier oid) {
        String name = null;
        if (names != null) {
            name = (String)names.get(oid);
        }
        return name;
    }

    public static final Enumeration getNames(HashMap objIds) {
        return Collections.enumeration(NamedCurves.getNameList(objIds));
    }

    public static final List getNameList(HashMap objIds) {
        ArrayList values = new ArrayList();
        if (objIds != null) {
            values.addAll(objIds.keySet());
        }
        return values;
    }
}

