/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.agreement;

import cfca.sadk.org.bouncycastle.crypto.BasicAgreement;
import cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.MQVPrivateParameters;
import cfca.sadk.org.bouncycastle.crypto.params.MQVPublicParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.math.ec.ECAlgorithms;
import cfca.sadk.org.bouncycastle.math.ec.ECConstants;
import cfca.sadk.org.bouncycastle.math.ec.ECCurve;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.org.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.math.BigInteger;

public final class SM2MQVBasicAgreement
implements BasicAgreement {
    MQVPrivateParameters privParams;

    public void init(CipherParameters key) {
        this.privParams = (MQVPrivateParameters)key;
    }

    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public BigInteger calculateAgreement(CipherParameters pubKey) {
        int count;
        int start;
        int length = this.getFieldSize();
        ECPoint agreement = this.calculateMqvAgreement(pubKey);
        byte[] value = new byte[length * 2];
        byte[] bytes = agreement.getXCoord().toBigInteger().toByteArray();
        if (bytes.length == length) {
            System.arraycopy(bytes, 0, value, 0, bytes.length);
        } else {
            start = bytes[0] == 0 ? 1 : 0;
            count = bytes.length - start;
            if (count > length) {
                throw new IllegalArgumentException("standard length exceeded for value");
            }
            System.arraycopy(bytes, start, value, length - count, count);
        }
        bytes = agreement.getYCoord().toBigInteger().toByteArray();
        if (bytes.length == length) {
            System.arraycopy(bytes, 0, value, length, bytes.length);
        } else {
            start = bytes[0] == 0 ? 1 : 0;
            count = bytes.length - start;
            if (count > length) {
                throw new IllegalArgumentException("standard length exceeded for value");
            }
            System.arraycopy(bytes, start, value, 2 * length - count, count);
        }
        return new BigInteger(1, value);
    }

    public final byte[] getAgreementBytes(ECPoint agreement) {
        int count;
        int start;
        int length = this.getFieldSize();
        byte[] value = new byte[length * 2];
        byte[] bytes = agreement.getXCoord().toBigInteger().toByteArray();
        if (bytes.length == length) {
            System.arraycopy(bytes, 0, value, 0, bytes.length);
        } else {
            start = bytes[0] == 0 ? 1 : 0;
            count = bytes.length - start;
            if (count > length) {
                throw new IllegalArgumentException("standard length exceeded for value");
            }
            System.arraycopy(bytes, start, value, length - count, count);
        }
        bytes = agreement.getYCoord().toBigInteger().toByteArray();
        if (bytes.length == length) {
            System.arraycopy(bytes, 0, value, length, bytes.length);
        } else {
            start = bytes[0] == 0 ? 1 : 0;
            count = bytes.length - start;
            if (count > length) {
                throw new IllegalArgumentException("standard length exceeded for value");
            }
            System.arraycopy(bytes, start, value, 2 * length - count, count);
        }
        return value;
    }

    public ECPoint calculateMqvAgreement(CipherParameters pubKey) {
        MQVPublicParameters pubParams = (MQVPublicParameters)pubKey;
        ECPrivateKeyParameters staticPrivateKey = this.privParams.getStaticPrivateKey();
        ECPoint agreement = this.calculateMqvAgreement(staticPrivateKey.getParameters(), staticPrivateKey, this.privParams.getEphemeralPrivateKey(), this.privParams.getEphemeralPublicKey(), pubParams.getStaticPublicKey(), pubParams.getEphemeralPublicKey()).normalize();
        if (agreement.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for MQV");
        }
        return agreement;
    }

    private ECPoint calculateMqvAgreement(ECDomainParameters parameters, ECPrivateKeyParameters d1U, ECPrivateKeyParameters d2U, ECPublicKeyParameters Q2U, ECPublicKeyParameters Q1V, ECPublicKeyParameters Q2V) {
        BigInteger n = parameters.getN();
        BigInteger h = parameters.getH();
        int e = (n.bitLength() + 1) / 2 - 1;
        BigInteger powE = ECConstants.ONE.shiftLeft(e);
        ECCurve curve = parameters.getCurve();
        ECPoint[] points = new ECPoint[]{ECAlgorithms.importPoint(curve, Q2U == null ? parameters.getG().multiply(d2U.getD()) : Q2U.getQ()), ECAlgorithms.importPoint(curve, Q1V.getQ()), ECAlgorithms.importPoint(curve, Q2V.getQ())};
        curve.normalizeAll(points);
        ECPoint q2U = points[0];
        ECPoint q1V = points[1];
        ECPoint q2V = points[2];
        BigInteger xU = q2U.getXCoord().toBigInteger();
        BigInteger XU = powE.add(xU.and(powE.subtract(SM2Params.ONE)));
        BigInteger tU = d1U.getD().add(XU.multiply(d2U.getD())).mod(n);
        BigInteger xV = q2V.getXCoord().toBigInteger();
        BigInteger XV = powE.add(xV.and(powE.subtract(SM2Params.ONE)));
        FixedPointCombMultiplier m = new FixedPointCombMultiplier();
        return m.multiply(q1V.add(q2V.multiply(XV)), h.multiply(tU));
    }
}

