/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.signature.rsa;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.pkcs.AuthenticatedAttributesUtil;
import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.org.bouncycastle.crypto.Signer;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.signers.RSADigestSigner;
import cfca.sadk.signature.rsa.RSAHashUtil;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.util.HashUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.Key;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;

public class RSASignUtil {
    static final int fileBufferSize = 65536;

    public static boolean verifySign(String digestAlgorithm, Key pubKey, byte[] sourceData, byte[] signature) throws PKIException {
        if (sourceData == null || signature == null) {
            return false;
        }
        Signer signer = RSASignUtil.getSigner(digestAlgorithm);
        if ("SM2".equalsIgnoreCase(pubKey.getAlgorithm())) {
            return false;
        }
        RSAPublicKey publicKey = (RSAPublicKey)pubKey;
        RSAKeyParameters pubParameter = RSASignUtil.generatePublicKeyParameter(publicKey);
        signer.init(false, pubParameter);
        try {
            signer.update(sourceData, 0, sourceData.length);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_SIGN, PKIException.VERIFY_SIGN_DES, e);
        }
        return signer.verifySignature(signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifySignFile(String digestAlgorithm, Key pubKey, String sourceFilePath, byte[] signature) throws Exception {
        if (sourceFilePath == null || signature == null) {
            return false;
        }
        Signer signer = RSASignUtil.getSigner(digestAlgorithm);
        RSAPublicKey publicKey = (RSAPublicKey)pubKey;
        RSAKeyParameters pubParameter = RSASignUtil.generatePublicKeyParameter(publicKey);
        signer.init(false, pubParameter);
        BufferedInputStream bfis = new BufferedInputStream(new FileInputStream(sourceFilePath));
        try {
            int buffer_size = 65536;
            byte[] buffer = new byte[buffer_size];
            int i = bfis.read(buffer);
            if (i == -1) {
                throw new Exception("the source data is null!");
            }
            do {
                signer.update(buffer, 0, i);
            } while ((i = bfis.read(buffer)) != -1);
        }
        finally {
            if (bfis != null) {
                bfis.close();
            }
        }
        return signer.verifySignature(signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifySignFile(String digestAlgorithm, Key pubKey, String sourceFilePath, long startPos, long dataLength, byte[] signature, String generate_sourceFilePath) throws Exception {
        boolean bl;
        FileOutputStream gen_fos;
        RandomAccessFile bfis;
        block11: {
            bfis = null;
            gen_fos = null;
            if (sourceFilePath != null && signature != null) break block11;
            boolean bl2 = false;
            FileHelper.closedStream(gen_fos, "verifySignFile for " + sourceFilePath);
            if (bfis != null) {
                bfis.close();
            }
            return bl2;
        }
        try {
            byte[] buffer;
            Signer signer = RSASignUtil.getSigner(digestAlgorithm);
            RSAPublicKey publicKey = (RSAPublicKey)pubKey;
            RSAKeyParameters pubParameter = RSASignUtil.generatePublicKeyParameter(publicKey);
            signer.init(false, pubParameter);
            bfis = new RandomAccessFile(new File(sourceFilePath), "r");
            bfis.seek(startPos);
            if (generate_sourceFilePath != null && !generate_sourceFilePath.trim().equals("")) {
                gen_fos = new FileOutputStream(generate_sourceFilePath);
            }
            if (dataLength > 65536L) {
                int readLen;
                buffer = new byte[65536];
                for (long readTotalLen = 0L; (readLen = bfis.read(buffer)) > 0 && readTotalLen < dataLength; readTotalLen += (long)readLen) {
                    if (readTotalLen + (long)readLen <= dataLength) {
                        signer.update(buffer, 0, readLen);
                        FileHelper.writeBytesToFile(buffer, 0, readLen, gen_fos);
                        continue;
                    }
                    int left = (int)(dataLength - readTotalLen);
                    signer.update(buffer, 0, left);
                    FileHelper.writeBytesToFile(buffer, 0, left, gen_fos);
                    break;
                }
            } else {
                buffer = new byte[(int)dataLength];
                int i = bfis.read(buffer);
                signer.update(buffer, 0, i);
                FileHelper.writeBytesToFile(buffer, 0, i, gen_fos);
            }
            bl = signer.verifySignature(signature);
        }
        catch (Throwable throwable) {
            FileHelper.closedStream(gen_fos, "verifySignFile for " + sourceFilePath);
            if (bfis != null) {
                bfis.close();
            }
            throw throwable;
        }
        FileHelper.closedStream(gen_fos, "verifySignFile for " + sourceFilePath);
        if (bfis != null) {
            bfis.close();
        }
        return bl;
    }

    public static boolean verifySignData(Mechanism digestAlgorithm, Key pubKey, byte[] content, byte[] signature, ASN1Set authAttributes, Session session) throws Exception {
        boolean forJNILib = session != null && session.useJniNativeOperation();
        byte[] contentDigest = null;
        contentDigest = forJNILib ? HashUtil.RSAHashMessageByJNI(content, digestAlgorithm, false) : HashUtil.RSAHashMessageByBC(content, digestAlgorithm, false);
        return RSASignUtil.verifySignDegist(digestAlgorithm, pubKey, contentDigest, signature, authAttributes, session);
    }

    public static boolean verifySignFile(Mechanism digestAlgorithm, Key pubKey, InputStream sourceFileStream, byte[] signature, ASN1Set authAttributes, Session session) throws Exception {
        byte[] contentDigest = RSAHashUtil.calculateDigest(digestAlgorithm.getMechanismType(), sourceFileStream, session);
        return RSASignUtil.verifySignDegist(digestAlgorithm, pubKey, contentDigest, signature, authAttributes, session);
    }

    private static boolean verifySignDegist(Mechanism digestAlgorithm, Key pubKey, byte[] contentDigest, byte[] signature, ASN1Set authAttributes, Session session) throws Exception {
        byte[] originDigest = null;
        if (authAttributes != null) {
            byte[] authAttributesDigest = AuthenticatedAttributesUtil.getMessageDigest(authAttributes);
            boolean verifyAuthAttributesDigest = Arrays.equals(contentDigest, authAttributesDigest);
            if (!verifyAuthAttributesDigest) {
                LoggerManager.exceptionLogger.error("verifySignDegist failed: the Digest of SourceData is not equals with Digest in authAttributes!");
                return false;
            }
            byte[] bAuthAttries = authAttributes.getEncoded();
            originDigest = HashUtil.RSAHashMessageByBC(bAuthAttries, digestAlgorithm, false);
        } else {
            originDigest = contentDigest;
        }
        return session.verifyByHash(digestAlgorithm, (PublicKey)pubKey, originDigest, signature);
    }

    private static Signer getSigner(String digestAlgorithm) throws PKIException {
        Digest engine = Mechanisms.getDigest(digestAlgorithm);
        if (engine == null) {
            throw new PKIException("can not support this degest algorithm:" + digestAlgorithm);
        }
        return new RSADigestSigner(engine);
    }

    private static RSAKeyParameters generatePublicKeyParameter(RSAPublicKey key) {
        return new RSAKeyParameters(false, key.getModulus(), key.getPublicExponent());
    }
}

