/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.signature.sm2;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM3Digest;
import cfca.sadk.lib.crypto.bcsoft.BCSoftSM2;
import cfca.sadk.lib.crypto.jni.JNIDigest;
import cfca.sadk.lib.crypto.jni.JNISM2;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTPrivateKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTPublicKey;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPrivateKey;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPublicKey;
import java.security.PrivateKey;
import java.security.PublicKey;

public class SM2Signature {
    private GMTPrivateKey priKey;
    private GMTPublicKey pubKey;
    private Digest hash;
    private final boolean jniFlag;
    private boolean initedKey = false;

    public SM2Signature() throws PKIException {
        this(false);
    }

    public SM2Signature(boolean jniFlag) throws PKIException {
        this.hash = jniFlag ? new JNIDigest(922) : new SM3Digest();
        this.jniFlag = jniFlag;
    }

    public final void destroy() {
        if (this.jniFlag && this.hash != null) {
            JNIDigest.destroy(this.hash);
        }
        this.hash = null;
    }

    public final void initSign(PrivateKey privateKey) throws PKIException {
        if (privateKey == null) {
            throw new PKIException("SM2Signature@initSign required privateKey not null");
        }
        if (this.hash == null) {
            throw new PKIException("SM2Signature@initSign required hash not null");
        }
        if (privateKey instanceof GMTPrivateKey) {
            this.priKey = (GMTPrivateKey)privateKey;
        } else if (privateKey instanceof ECPrivateKey) {
            try {
                this.priKey = new GMTPrivateKey(privateKey.getEncoded());
            }
            catch (Exception e) {
                throw new PKIException("SM2Signature@initSign can't recognise key type in SM2 based signer", e);
            }
        } else {
            throw new PKIException("SM2Signature@initSign can't recognise key type in SM2 based signer");
        }
        this.initedKey = true;
    }

    public final void initVerify(PublicKey publicKey) throws PKIException {
        if (publicKey == null) {
            throw new PKIException("SM2Signature@initVerify required publicKey not null");
        }
        if (this.hash == null) {
            throw new PKIException("SM2Signature@initVerify required hash not null");
        }
        if (publicKey instanceof GMTPublicKey) {
            this.pubKey = (GMTPublicKey)publicKey;
        } else if (publicKey instanceof ECPublicKey) {
            try {
                this.pubKey = new GMTPublicKey(publicKey.getEncoded());
            }
            catch (Exception e) {
                throw new PKIException("SM2Signature@initVerify Can't recognise key type in SM2 based signer");
            }
        } else {
            throw new PKIException("SM2Signature@initVerify Can't recognise key type in SM2 based signer");
        }
        this.initedKey = true;
    }

    public final void update(byte in) throws PKIException {
        if (!this.initedKey) {
            throw new PKIException("SM2Signature@update failed: key not yet inited");
        }
        if (this.hash == null) {
            throw new PKIException("SM2Signature@update required hash not null");
        }
        this.hash.update(in);
    }

    public final void update(byte[] in, int inOff, int len) throws PKIException {
        if (!this.initedKey) {
            throw new PKIException("SM2Signature@update failed: key not yet inited");
        }
        if (this.hash == null) {
            throw new PKIException("SM2Signature@update required hash not null");
        }
        if (in == null) {
            throw new PKIException("SM2Signature@update failed: required in not null");
        }
        if (inOff < 0) {
            throw new PKIException("SM2Signature@update failed: required inOff>=0");
        }
        if (len < 0) {
            throw new PKIException("SM2Signature@update failed: required len>=0");
        }
        if (in.length - inOff < len) {
            throw new PKIException("SM2Signature@update failed: required in.length-inOff>=len=" + len);
        }
        this.hash.update(in, inOff, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] sign(byte[] sourceData) throws PKIException {
        try {
            byte[] signData;
            if (!this.initedKey) {
                throw new PKIException("SM2Signature@sign failed: key not yet inited");
            }
            if (this.hash == null) {
                throw new PKIException("SM2Signature@sign required hash not null");
            }
            if (this.priKey == null) {
                throw new PKIException("SM2Signature@sign failed: priKey not yet inited");
            }
            if (sourceData == null) {
                throw new PKIException("SM2Signature@sign failed: required sourceData not null");
            }
            byte[] hashData = this.hashData(sourceData);
            if (this.jniFlag) {
                byte[] d32Bytes = this.priKey.getDByBytes();
                if (d32Bytes == null || d32Bytes.length != 32) {
                    throw new PKIException("SM2Signature@sign failed: required d32BytesLength=32");
                }
                byte[] R32Bytes = new byte[32];
                byte[] S32Bytes = new byte[32];
                try {
                    JNISM2.sign(hashData, d32Bytes, R32Bytes, S32Bytes);
                }
                catch (PKIException e) {
                    throw new PKIException("SM2Signature@sign jni failed", e);
                }
                catch (Exception e) {
                    throw new PKIException("SM2Signature@sign jni failed", e);
                }
                catch (Throwable e) {
                    throw new PKIException("SM2Signature@sign jni failed", e);
                }
                signData = new byte[64];
                System.arraycopy(R32Bytes, 0, signData, 0, 32);
                System.arraycopy(S32Bytes, 0, signData, 32, 32);
            } else {
                try {
                    signData = BCSoftSM2.sign(hashData, this.priKey.getDByInt(), false);
                }
                catch (Exception e) {
                    throw new PKIException("SM2Signature@sign java failed", e);
                }
            }
            byte[] byArray = signData;
            return byArray;
        }
        finally {
            this.initedKey = false;
            this.priKey = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean verify(byte[] signature, byte[] sourceData) throws PKIException {
        try {
            boolean passed;
            if (!this.initedKey) {
                throw new PKIException("SM2Signature@verify failed: key not yet inited");
            }
            if (this.hash == null) {
                throw new PKIException("SM2Signature@verify required hash not null");
            }
            if (this.pubKey == null) {
                throw new PKIException("SM2Signature@verify failed: pubKey not yet inited");
            }
            if (sourceData == null) {
                throw new PKIException("SM2Signature@verify failed: required sourceData not null");
            }
            if (signature == null) {
                throw new PKIException("SM2Signature@verify failed: required signature not null");
            }
            byte[] hashData = this.hashData(sourceData);
            byte[] signData = new ASN1SM2Signature(signature).getRSRaw64Bytes();
            if (this.jniFlag) {
                byte[] X32Bytes = this.pubKey.getPubXByBytes();
                if (X32Bytes == null || X32Bytes.length != 32) {
                    throw new PKIException("SM2Signature@verify failed: required X32BytesLength=32");
                }
                byte[] Y32Bytes = this.pubKey.getPubYByBytes();
                if (Y32Bytes == null || Y32Bytes.length != 32) {
                    throw new PKIException("SM2Signature@verify failed: required Y32BytesLength=32");
                }
                byte[] R32Bytes = new byte[32];
                byte[] S32Bytes = new byte[32];
                System.arraycopy(signData, 0, R32Bytes, 0, 32);
                System.arraycopy(signData, 32, S32Bytes, 0, 32);
                try {
                    passed = JNISM2.verify(R32Bytes, S32Bytes, X32Bytes, Y32Bytes, hashData);
                }
                catch (PKIException e) {
                    throw new PKIException("SM2Signature@verify jni failed", e);
                }
                catch (Exception e) {
                    throw new PKIException("SM2Signature@verify jni failed", e);
                }
                catch (Throwable e) {
                    throw new PKIException("SM2Signature@verify jni failed", e);
                }
            }
            try {
                passed = BCSoftSM2.verify(hashData, signData, this.pubKey.getQ());
            }
            catch (Exception e) {
                throw new PKIException("SM2Signature@verify jni failed", e);
            }
            boolean bl = passed;
            return bl;
        }
        finally {
            this.initedKey = false;
            this.pubKey = null;
        }
    }

    private byte[] hashData(byte[] sourceData) throws PKIException {
        try {
            byte[] hashData = new byte[this.hash.getDigestSize()];
            this.hash.update(sourceData, 0, sourceData.length);
            this.hash.doFinal(hashData, 0);
            this.hash = null;
            return hashData;
        }
        catch (Exception e) {
            throw new PKIException("SM2Signature@hashData failed", e);
        }
    }
}

