/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.x509.certificate;

import cfca.sadk.algorithm.common.GMObjectIdentifiers;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.common.X9ObjectIdentifiers;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.util.SM2OIDUtil;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.extend.session.ECCCurveId;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DLSequence;
import cfca.sadk.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import cfca.sadk.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.RecipientIdentifier;
import cfca.sadk.org.bouncycastle.asn1.pkcs.RSAPublicKey;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x500.X500NameStyle;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.BasicConstraints;
import cfca.sadk.org.bouncycastle.asn1.x509.CRLDistPoint;
import cfca.sadk.org.bouncycastle.asn1.x509.Certificate;
import cfca.sadk.org.bouncycastle.asn1.x509.Extension;
import cfca.sadk.org.bouncycastle.asn1.x509.Extensions;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.util.PublicKeyFactory;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.ECCSuportedCurves;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import cfca.sadk.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import cfca.sadk.org.bouncycastle.util.Strings;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.signature.rsa.RSASignUtil;
import cfca.sadk.signature.sm2.SM2SignUtil;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.x509.certificate.CFCAStyle;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Date;

public class X509Cert {
    public static final String DIGITS = "0123456789ABCDEF";
    private static final byte[] headBytes = Strings.toByteArray("-----BEGIN CERTIFICATE-----");
    private static final int headLength = headBytes.length;
    private static final byte[] endBytes = Strings.toByteArray("-----END CERTIFICATE-----");
    private static final int endLength = endBytes.length;
    public static final int CERT_TYPE_SM2CERT = 1;
    public static final int CERT_TYPE_RSACERT = 2;
    public static final int CERT_TYPE_ECCCERT = 3;
    private final Certificate cert;
    private final int certType;
    private byte[] derEncoding;
    private PublicKey publicKey;
    private SubjectKeyIdentifier recipientKeyIdentifier = null;
    private IssuerAndSerialNumber recipientIssuerAndSerialNumber = null;

    public X509Cert(byte[] certData) throws PKIException {
        this(X509Cert.certFrom(certData), 0);
    }

    public X509Cert(InputStream certInputStream) throws PKIException {
        this(X509Cert.certFrom(certInputStream), 0);
    }

    public X509Cert(String certFilePath) throws PKIException {
        this(X509Cert.certFrom(certFilePath), 0);
    }

    public X509Cert(Certificate certificate) {
        if (certificate == null) {
            throw new IllegalArgumentException("null not allowed for parameters@certificate");
        }
        this.cert = certificate;
        this.certType = X509Cert.buildCertType(this.cert);
    }

    X509Cert(Certificate certificate, int certType) throws PKIException {
        if (certificate == null) {
            throw new PKIException("null not allowed for parameters@certificate");
        }
        this.cert = certificate;
        this.certType = X509Cert.buildCertType(this.cert);
    }

    public final Certificate getCertStructure() {
        return this.cert;
    }

    public final byte[] getEncoded() throws PKIException {
        try {
            return this.cert.getEncoded("DER");
        }
        catch (Exception e) {
            throw new PKIException(PKIException.ENCODED_CERT, PKIException.ENCODED_CERT_DES, e);
        }
    }

    public final byte[] getEncoding() {
        if (this.derEncoding == null) {
            byte[] derEncoding;
            try {
                derEncoding = this.cert.getEncoded("DER");
            }
            catch (Exception e) {
                throw new SecurityException("cert-encoding failure", e);
            }
            this.derEncoding = derEncoding;
        }
        return this.derEncoding;
    }

    public final ASN1Integer getVersion() {
        return this.cert.getVersion();
    }

    public String getIssuer() {
        return this.getIssuer(CFCAStyle.INSTANCE);
    }

    public String getIssuer(X500NameStyle style) {
        X500Name x500IssuerName = this.cert.getIssuer();
        X500Name issuer = new X500Name(style, x500IssuerName);
        return issuer.toString();
    }

    public X500Name getIssuerX500Name() {
        return this.cert.getIssuer();
    }

    public String getSubject() {
        return this.getSubject(CFCAStyle.INSTANCE);
    }

    public String getSubject(X500NameStyle style) {
        X500Name x500SubjectName = this.cert.getSubject();
        X500Name subject = new X500Name(style, x500SubjectName);
        return subject.toString();
    }

    public X500Name getSubjectX500Name() {
        return this.cert.getSubject();
    }

    public final Date getNotBefore() {
        return this.cert.getStartDate().getDate();
    }

    public final Date getNotAfter() {
        return this.cert.getEndDate().getDate();
    }

    public final BigInteger getSerialNumber() {
        return this.cert.getSerialNumber().getPositiveValue();
    }

    public final String getStringSerialNumber() {
        byte[] snData = this.getSerialNumber().toByteArray();
        if (snData != null) {
            int length = snData.length;
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i != length; ++i) {
                int v = snData[i] & 0xFF;
                buf.append(DIGITS.charAt(v >>> 4));
                buf.append(DIGITS.charAt(v & 0xF));
            }
            return buf.toString();
        }
        return "";
    }

    public final String getSignatureAlgName() {
        return Mechanism.getSignatureAlgName(this.cert.getSignatureAlgorithm());
    }

    public PublicKey getPublicKey() throws PKIException {
        if (this.publicKey == null) {
            PublicKey publicKey;
            this.publicKey = publicKey = X509Cert.buildPublicKey(this.cert);
        }
        return this.publicKey;
    }

    public boolean verify(PublicKey publicKey) throws PKIException {
        ASN1ObjectIdentifier oid = this.cert.getSignatureAlgorithm().getAlgorithm();
        boolean verifyResult = false;
        byte[] sourceData = this.getTBSCertificate();
        byte[] signature = this.getSignature();
        if (SM2OIDUtil.isSm3WithSM2Encryption(oid)) {
            verifyResult = SM2SignUtil.verify(sourceData, null, signature, publicKey);
        } else if (X509Cert.isECCSigAlg(this.cert)) {
            String sigMechanism = Mechanism.getSignatureAlgName(this.cert.getSignatureAlgorithm());
            verifyResult = BCSoftLib.INSTANCE().verify(new Mechanism(sigMechanism), publicKey, sourceData, signature);
        } else {
            String digestAlgorithm = Mechanisms.getDigestAlgorithmName(oid);
            if (digestAlgorithm == null) {
                throw new PKIException(PKIException.NONSUPPORT_SIGALG, PKIException.NONSUPPORT_SIGALG_DES + ":" + oid.getId());
            }
            verifyResult = RSASignUtil.verifySign(digestAlgorithm, publicKey, sourceData, signature);
        }
        return verifyResult;
    }

    public final byte[] getPublicKeyData() throws PKIException {
        return this.cert.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
    }

    public final byte[] getTBSCertificate() throws PKIException {
        try {
            return this.cert.getTBSCertificate().getEncoded("DER");
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.TBSCERT_BYTES, PKIException.TBSCERT_BYTES_DES, ex);
        }
    }

    public final byte[] getSignature() {
        return this.cert.getSignature().getBytes();
    }

    public final SubjectKeyIdentifier getSubjectKeyIdentifier() throws PKIException {
        SubjectKeyIdentifier subjectKeyIdentifier = null;
        try {
            ASN1Object extension = this.getExtensionData(Extension.subjectKeyIdentifier);
            if (extension != null) {
                subjectKeyIdentifier = SubjectKeyIdentifier.getInstance(extension);
            }
        }
        catch (Exception e) {
            subjectKeyIdentifier = null;
        }
        return subjectKeyIdentifier;
    }

    public final AuthorityKeyIdentifier getAuthorityKeyIdentifier() throws PKIException {
        AuthorityKeyIdentifier authorityKeyIdentifier = null;
        try {
            ASN1Object extension = this.getExtensionData(Extension.authorityKeyIdentifier);
            if (extension != null) {
                authorityKeyIdentifier = AuthorityKeyIdentifier.getInstance(extension);
            }
        }
        catch (Exception e) {
            authorityKeyIdentifier = null;
        }
        return authorityKeyIdentifier;
    }

    public final ASN1Object getExtensionData(ASN1ObjectIdentifier oid) throws Exception {
        byte[] extensionValue = this.getExtensionByteData(oid);
        if (extensionValue == null) {
            return null;
        }
        return ASN1Parser.parseBytes2DERObj(extensionValue);
    }

    public final Extensions getExtensionsData() {
        return this.cert.getTBSCertificate().getExtensions();
    }

    public final byte[] getExtensionByteData(ASN1ObjectIdentifier oid) throws Exception {
        Extension extension;
        Extensions extensions = this.cert.getTBSCertificate().getExtensions();
        byte[] extensionValue = null;
        if (extensions != null && (extension = extensions.getExtension(oid)) != null) {
            extensionValue = extension.getExtnValue().getOctets();
        }
        return extensionValue;
    }

    public final CRLDistPoint getCRLDistributionPoints() throws PKIException {
        CRLDistPoint crlDistributPoint = null;
        try {
            ASN1Object extension = this.getExtensionData(Extension.cRLDistributionPoints);
            if (extension != null) {
                crlDistributPoint = CRLDistPoint.getInstance(extension);
            }
        }
        catch (Exception e) {
            throw new PKIException(PKIException.CONSTRUCT_CRL_DIST_POINT_ERR, PKIException.CONSTRUCT_CRL_DIST_POINT_ERR_DES, e);
        }
        return crlDistributPoint;
    }

    public final BasicConstraints getBasicConstraints() throws PKIException {
        BasicConstraints basicConstraints = null;
        try {
            ASN1Object extension = this.getExtensionData(Extension.basicConstraints);
            if (extension != null) {
                basicConstraints = BasicConstraints.getInstance(extension);
            }
        }
        catch (Exception e) {
            throw new PKIException(PKIException.CONSTRUCT_BASIC_CONSTRAINTS_ERR, PKIException.CONSTRUCT_BASIC_CONSTRAINTS_ERR_DES, e);
        }
        return basicConstraints;
    }

    public final String getSignatureAlgorithmOID() {
        return this.cert.getSignatureAlgorithm().getAlgorithm().getId();
    }

    public final String getPublicKeyAlgorithmOID() {
        return this.cert.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm().getId();
    }

    public final int getCertType() {
        return this.certType;
    }

    public final boolean isSM2Cert() {
        return this.certType == 1;
    }

    public final boolean isRSACert() {
        return this.certType == 2;
    }

    public final boolean isECCCert() {
        return this.certType == 3;
    }

    public boolean isCACert() throws PKIException {
        boolean isCA = false;
        try {
            BasicConstraints bcs = this.getBasicConstraints();
            if (bcs != null) {
                isCA = bcs.isCA();
            }
        }
        catch (PKIException e) {
            isCA = false;
        }
        catch (Throwable e) {
            isCA = false;
        }
        return isCA;
    }

    private static int buildCertType(Certificate cert) {
        int certType = 0;
        if (cert != null) {
            SubjectPublicKeyInfo subjectPublicKeyInfo = cert.getSubjectPublicKeyInfo();
            AlgorithmIdentifier algorithm = subjectPublicKeyInfo.getAlgorithm();
            String keyTypeAlgorithmId = algorithm.getAlgorithm().getId();
            if (keyTypeAlgorithmId.equals(PKCSObjectIdentifiers.rsaEncryption.getId())) {
                certType = 2;
            } else if (keyTypeAlgorithmId.equals(GMObjectIdentifiers.ecPubKey.getId())) {
                boolean issm2 = X509Cert.isSM2SigAlg(cert);
                if (issm2) {
                    ASN1Encodable parameters = algorithm.getParameters();
                    if (parameters != null && parameters instanceof ASN1ObjectIdentifier) {
                        ASN1ObjectIdentifier param = (ASN1ObjectIdentifier)parameters;
                        if (param.equals(GMObjectIdentifiers.sm2_old)) {
                            certType = 1;
                        } else if (param.equals(GMObjectIdentifiers.sm2PubKey)) {
                            certType = 1;
                        }
                    }
                    if (certType != 1) {
                        String signAlgorithmId = cert.getSignatureAlgorithm().getAlgorithm().getId();
                        if (signAlgorithmId.equals(X9ObjectIdentifiers.sm3WithSM2Encryption.getId())) {
                            certType = 1;
                        } else if (signAlgorithmId.equals(X9ObjectIdentifiers.sm3WithSM2Encryption_OLD.getId())) {
                            certType = 1;
                        }
                    }
                } else {
                    ASN1Encodable parameters = algorithm.getParameters();
                    if (parameters != null) {
                        if (parameters instanceof ASN1ObjectIdentifier) {
                            boolean eccFlag;
                            ASN1ObjectIdentifier param = (ASN1ObjectIdentifier)parameters;
                            String curveName = ECUtil.getCurveName(param);
                            boolean bl = eccFlag = ECCSuportedCurves.isSupportedCurve(curveName) || ECCCurveId.findECCCurveId(param.getId()) != null;
                            if (eccFlag) {
                                certType = 3;
                            }
                        } else if (parameters instanceof DLSequence) {
                            certType = 3;
                        }
                    }
                }
            }
        }
        return certType;
    }

    private SubjectKeyIdentifier buildRecipientKeyIdentifier() throws PKIException {
        if (this.recipientKeyIdentifier == null) {
            SubjectKeyIdentifier recipientKeyIdentifier = this.getSubjectKeyIdentifier();
            if (recipientKeyIdentifier == null) {
                byte[] hashValue = new byte[20];
                byte[] encoding = this.getPublicKeyData();
                SHA1Digest haSha1Digest = new SHA1Digest();
                haSha1Digest.update(encoding, 0, encoding.length);
                haSha1Digest.doFinal(hashValue, 0);
                recipientKeyIdentifier = new SubjectKeyIdentifier(hashValue);
            }
            this.recipientKeyIdentifier = recipientKeyIdentifier;
        }
        return this.recipientKeyIdentifier;
    }

    private IssuerAndSerialNumber buildRecipientIssuerAndSerialNumber() throws PKIException {
        if (this.recipientIssuerAndSerialNumber == null) {
            IssuerAndSerialNumber recipientIssuerAndSerialNumber;
            this.recipientIssuerAndSerialNumber = recipientIssuerAndSerialNumber = new IssuerAndSerialNumber(this.cert.getIssuer(), this.cert.getSerialNumber().getPositiveValue());
        }
        return this.recipientIssuerAndSerialNumber;
    }

    public final boolean isRecipent(KeyTransRecipientInfo keyTransRecipientInfo) throws PKIException {
        boolean isRecipent = false;
        if (keyTransRecipientInfo != null) {
            ASN1Encodable recipientIdentifier = keyTransRecipientInfo.getRecipientIdentifier().getId();
            ASN1Primitive asn1 = recipientIdentifier.toASN1Primitive();
            SubjectKeyIdentifier certKeyIdentifier = this.buildRecipientKeyIdentifier();
            if (certKeyIdentifier != null && asn1.asn1Equals(certKeyIdentifier.toASN1Primitive())) {
                isRecipent = true;
            } else {
                IssuerAndSerialNumber issu = this.buildRecipientIssuerAndSerialNumber();
                isRecipent = asn1.asn1Equals(issu.toASN1Primitive());
            }
        }
        return isRecipent;
    }

    public final RecipientIdentifier generateRecipientIdentifier(int recipientPolicy) throws PKIException {
        RecipientIdentifier recipientIdentifier = null;
        switch (recipientPolicy) {
            case 0: {
                SubjectKeyIdentifier subjectKeyIdentifier = this.getSubjectKeyIdentifier();
                if (subjectKeyIdentifier == null) {
                    throw new PKIException("envelope required certificate extension SubjectKeyIdentifier");
                }
                recipientIdentifier = new RecipientIdentifier(new DEROctetString(subjectKeyIdentifier.getKeyIdentifier()));
                break;
            }
            case 1: {
                SubjectKeyIdentifier subjectKeyIdentifier = this.buildRecipientKeyIdentifier();
                recipientIdentifier = new RecipientIdentifier(new DEROctetString(subjectKeyIdentifier.getKeyIdentifier()));
                break;
            }
            case 2: {
                IssuerAndSerialNumber IssuerAndSerialNumber2 = this.buildRecipientIssuerAndSerialNumber();
                recipientIdentifier = new RecipientIdentifier(IssuerAndSerialNumber2);
                break;
            }
            default: {
                throw new PKIException("Invalid recipientPolicy=" + recipientPolicy);
            }
        }
        return recipientIdentifier;
    }

    private static PublicKey buildPublicKey(Certificate cert) throws PKIException {
        int certType = X509Cert.buildCertType(cert);
        PublicKey publicKey = null;
        switch (certType) {
            case 1: {
                try {
                    SubjectPublicKeyInfo subjectPublicKeyInfo = cert.getSubjectPublicKeyInfo();
                    byte[] pubData = subjectPublicKeyInfo.getPublicKeyData().getBytes();
                    if (pubData == null || pubData.length != 64 && pubData.length != 65) {
                        throw new PKIException(PKIException.SPKI_KEY, PKIException.SPKI_KEY_DES);
                    }
                    int starter = pubData.length == 65 ? 1 : 0;
                    byte[] pubX = new byte[32];
                    byte[] pubY = new byte[32];
                    System.arraycopy(pubData, starter, pubX, 0, 32);
                    System.arraycopy(pubData, starter + 32, pubY, 0, 32);
                    publicKey = new SM2PublicKey(pubX, pubY);
                    break;
                }
                catch (Exception e) {
                    throw new PKIException(PKIException.SPKI_KEY, PKIException.SPKI_KEY_DES, e);
                }
            }
            case 2: {
                try {
                    SubjectPublicKeyInfo subjectPublicKeyInfo = cert.getSubjectPublicKeyInfo();
                    RSAPublicKey pubKey = RSAPublicKey.getInstance(subjectPublicKeyInfo.parsePublicKey());
                    RSAKeyParameters param = new RSAKeyParameters(false, pubKey.getModulus(), pubKey.getPublicExponent());
                    publicKey = new BCRSAPublicKey(param);
                    break;
                }
                catch (Exception e) {
                    throw new PKIException(PKIException.SPKI_KEY, PKIException.SPKI_KEY_DES, e);
                }
            }
            case 3: {
                try {
                    SubjectPublicKeyInfo subjectPublicKeyInfo = cert.getSubjectPublicKeyInfo();
                    ECPublicKeyParameters params = (ECPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
                    if (params.getParameters() instanceof ECNamedDomainParameters) {
                        ECNamedDomainParameters domainParams = (ECNamedDomainParameters)params.getParameters();
                        ECNamedCurveParameterSpec spec = new ECNamedCurveParameterSpec(domainParams.getName().getId(), domainParams.getCurve(), domainParams.getG(), domainParams.getN(), domainParams.getH(), domainParams.getSeed());
                        publicKey = new BCECPublicKey("EC", params, spec);
                        break;
                    }
                    if (!(params.getParameters() instanceof ECDomainParameters)) break;
                    ECDomainParameters domainParams = params.getParameters();
                    ECParameterSpec spec = new ECParameterSpec(domainParams.getCurve(), domainParams.getG(), domainParams.getN(), domainParams.getH(), domainParams.getSeed());
                    publicKey = new BCECPublicKey("EC", params, spec);
                    break;
                }
                catch (Exception e) {
                    throw new PKIException(PKIException.SPKI_KEY, PKIException.SPKI_KEY_DES, e);
                }
            }
            default: {
                throw new PKIException(PKIException.SPKI_KEY, PKIException.SPKI_KEY_DES);
            }
        }
        return publicKey;
    }

    private static Certificate certFrom(InputStream certInputStream) throws PKIException {
        byte[] certData;
        if (certInputStream == null) {
            throw new IllegalArgumentException("null not allowed for parameters@certInputStream");
        }
        try {
            certData = FileHelper.read(certInputStream);
        }
        catch (IOException e) {
            throw new PKIException(PKIException.INIT_CERT, PKIException.INIT_CERT_DES, e);
        }
        return X509Cert.certFrom(certData);
    }

    private static Certificate certFrom(String certFilePath) throws PKIException {
        byte[] certData;
        if (certFilePath == null) {
            throw new PKIException("null not allowed for parameters@certFilePath");
        }
        try {
            certData = FileHelper.read(certFilePath);
        }
        catch (IOException e) {
            throw new PKIException(PKIException.INIT_CERT, PKIException.INIT_CERT_DES, e);
        }
        return X509Cert.certFrom(certData);
    }

    private static Certificate certFrom(byte[] certData) throws PKIException {
        Certificate cert = null;
        try {
            byte[] certBytes = X509Cert.filterPEMText(certData);
            ASN1Sequence seq = ASN1Parser.getDERSequenceFrom(certBytes);
            cert = Certificate.getInstance(seq);
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.INIT_CERT, PKIException.INIT_CERT_DES, ex);
        }
        if (cert == null) {
            throw new PKIException(PKIException.INIT_CERT, PKIException.INIT_CERT_DES);
        }
        return cert;
    }

    private static byte[] filterPEMText(byte[] certData) {
        byte[] certHead = new byte[headLength];
        byte[] certEnd = new byte[endLength];
        System.arraycopy(certData, 0, certHead, 0, headLength);
        boolean hasHead = Arrays.equals(certHead, headBytes);
        if (hasHead) {
            certData = ASN1Parser.deleteCRLF(certData);
        }
        int certDataLength = certData.length;
        System.arraycopy(certData, certDataLength - endLength, certEnd, 0, endLength);
        boolean hasEnd = Arrays.equals(certEnd, endBytes);
        int datStarter = 0;
        int datLength = 0;
        byte[] certBytes = null;
        if (hasHead && hasEnd) {
            datStarter = headLength;
            datLength = certDataLength - headLength - endLength;
        } else if (!hasHead && hasEnd) {
            datStarter = 0;
            datLength = certDataLength - endLength;
        } else if (hasHead && !hasEnd) {
            datStarter = headLength;
            datLength = certDataLength - headLength;
        } else {
            certBytes = certData;
        }
        if (certBytes == null) {
            certBytes = new byte[datLength];
            System.arraycopy(certData, datStarter, certBytes, 0, certBytes.length);
        }
        return certBytes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cert == null ? 0 : this.cert.hashCode());
        result = 31 * result + this.certType;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        X509Cert other = (X509Cert)obj;
        if (this.cert == null ? other.cert != null : !this.cert.equals(other.cert)) {
            return false;
        }
        return this.certType == other.certType;
    }

    private static boolean isECCSigAlg(Certificate cert) {
        String sigAlg = Mechanism.getSignatureAlgName(cert.getSignatureAlgorithm());
        return Mechanisms.isECDSA(sigAlg);
    }

    private static boolean isSM2SigAlg(Certificate cert) {
        String sigAlg = Mechanism.getSignatureAlgName(cert.getSignatureAlgorithm());
        return Mechanisms.isSM2WithSM3(sigAlg);
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        if (this.cert != null) {
            try {
                builder.append("\n SN: ");
                builder.append(this.cert.getSerialNumber().getValue().toString(16));
                builder.append("\n Issuer: ").append(this.cert.getIssuer());
                builder.append("\n Subject: ").append(this.cert.getSubject());
                builder.append("\n Validate: ");
                builder.append(this.cert.getStartDate());
                builder.append(", ");
                builder.append(this.cert.getEndDate());
                builder.append("\n SignatureAlgorithm: ");
                builder.append(this.cert.getSignatureAlgorithm().getAlgorithm().getId());
                builder.append("\n encoding: ");
                builder.append(Hex.toHexString(this.cert.getEncoded()));
            }
            catch (Exception e) {
                builder.append("dump cert detail failure: " + e.getMessage());
            }
        } else {
            builder.append("\n none content");
        }
        return builder.toString();
    }
}

