/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.ecc;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.ECCCurveId;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardBigIntegers;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardCurveHelper;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardKey;
import cfca.sadk.extend.session.bridge.impl.ecc.ECCCardKeyHelper;
import cfca.sadk.extend.session.util.Args;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.extend.session.util.NumberHelper;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTBigIntegerUtil;
import cfca.sadk.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import cfca.sadk.org.bouncycastle.math.ec.ECCurve;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;
import java.security.PublicKey;

public final class ECCCardPublicKey
extends BCECPublicKey
implements ECCCardKey {
    private static final long serialVersionUID = 6831417098775453771L;
    private static final int MAX_STRENGTH = 66;
    private final ECCCurveId curveId;
    private final int keyIndex;
    private final int keyUsage;
    private byte[] bPubX;
    private byte[] bPubY;
    private byte[] bPubH;
    private byte[] keyData;
    private String pubKeyInfo;

    public ECCCardPublicKey(BCECPublicKey key, int curveId) throws CryptoException {
        super("EC", Args.notNull(key, "ECPublicKey"));
        ECCCurveId curve = ECCCurveId.findECCCurveId(curveId);
        if (curve == null) {
            throw new CryptoException("unknown curve name: " + curveId);
        }
        this.curveId = curve;
        this.keyIndex = 0;
        this.keyUsage = 0;
        this.setting(this.curveId.getCurveBitLength());
    }

    public ECCCardPublicKey(BCECPublicKey key) throws CryptoException {
        super("EC", Args.notNull(key, "ECPublicKey"));
        ECCCurveId curve = ECCCurveId.findECCCurveId(this.getParameters());
        if (curve == null) {
            throw new CryptoException("unknown curve key");
        }
        this.curveId = curve;
        this.keyIndex = 0;
        this.keyUsage = 0;
        this.setting(this.curveId.getCurveBitLength());
    }

    public ECCCardPublicKey(ECPublicKeyParameters ecPubKeyParams, int curveId) throws CryptoException {
        super("EC", ecPubKeyParams, ECCCardCurveHelper.buildECParameterSpec(ecPubKeyParams));
        ECCCurveId curve = ECCCurveId.findECCCurveId(curveId);
        if (curve == null) {
            throw new CryptoException("unknown curve name: " + curveId);
        }
        this.curveId = curve;
        this.keyIndex = 0;
        this.keyUsage = 0;
        this.setting(this.curveId.getCurveBitLength());
    }

    private ECCCardPublicKey(int keyIndex, int keyUsage, byte[] pubKeyData) throws CryptoException {
        super("EC", Args.notNull(ECCCardPublicKey.parseEccKey(pubKeyData), "ECPublicKey"));
        int id = ECCCardBigIntegers.parseInt(pubKeyData, 0);
        ECCCurveId curveId = ECCCurveId.findECCCurveId(id);
        if (curveId == null) {
            throw new CryptoException("unknown curve name: " + (Object)((Object)curveId));
        }
        this.curveId = curveId;
        this.keyIndex = keyIndex;
        this.keyUsage = keyUsage;
        this.setting(this.curveId.getCurveBitLength());
    }

    public static ECCCardPublicKey buildInternalKey(int keyIndex, int keyUsage, byte[] pubKeyData) throws CryptoException {
        return new ECCCardPublicKey(keyIndex, keyUsage, pubKeyData);
    }

    public static PublicKey buildExternalKey(byte[] pubKeyData) throws CryptoException {
        return new ECCCardPublicKey(-1, -1, pubKeyData);
    }

    private void setting(int bitLength) {
        ECPoint normalizeQ = this.getQ().normalize();
        this.bPubX = this.buildPubX(normalizeQ, bitLength);
        this.bPubY = this.buildPubY(normalizeQ, bitLength);
        this.bPubH = NumberHelper.md5(this.bPubX, this.bPubY);
        this.keyData = this.buildKeyData();
    }

    private byte[] buildPubX(ECPoint Q, int bitLength) {
        int byteLength = this.getCurveByteLength();
        return GMTBigIntegerUtil.asUnsignedNByteArray(Q.getAffineXCoord().toBigInteger(), byteLength);
    }

    private byte[] buildPubY(ECPoint Q, int bitLength) {
        int byteLength = this.getCurveByteLength();
        return GMTBigIntegerUtil.asUnsignedNByteArray(Q.getAffineYCoord().toBigInteger(), byteLength);
    }

    private byte[] buildKeyData() {
        byte[] keyData = new byte[140];
        int offset = 0;
        try {
            byte[] xBytes = ECCCardBigIntegers.fillBytes("ECC#pubX", this.getPubX(), 66);
            byte[] yBytes = ECCCardBigIntegers.fillBytes("ECC#pubY", this.getPubY(), 66);
            offset += ECCCardBigIntegers.copyInteger(this.curveId.getCurveId(), keyData, offset);
            offset += ECCCardBigIntegers.copyInteger(this.curveId.getCurveBitLength(), keyData, offset);
            offset += ECCCardBigIntegers.copyBytes("ECC#pubX", xBytes, keyData, offset);
            offset += ECCCardBigIntegers.copyBytes("ECC#pubY", yBytes, keyData, offset);
        }
        catch (CryptoException e) {
            throw new IllegalArgumentException("buildKeyData failure", e);
        }
        return keyData;
    }

    private static BCECPublicKey parseEccKey(byte[] pubKeyData) throws CryptoException {
        int id = ECCCardBigIntegers.parseInt(pubKeyData, 0);
        ECCCurveId curveId = ECCCurveId.findECCCurveId(id);
        if (curveId == null) {
            throw new CryptoException("unknown curve id: " + id);
        }
        int bitLength = ECCCardBigIntegers.parseInt(pubKeyData, 4);
        if (bitLength != curveId.getCurveBitLength()) {
            throw new CryptoException("invalid curve bitLength: " + bitLength + " for " + (Object)((Object)curveId));
        }
        byte[] xBytes = ECCCardBigIntegers.parseBytes(pubKeyData, 8, 66);
        byte[] yBytes = ECCCardBigIntegers.parseBytes(pubKeyData, 74, 66);
        ECCurve curve = curveId.getCurveParams().getCurve();
        ECPoint Q = curve.validatePoint(new BigInteger(1, xBytes), new BigInteger(1, yBytes));
        ECDomainParameters params = ECCCardCurveHelper.buildECDomainParameters(curveId.getCurveParams());
        ECPublicKeyParameters pubKeyParams = new ECPublicKeyParameters(Q, params);
        ECNamedCurveParameterSpec ecSpec = new ECNamedCurveParameterSpec(curveId.getCurveName(), curve, params.getG(), params.getN(), params.getH(), null);
        return new BCECPublicKey("EC", pubKeyParams, ecSpec);
    }

    public String getAlgorithm() {
        return "ECC";
    }

    public String getFormat() {
        return "X.509";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ECCCardPublicKey [curveId=").append((Object)this.curveId);
        builder.append(",keyIndex=").append(this.keyIndex);
        builder.append(",keyUsage=").append(this.keyUsage);
        builder.append(",isInternalKey=").append(this.isInternalKey());
        builder.append(",pubX=").append(DataHelper.toHexString(this.getPubX()));
        builder.append(",pubY=").append(DataHelper.toHexString(this.getPubY()));
        builder.append(",pubH=").append(DataHelper.toHexString(this.getPubH()));
        builder.append("]");
        return builder.toString();
    }

    public String dumpPublicKey() {
        if (this.pubKeyInfo == null) {
            this.pubKeyInfo = ECCCardKeyHelper.dumpPublicKey(this.bPubX, this.bPubY, this.bPubH);
        }
        return this.pubKeyInfo;
    }

    public byte[] getEncoded() {
        return super.getEncoded();
    }

    public boolean isInternalKey() {
        return this.keyIndex > 0;
    }

    public int getKeyIndex() {
        return this.keyIndex;
    }

    public int getKeyUsage() {
        return this.keyUsage;
    }

    public ECCCurveId getCurveId() {
        return this.curveId == null ? null : this.curveId;
    }

    public int getCurveBitLength() {
        return this.curveId == null ? 0 : this.curveId.getCurveBitLength();
    }

    public int getCurveByteLength() {
        return this.curveId == null ? 0 : this.curveId.getCurveBytesLength();
    }

    public byte[] getPubX() {
        return this.bPubX == null ? null : (byte[])this.bPubX.clone();
    }

    public byte[] getPubY() {
        return this.bPubY == null ? null : (byte[])this.bPubY.clone();
    }

    public byte[] getPubH() {
        return this.bPubH == null ? null : (byte[])this.bPubH.clone();
    }

    public byte[] keyData() {
        return this.keyData == null ? null : (byte[])this.keyData.clone();
    }
}

