/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.data;

import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.geom.Matrix;
import cfca.sadk.com.itextpdf.kernel.geom.Path;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.CanvasGraphicsState;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.data.IEventData;

public class PathRenderInfo
implements IEventData {
    public static final int NO_OP = 0;
    public static final int STROKE = 1;
    public static final int FILL = 2;
    private Path path;
    private int operation;
    private int rule;
    private boolean isClip;
    private int clippingRule;
    private CanvasGraphicsState gs;
    private boolean graphicsStateIsPreserved;

    public PathRenderInfo(Path path, int operation, int rule, boolean isClip, int clipRule, CanvasGraphicsState gs) {
        this.path = path;
        this.operation = operation;
        this.rule = rule;
        this.gs = gs;
        this.isClip = isClip;
        this.clippingRule = clipRule;
    }

    public PathRenderInfo(Path path, int operation, CanvasGraphicsState gs) {
        this(path, operation, 1, false, 1, gs);
    }

    public Path getPath() {
        return this.path;
    }

    public int getOperation() {
        return this.operation;
    }

    public int getRule() {
        return this.rule;
    }

    public boolean isPathModifiesClippingPath() {
        return this.isClip;
    }

    public int getClippingRule() {
        return this.clippingRule;
    }

    public Matrix getCtm() {
        if (null == this.gs) {
            throw new IllegalStateException("Graphics state is always deleted after event dispatching. If you want to preserve it in renderer info, use preserveGraphicsState method after receiving renderer info.");
        }
        return this.gs.getCtm();
    }

    public float getLineWidth() {
        if (null == this.gs) {
            throw new IllegalStateException("Graphics state is always deleted after event dispatching. If you want to preserve it in renderer info, use preserveGraphicsState method after receiving renderer info.");
        }
        return this.gs.getLineWidth();
    }

    public int getLineCapStyle() {
        if (null == this.gs) {
            throw new IllegalStateException("Graphics state is always deleted after event dispatching. If you want to preserve it in renderer info, use preserveGraphicsState method after receiving renderer info.");
        }
        return this.gs.getLineCapStyle();
    }

    public int getLineJoinStyle() {
        if (null == this.gs) {
            throw new IllegalStateException("Graphics state is always deleted after event dispatching. If you want to preserve it in renderer info, use preserveGraphicsState method after receiving renderer info.");
        }
        return this.gs.getLineJoinStyle();
    }

    public float getMiterLimit() {
        if (null == this.gs) {
            throw new IllegalStateException("Graphics state is always deleted after event dispatching. If you want to preserve it in renderer info, use preserveGraphicsState method after receiving renderer info.");
        }
        return this.gs.getMiterLimit();
    }

    public PdfArray getLineDashPattern() {
        if (null == this.gs) {
            throw new IllegalStateException("Graphics state is always deleted after event dispatching. If you want to preserve it in renderer info, use preserveGraphicsState method after receiving renderer info.");
        }
        return this.gs.getDashPattern();
    }

    public Color getStrokeColor() {
        if (null == this.gs) {
            throw new IllegalStateException("Graphics state is always deleted after event dispatching. If you want to preserve it in renderer info, use preserveGraphicsState method after receiving renderer info.");
        }
        return this.gs.getStrokeColor();
    }

    public Color getFillColor() {
        if (null == this.gs) {
            throw new IllegalStateException("Graphics state is always deleted after event dispatching. If you want to preserve it in renderer info, use preserveGraphicsState method after receiving renderer info.");
        }
        return this.gs.getFillColor();
    }

    public boolean isGraphicsStatePreserved() {
        return this.graphicsStateIsPreserved;
    }

    public void preserveGraphicsState() {
        if (null == this.gs) {
            throw new IllegalStateException("Graphics state is always deleted after event dispatching. If you want to preserve it in renderer info, use preserveGraphicsState method after receiving renderer info.");
        }
        this.graphicsStateIsPreserved = true;
        this.gs = new CanvasGraphicsState(this.gs);
    }

    public void releaseGraphicsState() {
        if (!this.graphicsStateIsPreserved) {
            this.gs = null;
        }
    }
}

