/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.table.core;

import cfca.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.com.google.typography.font.sfntly.table.Header;
import cfca.com.google.typography.font.sfntly.table.Table;
import cfca.com.google.typography.font.sfntly.table.TableBasedTableBuilder;

public class HorizontalDeviceMetricsTable
extends Table {
    private int numGlyphs;

    private HorizontalDeviceMetricsTable(Header header, ReadableFontData data, int numGlyphs) {
        super(header, data);
        this.numGlyphs = numGlyphs;
    }

    public int version() {
        return this.data.readUShort(Offset.version.offset);
    }

    public int numRecords() {
        return this.data.readShort(Offset.numRecords.offset);
    }

    public int recordSize() {
        return this.data.readLong(Offset.sizeDeviceRecord.offset);
    }

    public int pixelSize(int recordIx) {
        if (recordIx < 0 || recordIx >= this.numRecords()) {
            throw new IndexOutOfBoundsException();
        }
        return this.data.readUByte(Offset.records.offset + recordIx * this.recordSize() + Offset.deviceRecordPixelSize.offset);
    }

    public int maxWidth(int recordIx) {
        if (recordIx < 0 || recordIx >= this.numRecords()) {
            throw new IndexOutOfBoundsException();
        }
        return this.data.readUByte(Offset.records.offset + recordIx * this.recordSize() + Offset.deviceRecordMaxWidth.offset);
    }

    public int width(int recordIx, int glyphNum) {
        if (recordIx < 0 || recordIx >= this.numRecords() || glyphNum < 0 || glyphNum >= this.numGlyphs) {
            throw new IndexOutOfBoundsException();
        }
        return this.data.readUByte(Offset.records.offset + recordIx * this.recordSize() + Offset.deviceRecordWidths.offset + glyphNum);
    }

    public static class Builder
    extends TableBasedTableBuilder<HorizontalDeviceMetricsTable> {
        private int numGlyphs = -1;

        public static Builder createBuilder(Header header, WritableFontData data) {
            return new Builder(header, data);
        }

        protected Builder(Header header, WritableFontData data) {
            super(header, data);
        }

        protected Builder(Header header, ReadableFontData data) {
            super(header, data);
        }

        @Override
        protected HorizontalDeviceMetricsTable subBuildTable(ReadableFontData data) {
            return new HorizontalDeviceMetricsTable(this.header(), data, this.numGlyphs);
        }

        public void setNumGlyphs(int numGlyphs) {
            if (numGlyphs < 0) {
                throw new IllegalArgumentException("Number of glyphs can't be negative.");
            }
            this.numGlyphs = numGlyphs;
            ((HorizontalDeviceMetricsTable)this.table()).numGlyphs = numGlyphs;
        }
    }

    private static enum Offset {
        version(0),
        numRecords(2),
        sizeDeviceRecord(4),
        records(8),
        deviceRecordPixelSize(0),
        deviceRecordMaxWidth(1),
        deviceRecordWidths(2);

        private final int offset;

        private Offset(int offset) {
            this.offset = offset;
        }
    }
}

