/*
 * Decompiled with CFR 0.152.
 */
package cfca.pdf.jni;

public class Document {
    private long handle = 0L;
    private int rotation = 0;
    private int resolution = 0;
    private int maxWidth = 0;
    private int maxHeight = 0;
    private boolean maintainAspectRatio = true;

    static {
        System.loadLibrary("PDFJniKit");
    }

    private native long jniOpenDocument(String var1) throws Exception;

    private native int jniGetPageCount(long var1) throws Exception;

    private native byte[] jniRenderPage(long var1, int var3, int var4, int var5, int var6, int var7, boolean var8) throws Exception;

    private native void jniCloseDocument(long var1) throws Exception;

    public void openDocument(String fileName) throws Exception {
        if (0L != this.handle) {
            throw new Exception("There is an opened document!");
        }
        long handle = this.jniOpenDocument(fileName);
        if (0L == handle) {
            throw new Exception("jniOpenDocument() failed!");
        }
        this.handle = handle;
    }

    public int getPageCount() throws Exception {
        if (0L == this.handle) {
            throw new Exception("invalid document handle!");
        }
        return this.jniGetPageCount(this.handle);
    }

    public byte[] renderPage(int pageNum) throws Exception {
        if (0L == this.handle) {
            throw new Exception("invalid document handle!");
        }
        return this.jniRenderPage(this.handle, pageNum, this.rotation, this.resolution, this.maxWidth, this.maxHeight, this.maintainAspectRatio);
    }

    public void closeDocument() throws Exception {
        if (0L == this.handle) {
            throw new Exception("invalid document handle!");
        }
        this.jniCloseDocument(this.handle);
        this.handle = 0L;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setMaintainAspectRatio(boolean maintainAspectRatio) {
        this.maintainAspectRatio = maintainAspectRatio;
    }
}

