/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.base.bean.sign;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.com.itextpdf.signatures.ITSAClient;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.seal.base.config.SysEnv;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.external.AbstractExternalP7Signer;
import cfca.sadk.seal.base.util.PDFUtil;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.x509.certificate.X509Cert;
import java.security.PrivateKey;
import java.security.cert.Certificate;

public class SignInfoConfig {
    private static Logger businessLog = LoggerFactory.getLogger(SignInfoConfig.class);
    private Session session;
    private Mechanism signAlg;
    private PrivateKey privateKey;
    private X509Cert signCert = null;
    private X509Cert[] certs = null;
    private Certificate[] chain = null;
    private boolean isP7ContainChain = true;
    private ITSAClient tsaClient = null;
    private byte[] hash = null;
    private byte[] originHash = null;
    private AbstractExternalP7Signer p7Signer = null;
    private boolean isAsyn = false;
    private static PrivateKey sm2Private = null;
    private static PrivateKey rsaPrivate = null;
    private int signatureCount = 0;
    private byte[] openPassword = null;
    private int signatureOrder = 0;
    private boolean isSecondHash = false;
    private int pkcs7SigEstimatedSize = 8192;
    private int signatureVersion = 0;
    private String javaScript = "this.submitForm({ cURL: \"http://paperlessverify.cfca.com.cn/PaperlessVerify/Pdf\", cSubmitAs: \"PDF\" });";

    public int getSignatureCount() {
        return this.signatureCount;
    }

    public void setSignatureCount(int signatureCount) {
        this.signatureCount = signatureCount;
    }

    public void setSignatureOrder(int signatureOrder) {
        this.signatureOrder = signatureOrder;
    }

    public int getSignatureOrder() {
        return this.signatureOrder;
    }

    public SignInfoConfig() {
    }

    public SignInfoConfig(AbstractExternalP7Signer p7Signer) {
        this.p7Signer = p7Signer;
    }

    public void setSignatureVersion(int signatureVersion) {
        this.signatureVersion = signatureVersion;
    }

    public int getSignatureVersion() {
        return this.signatureVersion;
    }

    public void setJavaScript(String javaScript) {
        this.javaScript = javaScript;
    }

    public String getJavaScript() {
        return this.javaScript;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Mechanism getSignAlg() {
        return this.signAlg;
    }

    public void setSignAlg(Mechanism signAlg) {
        this.signAlg = signAlg;
    }

    public boolean isP7ContainChain() {
        return this.isP7ContainChain;
    }

    public void setP7ContainChain(boolean isP7ContainChain) {
        this.isP7ContainChain = isP7ContainChain;
    }

    public ITSAClient getTsaClient() {
        return this.tsaClient;
    }

    public void setTsaClient(ITSAClient tsaClient) {
        this.tsaClient = tsaClient;
    }

    public Certificate[] getChain() throws SealException {
        if (this.chain == null && this.certs != null) {
            this.chain = new Certificate[this.certs.length];
            try {
                for (int i = 0; i < this.certs.length; ++i) {
                    this.chain[i] = PDFUtil.certFrom(this.certs[i].getEncoding());
                }
            }
            catch (PKIException e) {
                businessLog.error("parse chain failed:", (Throwable)e);
                throw new SealException("parse chain failed:", e);
            }
        }
        return this.chain;
    }

    public void setChain(Certificate[] chain) {
        this.chain = chain;
        if (chain != null) {
            try {
                this.certs = new X509Cert[chain.length];
                for (int i = 0; i < chain.length; ++i) {
                    this.certs[i] = new X509Cert(chain[i].getEncoded());
                }
                this.signCert = this.certs[0];
                this.setEstimatedSize(this.certs);
            }
            catch (Exception e) {
                businessLog.error("parse chain failed:", (Throwable)e);
            }
        }
    }

    public void setChain(X509Cert[] chain) {
        this.certs = chain;
        if (this.certs.length < 1) {
            businessLog.error("certs can not be null.");
        }
        this.signCert = this.certs[0];
        this.setEstimatedSize(this.certs);
    }

    public X509Cert getSignCert() {
        return this.signCert;
    }

    public X509Cert[] getCerts() {
        return this.certs;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("SignInfoConfig>>>>>>Running");
        buffer.append("\n signAlg: ");
        buffer.append(SADKDebugger.dump((Mechanism)this.signAlg));
        buffer.append("\n PrivateKey: ");
        buffer.append(SADKDebugger.dump((PrivateKey)this.privateKey));
        buffer.append("\n signCert: ");
        buffer.append(SADKDebugger.dump((X509Cert)this.signCert));
        buffer.append("\n signCerts: ");
        buffer.append(SADKDebugger.dump((X509Cert[])this.certs));
        buffer.append("\n p7Signer: ");
        buffer.append(this.p7Signer);
        buffer.append("\n session: ");
        buffer.append(SADKDebugger.dump((Session)this.session));
        buffer.append("\n isP7ContainChain: ");
        buffer.append(this.isP7ContainChain);
        buffer.append("\n ITSAClient: ");
        buffer.append(this.tsaClient);
        return buffer.toString();
    }

    public AbstractExternalP7Signer getP7Signer() {
        return this.p7Signer;
    }

    public void setP7Signer(AbstractExternalP7Signer p7Signer) {
        this.p7Signer = p7Signer;
    }

    public boolean isAsyn() {
        return this.isAsyn;
    }

    public void setAsyn(boolean isAsyn) throws SealException {
        this.isAsyn = isAsyn;
        if (this.signAlg == null) {
            throw new SealException("you must invoke setSignAlg(Mechanism) method first!");
        }
        if (this.privateKey == null) {
            this.privateKey = Mechanisms.isSM2WithSM3((Mechanism)this.signAlg) ? sm2Private : rsaPrivate;
        }
    }

    public int getPKCS7SigEstimatedSize() {
        return this.pkcs7SigEstimatedSize;
    }

    public void setPKCS7SigEstimatedSize(int pkcs7SigEstimatedSize) {
        this.pkcs7SigEstimatedSize = pkcs7SigEstimatedSize;
    }

    public byte[] getHash() {
        return this.hash;
    }

    public void setHash(byte[] hash) {
        this.hash = hash;
    }

    public byte[] getOriginHash() {
        return this.originHash;
    }

    public void setOriginHash(byte[] originHash) {
        this.originHash = originHash;
    }

    public byte[] getOpenPassword() {
        return this.openPassword;
    }

    public void setOpenPassword(byte[] openPassword) {
        this.openPassword = openPassword;
    }

    public boolean isSecondHash() {
        return this.isSecondHash;
    }

    public void setSecondHash(boolean isSecondHash) throws SealException {
        if (this.signAlg == null) {
            throw new SealException("you must invoke setSignAlg() first,and the Mechanism must be Mechanisms.M_SHA1_RSA");
        }
        if (!this.signAlg.equals((Object)Mechanisms.M_SM3_SM2) && !this.signAlg.equals((Object)Mechanisms.M_SHA1_RSA)) {
            throw new SealException("the Mechanism must be Mechanisms.M_SHA1_RSA or Mechanisms.M_SM3_SM2");
        }
        this.isSecondHash = isSecondHash;
    }

    private void setEstimatedSize(X509Cert[] signCerts) {
        if (signCerts != null) {
            try {
                this.pkcs7SigEstimatedSize = 0;
                for (int i = 0; i < signCerts.length; ++i) {
                    X509Cert oneSignCert = signCerts[i];
                    this.pkcs7SigEstimatedSize += oneSignCert.getEncoded().length;
                }
                this.pkcs7SigEstimatedSize = signCerts[0].isRSACert() ? (this.pkcs7SigEstimatedSize += SysEnv.RSAP7TSALength) : (this.pkcs7SigEstimatedSize += SysEnv.SM2P7TSALength);
            }
            catch (PKIException e) {
                this.pkcs7SigEstimatedSize = 8192;
                businessLog.error("setEstimatedSize failed", (Throwable)e);
            }
        }
    }

    static {
        try {
            rsaPrivate = KeyUtil.generateKeyPair((Mechanism)Mechanisms.K_RSA, (int)1024, (Session)BCSoftLib.INSTANCE()).getPrivate();
            sm2Private = KeyUtil.generateKeyPair((Mechanism)Mechanisms.K_SM2, (int)256, (Session)BCSoftLib.INSTANCE()).getPrivate();
        }
        catch (PKIException e) {
            businessLog.error("generate default privateKey failed", (Throwable)e);
        }
    }

    public static interface SignatureVersion {
        public static final int VERSION_0 = 0;
        public static final int VERSION_1 = 1;
        public static final int VERSION_0_CUSTOM_COMMBANK = 2;
    }
}

