/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.io.font;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.InflaterInputStream;

class WoffConverter {
    private static final long woffSignature = 2001684038L;

    WoffConverter() {
    }

    public static boolean isWoffFont(byte[] woffBytes) {
        return WoffConverter.bytesToUInt(woffBytes, 0) == 2001684038L;
    }

    public static byte[] convert(byte[] woffBytes) throws IOException {
        int srcPos = 0;
        int destPos = 0;
        if (WoffConverter.bytesToUInt(woffBytes, srcPos) != 2001684038L) {
            throw new IllegalArgumentException();
        }
        byte[] flavor = new byte[4];
        System.arraycopy(woffBytes, srcPos += 4, flavor, 0, 4);
        if (WoffConverter.bytesToUInt(woffBytes, srcPos += 4) != (long)woffBytes.length) {
            throw new IllegalArgumentException();
        }
        byte[] numTables = new byte[2];
        System.arraycopy(woffBytes, srcPos += 4, numTables, 0, 2);
        if (WoffConverter.bytesToUShort(woffBytes, srcPos += 2) != 0) {
            throw new IllegalArgumentException();
        }
        long totalSfntSize = WoffConverter.bytesToUInt(woffBytes, srcPos += 2);
        srcPos += 4;
        srcPos += 2;
        srcPos += 2;
        srcPos += 4;
        srcPos += 4;
        srcPos += 4;
        srcPos += 4;
        srcPos += 4;
        byte[] otfBytes = new byte[(int)totalSfntSize];
        System.arraycopy(flavor, 0, otfBytes, destPos, 4);
        System.arraycopy(numTables, 0, otfBytes, destPos += 4, 2);
        destPos += 2;
        int entrySelector = -1;
        int searchRange = -1;
        int numTablesVal = WoffConverter.bytesToUShort(numTables, 0);
        for (int i = 0; i < 17; ++i) {
            int powOfTwo = (int)Math.pow(2.0, i);
            if (powOfTwo <= numTablesVal) continue;
            entrySelector = i;
            searchRange = powOfTwo * 16;
            break;
        }
        if (entrySelector < 0) {
            throw new IllegalArgumentException();
        }
        otfBytes[destPos] = (byte)(searchRange >> 8);
        otfBytes[destPos + 1] = (byte)searchRange;
        otfBytes[destPos += 2] = (byte)(entrySelector >> 8);
        otfBytes[destPos + 1] = (byte)entrySelector;
        int rangeShift = numTablesVal * 16 - searchRange;
        otfBytes[destPos += 2] = (byte)(rangeShift >> 8);
        otfBytes[destPos + 1] = (byte)rangeShift;
        int outTableOffset = destPos += 2;
        ArrayList<TableDirectory> tdList = new ArrayList<TableDirectory>(numTablesVal);
        for (int i = 0; i < numTablesVal; ++i) {
            TableDirectory td = new TableDirectory();
            System.arraycopy(woffBytes, srcPos, td.tag, 0, 4);
            td.offset = WoffConverter.bytesToUInt(woffBytes, srcPos += 4);
            srcPos += 4;
            if (td.offset % 4L != 0L) {
                throw new IllegalArgumentException();
            }
            td.compLength = WoffConverter.bytesToUInt(woffBytes, srcPos);
            System.arraycopy(woffBytes, srcPos += 4, td.origLength, 0, 4);
            td.origLengthVal = WoffConverter.bytesToUInt(td.origLength, 0);
            System.arraycopy(woffBytes, srcPos += 4, td.origChecksum, 0, 4);
            srcPos += 4;
            tdList.add(td);
            outTableOffset += 16;
        }
        for (TableDirectory td : tdList) {
            System.arraycopy(td.tag, 0, otfBytes, destPos, 4);
            System.arraycopy(td.origChecksum, 0, otfBytes, destPos += 4, 4);
            otfBytes[destPos += 4] = (byte)(outTableOffset >> 24);
            otfBytes[destPos + 1] = (byte)(outTableOffset >> 16);
            otfBytes[destPos + 2] = (byte)(outTableOffset >> 8);
            otfBytes[destPos + 3] = (byte)outTableOffset;
            System.arraycopy(td.origLength, 0, otfBytes, destPos += 4, 4);
            destPos += 4;
            td.outOffset = outTableOffset;
            if ((outTableOffset += (int)td.origLengthVal) % 4 == 0) continue;
            outTableOffset += 4 - outTableOffset % 4;
        }
        if ((long)outTableOffset != totalSfntSize) {
            throw new IllegalArgumentException();
        }
        for (TableDirectory td : tdList) {
            byte[] uncompressedData;
            byte[] compressedData = new byte[(int)td.compLength];
            System.arraycopy(woffBytes, (int)td.offset, compressedData, 0, (int)td.compLength);
            int expectedUncompressedLen = (int)td.origLengthVal;
            if (td.compLength > td.origLengthVal) {
                throw new IllegalArgumentException();
            }
            if (td.compLength != td.origLengthVal) {
                ByteArrayInputStream stream = new ByteArrayInputStream(compressedData);
                InflaterInputStream zip = new InflaterInputStream(stream);
                uncompressedData = new byte[expectedUncompressedLen];
                int bytesRead = 0;
                while (expectedUncompressedLen - bytesRead > 0) {
                    int readRes = zip.read(uncompressedData, bytesRead, expectedUncompressedLen - bytesRead);
                    if (readRes < 0) {
                        throw new IllegalArgumentException();
                    }
                    bytesRead += readRes;
                }
                if (zip.read() >= 0) {
                    throw new IllegalArgumentException();
                }
            } else {
                uncompressedData = compressedData;
            }
            System.arraycopy(uncompressedData, 0, otfBytes, td.outOffset, expectedUncompressedLen);
        }
        return otfBytes;
    }

    private static long bytesToUInt(byte[] b, int start) {
        return ((long)b[start] & 0xFFL) << 24 | ((long)b[start + 1] & 0xFFL) << 16 | ((long)b[start + 2] & 0xFFL) << 8 | (long)b[start + 3] & 0xFFL;
    }

    private static int bytesToUShort(byte[] b, int start) {
        return (b[start] & 0xFF) << 8 | b[start + 1] & 0xFF;
    }

    private static class TableDirectory {
        byte[] tag = new byte[4];
        long offset;
        long compLength;
        byte[] origLength = new byte[4];
        long origLengthVal;
        byte[] origChecksum = new byte[4];
        int outOffset;

        private TableDirectory() {
        }
    }
}

