/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zzPF;
import asposewobfuscated.zzPG;
import asposewobfuscated.zzWQ;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellCollection;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.PreferredWidth;
import com.aspose.words.Row;
import com.aspose.words.RowCollection;
import com.aspose.words.Shading;
import com.aspose.words.Style;
import com.aspose.words.zzYK;
import com.aspose.words.zzYYJ;
import com.aspose.words.zzYYM;
import com.aspose.words.zzYYO;
import com.aspose.words.zzZIP;
import com.aspose.words.zzZOM;
import com.aspose.words.zzZRT;
import java.awt.Color;
import java.util.Iterator;

public class Table
extends CompositeNode<Row> {
    private RowCollection zzYgt;
    private zzYYJ zzZAw;

    public Table(DocumentBase doc) {
        super(doc);
    }

    @Override
    public int getNodeType() {
        return 5;
    }

    public Row getFirstRow() {
        return (Row)this.zznU();
    }

    public Row getLastRow() {
        return (Row)this.zznT();
    }

    public RowCollection getRows() {
        if (this.zzYgt == null) {
            this.zzYgt = new RowCollection(this);
        }
        return this.zzYgt;
    }

    boolean zzZ2f() {
        for (Row row : this.getRows()) {
            Iterator iterator = row.getCells().iterator();
            if (!iterator.hasNext()) continue;
            Cell cell = (Cell)iterator.next();
            return true;
        }
        return false;
    }

    @Override
    Node zzZ(boolean bl, zzZRT zzZRT2) throws Exception {
        Table table = (Table)super.zzZ(bl, zzZRT2);
        table.zzYgt = null;
        return table;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    int zzZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitTableStart(this);
    }

    @Override
    int zzY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitTableEnd(this);
    }

    public void ensureMinimum() {
        Row row = this.getFirstRow();
        if (row == null) {
            row = (Row)this.appendChild(new Row(this.getDocument()));
        }
        row.ensureMinimum();
    }

    Cell zzXo(int n, int n2) {
        try {
            if (n2 < 0 || n2 >= this.getRows().getCount()) {
                return null;
            }
            CellCollection cellCollection = this.getRows().get(n2).getCells();
            if (n < 0 || n >= cellCollection.getCount()) {
                return null;
            }
            return cellCollection.get(n);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    int getColumnCount() {
        int n = 0;
        for (Row row = this.getFirstRow(); row != null; row = row.zzZgR()) {
            n = Math.max(n, row.getCells().getCount());
        }
        return n;
    }

    zzZOM zzZ2e() throws Exception {
        zzYYM zzYYM2 = new zzYYM(this);
        return zzYYM2.zzZ1k();
    }

    void zzZ2d() {
        for (Row row = this.getFirstRow(); row != null; row = row.zzZgR()) {
            Cell cell = null;
            block6: for (Cell cell2 = row.getFirstCell(); cell2 != null; cell2 = cell2.zzsB()) {
                switch (cell2.zzsy().getHorizontalMerge()) {
                    case 1: {
                        cell = cell2;
                        cell.zzsy().setHorizontalMerge(0);
                        continue block6;
                    }
                    case 2: {
                        if (cell != null) {
                            cell.zzsy().setWidth(cell.zzsy().getWidth() + cell2.zzsy().getWidth());
                            if (cell2.zzsy().getWidth() != 0 && cell.zzsy().getPreferredWidth().zzx6() && cell2.zzsy().getPreferredWidth().zzx6()) {
                                int n = cell.zzsy().getPreferredWidth().zzZin() + cell2.zzsy().getPreferredWidth().zzZin();
                                cell.zzsy().setPreferredWidth(PreferredWidth.zzA1(n));
                            }
                            Iterator iterator = zzYK.zz4r.zzAP().iterator();
                            while (iterator.hasNext()) {
                                int n = (Integer)iterator.next();
                                if (!cell2.zzsy().contains(n) || cell.zzsy().contains(n)) continue;
                                cell.zzsy().zzX(n, cell2.zzsy().zzT3(n));
                            }
                            cell2.remove();
                            cell2 = cell;
                            continue block6;
                        }
                        cell2.zzsy().setHorizontalMerge(0);
                        continue block6;
                    }
                    case 0: {
                        cell = null;
                        continue block6;
                    }
                    default: {
                        throw new IllegalStateException("Unknown cell merge type.");
                    }
                }
            }
        }
    }

    void zzZ2c() throws Exception {
        CompositeNode compositeNode;
        if (!this.zznX()) {
            return;
        }
        zzYYO zzYYO2 = new zzYYO(this);
        if (zzYYO2.zzr0().length == 0) {
            return;
        }
        zzPG zzPG2 = new zzPG();
        zzPF zzPF2 = new zzPF();
        for (compositeNode = this.getFirstRow(); compositeNode != null; compositeNode = ((Row)compositeNode).zzZgR()) {
            Object object;
            zzYYO2.zzu((Row)compositeNode);
            zzPG zzPG3 = new zzPG();
            zzPF zzPF3 = new zzPF();
            int n = zzYYO2.zzZ5I();
            for (object = ((Row)compositeNode).getFirstCell(); object != null; object = ((Cell)object).zzsB()) {
                int n2 = zzYYO2.zzZ1B();
                if (((Cell)object).zzsy().getVerticalMerge() != 0) {
                    boolean bl;
                    int n3 = zzPG2.get(n);
                    if (zzPG.zzXO(n3) || n3 != n2) {
                        ((Cell)object).zzsy().setVerticalMerge(1);
                    }
                    boolean bl2 = bl = !((Row)compositeNode).zzZZg().zzXx(4110) && ((Row)compositeNode).getCells().getCount() == 1;
                    if (bl) {
                        Table.zzx((Row)compositeNode);
                    }
                    zzPG3.set(n, n2);
                    zzPF3.set(n, object);
                }
                n += n2;
            }
            object = zzPF2.zzMM();
            while (((zzPF.zzZ)object).moveNext()) {
                Cell cell = (Cell)((zzPF.zzZ)object).zzMK();
                if (cell.zzsy().getVerticalMerge() != 1 || zzPF3.get(((zzPF.zzZ)object).zzMO()) != null) continue;
                cell.zzsy().setVerticalMerge(0);
            }
            zzPG2 = zzPG3;
            zzPF2 = zzPF3;
        }
        for (compositeNode = this.getLastRow().getFirstCell(); compositeNode != null; compositeNode = ((Cell)compositeNode).zzsB()) {
            if (((Cell)compositeNode).zzsy().getVerticalMerge() != 1) continue;
            ((Cell)compositeNode).zzsy().setVerticalMerge(0);
        }
    }

    void zzZ2b() throws Exception {
        if (this.isNested() && this.getFirstRow() != null) {
            Table table = (Table)this.getAncestor(5);
            this.setAllowAutoFit(table.getAllowAutoFit());
        }
    }

    private static void zzx(Row row) throws Exception {
        int n = 23;
        int n2 = 276;
        int n3 = row.getFirstCell().getLastParagraph() != null ? (int)((double)n * row.getFirstCell().getLastParagraph().getParagraphBreakFont().getSize()) : n2;
        row.zzZZg().zzX(4120, n3);
        row.zzZZg().zzX(4110, 0);
    }

    int zz0D() {
        Row row = this.getFirstRow();
        if (row == null) {
            return 0;
        }
        zzYK zzYK2 = row.getFirstCell().zzsy();
        return row.zzZZg().zzZ(zzYK2, this.isNested());
    }

    @Override
    boolean zzP(Node node) {
        return zzZIP.zzZe(node);
    }

    boolean isNested() {
        if (this.zzZtx() == null) {
            return false;
        }
        return this.zzZtx().getNodeType() == 7;
    }

    public int getAlignment() {
        return (Integer)this.zzwt(4010);
    }

    public void setAlignment(int value) throws Exception {
        this.zzb(4010, value);
    }

    public boolean getAllowAutoFit() {
        return (Boolean)this.zzwt(4240);
    }

    public void setAllowAutoFit(boolean value) throws Exception {
        this.zzb(4240, value);
    }

    public PreferredWidth getPreferredWidth() {
        return (PreferredWidth)this.zzwt(4230);
    }

    public void setPreferredWidth(PreferredWidth value) throws Exception {
        this.zzb(4230, value);
    }

    public boolean getBidi() {
        return (Boolean)this.zzwt(4380);
    }

    public void setBidi(boolean value) throws Exception {
        this.zzb(4380, value);
    }

    public double getLeftPadding() {
        return zzWQ.zzZt((Integer)this.zzwt(4020));
    }

    public void setLeftPadding(double value) throws Exception {
        this.zzb(4020, zzWQ.zzs(value));
    }

    public double getRightPadding() {
        return zzWQ.zzZt((Integer)this.zzwt(4320));
    }

    public void setRightPadding(double value) throws Exception {
        this.zzb(4320, zzWQ.zzs(value));
    }

    public double getTopPadding() {
        return zzWQ.zzZt((Integer)this.zzwt(4300));
    }

    public void setTopPadding(double value) throws Exception {
        this.zzb(4300, zzWQ.zzs(value));
    }

    public double getBottomPadding() {
        return zzWQ.zzZt((Integer)this.zzwt(4310));
    }

    public void setBottomPadding(double value) throws Exception {
        this.zzb(4310, zzWQ.zzs(value));
    }

    public double getCellSpacing() {
        return zzWQ.zzZt((Integer)this.zzwt(4290));
    }

    public void setCellSpacing(double value) throws Exception {
        this.zzb(4290, zzWQ.zzs(value));
    }

    public double getLeftIndent() {
        return zzWQ.zzZt((Integer)this.zzwt(4340));
    }

    public void setLeftIndent(double value) throws Exception {
        this.zzb(4340, zzWQ.zzs(value));
    }

    public int getStyleOptions() {
        return (Integer)this.zzwt(4140);
    }

    public void setStyleOptions(int value) throws Exception {
        this.zzb(4140, value);
    }

    public Style getStyle() {
        return this.getDocument().getStyles().zzXs(this.zzZLD(), 11);
    }

    public void setStyle(Style value) throws Exception {
        if (value == null) {
            throw new IllegalArgumentException("value");
        }
        if (value.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("This style belongs to a different document.");
        }
        if (value.getType() != 3) {
            throw new IllegalArgumentException("This style is not a table style.");
        }
        this.zzIw(value.zzZLD());
    }

    public String getStyleName() {
        return this.getStyle().getName();
    }

    public void setStyleName(String value) throws Exception {
        this.setStyle(this.getDocument().getStyles().zzIc(value));
    }

    public int getStyleIdentifier() {
        return this.getStyle().getStyleIdentifier();
    }

    public void setStyleIdentifier(int value) throws Exception {
        this.setStyle(this.getDocument().getStyles().zzwU(value));
    }

    public int getTextWrapping() {
        return this.isFloating() ? 1 : 0;
    }

    public void setTextWrapping(int value) throws Exception {
        if (value == 1) {
            this.zzZ29();
        } else {
            this.zzZ2a();
        }
    }

    int zzZLD() {
        return (Integer)this.zzwt(4005);
    }

    void zzIw(int n) throws Exception {
        this.zzb(4005, n);
    }

    boolean isFloating() {
        return this.getRows().getCount() > 0 && this.getRows().get(0).zzZZg().isFloating();
    }

    zzYYJ zzZZg() {
        if (this.zzZAw == null) {
            this.zzZAw = new zzYYJ();
        }
        return this.zzZAw;
    }

    public void setBorders(int lineStyle, double lineWidth, Color color) throws Exception {
        Iterator iterator = zzYYJ.zz4r.zzAR().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.setBorder(n, lineStyle, lineWidth, color, true);
        }
    }

    public void setBorder(int borderType, int lineStyle, double lineWidth, Color color, boolean isOverrideCellBorders) throws Exception {
        if (isOverrideCellBorders) {
            this.zzww(borderType);
        }
        for (Row row = this.getFirstRow(); row != null; row = row.zzZgR()) {
            Border border = row.getRowFormat().getBorders().getByBorderType(borderType);
            border.setLineStyle(lineStyle);
            border.setLineWidth(lineWidth);
            border.setColor(color);
        }
    }

    public void clearBorders() {
        for (Row row = this.getFirstRow(); row != null; row = row.zzZgR()) {
            row.zzZZg().zzrE();
            for (Cell cell = row.getFirstCell(); cell != null; cell = cell.zzsB()) {
                cell.zzsy().zzrE();
            }
        }
    }

    private void zzZ2a() throws Exception {
        zzYYJ zzYYJ2 = this.getFirstRow().zzZZg();
        int n = (Integer)zzYYJ2.zzT2(4180);
        if (n == 3) {
            this.zzb(4010, 2);
        } else if (n == 2) {
            this.zzb(4010, 1);
        }
        this.zzwv(4170);
        this.zzwv(4160);
        this.zzwv(4150);
        this.zzwv(4190);
        this.zzwv(4210);
        this.zzwv(4270);
        this.zzwv(4350);
        this.zzwv(4180);
        this.zzwv(4200);
    }

    private void zzZ29() throws Exception {
        zzYYJ zzYYJ2 = this.getFirstRow().zzZZg();
        this.zzb(4160, 2);
        this.zzb(4190, 0);
        this.zzb(4210, 180);
        this.zzb(4270, 180);
        this.zzb(4350, false);
        int n = (Integer)zzYYJ2.zzT2(4010);
        if (n == 2) {
            this.zzb(4180, 3);
        } else if (n == 1) {
            this.zzb(4180, 2);
        }
        this.zzwv(4010);
        if (zzYYJ2.contains(4340)) {
            int n2 = (Integer)zzYYJ2.zzT3(4340);
            this.zzb(4170, n2 - 1);
        }
        this.zzwv(4340);
    }

    private void zzww(int n) {
        switch (n) {
            case 3: {
                Row row = this.getFirstRow();
                if (row == null) break;
                for (Cell cell = row.getFirstCell(); cell != null; cell = cell.zzsB()) {
                    cell.zzsy().remove(3110);
                }
                break;
            }
            case 0: {
                Row row = this.getLastRow();
                if (row == null) break;
                for (Cell cell = row.getFirstCell(); cell != null; cell = cell.zzsB()) {
                    cell.zzsy().remove(3130);
                }
                break;
            }
            case 1: {
                for (Row row = this.getFirstRow(); row != null; row = row.zzZgR()) {
                    Cell cell = row.getFirstCell();
                    if (cell == null) continue;
                    cell.zzsy().remove(3120);
                }
                break;
            }
            case 2: {
                for (Row row = this.getFirstRow(); row != null; row = row.zzZgR()) {
                    Cell cell = row.getLastCell();
                    if (cell == null) continue;
                    cell.zzsy().remove(3140);
                }
                break;
            }
            case 4: {
                for (Row row = this.getFirstRow(); row != null; row = row.zzZgR()) {
                    boolean bl = !row.isFirstRow();
                    boolean bl2 = !row.isLastRow();
                    for (Cell cell = row.getFirstCell(); cell != null; cell = cell.zzsB()) {
                        if (bl) {
                            cell.zzsy().remove(3110);
                        }
                        if (!bl2) continue;
                        cell.zzsy().remove(3130);
                    }
                }
                break;
            }
            case 5: {
                for (Row row = this.getFirstRow(); row != null; row = row.zzZgR()) {
                    for (Cell cell = row.getFirstCell(); cell != null; cell = cell.zzsB()) {
                        boolean bl;
                        boolean bl3 = !cell.isFirstCell();
                        boolean bl4 = bl = !cell.isLastCell();
                        if (bl3) {
                            cell.zzsy().remove(3120);
                        }
                        if (!bl) continue;
                        cell.zzsy().remove(3140);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected border type.");
            }
        }
    }

    public void setShading(int texture, Color foregroundColor, Color backgroundColor) throws Exception {
        for (Row row = this.getFirstRow(); row != null; row = row.zzZgR()) {
            for (Cell cell = row.getFirstCell(); cell != null; cell = cell.zzsB()) {
                Shading shading = cell.getCellFormat().getShading();
                shading.setTexture(texture);
                shading.setForegroundPatternColor(foregroundColor);
                shading.setBackgroundPatternColor(backgroundColor);
            }
        }
    }

    public void clearShading() {
        for (Row row = this.getFirstRow(); row != null; row = row.zzZgR()) {
            row.zzZZg().zzrD();
            for (Cell cell = row.getFirstCell(); cell != null; cell = cell.zzsB()) {
                cell.zzsy().zzrD();
            }
        }
    }

    public void autoFit(int behavior) throws Exception {
        switch (behavior) {
            case 0: {
                this.zzZ27();
                break;
            }
            case 1: {
                this.zzZ26();
                break;
            }
            case 2: {
                this.zzZ25();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown auto fit behavior.");
            }
        }
    }

    int zzZ28() {
        if (this.getRows().getCount() == 0) {
            return 0;
        }
        int n = 0;
        for (Row row : this.getRows()) {
            int n2 = 0;
            for (Cell cell : row.getCells()) {
                n2 += cell.zzsy().getWidth();
            }
            n = Math.max(n, n2);
        }
        return n;
    }

    boolean zzZxb() {
        for (Row row : this.getRows()) {
            if (!row.zzZZg().hasRevisions()) continue;
            return true;
        }
        return false;
    }

    void zzwv(int n) {
        for (Row row = this.getFirstRow(); row != null; row = row.zzZgR()) {
            row.zzZZg().remove(n);
        }
    }

    void zzb(int n, Object object) throws Exception {
        if (this.getFirstRow() == null) {
            throw new IllegalStateException("Formatting cannot be applied because the table is empty. Add at least one row to the table first.");
        }
        for (Row row = this.getFirstRow(); row != null; row = row.zzZgR()) {
            if (n == 4005) {
                this.zzw(row);
            }
            row.zzZZg().zzX(n, object);
        }
    }

    private void zzZ27() throws Exception {
        this.setAllowAutoFit(true);
        this.zzwv(4230);
        this.zzwu(3020);
        this.zzZ2e();
    }

    private void zzZ26() throws Exception {
        this.setAllowAutoFit(true);
        this.zzb(4230, PreferredWidth.fromPercent(100.0));
        this.zzwu(3020);
        this.zzZ2e();
    }

    private void zzZ25() throws Exception {
        this.setAllowAutoFit(false);
        this.zzwv(4230);
    }

    private void zzwu(int n) {
        for (Row row = this.getFirstRow(); row != null; row = row.zzZgR()) {
            for (Cell cell = row.getFirstCell(); cell != null; cell = cell.zzsB()) {
                cell.zzsy().remove(n);
            }
        }
    }

    private void zzw(Row row) throws Exception {
        Object object = row.zzZZg().get(4120);
        Object object2 = row.zzZZg().get(4110);
        Object object3 = row.zzZZg().get(4240);
        Object object4 = row.zzZZg().get(4230);
        row.getRowFormat().clearFormatting();
        this.zzwu(3060);
        if (object != null) {
            row.zzZZg().zzX(4120, object);
        }
        if (object2 != null) {
            row.zzZZg().zzX(4110, object2);
        }
        if (object3 != null) {
            row.zzZZg().zzX(4240, object3);
        }
        if (object4 != null) {
            row.zzZZg().zzX(4230, object4);
        }
    }

    private Object zzwt(int n) {
        Row row = this.getFirstRow();
        if (row == null) {
            return zzYYJ.zzSv(n);
        }
        if (n == 4005) {
            return row.zzZZg() != null ? Integer.valueOf(row.zzZZg().zzZLD()) : zzYYJ.zzSv(4005);
        }
        return row.fetchRowAttr(n);
    }
}

