/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.asn1;

import cfca.sadk.org.bouncycastle.asn1.ASN1Boolean;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import java.util.Enumeration;

public class ExtData
extends ASN1Object
implements PKCSObjectIdentifiers {
    private ASN1ObjectIdentifier extnID;
    private ASN1Boolean critical;
    private ASN1OctetString extnValue;

    public static ExtData getInstance(Object o) {
        if (o instanceof ExtData) {
            return (ExtData)((Object)o);
        }
        if (o != null) {
            return new ExtData(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public ExtData(ASN1ObjectIdentifier extnID, ASN1Boolean critical, ASN1OctetString extnValue) {
        this.extnID = extnID;
        this.critical = critical;
        this.extnValue = extnValue;
    }

    public ExtData(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.extnID = ASN1ObjectIdentifier.getInstance(e.nextElement());
        this.critical = ASN1Boolean.getInstance(e.nextElement());
        this.extnValue = ASN1OctetString.getInstance(e.nextElement());
    }

    public ASN1ObjectIdentifier getExtnID() {
        return this.extnID;
    }

    public ASN1Boolean getCritical() {
        return this.critical;
    }

    public ASN1OctetString getExtnValue() {
        return this.extnValue;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.extnID);
        v.add((ASN1Encodable)this.critical);
        v.add((ASN1Encodable)this.extnValue);
        return new DERSequence(v);
    }
}

