/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.paperless.base.exception.CodeException;
import cfca.paperless.base.util.FastBase64;
import java.util.Arrays;

public class Base64Util {
    public static String base64(byte[] content) throws CodeException {
        try {
            return new String(FastBase64.encode(content), "UTF-8");
        }
        catch (Exception e) {
            throw new CodeException("600706", "Base64 encode error: " + Arrays.toString(content), (Throwable)e);
        }
    }

    public static String base64(String content) throws CodeException {
        try {
            return new String(FastBase64.encode(content.getBytes("UTF-8")), "UTF-8");
        }
        catch (Exception e) {
            throw new CodeException("600706", content, (Throwable)e);
        }
    }

    public static String decode(byte[] content) throws CodeException {
        try {
            return new String(FastBase64.decode(content), "UTF-8");
        }
        catch (Exception e) {
            throw new CodeException("600707", "Base64 encode error: " + Arrays.toString(content), (Throwable)e);
        }
    }

    public static String decode(String content) throws CodeException {
        try {
            return new String(FastBase64.decode(content.getBytes("UTF-8")), "UTF-8");
        }
        catch (Exception e) {
            throw new CodeException("600707", "Base64 decode error: " + content, (Throwable)e);
        }
    }

    public static byte[] decode2Byte(String content) throws CodeException {
        try {
            return FastBase64.decode(content.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new CodeException("600707", "Base64 decode error: " + content, (Throwable)e);
        }
    }
}

