/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.table.opentype;

import cfca.sadk.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.sadk.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.CoverageTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.SubstSubtable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.chaincontextsubst.CoverageArray;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.chaincontextsubst.InnerArraysFmt3;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.component.NumRecordList;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.component.NumRecordTable;
import cfca.sadk.com.google.typography.font.sfntly.table.opentype.component.VisibleSubTable;

public class ReverseChainSingleSubst
extends SubstSubtable {
    private static final int FIELD_COUNT = 1;
    private static final int COVERAGE_INDEX = 2;
    public final CoverageTable coverage;
    public final CoverageArray backtrackGlyphs;
    public final CoverageArray lookAheadGlyphs;
    public final NumRecordTable substitutes;

    ReverseChainSingleSubst(ReadableFontData data, int base, boolean dataIsCanonical) {
        super(data, base, dataIsCanonical);
        if (this.format != 1) {
            throw new IllegalStateException("Subt format value is " + this.format + " (should be 1).");
        }
        int coverageOffset = this.getField(2);
        this.coverage = new CoverageTable(data.slice(coverageOffset), 0, dataIsCanonical);
        NumRecordList records = new NumRecordList(data, 0, this.headerSize());
        this.backtrackGlyphs = new CoverageArray(records);
        records = new NumRecordList(data, 0, records.limit());
        this.lookAheadGlyphs = new CoverageArray(records);
        records = new NumRecordList(data, 0, records.limit());
        this.substitutes = new NumRecordTable(records);
    }

    @Override
    public int fieldCount() {
        return super.fieldCount() + 1;
    }

    public static class Builder
    extends VisibleSubTable.Builder<ReverseChainSingleSubst> {
        private CoverageTable.Builder coverageBuilder;
        private CoverageArray.Builder backtrackGlyphsBuilder;
        private CoverageArray.Builder lookAheadGlyphsBuilder;

        protected Builder() {
        }

        protected Builder(InnerArraysFmt3 table) {
            this(table.readFontData(), 0, false);
        }

        protected Builder(ReadableFontData data, int base, boolean dataIsCanonical) {
            super(data);
            if (!dataIsCanonical) {
                this.prepareToEdit();
            }
        }

        protected Builder(Builder other) {
            this.coverageBuilder = other.coverageBuilder;
            this.backtrackGlyphsBuilder = other.backtrackGlyphsBuilder;
            this.lookAheadGlyphsBuilder = other.lookAheadGlyphsBuilder;
        }

        @Override
        public int subDataSizeToSerialize() {
            if (this.lookAheadGlyphsBuilder != null) {
                this.serializedLength = this.lookAheadGlyphsBuilder.limit();
            } else {
                this.computeSizeFromData(this.internalReadData());
            }
            return this.serializedLength;
        }

        @Override
        public int subSerialize(WritableFontData newData) {
            if (this.serializedLength == 0) {
                return 0;
            }
            if (this.coverageBuilder == null || this.backtrackGlyphsBuilder == null || this.lookAheadGlyphsBuilder == null) {
                return this.serializeFromData(newData);
            }
            int tableOnlySize = 0;
            tableOnlySize += this.coverageBuilder.headerSize();
            tableOnlySize += this.backtrackGlyphsBuilder.tableSizeToSerialize();
            int subTableWriteOffset = tableOnlySize += this.lookAheadGlyphsBuilder.tableSizeToSerialize();
            this.coverageBuilder.subSerialize(newData);
            this.backtrackGlyphsBuilder.subSerialize(newData, subTableWriteOffset);
            int tableWriteOffset = this.backtrackGlyphsBuilder.tableSizeToSerialize();
            this.lookAheadGlyphsBuilder.subSerialize(newData.slice(tableWriteOffset), subTableWriteOffset += this.backtrackGlyphsBuilder.subTableSizeToSerialize());
            return subTableWriteOffset += this.lookAheadGlyphsBuilder.subTableSizeToSerialize();
        }

        @Override
        public ReverseChainSingleSubst subBuildTable(ReadableFontData data) {
            return new ReverseChainSingleSubst(data, 0, true);
        }

        @Override
        protected boolean subReadyToSerialize() {
            return true;
        }

        @Override
        public void subDataSet() {
            this.backtrackGlyphsBuilder = null;
            this.lookAheadGlyphsBuilder = null;
        }

        private void prepareToEdit() {
            this.initFromData(this.internalReadData());
            this.setModelChanged();
        }

        private void initFromData(ReadableFontData data) {
            if (this.backtrackGlyphsBuilder == null || this.lookAheadGlyphsBuilder == null) {
                NumRecordList records = new NumRecordList(data);
                this.backtrackGlyphsBuilder = new CoverageArray.Builder(records);
                records = new NumRecordList(data, 0, records.limit());
                this.lookAheadGlyphsBuilder = new CoverageArray.Builder(records);
            }
        }

        private void computeSizeFromData(ReadableFontData data) {
            int len = 0;
            if (data != null) {
                len = data.length();
            }
            this.serializedLength = len;
        }

        private int serializeFromData(WritableFontData newData) {
            ReadableFontData data = this.internalReadData();
            data.copyTo(newData);
            return data.length();
        }
    }
}

