/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.tool.xml.html.table;

import cfca.com.itextpdf.text.BaseColor;
import cfca.com.itextpdf.text.pdf.PdfContentByte;
import cfca.com.itextpdf.text.pdf.PdfPTable;
import cfca.com.itextpdf.text.pdf.PdfPTableEvent;
import cfca.com.itextpdf.tool.xml.html.table.TableStyleValues;

public class TableBorderEvent
implements PdfPTableEvent {
    private final TableStyleValues styleValues;

    public TableBorderEvent(TableStyleValues styleValues) {
        this.styleValues = styleValues;
    }

    public void tableLayout(PdfPTable table, float[][] width, float[] height, int headerRows, int rowStart, PdfContentByte[] canvas) {
        float left = this.styleValues.getBorderWidthLeft();
        float right = this.styleValues.getBorderWidthRight();
        float top = this.styleValues.getBorderWidthTop();
        float bottom = this.styleValues.getBorderWidthBottom();
        float[] widths = width[0];
        float effectivePadding = left / 2.0f;
        float x1 = widths[0] - effectivePadding;
        effectivePadding = right / 2.0f;
        float x2 = widths[widths.length - 1] + effectivePadding;
        effectivePadding = top / 2.0f;
        float y1 = height[0] + effectivePadding;
        effectivePadding = bottom / 2.0f + this.styleValues.getVerBorderSpacing();
        float y2 = height[height.length - 1] - effectivePadding;
        PdfContentByte cb = canvas[1];
        BaseColor color = this.styleValues.getBackground();
        if (color != null) {
            cb.setColorFill(color);
            cb.rectangle(x1, y1, x2 - x1, y2 - y1);
            cb.fill();
        }
        cb = canvas[2];
        if (left != 0.0f) {
            color = this.styleValues.getBorderColorLeft();
            if (color == null) {
                color = BaseColor.BLACK;
            }
            cb.setLineWidth(left);
            cb.setColorStroke(color);
            cb.moveTo(x1, y1);
            cb.lineTo(x1, y2);
            cb.stroke();
        }
        if (bottom != 0.0f) {
            color = this.styleValues.getBorderColorBottom();
            if (color == null) {
                color = BaseColor.BLACK;
            }
            cb.setLineWidth(bottom);
            cb.setColorStroke(color);
            cb.moveTo(x1, y2);
            cb.lineTo(x2, y2);
            cb.stroke();
        }
        if (right != 0.0f) {
            color = this.styleValues.getBorderColorRight();
            if (color == null) {
                color = BaseColor.BLACK;
            }
            cb.setLineWidth(right);
            cb.setColorStroke(color);
            cb.moveTo(x2, y2);
            cb.lineTo(x2, y1);
            cb.stroke();
        }
        if (top != 0.0f) {
            color = this.styleValues.getBorderColorTop();
            if (color == null) {
                color = BaseColor.BLACK;
            }
            cb.setLineWidth(top);
            cb.setColorStroke(color);
            cb.moveTo(x2, y1);
            cb.lineTo(x1, y1);
            cb.stroke();
        }
        cb.resetRGBColorStroke();
    }

    public TableStyleValues getTableStyleValues() {
        return this.styleValues;
    }
}

