/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.rsa;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.CryptoParameterException;
import cfca.sadk.extend.session.IExtendRSA;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardDummyPrivateKey;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardDummyPublicKey;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardHashHelper;
import cfca.sadk.extend.session.bridge.impl.rsa.RSACardP1Decoder;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.lib.crypto.jni.JNIRSA;
import cfca.sadk.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import cfca.sadk.system.logging.LoggerManager;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;

public final class RSACardDummy
implements IExtendRSA {
    private final int minHashLength = 16;
    private final int sequenceAsn1Ttag = 48;
    private final int minPaddingLength = 11;

    public KeyPair generateKeyPair(boolean isExport, int bitLength, int keyIndex, int keyUsage) throws CryptoException {
        if (!isExport) {
            throw new CryptoException("RSACardDummy do not support isExport=false");
        }
        try {
            KeyPair keypair = JNIRSA.RSAGenerateKeyPair(bitLength);
            KeyPair output = new KeyPair(new RSACardDummyPublicKey((RSAPublicKey)keypair.getPublic()), new RSACardDummyPrivateKey((RSAPrivateCrtKey)keypair.getPrivate()));
            return output;
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSACardDummy generateKeyPair failure", (Throwable)e);
            throw new CryptoException("RSACardDummy generateKeyPair failure", e);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("RSACardDummy generateKeyPair failure", e);
            throw new CryptoException("RSACardDummy generateKeyPair failure", e);
        }
    }

    public byte[] signByHash(PrivateKey privateKey, byte[] digestInfoBytes) throws CryptoException {
        boolean operationResult;
        byte[] pkcs1Encoding;
        RSACardDummyPrivateKey dummyPrivateKey = this.convertPrivateKey(privateKey);
        int moduleLength = dummyPrivateKey.moduleBytesLength;
        if (digestInfoBytes == null || digestInfoBytes.length == 0) {
            throw new CryptoParameterException("RSACardDummy signByHash missing hashValue");
        }
        if (digestInfoBytes.length < 16 || digestInfoBytes[0] != 48) {
            throw new CryptoParameterException("RSACardDummy signByHash invalid hashValue: " + DataHelper.dump4KPartData(digestInfoBytes));
        }
        int limitLength = moduleLength - 11;
        if (digestInfoBytes.length > limitLength) {
            throw new CryptoParameterException("RSACardDummy signByHash invalid hashLength: " + digestInfoBytes.length + ",limitLength=" + limitLength);
        }
        try {
            pkcs1Encoding = RSACardP1Decoder.addPKCS1Padding(digestInfoBytes, moduleLength, true);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSACardDummy signByHash PKCS1Padding encode failure, digestInfoBytes={},moduleLength={}", new Object[]{DataHelper.dump4KPartData(digestInfoBytes), moduleLength, e});
            throw new CryptoException("RSACardDummy signByHash PKCS1Padding encode failure", e);
        }
        byte[] signData = new byte[dummyPrivateKey.moduleBytesLength];
        try {
            operationResult = JNIRSA.dowithPrivateKey(pkcs1Encoding, dummyPrivateKey.jniEncodedBytes, signData, dummyPrivateKey.getPrivateKeyRef());
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSACardDummy signByHash failure, pkcs1Encoding={},dummyPrivateKey={}", new Object[]{DataHelper.dump4KPartData(pkcs1Encoding), dummyPrivateKey.dumpPublicKey(), e});
            throw new CryptoException("RSACardDummy signByHash failure", e);
        }
        if (!operationResult) {
            LoggerManager.exceptionLogger.error("RSACardDummy signByHash failure,operationResult={}, pkcs1Encoding={},dummyPrivateKey={}", new Object[]{operationResult, DataHelper.dump4KPartData(pkcs1Encoding), dummyPrivateKey.dumpPublicKey()});
            throw new CryptoException("RSACardDummy signByHash failure: operationResult=" + operationResult);
        }
        return signData;
    }

    public boolean verifyByHash(PublicKey publicKey, byte[] digestInfoBytes, byte[] signData) throws CryptoException {
        byte[] returnDecryptBytes;
        boolean operationResult;
        RSACardDummyPublicKey dummyPublicKey = this.convertPublicKey(publicKey);
        int moduleLength = dummyPublicKey.moduleBytesLength;
        if (digestInfoBytes == null || digestInfoBytes.length == 0) {
            throw new CryptoParameterException("RSACardDummy verifyByHash missing hashValue");
        }
        if (digestInfoBytes.length < 16 || digestInfoBytes[0] != 48) {
            throw new CryptoParameterException("RSACardDummy verifyByHash invalid hashValue: " + DataHelper.dump4KPartData(digestInfoBytes));
        }
        int limitLength = moduleLength - 11;
        if (digestInfoBytes.length > limitLength) {
            throw new CryptoParameterException("RSACardDummy verifyByHash invalid hashLength: " + digestInfoBytes.length + ",limitLength=" + limitLength);
        }
        if (signData == null || signData.length == 0) {
            throw new CryptoParameterException("RSACardDummy verifyByHash missing signedData");
        }
        if (signData.length != moduleLength) {
            throw new CryptoParameterException("RSACardDummy verifyByHash invalid signedLength: " + signData.length + ",moduleLength=" + moduleLength);
        }
        byte[] decryptData = new byte[moduleLength];
        try {
            operationResult = cryptokit.jni.JNIRSA.dowithPublicKey((byte[])signData, (byte[])dummyPublicKey.jniEncodedBytes, (byte[])decryptData);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSACardDummy verifyByHash failure, signData={},dummyPublicKey={}", new Object[]{DataHelper.dump4KPartData(signData), dummyPublicKey.dumpPublicKey(), e});
            throw new CryptoException("RSACardDummy verifyByHash failure", e);
        }
        if (!operationResult) {
            LoggerManager.exceptionLogger.error("RSACardDummy verifyByHash failure,operationResult={}, pkcs1Encoding={},dummyPublicKey={}", new Object[]{operationResult, DataHelper.dump4KPartData(signData), dummyPublicKey.dumpPublicKey()});
            throw new CryptoException("RSACardDummy verifyByHash failure: operationResult=" + operationResult);
        }
        try {
            returnDecryptBytes = RSACardP1Decoder.delPKCS1Padding(decryptData, moduleLength, true);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSACardDummy verifyByHash PKCS1Padding decode failure, decryptData={},moduleLength={}, signData={},dummyPublicKey={}", new Object[]{DataHelper.dump4KPartData(decryptData), moduleLength, DataHelper.dump4KPartData(signData), dummyPublicKey.dumpPublicKey(), e});
            throw new CryptoException("RSACardDummy verifyByHash PKCS1Padding decode failure", e);
        }
        boolean verifyResult = Arrays.equals(digestInfoBytes, returnDecryptBytes);
        if (!verifyResult) {
            LoggerManager.exceptionLogger.error("RSACardDummy verifyByHash returnFalse, digestInfoBytes={},decryptData={}, signData={},dummyPublicKey={}", new Object[]{DataHelper.dump4KPartData(digestInfoBytes), DataHelper.dump4KPartData(decryptData), DataHelper.dump4KPartData(signData), dummyPublicKey.dumpPublicKey()});
        }
        return verifyResult;
    }

    public byte[] encrypt(PublicKey publicKey, byte[] sourceData) throws CryptoException {
        boolean operationResult;
        byte[] pkcs1Encoding;
        RSACardDummyPublicKey dummyPublicKey = this.convertPublicKey(publicKey);
        int moduleLength = dummyPublicKey.moduleBytesLength;
        if (sourceData == null || sourceData.length == 0) {
            throw new CryptoParameterException("RSACardDummy encrypt missing sourceData");
        }
        int limitLength = moduleLength - 11;
        if (sourceData.length > limitLength) {
            throw new CryptoParameterException("RSACardDummy encrypt invalid sourceLength: " + sourceData.length + ",limitLength=" + limitLength);
        }
        try {
            pkcs1Encoding = RSACardP1Decoder.addPKCS1Padding(sourceData, moduleLength, false);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSACardDummy encrypt PKCS1Padding encode failure, sourceData={},moduleLength={}", new Object[]{DataHelper.dump4KPartData(sourceData), moduleLength, e});
            throw new CryptoException("RSACardDummy encrypt PKCS1Padding encode failure", e);
        }
        byte[] encryptData = new byte[moduleLength];
        try {
            operationResult = cryptokit.jni.JNIRSA.dowithPublicKey((byte[])pkcs1Encoding, (byte[])dummyPublicKey.jniEncodedBytes, (byte[])encryptData);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSACardDummy encrypt failure, pkcs1Encoding={},dummyPublicKey={}", new Object[]{DataHelper.dump4KPartData(pkcs1Encoding), dummyPublicKey.dumpPublicKey(), e});
            throw new CryptoException("RSACardDummy encrypt failure", e);
        }
        if (!operationResult) {
            LoggerManager.exceptionLogger.error("RSACardDummy encrypt failure, operationResult={},pkcs1Encoding={},dummyPublicKey={}", new Object[]{operationResult, DataHelper.dump4KPartData(pkcs1Encoding), dummyPublicKey.dumpPublicKey()});
            throw new CryptoException("RSACardDummy encrypt: operationResult=" + operationResult);
        }
        return encryptData;
    }

    public byte[] decrypt(PrivateKey privateKey, byte[] encryptData) throws CryptoException {
        boolean operationResult;
        RSACardDummyPrivateKey dummyPrivateKey = this.convertPrivateKey(privateKey);
        int moduleLength = dummyPrivateKey.moduleBytesLength;
        if (encryptData == null || encryptData.length == 0) {
            throw new CryptoParameterException("RSACardDummy decrypt missing encryptData");
        }
        if (encryptData.length != moduleLength) {
            throw new CryptoParameterException("RSACardDummy decrypt invalid encryptLength: " + encryptData.length + ",moduleLength=" + moduleLength);
        }
        byte[] decryptData = new byte[moduleLength];
        try {
            operationResult = JNIRSA.dowithPrivateKey(encryptData, dummyPrivateKey.jniEncodedBytes, decryptData, dummyPrivateKey.getPrivateKeyRef());
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSACardDummy decrypt failure, encryptData={},dummyPrivateKey={}", new Object[]{DataHelper.dump4KPartData(encryptData), dummyPrivateKey.dumpPublicKey(), e});
            throw new CryptoException("RSACardDummy decrypt failure", e);
        }
        if (!operationResult) {
            LoggerManager.exceptionLogger.error("RSACardDummy decrypt failure, operationResult={},encryptData={},dummyPrivateKey={}", new Object[]{operationResult, DataHelper.dump4KPartData(encryptData), dummyPrivateKey.dumpPublicKey()});
            throw new CryptoException("RSACardDummy decrypt failure: operationResult=" + operationResult);
        }
        try {
            return RSACardP1Decoder.delPKCS1Padding(decryptData, moduleLength, false);
        }
        catch (Exception e) {
            LoggerManager.exceptionLogger.error("RSACardDummy decrypt PKCS1Padding decode failure, decryptData={},moduleLength={},encryptData={},dummyPrivateKey={}", new Object[]{DataHelper.dump4KPartData(decryptData), moduleLength, DataHelper.dump4KPartData(encryptData), dummyPrivateKey.dumpPublicKey(), e});
            throw new CryptoException("RSACardDummy decrypt PKCS1Padding decode failure", e);
        }
    }

    private RSACardDummyPrivateKey convertPrivateKey(PrivateKey privateKey) throws CryptoException {
        if (privateKey == null) {
            throw new CryptoParameterException("missing privateKey");
        }
        RSACardDummyPrivateKey outputPrivateKey = null;
        if (privateKey instanceof RSACardDummyPrivateKey) {
            outputPrivateKey = (RSACardDummyPrivateKey)privateKey;
        } else if (privateKey instanceof RSAPrivateCrtKey) {
            outputPrivateKey = new RSACardDummyPrivateKey((RSAPrivateCrtKey)privateKey);
        } else if (privateKey instanceof RSAPrivateKey) {
            RSAPrivateKey rsaKey = (RSAPrivateKey)privateKey;
            BCRSAPrivateCrtKey crtKey = new BCRSAPrivateCrtKey(new RSAPrivateCrtKeyParameters(rsaKey.getModulus(), BigInteger.ZERO, rsaKey.getPrivateExponent(), BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO));
            outputPrivateKey = new RSACardDummyPrivateKey(crtKey);
        } else {
            throw new CryptoParameterException("invalid privateKey(required RSAPrivateKey)");
        }
        return outputPrivateKey;
    }

    private RSACardDummyPublicKey convertPublicKey(PublicKey publicKey) throws CryptoException {
        if (publicKey == null) {
            throw new CryptoParameterException("missing publicKey");
        }
        RSACardDummyPublicKey outputPublicKey = null;
        if (publicKey instanceof RSACardDummyPublicKey) {
            outputPublicKey = (RSACardDummyPublicKey)publicKey;
        } else if (publicKey instanceof RSAPublicKey) {
            outputPublicKey = new RSACardDummyPublicKey((RSAPublicKey)publicKey);
        } else {
            throw new CryptoParameterException("invalid publicKey(required RSAPublicKey)");
        }
        return outputPublicKey;
    }

    public boolean idleTest() throws CryptoException {
        return true;
    }

    public int ensureKeyIndexValid(int keyIndex) throws CryptoException {
        return keyIndex;
    }

    public byte[] hashDigestInfo(Mechanism mechanism, byte[] sourceData) throws CryptoException {
        return RSACardHashHelper.hashDigestInfo(mechanism, sourceData);
    }

    public byte[] hashDigestInfo(Mechanism mechanism, InputStream sourceStream) throws CryptoException {
        return RSACardHashHelper.hashDigestInfo(mechanism, sourceStream);
    }

    public byte[] buildDigestInfo(Mechanism mechanism, byte[] hashValue) throws CryptoException {
        return RSACardHashHelper.buildDigestInfo(mechanism, hashValue);
    }

    public static class Dummy {
        public static final RSACardDummy INSTANCE = new RSACardDummy();
    }
}

