/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.httpframework.utils;

import cfca.paperless.httpframework.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpParamUtils {
    private static final Logger logger = LoggerFactory.getLogger(HttpParamUtils.class);

    public static String base64UrlDecode(String str) throws UnsupportedEncodingException {
        if (StringUtils.isNotEmpty(str)) {
            return str.replaceAll(" ", "+").replaceAll("%2F", "/").replaceAll("%3D", "=").replaceAll("\n", "");
        }
        return str;
    }

    public static String urlDecode(String str) throws UnsupportedEncodingException {
        return HttpParamUtils.base64UrlDecode(str);
    }

    public static void main(String[] args) throws Exception {
        String abc = "123456789";
        Map<String, String> map = HttpParamUtils.parseHttpRequestParams(abc.getBytes("UTF-8"));
        System.out.println(map.size());
    }

    public static Map<String, String> parseHttpRequestParams(byte[] bytes) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (bytes == null || bytes.length == 0) {
            return params;
        }
        int pos = 0;
        int end = bytes.length;
        while (pos < end) {
            int nameStart = pos;
            int nameEnd = -1;
            int valueStart = -1;
            int valueEnd = -1;
            boolean parsingName = true;
            boolean decodeName = false;
            boolean decodeValue = false;
            boolean parameterComplete = false;
            do {
                switch (bytes[pos]) {
                    case 61: {
                        if (parsingName) {
                            nameEnd = pos++;
                            parsingName = false;
                            valueStart = pos;
                            break;
                        }
                        ++pos;
                        break;
                    }
                    case 38: {
                        if (parsingName) {
                            nameEnd = pos;
                        } else {
                            valueEnd = pos;
                        }
                        parameterComplete = true;
                        ++pos;
                        break;
                    }
                    case 37: 
                    case 43: {
                        if (parsingName) {
                            decodeName = true;
                        } else {
                            decodeValue = true;
                        }
                        ++pos;
                        break;
                    }
                    default: {
                        ++pos;
                    }
                }
            } while (!parameterComplete && pos < end);
            if (pos == end) {
                if (nameEnd == -1) {
                    nameEnd = pos;
                } else if (valueStart > -1 && valueEnd == -1) {
                    valueEnd = pos;
                }
            }
            if (nameEnd <= nameStart) {
                if (valueStart == -1) continue;
                throw new RuntimeException("\u89e3\u6790\u53c2\u6570\u51fa\u9519\uff0c\u51fa\u73b0\u5f62\u5982'&=foo&'\u7684\u53c2\u6570");
            }
            try {
                String name = new String(bytes, nameStart, nameEnd - nameStart, "UTF-8");
                if (decodeName) {
                    name = URLDecoder.decode(name, "UTF-8");
                }
                String value = "";
                if (valueStart >= 0) {
                    value = new String(bytes, valueStart, valueEnd - valueStart, "UTF-8");
                    if (decodeValue) {
                        value = URLDecoder.decode(value, "UTF-8");
                    }
                }
                params.put(name, value);
            }
            catch (Exception e) {
                logger.error("parse http request body error", (Throwable)e);
            }
        }
        return params;
    }
}

