/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.sadk;

import cfca.com.itextpdf.text.BadElementException;
import cfca.com.itextpdf.text.BaseColor;
import cfca.com.itextpdf.text.Document;
import cfca.com.itextpdf.text.DocumentException;
import cfca.com.itextpdf.text.Font;
import cfca.com.itextpdf.text.Image;
import cfca.com.itextpdf.text.Rectangle;
import cfca.com.itextpdf.text.pdf.AcroFields;
import cfca.com.itextpdf.text.pdf.BaseFont;
import cfca.com.itextpdf.text.pdf.ByteBuffer;
import cfca.com.itextpdf.text.pdf.IntHashtable;
import cfca.com.itextpdf.text.pdf.PRStream;
import cfca.com.itextpdf.text.pdf.PRTokeniser;
import cfca.com.itextpdf.text.pdf.PdfArray;
import cfca.com.itextpdf.text.pdf.PdfContentByte;
import cfca.com.itextpdf.text.pdf.PdfContentParser;
import cfca.com.itextpdf.text.pdf.PdfCopy;
import cfca.com.itextpdf.text.pdf.PdfDate;
import cfca.com.itextpdf.text.pdf.PdfDictionary;
import cfca.com.itextpdf.text.pdf.PdfGState;
import cfca.com.itextpdf.text.pdf.PdfImportedPage;
import cfca.com.itextpdf.text.pdf.PdfIndirectReference;
import cfca.com.itextpdf.text.pdf.PdfLiteral;
import cfca.com.itextpdf.text.pdf.PdfName;
import cfca.com.itextpdf.text.pdf.PdfNumber;
import cfca.com.itextpdf.text.pdf.PdfObject;
import cfca.com.itextpdf.text.pdf.PdfReader;
import cfca.com.itextpdf.text.pdf.PdfSignature;
import cfca.com.itextpdf.text.pdf.PdfSignatureAppearance;
import cfca.com.itextpdf.text.pdf.PdfStamper;
import cfca.com.itextpdf.text.pdf.PdfTemplate;
import cfca.com.itextpdf.text.pdf.PdfWriter;
import cfca.com.itextpdf.text.pdf.RandomAccessFileOrArray;
import cfca.com.itextpdf.text.pdf.parser.PdfTextExtractor;
import cfca.com.itextpdf.text.pdf.security.BouncyCastleDigest;
import cfca.com.itextpdf.text.pdf.security.ExternalDigest;
import cfca.com.itextpdf.text.pdf.security.ExternalSignature;
import cfca.com.itextpdf.text.pdf.security.MakeSignature;
import cfca.com.itextpdf.text.pdf.security.PdfPKCS7;
import cfca.com.itextpdf.text.pdf.security.PrivateKeySignature;
import cfca.com.itextpdf.text.pdf.security.TSAClient;
import cfca.com.itextpdf.text.pdf.security.TSAClientBouncyCastle;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.tsp.TSPException;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.seal.sadk.LocationInfo;
import cfca.seal.sadk.PdfSealRevoker;
import cfca.seal.sadk.PrePdfReader;
import cfca.seal.sadk.PrePdfSeal;
import cfca.seal.sadk.PrePdfSealExtra;
import cfca.seal.sadk.SignatureLandscape;
import cfca.seal.sadk.crosspage.CrossPageStrategy;
import cfca.seal.sadk.keyword.PdfKeywordLocationImpl;
import cfca.seal.sadk.security.deferred.ExternalReservedSignatureContainer;
import cfca.seal.sadk.security.deferred.ReservedPdfPKCS7;
import cfca.seal.sadk.security.external.DoneExternalSessionSignatureContainer;
import cfca.seal.sadk.security.external.ExternalBlankPrivateSignature;
import cfca.seal.sadk.security.external.PreExternalTSAClient;
import cfca.seal.sadk.watermark.PageRangeOption;
import cfca.seal.sadk.watermark.WaterMarkOption;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.io.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DonePdfSeal {
    Logger logger = LoggerFactory.getLogger(DonePdfSeal.class);
    private LocationInfo locationInfo;
    private PrePdfSeal prePdfSeal;
    private PrePdfSealExtra prePdfSealExtra;
    private PrePdfReader prePdfReader;
    private String fieldName = "DefaultFieldName";
    private ArrayList sigNames;
    private HashMap sigNameCertMap;
    private HashMap sigNamePKCS7Map;
    private int sealType;
    private boolean exactMatch = false;
    private boolean isVisible = true;
    private Rectangle visibleRectangle;
    private boolean keywordisLocatedAgain;
    private String lastKeyword;

    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    public void setLocationInfo(LocationInfo locationInfo) {
        this.locationInfo = locationInfo;
    }

    public Map getSigNameCertMap() throws DocumentException {
        if (this.sigNameCertMap == null) {
            throw new DocumentException("this method must be called after verifyPKCS7(.)");
        }
        return this.sigNameCertMap;
    }

    public Map getSigNameCertMap(String field) throws DocumentException {
        if (this.sigNameCertMap == null) {
            throw new DocumentException("this method must be called after verifyPKCS7(.)");
        }
        HashMap<String, X509Cert> tmpSigNameCertMap = new HashMap<String, X509Cert>();
        ArrayList tmpFields = this.getSigNames(field);
        int sizeOftmpFields = tmpFields.size();
        for (int i = 0; i < sizeOftmpFields; ++i) {
            String aTmpfield = (String)tmpFields.get(i);
            X509Cert aCert = (X509Cert)this.sigNameCertMap.get(aTmpfield);
            tmpSigNameCertMap.put(aTmpfield, aCert);
        }
        return tmpSigNameCertMap;
    }

    public Map getSigNamePKCS7Map() throws DocumentException {
        if (this.sigNamePKCS7Map == null) {
            throw new DocumentException("this method must be called after verifyPKCS7(.)");
        }
        return this.sigNamePKCS7Map;
    }

    public Map getSigNamePKCS7Map(String field) throws DocumentException {
        if (this.sigNamePKCS7Map == null) {
            throw new DocumentException("this method must be called after verifyPKCS7(.)");
        }
        HashMap<String, PdfPKCS7> tmpSigNamePKCS7Map = new HashMap<String, PdfPKCS7>();
        ArrayList tmpFields = this.getSigNames(field);
        int sizeOftmpFields = tmpFields.size();
        for (int i = 0; i < sizeOftmpFields; ++i) {
            String aTmpfield = (String)tmpFields.get(i);
            PdfPKCS7 pdfPKCS7 = (PdfPKCS7)this.sigNamePKCS7Map.get(aTmpfield);
            tmpSigNamePKCS7Map.put(aTmpfield, pdfPKCS7);
        }
        return tmpSigNamePKCS7Map;
    }

    public ArrayList getSigNames() throws DocumentException {
        if (this.sigNames == null) {
            throw new DocumentException("this method must be called after verifyPKCS7(.)");
        }
        return this.sigNames;
    }

    public ArrayList getSigNames(String field) throws DocumentException {
        ArrayList<String> sigNamesWithSpecField = new ArrayList<String>();
        if (this.sigNames == null) {
            throw new DocumentException("this method must be called after verifyPKCS7(.)");
        }
        boolean match = false;
        int sizeOfSigNames = this.sigNames.size();
        for (int i = 0; i < sizeOfSigNames; ++i) {
            String tmpField = (String)this.sigNames.get(i);
            boolean bl = match = this.exactMatch ? tmpField.equals(field) : tmpField.contains(field);
            if (!match) continue;
            sigNamesWithSpecField.add(tmpField);
        }
        if (sigNamesWithSpecField.isEmpty()) {
            throw new DocumentException("No specific field Signature/Seal found!");
        }
        return sigNamesWithSpecField;
    }

    public void initPdfReader(PrePdfReader prePdfReader) {
        this.keywordisLocatedAgain = true;
        this.prePdfReader = prePdfReader;
    }

    public void initPdfSealExtra(PrePdfSealExtra prePdfSealExtra) {
        this.prePdfSealExtra = prePdfSealExtra;
    }

    public void initPdfSeal(PrePdfSeal prePdfSeal) {
        this.prePdfSeal = prePdfSeal;
    }

    public byte[] createPdfSeal(int certificationLevel) throws DocumentException, IOException, GeneralSecurityException {
        if (!this.canMakeSignature(this.prePdfReader.getPdfReader())) {
            throw new GeneralSecurityException("Only approval signature allowed to make signature again!");
        }
        return this.createPdfSealByLocation(this.locationInfo, null, certificationLevel);
    }

    public byte[] createPdfSeal(String tsaURL, String tsaUserName, String tsaPassword, int certificationLevel) throws DocumentException, IOException, GeneralSecurityException {
        if (!this.canMakeSignature(this.prePdfReader.getPdfReader())) {
            throw new GeneralSecurityException("Only approval signature allowed to make signature again!");
        }
        TSAClientBouncyCastle tsaClient = null;
        if (tsaURL != null && !tsaURL.equals("")) {
            PrePdfSealExtra.TSASettings tsaSettings = this.prePdfSealExtra.getTSASettings();
            if (tsaSettings != null) {
                int connectTimeout = tsaSettings.getConnectTimeout();
                int readTimeout = tsaSettings.getReadTimeout();
                boolean catchException = tsaSettings.switchover;
                tsaClient = new TSAClientBouncyCastle(tsaURL, tsaUserName, tsaPassword, connectTimeout, readTimeout, catchException);
            } else {
                tsaClient = new TSAClientBouncyCastle(tsaURL, tsaUserName, tsaPassword);
            }
        }
        return this.createPdfSealByLocation(this.locationInfo, tsaClient, certificationLevel);
    }

    public byte[] createPdfSeal(PreExternalTSAClient preExternalTSAClient, int certificationLevel) throws DocumentException, IOException, GeneralSecurityException {
        if (!this.canMakeSignature(this.prePdfReader.getPdfReader())) {
            throw new GeneralSecurityException("Only approval signature allowed to make signature again!");
        }
        return this.createPdfSealByLocation(this.locationInfo, preExternalTSAClient, certificationLevel);
    }

    public byte[] createPdfSeal(String tsaURL, String tsaUserName, String tsaPassword, int tsaEstimatedTokenSize, String tsaDigestAlgorithm, int certificationLevel) throws DocumentException, IOException, GeneralSecurityException {
        if (!this.canMakeSignature(this.prePdfReader.getPdfReader())) {
            throw new GeneralSecurityException("Only approval signature allowed to make signature again!");
        }
        TSAClientBouncyCastle tsaClient = null;
        if (tsaURL != null && !tsaURL.equals("")) {
            PrePdfSealExtra.TSASettings tsaSettings = this.prePdfSealExtra.getTSASettings();
            if (tsaSettings != null) {
                int connectTimeout = tsaSettings.getConnectTimeout();
                int readTimeout = tsaSettings.getReadTimeout();
                boolean catchException = tsaSettings.switchover;
                tsaClient = new TSAClientBouncyCastle(tsaURL, tsaUserName, tsaPassword, tsaEstimatedTokenSize, tsaDigestAlgorithm, connectTimeout, readTimeout, catchException);
            } else {
                tsaClient = new TSAClientBouncyCastle(tsaURL, tsaUserName, tsaPassword, tsaEstimatedTokenSize, tsaDigestAlgorithm);
            }
        }
        return this.createPdfSealByLocation(this.locationInfo, tsaClient, certificationLevel);
    }

    private byte[] createPdfSealByLocation(LocationInfo locationInfo, TSAClient tsaClient, int certificationLevel) throws DocumentException, IOException, GeneralSecurityException {
        byte[] sealedPdfBytes = null;
        this.logger.info("begin createPdfSealByLocation...");
        ByteBuffer outByteBuffer = null;
        ByteBuffer workByteBuffer = null;
        PrePdfSealExtra.TempFileBufferStrategy tempFileBufferStrategy = null;
        PrePdfSealExtra.BufferStrategy bufferStrategy = this.prePdfSealExtra.getBufferStrategy();
        PrePdfSealExtra.SignatureOpacity signatureOpacity = this.prePdfSealExtra.getSignatureOpacity();
        if (null == bufferStrategy) {
            outByteBuffer = new ByteBuffer(4096);
            workByteBuffer = new ByteBuffer(4096);
        } else if (bufferStrategy instanceof PrePdfSealExtra.TempFileBufferStrategy) {
            tempFileBufferStrategy = (PrePdfSealExtra.TempFileBufferStrategy)bufferStrategy;
        }
        PdfReader workPdfReader = this.prePdfReader.getPdfReader();
        byte[] password = workPdfReader.getOwnerPassword();
        int cntSeal = locationInfo.getCntSeal();
        for (int i = 0; i < cntSeal; ++i) {
            PdfStamper stamper = null;
            PdfSignatureAppearance appearance = null;
            if (null == bufferStrategy) {
                stamper = PdfStamper.createSignature(workPdfReader, (OutputStream)outByteBuffer, '\u0000', workByteBuffer, true);
            } else if (bufferStrategy instanceof PrePdfSealExtra.TempFileBufferStrategy) {
                File stpTempFile = tempFileBufferStrategy.tempFile;
                stamper = PdfStamper.createSignature(workPdfReader, null, '\u0000', stpTempFile, true);
            }
            appearance = stamper.getSignatureAppearance();
            Object image = null;
            SignatureLandscape signatureLandscape = locationInfo.getLocSignatureLandscapeInfoList().get(i);
            if (this.sealType == 1) {
                this.doBlankSignature(signatureOpacity, appearance, signatureLandscape);
            } else {
                this.visibleRectangle = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
                String userFieldName = this.prePdfSealExtra.getFieldName();
                if (null != userFieldName && !"".equals(userFieldName)) {
                    this.fieldName = userFieldName;
                }
                if (null != signatureOpacity) {
                    this.isVisible = signatureOpacity.getVisible();
                }
                if (this.isVisible) {
                    this.doVisibleSignature(signatureOpacity, i, appearance, signatureLandscape);
                } else {
                    this.doInvisibleSignature(appearance, signatureLandscape);
                }
            }
            String reason = this.prePdfSealExtra.getReason();
            String location = this.prePdfSealExtra.getLocation();
            appearance.setReason(reason);
            appearance.setLocation(location);
            appearance.setCertificationLevel(certificationLevel);
            boolean ifExternalContainer = this.prePdfSeal.IfExternalContainer();
            PrivateKey privateKey = this.prePdfSeal.getPrivateKey();
            if (!ifExternalContainer) {
                this.doInternalContainer(tsaClient, appearance, privateKey);
            } else {
                this.doExternalContainer(tsaClient, appearance);
            }
            if (null == bufferStrategy) {
                byte[] tempSealedPdfBytes = outByteBuffer.toByteArray();
                if (cntSeal - i == 1) {
                    sealedPdfBytes = tempSealedPdfBytes;
                    break;
                }
                outByteBuffer.reset();
                workByteBuffer.reset();
                workPdfReader = new PdfReader(tempSealedPdfBytes, password);
                continue;
            }
            if (!(bufferStrategy instanceof PrePdfSealExtra.TempFileBufferStrategy)) continue;
            File tempFile = tempFileBufferStrategy.tempFile;
            byte[] tempSealedPdfBytes = FileUtils.readFileToByteArray((File)tempFile);
            if (cntSeal - i == 1) {
                sealedPdfBytes = tempSealedPdfBytes;
                boolean isTempFileTemporal = tempFileBufferStrategy.isTempFileTemporal;
                if (!isTempFileTemporal || tempFile == null) break;
                tempFile.delete();
                break;
            }
            workPdfReader = new PdfReader(tempSealedPdfBytes, password);
        }
        this.logger.info("end createPdfSealByLocation...");
        return sealedPdfBytes;
    }

    private void doExternalContainer(TSAClient tsaClient, PdfSignatureAppearance appearance) throws CertificateException, GeneralSecurityException, IOException, DocumentException {
        ExternalDigest externalDigest = this.prePdfSeal.getExternalDigest();
        ExternalSignature externalSignature = this.prePdfSeal.getExternalSignature();
        int deferredType = this.prePdfSeal.getDeferredType();
        Certificate[] chain = externalSignature.getCertificateChain();
        String encryptionAlgorithm = this.prePdfSeal.getEncryptionAlgorithm();
        appearance.setEncryptionAlgorithm(encryptionAlgorithm);
        DoneExternalSessionSignatureContainer externalSessionSignatureContainer = null;
        MakeSignature.CryptoStandard csd = MakeSignature.CryptoStandard.CMS;
        boolean docBase64Encoding = this.prePdfSealExtra.getDocHashBase64Encoding();
        if ("RSA".equals(encryptionAlgorithm)) {
            if (!docBase64Encoding) {
                PdfName filter = this.prePdfSeal.getFilter();
                PdfName subFilter = this.prePdfSeal.getSubFilter();
                externalSessionSignatureContainer = filter == null && subFilter == null ? new DoneExternalSessionSignatureContainer(PdfName.ADOBE_PPKLITE, csd == MakeSignature.CryptoStandard.CADES ? PdfName.ETSI_CADES_DETACHED : PdfName.ADBE_PKCS7_DETACHED, externalDigest, externalSignature) : new DoneExternalSessionSignatureContainer(filter, subFilter, externalDigest, externalSignature);
            } else {
                externalSessionSignatureContainer = new DoneExternalSessionSignatureContainer(PdfName.CFCA_TrustSignPDF, PdfName.RSA_BASE64_SHA1, externalDigest, externalSignature);
            }
        } else if ("SM2".equals(encryptionAlgorithm)) {
            externalSessionSignatureContainer = new DoneExternalSessionSignatureContainer(PdfName.CFCA_TrustSignPDF, PdfName.CFCA_SM2_PKCS7_DETACHED, externalDigest, externalSignature);
            int sigVer = this.prePdfSealExtra.getSignatureVersion();
            if (1 == sigVer) {
                appearance.setJavaScript(this.prePdfSealExtra.getJavaScript());
            }
            appearance.setSignatureVersion(sigVer);
        }
        if (null == externalSessionSignatureContainer) {
            throw new GeneralSecurityException("unsupported signature filter happen!");
        }
        externalSessionSignatureContainer.setTSAClient(tsaClient);
        externalSessionSignatureContainer.setCryptoStandard(MakeSignature.CryptoStandard.CMS);
        externalSessionSignatureContainer.setDeferredType(deferredType);
        externalSessionSignatureContainer.setCertificateChain(chain);
        int estimatedSize = this.prePdfSealExtra.getEstimatedSize();
        if (0 == estimatedSize) {
            estimatedSize = externalSessionSignatureContainer.getExternalSignatureSize();
        }
        MakeSignature.signExternalContainer(appearance, externalSessionSignatureContainer, estimatedSize);
    }

    private void doInternalContainer(TSAClient tsaClient, PdfSignatureAppearance appearance, PrivateKey privateKey) throws IOException, DocumentException, GeneralSecurityException {
        boolean docBase64Encoding = this.prePdfSealExtra.getDocHashBase64Encoding();
        MakeSignature.Option option = new MakeSignature.Option();
        option.docHashBase64Encoding = docBase64Encoding;
        Certificate[] chain = this.prePdfSeal.getCertificateChain();
        String encryptionAlgorithm = this.prePdfSeal.getEncryptionAlgorithm();
        appearance.setEncryptionAlgorithm(encryptionAlgorithm);
        PrivateKeySignature externalSignature = null;
        if ("SM2".equals(encryptionAlgorithm)) {
            externalSignature = new PrivateKeySignature(privateKey, chain, encryptionAlgorithm, this.prePdfSeal.getHashAlgorithm(), null);
            int sigVer = this.prePdfSealExtra.getSignatureVersion();
            if (1 == sigVer) {
                appearance.setJavaScript(this.prePdfSealExtra.getJavaScript());
            }
            appearance.setSignatureVersion(sigVer);
        } else if ("RSA".equals(encryptionAlgorithm)) {
            externalSignature = new PrivateKeySignature(privateKey, null, encryptionAlgorithm, this.prePdfSeal.getHashAlgorithm(), null);
        }
        BouncyCastleDigest externalDigest = new BouncyCastleDigest();
        int estimatedSize = this.prePdfSealExtra.getEstimatedSize();
        MakeSignature.signDetached(appearance, externalDigest, externalSignature, chain, null, null, tsaClient, estimatedSize, MakeSignature.CryptoStandard.CMS, option);
    }

    private void doInvisibleSignature(PdfSignatureAppearance appearance, SignatureLandscape signatureLandscape) {
        String tmpFieldName = this.doFieldName();
        appearance.setVisibleSignature(this.visibleRectangle, signatureLandscape.page, tmpFieldName);
    }

    private void doVisibleSignature(PrePdfSealExtra.SignatureOpacity signatureOpacity, int i, PdfSignatureAppearance appearance, SignatureLandscape signatureLandscape) throws BadElementException, DocumentException {
        PrePdfSealExtra.ImageAppearance imageAppearance;
        Image image;
        float llxAppearance = 100.0f;
        float llyAppearance = 100.0f;
        float urxAppearance = 200.0f;
        float uryAppearance = 200.0f;
        if (this.sealType == 3) {
            image = this.prePdfSeal.getImage(i + 1);
            if (image == null && (imageAppearance = this.prePdfSealExtra.getImageAppearance()) != null) {
                image = imageAppearance.getImage(i + 1);
            }
        } else {
            image = this.prePdfSeal.getImage(0);
            if (image == null && (imageAppearance = this.prePdfSealExtra.getImageAppearance()) != null) {
                image = imageAppearance.getImage(0);
            }
        }
        PrePdfSealExtra.Layer2Appearance layer2Appearance = this.prePdfSealExtra.getLayer2Appearance();
        if (image != null) {
            this.doImageAppearance(appearance, signatureLandscape, image, llxAppearance, llyAppearance, urxAppearance, uryAppearance);
        } else if (layer2Appearance != null) {
            this.doLayer2TextAppearance(appearance, signatureLandscape, llxAppearance, llyAppearance, urxAppearance, uryAppearance);
        } else {
            this.doDefaultAppearance(signatureLandscape);
        }
        String tmpFieldName = this.doFieldName();
        appearance.setVisibleSignature(this.visibleRectangle, signatureLandscape.page, tmpFieldName);
        appearance.setAcro6Layers(false);
        this.doSignatureOpacity(signatureOpacity, appearance);
    }

    private void doDefaultAppearance(SignatureLandscape signatureLandscape) {
        float uryAppearance;
        float urxAppearance;
        float llxAppearance = signatureLandscape.rectViewer.getLeft();
        float llyAppearance = signatureLandscape.rectViewer.getBottom();
        if (this.sealType == 1) {
            urxAppearance = signatureLandscape.rectViewer.getRight();
            uryAppearance = signatureLandscape.rectViewer.getTop();
        } else {
            urxAppearance = llxAppearance + 200.0f;
            uryAppearance = llyAppearance + 80.0f;
        }
        this.visibleRectangle = new Rectangle(llxAppearance - 2.0f, llyAppearance - 2.0f, urxAppearance + 2.0f, uryAppearance + 2.0f);
    }

    private void doImageAppearance(PdfSignatureAppearance appearance, SignatureLandscape signatureLandscape, Image image, float llxAppearance, float llyAppearance, float urxAppearance, float uryAppearance) throws DocumentException {
        float pointImageHeight = 0.0f;
        float pointImageWidth = 0.0f;
        float poundImageHeight = 0.0f;
        float scaledPoundImageHeight = 0.0f;
        float poundImageWidth = 0.0f;
        float scaledPoundImageWidth = 0.0f;
        float imageScale = 0.0f;
        if (this.prePdfSeal.getImage(0) != null) {
            imageScale = this.prePdfSeal.getImageScale();
        } else {
            PrePdfSealExtra.ImageAppearance imageAppearance = this.prePdfSealExtra.getImageAppearance();
            if (imageAppearance != null) {
                imageScale = imageAppearance.getImageScale();
            }
        }
        int dpiX = image.getDpiX();
        int dpiY = image.getDpiY();
        dpiX = dpiX == 0 ? 72 : dpiX;
        dpiY = dpiY == 0 ? 72 : dpiY;
        pointImageHeight = image.getHeight();
        poundImageHeight = pointImageHeight / (float)dpiY * 72.0f;
        scaledPoundImageHeight = poundImageHeight * imageScale;
        pointImageWidth = image.getWidth();
        poundImageWidth = pointImageWidth / (float)dpiX * 72.0f;
        scaledPoundImageWidth = poundImageWidth * imageScale;
        appearance.setSignatureGraphic(image);
        appearance.setRenderingMode(PdfSignatureAppearance.RenderingMode.GRAPHIC);
        if (pointImageHeight > 0.0f && pointImageWidth > 0.0f) {
            if (2 == this.sealType) {
                int alignmentSettings = this.prePdfSealExtra.getAlignmentSettings();
                this.visibleRectangle = DonePdfSeal.adjustAlignment(signatureLandscape.rectViewer, alignmentSettings, scaledPoundImageWidth, scaledPoundImageHeight);
                llxAppearance = this.visibleRectangle.getLeft();
                llyAppearance = this.visibleRectangle.getBottom();
                urxAppearance = this.visibleRectangle.getRight();
                uryAppearance = this.visibleRectangle.getTop();
            } else if (0 == this.sealType || 3 == this.sealType) {
                llxAppearance = signatureLandscape.rectViewer.getLeft();
                llyAppearance = signatureLandscape.rectViewer.getBottom();
                urxAppearance = signatureLandscape.rectViewer.getLeft() + scaledPoundImageWidth;
                uryAppearance = signatureLandscape.rectViewer.getBottom() + scaledPoundImageHeight;
            }
        }
        this.visibleRectangle = new Rectangle(llxAppearance - 2.0f, llyAppearance - 2.0f, urxAppearance + 2.0f, uryAppearance + 2.0f);
    }

    private void doLayer2TextAppearance(PdfSignatureAppearance appearance, SignatureLandscape signatureLandscape, float llxAppearance, float llyAppearance, float urxAppearance, float uryAppearance) throws DocumentException {
        appearance.setRenderingMode(PdfSignatureAppearance.RenderingMode.DESCRIPTION);
        float width = 0.0f;
        float height = 0.0f;
        PrePdfSealExtra.Layer2Appearance layer2Appearance = this.prePdfSealExtra.getLayer2Appearance();
        String layer2Text = layer2Appearance.getLayer2Text();
        Font layer2Font = layer2Appearance.getLayer2Font();
        boolean isTop = layer2Appearance.isALIGN_TOP();
        appearance.setLayer2Font(layer2Font);
        appearance.setLayer2Text(layer2Text);
        appearance.setLayer2TextTopAliment(isTop);
        Rectangle visibleSignature = layer2Appearance.getVisibleSignature();
        width = visibleSignature.getWidth();
        height = visibleSignature.getHeight();
        if (2 == this.sealType) {
            int alignmentSettings = this.prePdfSealExtra.getAlignmentSettings();
            this.visibleRectangle = DonePdfSeal.adjustAlignment(signatureLandscape.rectViewer, alignmentSettings, width, height);
            llxAppearance = this.visibleRectangle.getLeft();
            llyAppearance = this.visibleRectangle.getBottom();
            urxAppearance = this.visibleRectangle.getRight();
            uryAppearance = this.visibleRectangle.getTop();
        } else if (0 == this.sealType || 3 == this.sealType) {
            llxAppearance = signatureLandscape.rectViewer.getLeft();
            llyAppearance = signatureLandscape.rectViewer.getBottom();
            urxAppearance = llxAppearance + width;
            uryAppearance = llyAppearance + height;
        }
        this.visibleRectangle = new Rectangle(llxAppearance - 2.0f, llyAppearance - 2.0f, urxAppearance + 2.0f, uryAppearance + 2.0f);
    }

    private String doFieldName() {
        boolean completeMatch = this.prePdfSealExtra.getCompleteMatch();
        String tmpFieldName = "";
        tmpFieldName = completeMatch ? this.fieldName : this.fieldName + ":" + UUID.randomUUID().toString();
        return tmpFieldName;
    }

    private void doSignatureOpacity(PrePdfSealExtra.SignatureOpacity signatureOpacity, PdfSignatureAppearance appearance) {
        if (null != signatureOpacity) {
            float fillOpacity = signatureOpacity.getFillOpacity();
            int gsBlendMode = signatureOpacity.getGSBlendMode();
            PdfGState gState = new PdfGState();
            gState.setFillOpacity(fillOpacity);
            if (1 == gsBlendMode) {
                gState.put(PdfName.BM, PdfGState.BM_MULTIPLY);
                gState.put(PdfName.TYPE, PdfName.EXTGSTATE);
            }
            appearance.setGState(gState);
        } else {
            PdfGState gState = new PdfGState();
            gState.put(PdfName.BM, PdfGState.BM_MULTIPLY);
            gState.put(PdfName.TYPE, PdfName.EXTGSTATE);
            appearance.setGState(gState);
        }
    }

    private void doBlankSignature(PrePdfSealExtra.SignatureOpacity signatureOpacity, PdfSignatureAppearance appearance, SignatureLandscape signatureLandscape) throws BadElementException {
        PrePdfSealExtra.ImageAppearance imageAppearance;
        String blankSigFieldName;
        Image image = null;
        this.fieldName = blankSigFieldName = signatureLandscape.fieldName;
        image = this.prePdfSeal.getImage(0);
        if (image == null && (imageAppearance = this.prePdfSealExtra.getImageAppearance()) != null) {
            image = imageAppearance.getImage(0);
        }
        PrePdfSealExtra.Layer2Appearance layer2Appearance = this.prePdfSealExtra.getLayer2Appearance();
        if (image != null) {
            appearance.setSignatureGraphic(image);
            appearance.setRenderingMode(PdfSignatureAppearance.RenderingMode.GRAPHIC);
        } else if (layer2Appearance != null) {
            this.doLayer2TextAppearance(appearance);
        } else {
            this.doDefaultAppearance(signatureLandscape);
        }
        appearance.setAcro6Layers(false);
        this.doSignatureOpacity(signatureOpacity, appearance);
        appearance.setVisibleSignature(this.fieldName);
    }

    private void doLayer2TextAppearance(PdfSignatureAppearance appearance) {
        appearance.setRenderingMode(PdfSignatureAppearance.RenderingMode.DESCRIPTION);
        PrePdfSealExtra.Layer2Appearance layer2Appearance = this.prePdfSealExtra.getLayer2Appearance();
        String layer2Text = layer2Appearance.getLayer2Text();
        Font layer2Font = layer2Appearance.getLayer2Font();
        appearance.setLayer2Font(layer2Font);
        appearance.setLayer2Text(layer2Text);
        appearance.setLayer2TextTopAliment(layer2Appearance.isALIGN_TOP());
    }

    public static Rectangle adjustAlignment(Rectangle rectViewerBefore, int alignmentSettings, float appearanceWidth, float appearanceHeight) throws DocumentException {
        float llxKeyword = rectViewerBefore.getLeft();
        float llyKeyword = rectViewerBefore.getBottom();
        float urxKeyword = rectViewerBefore.getRight();
        float uryKeyword = rectViewerBefore.getTop();
        float llxAppearance = 100.0f;
        float llyAppearance = 100.0f;
        float urxAppearance = 200.0f;
        float uryAppearance = 200.0f;
        if (256 == (alignmentSettings & 0x100) && 16 == (alignmentSettings & 0x10) && 64 == (alignmentSettings & 0x40)) {
            llxAppearance = llxKeyword - appearanceWidth;
            urxAppearance = llxKeyword;
            llyAppearance = llyKeyword - (appearanceHeight - (uryKeyword - llyKeyword)) / 2.0f;
            uryAppearance = llyAppearance + appearanceHeight;
        } else if (256 == (alignmentSettings & 0x100) && 16 == (alignmentSettings & 0x10)) {
            llxAppearance = llxKeyword - appearanceWidth;
            urxAppearance = llxKeyword;
            llyAppearance = llyKeyword;
            uryAppearance = llyKeyword + appearanceHeight;
        } else if (256 == (alignmentSettings & 0x100) && 32 == (alignmentSettings & 0x20) && 64 == (alignmentSettings & 0x40)) {
            llxAppearance = urxKeyword;
            urxAppearance = urxKeyword + appearanceWidth;
            llyAppearance = llyKeyword - (appearanceHeight - (uryKeyword - llyKeyword)) / 2.0f;
            uryAppearance = llyAppearance + appearanceHeight;
        } else if (256 == (alignmentSettings & 0x100) && 32 == (alignmentSettings & 0x20)) {
            llxAppearance = urxKeyword;
            urxAppearance = llxAppearance + appearanceWidth;
            llyAppearance = llyKeyword;
            uryAppearance = llyAppearance + appearanceHeight;
        } else if (256 == (alignmentSettings & 0x100) && 4 == (alignmentSettings & 4) && 64 == (alignmentSettings & 0x40)) {
            llxAppearance = llxKeyword - (appearanceWidth - (urxKeyword - llxKeyword)) / 2.0f;
            urxAppearance = llxAppearance + appearanceWidth;
            llyAppearance = uryKeyword;
            uryAppearance = llyAppearance + appearanceHeight;
        } else if (256 == (alignmentSettings & 0x100) && 4 == (alignmentSettings & 4)) {
            llxAppearance = llxKeyword;
            urxAppearance = llxAppearance + appearanceWidth;
            llyAppearance = uryKeyword;
            uryAppearance = llyAppearance + appearanceHeight;
        } else if (256 == (alignmentSettings & 0x100) && 8 == (alignmentSettings & 8) && 64 == (alignmentSettings & 0x40)) {
            llxAppearance = llxKeyword - (appearanceWidth - (urxKeyword - llxKeyword)) / 2.0f;
            urxAppearance = llxAppearance + appearanceWidth;
            llyAppearance = llyKeyword - appearanceHeight;
            uryAppearance = llyKeyword;
        } else if (256 == (alignmentSettings & 0x100) && 8 == (alignmentSettings & 8)) {
            llxAppearance = llxKeyword;
            urxAppearance = llxKeyword + appearanceWidth;
            llyAppearance = llyKeyword - appearanceHeight;
            uryAppearance = llyKeyword;
        } else if (128 == (alignmentSettings & 0x80) && 2 == (alignmentSettings & 2) && 1 == (alignmentSettings & 1) && 64 == (alignmentSettings & 0x40)) {
            llxAppearance = llxKeyword - (appearanceWidth - (urxKeyword - llxKeyword)) / 2.0f;
            urxAppearance = llxAppearance + appearanceWidth;
            llyAppearance = llyKeyword - (appearanceHeight - (uryKeyword - llyKeyword)) / 2.0f;
            uryAppearance = llyAppearance + appearanceHeight;
        } else if (128 == (alignmentSettings & 0x80) && 16 == (alignmentSettings & 0x10) && 64 == (alignmentSettings & 0x40)) {
            llxAppearance = llxKeyword;
            urxAppearance = llxKeyword + appearanceWidth;
            llyAppearance = llyKeyword - (appearanceHeight - (uryKeyword - llyKeyword)) / 2.0f;
            uryAppearance = llyAppearance + appearanceHeight;
        } else if (128 == (alignmentSettings & 0x80) && 16 == (alignmentSettings & 0x10)) {
            llxAppearance = llxKeyword;
            llyAppearance = llyKeyword;
            urxAppearance = llxKeyword + appearanceWidth;
            uryAppearance = llyKeyword + appearanceHeight;
        } else if (128 == (alignmentSettings & 0x80) && 32 == (alignmentSettings & 0x20) && 64 == (alignmentSettings & 0x40)) {
            llxAppearance = urxKeyword - appearanceWidth;
            urxAppearance = urxKeyword;
            llyAppearance = llyKeyword - (appearanceHeight - (uryKeyword - llyKeyword)) / 2.0f;
            uryAppearance = llyAppearance + appearanceHeight;
        } else if (128 == (alignmentSettings & 0x80) && 32 == (alignmentSettings & 0x20)) {
            llxAppearance = urxKeyword - appearanceWidth;
            urxAppearance = urxKeyword;
            llyAppearance = llyKeyword;
            uryAppearance = llyAppearance + appearanceHeight;
        } else if (128 == (alignmentSettings & 0x80) && 4 == (alignmentSettings & 4) && 64 == (alignmentSettings & 0x40)) {
            llxAppearance = llxKeyword - (appearanceWidth - (urxKeyword - llxKeyword)) / 2.0f;
            urxAppearance = llxAppearance + appearanceWidth;
            llyAppearance = uryKeyword - appearanceHeight;
            uryAppearance = uryKeyword;
        } else if (128 == (alignmentSettings & 0x80) && 4 == (alignmentSettings & 4)) {
            llxAppearance = llxKeyword;
            urxAppearance = llxKeyword + appearanceWidth;
            llyAppearance = uryKeyword - appearanceHeight;
            uryAppearance = uryKeyword;
        } else if (128 == (alignmentSettings & 0x80) && 8 == (alignmentSettings & 8) && 64 == (alignmentSettings & 0x40)) {
            llxAppearance = llxKeyword;
            urxAppearance = llxKeyword + appearanceWidth;
            llyAppearance = llyKeyword;
            uryAppearance = llyAppearance + appearanceHeight;
        } else if (128 == (alignmentSettings & 0x80) && 8 == (alignmentSettings & 8)) {
            llxAppearance = llxKeyword - (appearanceWidth - (urxKeyword - llxKeyword)) / 2.0f;
            urxAppearance = llxAppearance + appearanceWidth;
            llyAppearance = llyKeyword;
            uryAppearance = llyAppearance + appearanceHeight;
        } else {
            throw new DocumentException("Unsupported alignment!");
        }
        Rectangle rectViewerAfter = new Rectangle(llxAppearance, llyAppearance, urxAppearance, uryAppearance);
        return rectViewerAfter;
    }

    private Rectangle transformRectangle(PdfReader reader, int page, Rectangle rectDocument) {
        int rotationAngle = reader.getPageRotation(page);
        if (0 == rotationAngle) {
            return rectDocument;
        }
        Rectangle pageSize = reader.getPageSize(page);
        float width = pageSize.getWidth();
        float height = pageSize.getHeight();
        float llx = rectDocument.getLeft();
        float lly = rectDocument.getBottom();
        float urx = rectDocument.getRight();
        float ury = rectDocument.getTop();
        float[] llxy = this.transformCoord(width, height, new float[]{llx, lly}, rotationAngle);
        llx = llxy[0];
        lly = llxy[1];
        float[] urxy = this.transformCoord(width, height, new float[]{urx, ury}, rotationAngle);
        urx = urxy[0];
        ury = urxy[1];
        Rectangle rectViewer = new Rectangle(llx, lly, urx, ury);
        return rectViewer;
    }

    private float[] transformCoord(float width, float height, float[] xy0, int rotationAngle) {
        double rotationRadian = Math.toRadians(rotationAngle);
        float[] xy = new float[2];
        if (90 == rotationAngle) {
            float h = width;
            float k = 0.0f;
            float x0 = xy0[0] - h;
            float y0 = xy0[1] - k;
            float xcos = x0 * (float)Math.cos(rotationRadian);
            float ysin = y0 * (float)Math.sin(rotationRadian);
            xy[0] = xcos + ysin;
            float ycos = y0 * (float)Math.cos(rotationRadian);
            float xsin = (float)((double)x0 * Math.sin(rotationRadian));
            xy[1] = ycos - xsin;
        } else if (180 == rotationAngle) {
            float xcos = xy0[0] * (float)Math.cos(rotationRadian);
            float ysin = xy0[1] * (float)Math.sin(rotationRadian);
            xy[0] = xcos + ysin;
            float ycos = xy0[1] * (float)Math.cos(rotationRadian);
            float xsin = xy0[0] * (float)Math.sin(rotationRadian);
            xy[1] = ycos - xsin;
            float h = -width;
            float k = 0.0f;
            xy[0] = xy[0] - h;
            xy[1] = xy[1] - k;
            h = 0.0f;
            k = -height;
            xy[0] = xy[0] - h;
            xy[1] = xy[1] - k;
        } else if (270 == rotationAngle) {
            // empty if block
        }
        return xy;
    }

    public byte[] createReservedPdfSeal(String tsaURL, String tsaUserName, String tsaPassword, int certificationLevel, ReservedPdfPKCS7 reservedPdfPKCS7) throws DocumentException, IOException, GeneralSecurityException {
        this.logger.info("begin createReservedPdfSeal...");
        if (!this.canMakeSignature(this.prePdfReader.getPdfReader())) {
            this.logger.error("a signature has been existed on the pdf, do not allowed to make another signature!");
            throw new GeneralSecurityException("Only approval signature allowed to make signature again!");
        }
        TSAClientBouncyCastle tsaClient = null;
        if (tsaURL != null && !tsaURL.equals("")) {
            PrePdfSealExtra.TSASettings tsaSettings = this.prePdfSealExtra.getTSASettings();
            if (tsaSettings != null) {
                int connectTimeout = tsaSettings.getConnectTimeout();
                int readTimeout = tsaSettings.getReadTimeout();
                boolean catchException = tsaSettings.switchover;
                tsaClient = new TSAClientBouncyCastle(tsaURL, tsaUserName, tsaPassword, connectTimeout, readTimeout, catchException);
            } else {
                tsaClient = new TSAClientBouncyCastle(tsaURL, tsaUserName, tsaPassword);
            }
        }
        this.logger.info("end createReservedPdfSeal...");
        return this.createReservedPdfSealByLocation(this.locationInfo, tsaClient, certificationLevel, reservedPdfPKCS7);
    }

    public byte[] createReservedPdfSeal(String tsaURL, String tsaUserName, String tsaPassword, int tsaEstimatedTokenSize, String tsaDigestAlgorithm, int certificationLevel, ReservedPdfPKCS7 reservedPdfPKCS7) throws DocumentException, IOException, GeneralSecurityException {
        this.logger.info("begin createReservedPdfSeal...");
        if (!this.canMakeSignature(this.prePdfReader.getPdfReader())) {
            this.logger.error("a signature has been existed on the pdf, do not allowed to make another signature!");
            throw new GeneralSecurityException("Only approval signature allowed to make signature again!");
        }
        TSAClientBouncyCastle tsaClient = null;
        if (tsaURL != null && !tsaURL.equals("")) {
            PrePdfSealExtra.TSASettings tsaSettings = this.prePdfSealExtra.getTSASettings();
            if (tsaSettings != null) {
                int connectTimeout = tsaSettings.getConnectTimeout();
                int readTimeout = tsaSettings.getReadTimeout();
                boolean catchException = tsaSettings.switchover;
                tsaClient = new TSAClientBouncyCastle(tsaURL, tsaUserName, tsaPassword, tsaEstimatedTokenSize, tsaDigestAlgorithm, connectTimeout, readTimeout, catchException);
            } else {
                tsaClient = new TSAClientBouncyCastle(tsaURL, tsaUserName, tsaPassword, tsaEstimatedTokenSize, tsaDigestAlgorithm);
            }
        }
        this.logger.info("end createReservedPdfSeal...");
        return this.createReservedPdfSealByLocation(this.locationInfo, tsaClient, certificationLevel, reservedPdfPKCS7);
    }

    public byte[] createReservedPdfSeal(int certificationLevel, ReservedPdfPKCS7 reservedPdfPKCS7) throws DocumentException, IOException, GeneralSecurityException {
        if (!this.canMakeSignature(this.prePdfReader.getPdfReader())) {
            throw new GeneralSecurityException("Only approval signature allowed to make signature again!");
        }
        return this.createReservedPdfSealByLocation(this.locationInfo, null, certificationLevel, reservedPdfPKCS7);
    }

    private byte[] createReservedPdfSealByLocation(LocationInfo locationInfo, TSAClient tsaClient, int certificationLevel, ReservedPdfPKCS7 reservedPdfPKCS7) throws DocumentException, IOException, GeneralSecurityException {
        this.logger.info("begin createReservedPdfSealByLocation...");
        byte[] sealedPdfBytes = null;
        ByteBuffer outByteBuffer = null;
        FileOutputStream fos = null;
        ByteBuffer workByteBuffer = null;
        PrePdfSealExtra.TempFileBufferStrategy tempFileBufferStrategy = null;
        PrePdfSealExtra.BufferStrategy bufferStrategy = this.prePdfSealExtra.getBufferStrategy();
        PrePdfSealExtra.SignatureOpacity signatureOpacity = this.prePdfSealExtra.getSignatureOpacity();
        if (null == bufferStrategy) {
            outByteBuffer = new ByteBuffer(4096);
            workByteBuffer = new ByteBuffer(4096);
        } else if (bufferStrategy instanceof PrePdfSealExtra.TempFileBufferStrategy) {
            tempFileBufferStrategy = (PrePdfSealExtra.TempFileBufferStrategy)bufferStrategy;
            fos = new FileOutputStream(tempFileBufferStrategy.tempFile);
        }
        PdfReader workPdfReader = new PdfReader(this.prePdfReader.getPdfReader());
        byte[] password = workPdfReader.getOwnerPassword();
        int cntSeal = locationInfo.getCntSeal();
        if (cntSeal > 1) {
            throw new GeneralSecurityException("number of seal must be 1");
        }
        for (int i = 0; i < cntSeal; ++i) {
            PdfStamper stamper = null;
            PdfSignatureAppearance appearance = null;
            if (null == bufferStrategy) {
                stamper = PdfStamper.createSignature(workPdfReader, (OutputStream)outByteBuffer, '\u0000', workByteBuffer, true);
            } else if (bufferStrategy instanceof PrePdfSealExtra.TempFileBufferStrategy) {
                File tempFile = tempFileBufferStrategy.tempFile;
                File stpTempFile = new File(tempFile.getName() + ".stamper");
                stamper = PdfStamper.createSignature(workPdfReader, (OutputStream)fos, '\u0000', stpTempFile, true);
            }
            appearance = stamper.getSignatureAppearance();
            Object image = null;
            SignatureLandscape signatureLandscape = locationInfo.getLocSignatureLandscapeInfoList().get(i);
            if (this.sealType == 1) {
                this.doBlankSignature(signatureOpacity, appearance, signatureLandscape);
            } else {
                this.visibleRectangle = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
                String userFieldName = this.prePdfSealExtra.getFieldName();
                if (null != userFieldName && !"".equals(userFieldName)) {
                    this.fieldName = userFieldName;
                }
                if (null != signatureOpacity) {
                    this.isVisible = signatureOpacity.getVisible();
                }
                if (this.isVisible) {
                    this.doVisibleSignature(signatureOpacity, i, appearance, signatureLandscape);
                } else {
                    this.doInvisibleSignature(appearance, signatureLandscape);
                }
            }
            String reason = this.prePdfSealExtra.getReason();
            String location = this.prePdfSealExtra.getLocation();
            appearance.setReason(reason);
            appearance.setLocation(location);
            appearance.setCertificationLevel(certificationLevel);
            boolean ifExternalContainer = this.prePdfSeal.IfExternalContainer();
            PrivateKey privateKey = this.prePdfSeal.getPrivateKey();
            Certificate[] chain = this.prePdfSeal.getCertificateChain();
            int deferredType = this.prePdfSeal.getDeferredType();
            if (!ifExternalContainer) {
                this.doInternalContainerReserved(tsaClient, reservedPdfPKCS7, appearance, privateKey, chain, deferredType);
            } else {
                this.doExternalContainerReserved(tsaClient, appearance);
            }
            if (null == bufferStrategy) {
                byte[] tempSealedPdfBytes = outByteBuffer.toByteArray();
                if (cntSeal - i == 1) {
                    sealedPdfBytes = tempSealedPdfBytes;
                    break;
                }
                outByteBuffer.reset();
                workByteBuffer.reset();
                workPdfReader = new PdfReader(tempSealedPdfBytes, password);
                continue;
            }
            if (!(bufferStrategy instanceof PrePdfSealExtra.TempFileBufferStrategy)) continue;
            File tempFile = tempFileBufferStrategy.tempFile;
            byte[] tempSealedPdfBytes = FileUtils.readFileToByteArray((File)tempFile);
            if (cntSeal - i == 1) {
                sealedPdfBytes = tempSealedPdfBytes;
                boolean isTempFileTemporal = tempFileBufferStrategy.isTempFileTemporal;
                if (!isTempFileTemporal || tempFile == null) break;
                tempFile.delete();
                break;
            }
            fos = new FileOutputStream(tempFile);
            workPdfReader = new PdfReader(tempSealedPdfBytes, password);
        }
        this.logger.info("end createReservedPdfSealByLocation...");
        return sealedPdfBytes;
    }

    private void doExternalContainerReserved(TSAClient tsaClient, PdfSignatureAppearance appearance) throws GeneralSecurityException, IOException, DocumentException {
        ExternalDigest externalDigest = this.prePdfSeal.getExternalDigest();
        ExternalSignature externalSignature = this.prePdfSeal.getExternalSignature();
        PdfName filter = this.prePdfSeal.getFilter();
        PdfName subFilter = this.prePdfSeal.getSubFilter();
        DoneExternalSessionSignatureContainer externalSessionSignatureContainer = filter == null && subFilter == null ? new DoneExternalSessionSignatureContainer(null, null, externalDigest, externalSignature) : new DoneExternalSessionSignatureContainer(filter, subFilter, externalDigest, externalSignature);
        externalSessionSignatureContainer.setTSAClient(tsaClient);
        externalSessionSignatureContainer.setCryptoStandard(MakeSignature.CryptoStandard.CMS);
        int estimatedSize = this.prePdfSealExtra.getEstimatedSize();
        if (0 == estimatedSize) {
            estimatedSize = externalSessionSignatureContainer.getExternalSignatureSize();
        }
        MakeSignature.signExternalContainer(appearance, externalSessionSignatureContainer, estimatedSize);
    }

    private void doInternalContainerReserved(TSAClient tsaClient, ReservedPdfPKCS7 reservedPdfPKCS7, PdfSignatureAppearance appearance, PrivateKey privateKey, Certificate[] chain, int deferredType) throws IOException, DocumentException, GeneralSecurityException {
        int sigVer;
        BouncyCastleDigest externalDigest = new BouncyCastleDigest();
        ExternalBlankPrivateSignature externalSignature = new ExternalBlankPrivateSignature(privateKey, null, this.prePdfSeal.getEncryptionAlgorithm(), this.prePdfSeal.getHashAlgorithm(), null);
        boolean docBase64Encoding = this.prePdfSealExtra.getDocHashBase64Encoding();
        reservedPdfPKCS7.type = deferredType;
        MakeSignature.Option option = new MakeSignature.Option();
        option.docHashBase64Encoding = docBase64Encoding;
        String encryptionAlgorithm = externalSignature.getEncryptionAlgorithm();
        if ("SM2".equals(encryptionAlgorithm)) {
            sigVer = this.prePdfSealExtra.getSignatureVersion();
            if (1 == sigVer) {
                appearance.setJavaScript(this.prePdfSealExtra.getJavaScript());
            }
            appearance.setSignatureVersion(sigVer);
        } else if ("RSA".equals(encryptionAlgorithm)) {
            sigVer = this.prePdfSealExtra.getSignatureVersion();
            if (2 == sigVer) {
                appearance.setJavaScript(this.prePdfSealExtra.getJavaScript());
            }
            appearance.setSignatureVersion(sigVer);
        }
        int estimatedSize = this.prePdfSealExtra.getEstimatedSize();
        MakeSignature.signReserved(appearance, externalDigest, externalSignature, chain, null, null, tsaClient, estimatedSize, MakeSignature.CryptoStandard.CMS, reservedPdfPKCS7, option);
    }

    public byte[] mergeReservedPdfSeal(PdfReader reader, ReservedPdfPKCS7 reservedPdfPKCS7) throws DocumentException, IOException, GeneralSecurityException {
        this.logger.info("begin mergeReservedPdfSeal...");
        ByteBuffer byteBuffer = new ByteBuffer(4096);
        ExternalBlankPrivateSignature externalSignature = new ExternalBlankPrivateSignature(null, null, reservedPdfPKCS7.encryptionAlgorithm, reservedPdfPKCS7.hashAlgorithm, null);
        BouncyCastleDigest externalDigest = new BouncyCastleDigest();
        int type = reservedPdfPKCS7.type;
        String encryptionAlgorithm = externalSignature.getEncryptionAlgorithm();
        ExternalReservedSignatureContainer externalSignatureContainer = null;
        if ("RSA".equals(encryptionAlgorithm)) {
            externalSignatureContainer = type != 1 ? new ExternalReservedSignatureContainer(PdfName.ADOBE_PPKLITE, reservedPdfPKCS7.cryptostandard == 1 ? PdfName.ETSI_CADES_DETACHED : PdfName.ADBE_PKCS7_DETACHED, externalDigest, externalSignature, reservedPdfPKCS7) : new ExternalReservedSignatureContainer(PdfName.CFCA_TrustSignPDF, PdfName.RSA_BASE64_SHA1, externalDigest, externalSignature, reservedPdfPKCS7);
        } else if ("SM2".equals(encryptionAlgorithm)) {
            externalSignatureContainer = new ExternalReservedSignatureContainer(PdfName.CFCA_TrustSignPDF, PdfName.CFCA_SM2_PKCS7_DETACHED, externalDigest, externalSignature, reservedPdfPKCS7);
        }
        MakeSignature.signDeferred(reader, reservedPdfPKCS7.fieldName, (OutputStream)byteBuffer, externalSignatureContainer);
        byte[] resultBytes = byteBuffer.toByteArray();
        byteBuffer.close();
        this.logger.info("end mergeReservedPdfSeal...");
        return resultBytes;
    }

    public byte[] mergeReservedPdfSeal(PdfReader reader, String fieldName, byte[] signedContent) throws DocumentException, IOException {
        this.logger.info("begin mergeReservedPdfSeal...");
        ByteBuffer byteBuffer = new ByteBuffer();
        MakeSignature.signDeferred(reader, fieldName, (OutputStream)byteBuffer, signedContent);
        byte[] resultBytes = byteBuffer.toByteArray();
        byteBuffer.close();
        this.logger.info("end mergeReservedPdfSeal...");
        return resultBytes;
    }

    public void updateLocationInfoByCoordinate(int page, int llx, int lly, int urx, int ury) {
        this.sealType = 0;
        SignatureLandscape landscape = new SignatureLandscape(new Integer(page), new Rectangle(llx, lly, urx, ury), 0.0f, 0.0f, null);
        this.locationInfo = new LocationInfo();
        this.locationInfo.addSignature(landscape);
    }

    public void updateLocationInfoByCoordinate(int page, int llx, int lly) {
        this.logger.info("begin updateLocationInfoByCoordinate...");
        this.sealType = 0;
        SignatureLandscape landscape = new SignatureLandscape(new Integer(page), new Rectangle(llx, lly, 0.0f, 0.0f), 0.0f, 0.0f, null);
        this.locationInfo = new LocationInfo();
        this.locationInfo.addSignature(landscape);
        this.logger.info("end updateLocationInfoByCoordinate...");
    }

    public void updateLocationInfoByCrossPage(int crossPageStyle, int fromPage, int toPage, float startX, float startY) throws DocumentException, IOException {
        this.updateLocationInfoByCrossPage(crossPageStyle, fromPage, toPage, startX, startY, 0);
    }

    public void updateLocationInfoByCrossPage(int crossPageStyle, int fromPage, int toPage, float startX, float startY, int pageRangeOption) throws DocumentException, IOException {
        this.logger.info("begin updateLocationInfoByCrossPage...");
        this.sealType = 3;
        CrossPageStrategy crossPageStrategy = new CrossPageStrategy();
        crossPageStrategy.setPageRangeOption(pageRangeOption);
        PrePdfSealExtra.ImageAppearance imageAppearance = this.prePdfSealExtra.getImageAppearance();
        this.locationInfo = imageAppearance != null ? crossPageStrategy.prepareImages(this.prePdfSealExtra, this.prePdfReader, crossPageStyle, fromPage, toPage, startX, startY) : crossPageStrategy.prepareImages(this.prePdfSeal, this.prePdfReader, crossPageStyle, fromPage, toPage, startX, startY);
        this.logger.info("end updateLocationInfoByCrossPage...");
    }

    public void updateLocationInfoByBlankSignature() throws DocumentException {
        this.logger.info("begin updateLocationInfoByBlankSignature...");
        this.sealType = 1;
        AcroFields fields = this.prePdfReader.getPdfReader().getAcroFields();
        ArrayList<String> signatureNames = fields.getBlankSignatureNames();
        if (signatureNames.size() == 0) {
            DocumentException e = new DocumentException("No blank signature found in the pdf file data!");
            this.logger.error(e.getLocalizedMessage());
            throw e;
        }
        this.locationInfo = new LocationInfo();
        for (String sigName : signatureNames) {
            AcroFields.Item item = fields.getFieldItem(sigName);
            PdfDictionary merged = item.getMerged(0);
            PdfArray array = merged.getAsArray(PdfName.RECT);
            Rectangle rectDocument = new Rectangle(array.getAsNumber(0).floatValue(), array.getAsNumber(1).floatValue(), array.getAsNumber(2).floatValue(), array.getAsNumber(3).floatValue());
            SignatureLandscape signatureLandscape = new SignatureLandscape(null, rectDocument, 0.0f, 0.0f, sigName);
            this.locationInfo.addSignature(signatureLandscape);
        }
        this.logger.info("end updateLocationInfoByBlankSignature...");
    }

    public void updateLocationInfoByBlankSignature(String userFieldName) throws DocumentException {
        this.updateLocationInfoByBlankSignature(userFieldName, false);
    }

    public void updateLocationInfoByBlankSignature(String userFieldName, boolean completeMatch) throws DocumentException {
        this.logger.info("begin updateLocationInfoByBlankSignature...");
        this.sealType = 1;
        AcroFields fields = this.prePdfReader.getPdfReader().getAcroFields();
        ArrayList<String> signatureNames = fields.getBlankSignatureNames();
        if (signatureNames.size() == 0) {
            DocumentException e = new DocumentException("No blank signature found in the pdf file data!");
            this.logger.error(e.getMessage());
            throw new DocumentException("No blank signature found in the pdf file data!");
        }
        this.locationInfo = new LocationInfo();
        boolean match = false;
        for (String sigName : signatureNames) {
            match = completeMatch ? sigName.equals(userFieldName) : sigName.contains(userFieldName);
            if (!match) continue;
            SignatureLandscape signatureLandscape = new SignatureLandscape(null, null, 0.0f, 0.0f, sigName);
            this.locationInfo.addSignature(signatureLandscape);
        }
        if (this.locationInfo.getCntSeal() == 0) {
            throw new DocumentException("No specified blank signature found in the pdf file data!");
        }
        this.logger.info("end updateLocationInfoByBlankSignature...");
    }

    public void updateLocationInfoByKeyword(String keyword) throws DocumentException, IOException {
        this.logger.info("begin updateLocationInfoByKeyword...");
        this.sealType = 2;
        if (this.keywordisLocatedAgain || null != keyword && !keyword.equals(this.lastKeyword)) {
            this.lastKeyword = keyword;
            PdfKeywordLocationImpl keywordLocationImpl = new PdfKeywordLocationImpl(this.prePdfReader.getPdfReader(), keyword);
            this.locationInfo = keywordLocationImpl.getKeywordLocation();
            if (this.locationInfo.getCntSeal() == 0) {
                throw new DocumentException("keyword: " + this.locationInfo.getKeyword() + "  not found!");
            }
            int cnt = this.locationInfo.getCntSeal();
            PdfReader reader = this.prePdfReader.getPdfReader();
            for (int i = 0; i < cnt; ++i) {
                Rectangle rectViewer;
                SignatureLandscape signatureLandscape = this.locationInfo.getLocSignatureLandscapeInfoList().get(i);
                Rectangle rectDocument = signatureLandscape.rectDocument;
                int page = signatureLandscape.page;
                signatureLandscape.rectViewer = rectViewer = this.transformRectangle(reader, page, rectDocument);
            }
            this.keywordisLocatedAgain = false;
        }
        this.logger.info("end updateLocationInfoByKeyword...");
    }

    public void updateLocationInfoByKeyword(String keyword, int pageNo) throws DocumentException, IOException {
        this.logger.info("begin updateLocationInfoByKeyword...");
        this.sealType = 2;
        if (this.keywordisLocatedAgain || null != keyword && !keyword.equals(this.lastKeyword)) {
            this.lastKeyword = keyword;
            PdfKeywordLocationImpl keywordLocationImpl = new PdfKeywordLocationImpl(this.prePdfReader.getPdfReader(), keyword, pageNo);
            this.locationInfo = keywordLocationImpl.getKeywordLocation();
            if (this.locationInfo.getCntSeal() == 0) {
                throw new DocumentException("keyword: " + this.locationInfo.getKeyword() + "  not found!");
            }
            int cnt = this.locationInfo.getCntSeal();
            PdfReader reader = this.prePdfReader.getPdfReader();
            for (int i = 0; i < cnt; ++i) {
                Rectangle rectViewer;
                SignatureLandscape signatureLandscape = this.locationInfo.getLocSignatureLandscapeInfoList().get(i);
                Rectangle rectDocument = signatureLandscape.rectDocument;
                int page = signatureLandscape.page;
                signatureLandscape.rectViewer = rectViewer = this.transformRectangle(reader, page, rectDocument);
            }
        }
        this.logger.info("end updateLocationInfoByKeyword...");
    }

    public void offsetCoordLocationInfo(float offsetX, float offsetY) throws DocumentException {
        if (this.sealType == 1) {
            this.logger.error("Offset operation not allowed on blank signature!");
            throw new DocumentException("Offset operation not allowed on blank signature!");
        }
        ArrayList<SignatureLandscape> landscapeList = this.locationInfo.getLocSignatureLandscapeInfoList();
        int size = landscapeList.size();
        for (int i = 0; i < size; ++i) {
            SignatureLandscape landscape = landscapeList.get(i);
            float llx = landscape.rectViewer.getLeft();
            float lly = landscape.rectViewer.getBottom();
            float urx = landscape.rectViewer.getRight();
            float ury = landscape.rectViewer.getTop();
            landscape.rectViewer = new Rectangle(llx += offsetX, lly += offsetY, urx += offsetX, ury += offsetY);
        }
    }

    public void offsetCharLocationInfo(int offsetChar, int offsetKeywordStyle) throws DocumentException {
        if (2 != this.sealType) {
            this.logger.error("Only support seal type KEYWORD location!");
            throw new DocumentException("Only support seal type KEYWORD location!");
        }
        ArrayList<SignatureLandscape> landscapeList = this.locationInfo.getLocSignatureLandscapeInfoList();
        int size = landscapeList.size();
        for (int j = 0; j < size; ++j) {
            SignatureLandscape landscape = landscapeList.get(j);
            float charTextWidth = landscape.charTextWidth;
            float llx = landscape.rectViewer.getLeft();
            float lly = landscape.rectViewer.getBottom();
            float urx = landscape.rectViewer.getRight();
            float ury = landscape.rectViewer.getTop();
            float offsetCharLocation = charTextWidth * (float)offsetChar;
            if (1 == offsetKeywordStyle) {
                landscape.rectViewer = new Rectangle(llx += offsetCharLocation, lly, urx += offsetCharLocation, ury);
                continue;
            }
            if (2 == offsetKeywordStyle) {
                landscape.rectViewer = new Rectangle(llx, lly += offsetCharLocation, urx, ury += offsetCharLocation);
                continue;
            }
            throw new DocumentException("Only support horizontal or vertical!");
        }
    }

    public void offsetCoordAlignedLocationInfo(float offset, int offsetKeywordStyle) throws DocumentException {
        float signatureRectHeight;
        float signatureRectWidth;
        if (2 != this.sealType) {
            throw new DocumentException("Only support seal type KEYWORD location!");
        }
        if (1 == offsetKeywordStyle || 2 == offsetKeywordStyle) {
            throw new DocumentException("Not allowed to horizontal and vertical offset!");
        }
        ArrayList<SignatureLandscape> landscapeList = null;
        Image image = this.prePdfSeal.getImage(0);
        if (null != image) {
            float scaledImageWidth;
            int dpiX = image.getDpiX();
            dpiX = dpiX == 0 ? (dpiX = 72) : dpiX;
            float imageScale = this.prePdfSeal.getImageScale();
            float imageHeight = image.getHeight();
            float poundImageHeight = imageHeight / (float)dpiX * 72.0f;
            float imageWidth = image.getWidth();
            float poundImageWidth = imageWidth / (float)dpiX * 72.0f;
            float scaledImageHeight = imageScale * poundImageHeight;
            signatureRectWidth = scaledImageWidth = imageScale * poundImageWidth;
            signatureRectHeight = scaledImageHeight;
        } else {
            Rectangle visibleRectangle = this.prePdfSealExtra.getLayer2Appearance().getVisibleSignature();
            signatureRectWidth = visibleRectangle.getWidth();
            signatureRectHeight = visibleRectangle.getHeight();
        }
        landscapeList = this.locationInfo.getLocSignatureLandscapeInfoList();
        int size = landscapeList.size();
        for (int j = 0; j < size; ++j) {
            float viewerllx = 0.0f;
            float viewerlly = 0.0f;
            float viewerurx = 0.0f;
            float viewerury = 0.0f;
            SignatureLandscape landscape = landscapeList.get(j);
            float llx = landscape.rectViewer.getLeft();
            float lly = landscape.rectViewer.getBottom();
            float urx = landscape.rectViewer.getRight();
            float ury = landscape.rectViewer.getTop();
            if ((4 & offsetKeywordStyle) == 4) {
                viewerllx = llx;
                viewerlly = ury;
                viewerurx = llx + signatureRectWidth;
                viewerury = ury + signatureRectHeight;
                viewerlly += offset;
                viewerury += offset;
            } else if ((8 & offsetKeywordStyle) == 8) {
                viewerllx = llx;
                viewerlly = lly - signatureRectHeight;
                viewerurx = llx + signatureRectWidth;
                viewerury = lly;
                viewerlly += offset;
                viewerury += offset;
            } else if ((0x10 & offsetKeywordStyle) == 16) {
                viewerllx = llx - signatureRectWidth;
                viewerlly = lly + signatureRectHeight;
                viewerurx = llx;
                viewerury = lly;
                viewerllx += offset;
                viewerurx += offset;
            } else if ((0x20 & offsetKeywordStyle) == 32) {
                viewerllx = urx;
                viewerlly = lly;
                viewerurx = urx + signatureRectWidth;
                viewerury = lly + signatureRectHeight;
                viewerllx += offset;
                viewerurx += offset;
            }
            landscape.rectViewer = new Rectangle(viewerllx, viewerlly, viewerurx, viewerury);
        }
    }

    public void offsetCoordLocationInfo(int offsetKeywordStyle) throws DocumentException {
        this.offsetCoordAlignedLocationInfo(0.0f, offsetKeywordStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyPKCS7(byte[] sealedPdfData) throws PKIException, IOException, GeneralSecurityException {
        boolean isAllPKCS7OK = true;
        boolean isAPKCS7OK = true;
        PdfReader pdfReader = null;
        try {
            pdfReader = new PdfReader(sealedPdfData);
            AcroFields af = pdfReader.getAcroFields();
            ArrayList<String> names = af.getSignatureNames();
            if (names == null || names.isEmpty()) {
                boolean bl = !isAllPKCS7OK;
                return bl;
            }
            boolean i = true;
            this.sigNameCertMap = new HashMap();
            this.sigNamePKCS7Map = new HashMap();
            this.sigNames = new ArrayList();
            for (String name : names) {
                PdfPKCS7 pkcs7 = af.verifySignature(name);
                X509Certificate x509Certificate = pkcs7.getSigningCertificate();
                X509Cert x509Cert = new X509Cert(x509Certificate.getEncoded());
                this.sigNames.add(name);
                this.sigNameCertMap.put(name, x509Cert);
                this.sigNamePKCS7Map.put(name, pkcs7);
                isAPKCS7OK = pkcs7.verify();
                if (isAllPKCS7OK = isAllPKCS7OK && isAPKCS7OK) continue;
                break;
            }
        }
        finally {
            if (null != pdfReader) {
                pdfReader.close();
            }
        }
        return isAllPKCS7OK;
    }

    public static void adjustAlignment(Rectangle rectViewerBefore, Rectangle rectViewerAfter, int alignmentSettings, float appearanceWidth, float appearanceHeight) throws DocumentException {
        float llxKeyword = rectViewerBefore.getLeft();
        float llyKeyword = rectViewerBefore.getBottom();
        float urxKeyword = rectViewerBefore.getRight();
        float uryKeyword = rectViewerBefore.getTop();
        float llxAppearance = 100.0f;
        float llyAppearance = 100.0f;
        float urxAppearance = 200.0f;
        float uryAppearance = 200.0f;
        if (256 == (alignmentSettings & 0x100) && 16 == (alignmentSettings & 0x10) && 64 == (alignmentSettings & 0x40)) {
            llxAppearance = llxKeyword - appearanceWidth;
            urxAppearance = llxKeyword;
            llyAppearance = llyKeyword - (appearanceHeight - (uryKeyword - llyKeyword)) / 2.0f;
            uryAppearance = llyAppearance + appearanceHeight;
        } else if (256 == (alignmentSettings & 0x100) && 16 == (alignmentSettings & 0x10)) {
            llxAppearance = llxKeyword - appearanceWidth;
            urxAppearance = llxKeyword;
            llyAppearance = llyKeyword;
            uryAppearance = llyKeyword + appearanceHeight;
        } else if (256 == (alignmentSettings & 0x100) && 32 == (alignmentSettings & 0x20) && 64 == (alignmentSettings & 0x40)) {
            llxAppearance = urxKeyword;
            urxAppearance = urxKeyword + appearanceWidth;
            llyAppearance = llyKeyword - (appearanceHeight - (uryKeyword - llyKeyword)) / 2.0f;
            uryAppearance = llyAppearance + appearanceHeight;
        } else if (256 == (alignmentSettings & 0x100) && 32 == (alignmentSettings & 0x20)) {
            llxAppearance = urxKeyword;
            urxAppearance = llxAppearance + appearanceWidth;
            llyAppearance = llyKeyword;
            uryAppearance = llyAppearance + appearanceHeight;
        } else if (256 == (alignmentSettings & 0x100) && 4 == (alignmentSettings & 4) && 64 == (alignmentSettings & 0x40)) {
            llxAppearance = llxKeyword - (appearanceWidth - (urxKeyword - llxKeyword)) / 2.0f;
            urxAppearance = llxAppearance + appearanceWidth;
            llyAppearance = uryKeyword;
            uryAppearance = llyAppearance + appearanceHeight;
        } else if (256 == (alignmentSettings & 0x100) && 4 == (alignmentSettings & 4)) {
            llxAppearance = llxKeyword;
            urxAppearance = llxAppearance + appearanceWidth;
            llyAppearance = uryKeyword;
            uryAppearance = llyAppearance + appearanceHeight;
        } else if (256 == (alignmentSettings & 0x100) && 8 == (alignmentSettings & 8) && 64 == (alignmentSettings & 0x40)) {
            llxAppearance = llxKeyword - (appearanceWidth - (urxKeyword - llxKeyword)) / 2.0f;
            urxAppearance = llxAppearance + appearanceWidth;
            llyAppearance = llyKeyword - appearanceHeight;
            uryAppearance = llyKeyword;
        } else if (256 == (alignmentSettings & 0x100) && 8 == (alignmentSettings & 8)) {
            llxAppearance = llxKeyword;
            urxAppearance = llxKeyword + appearanceWidth;
            llyAppearance = llyKeyword - appearanceHeight;
            uryAppearance = llyKeyword;
        } else if (128 == (alignmentSettings & 0x80) && 2 == (alignmentSettings & 2) && 1 == (alignmentSettings & 1) && 64 == (alignmentSettings & 0x40)) {
            llxAppearance = llxKeyword - (appearanceWidth - (urxKeyword - llxKeyword)) / 2.0f;
            urxAppearance = llxAppearance + appearanceWidth;
            llyAppearance = llyKeyword - (appearanceHeight - (uryKeyword - llyKeyword)) / 2.0f;
            uryAppearance = llyAppearance + appearanceHeight;
        } else if (128 == (alignmentSettings & 0x80) && 16 == (alignmentSettings & 0x10) && 64 == (alignmentSettings & 0x40)) {
            llxAppearance = llxKeyword;
            urxAppearance = llxKeyword + appearanceWidth;
            llyAppearance = llyKeyword - (appearanceHeight - (uryKeyword - llyKeyword)) / 2.0f;
            uryAppearance = llyAppearance + appearanceHeight;
        } else if (128 == (alignmentSettings & 0x80) && 16 == (alignmentSettings & 0x10)) {
            llxAppearance = llxKeyword;
            llyAppearance = llyKeyword;
            urxAppearance = llxKeyword + appearanceWidth;
            uryAppearance = llyKeyword + appearanceHeight;
        } else if (128 == (alignmentSettings & 0x80) && 32 == (alignmentSettings & 0x20) && 64 == (alignmentSettings & 0x40)) {
            llxAppearance = urxKeyword - appearanceWidth;
            urxAppearance = urxKeyword;
            llyAppearance = llyKeyword - (appearanceHeight - (uryKeyword - llyKeyword)) / 2.0f;
            uryAppearance = llyAppearance + appearanceHeight;
        } else if (128 == (alignmentSettings & 0x80) && 32 == (alignmentSettings & 0x20)) {
            llxAppearance = urxKeyword - appearanceWidth;
            urxAppearance = urxKeyword;
            llyAppearance = llyKeyword;
            uryAppearance = llyAppearance + appearanceHeight;
        } else if (128 == (alignmentSettings & 0x80) && 4 == (alignmentSettings & 4) && 64 == (alignmentSettings & 0x40)) {
            llxAppearance = llxKeyword - (appearanceWidth - (urxKeyword - llxKeyword)) / 2.0f;
            urxAppearance = llxAppearance + appearanceWidth;
            llyAppearance = uryKeyword - appearanceHeight;
            uryAppearance = uryKeyword;
        } else if (128 == (alignmentSettings & 0x80) && 4 == (alignmentSettings & 4)) {
            llxAppearance = llxKeyword;
            urxAppearance = llxKeyword + appearanceWidth;
            llyAppearance = uryKeyword - appearanceHeight;
            uryAppearance = uryKeyword;
        } else if (128 == (alignmentSettings & 0x80) && 8 == (alignmentSettings & 8) && 64 == (alignmentSettings & 0x40)) {
            llxAppearance = llxKeyword;
            urxAppearance = llxKeyword + appearanceWidth;
            llyAppearance = llyKeyword;
            uryAppearance = llyAppearance + appearanceHeight;
        } else if (128 == (alignmentSettings & 0x80) && 8 == (alignmentSettings & 8)) {
            llxAppearance = llxKeyword - (appearanceWidth - (urxKeyword - llxKeyword)) / 2.0f;
            urxAppearance = llxAppearance + appearanceWidth;
            llyAppearance = llyKeyword;
            uryAppearance = llyAppearance + appearanceHeight;
        } else {
            throw new DocumentException("Unsupported alignment!");
        }
        rectViewerAfter.setLeft(llxAppearance);
        rectViewerAfter.setBottom(llyAppearance);
        rectViewerAfter.setRight(urxAppearance);
        rectViewerAfter.setTop(uryAppearance);
    }

    public static boolean removeLastPdfSeal(InputStream is, OutputStream os) throws DocumentException, IOException {
        if (is == null) {
            throw new IOException("Parameter is must not null!");
        }
        if (os == null) {
            throw new IOException("Parameter os must not null!");
        }
        PdfReader reader = new PdfReader(is);
        PdfSealRevoker revoker = new PdfSealRevoker(reader, os);
        return revoker.revoke();
    }

    public static boolean verifyTSAClient(TSAClient tsaClient) {
        boolean verify = true;
        if (tsaClient == null) {
            verify = false;
        } else {
            byte[] tsImprint = "test".getBytes();
            try {
                tsImprint = tsaClient.getMessageDigest().digest("rui".getBytes());
                tsaClient.getTimeStampToken(tsImprint);
            }
            catch (Exception e) {
                verify = false;
            }
        }
        return verify;
    }

    public static byte[] testTSA(TSAClient tsaClient) throws IOException, TSPException, GeneralSecurityException {
        if (tsaClient == null) {
            return null;
        }
        byte[] tsImprint = "test".getBytes();
        tsImprint = tsaClient.getMessageDigest().digest("rui".getBytes());
        return tsaClient.getTimeStampToken(tsImprint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] flattenFields(PdfReader reader, String[] partialFlattening) throws DocumentException, IOException {
        ByteBuffer byteBuffer = new ByteBuffer();
        PdfStamper pdfStamper = new PdfStamper(reader, byteBuffer);
        try {
            pdfStamper.setFormFlattening(true);
            for (int i = 0; i < partialFlattening.length; ++i) {
                pdfStamper.partialFormFlattening(partialFlattening[i]);
            }
        }
        finally {
            pdfStamper.close();
        }
        return byteBuffer.toByteArray();
    }

    private static void updateColorCmds(ArrayList<PdfObject> updatedObjs) {
        int size = updatedObjs.size();
        PdfObject last1Objs = updatedObjs.get(size - 1);
        PdfObject last2Objs = updatedObjs.get(size - 2);
        if (!(last1Objs instanceof PdfNumber)) {
            return;
        }
        if (last1Objs instanceof PdfNumber && !(last2Objs instanceof PdfNumber)) {
            return;
        }
        PdfNumber bNumber = (PdfNumber)updatedObjs.remove(updatedObjs.size() - 1);
        PdfNumber gNumber = (PdfNumber)updatedObjs.remove(updatedObjs.size() - 1);
        PdfNumber rNumber = (PdfNumber)updatedObjs.remove(updatedObjs.size() - 1);
        if (rNumber.intValue() == 1 && gNumber.intValue() == 1 && bNumber.intValue() == 1) {
            updatedObjs.add(rNumber);
            updatedObjs.add(gNumber);
            updatedObjs.add(bNumber);
        } else {
            updatedObjs.add(new PdfNumber(0.45));
            updatedObjs.add(new PdfNumber(0.45));
            updatedObjs.add(new PdfNumber(0.45));
        }
    }

    private static void grayPageContents(PdfObject pdfObj, int grayStyle, IntHashtable tableUsedRef, PdfName prevName, PdfName prntName, PdfDictionary resources) throws IOException, InterruptedException {
        block8: {
            block7: {
                LinkedBlockingQueue<String> lbq = new LinkedBlockingQueue<String>();
                if (!(pdfObj instanceof PRStream)) break block7;
                PRStream stream = (PRStream)pdfObj;
                byte[] stmBytes = PdfReader.getStreamBytes(stream);
                RandomAccessFileOrArray rafa = new RandomAccessFileOrArray(stmBytes);
                PRTokeniser tokeniser = new PRTokeniser(rafa);
                PdfContentParser contentParser = new PdfContentParser(tokeniser);
                PdfObject obj = null;
                ArrayList<PdfObject> updatedObjs = new ArrayList<PdfObject>();
                List<String> colorCmds = Arrays.asList("rg", "RG", "scn", "SCN");
                while ((obj = contentParser.readPRObject()) != null) {
                    String objString = obj.toString();
                    if (colorCmds.contains(objString)) {
                        DonePdfSeal.updateColorCmds(updatedObjs);
                    }
                    if ("Do".equals(objString)) {
                        PdfName doName = (PdfName)updatedObjs.get(updatedObjs.size() - 1);
                        String doString = doName.toString();
                        lbq.put(doString);
                    }
                    updatedObjs.add(obj);
                }
                PdfObject[] arrObjs = updatedObjs.toArray(new PdfObject[0]);
                ByteBuffer baos = new ByteBuffer();
                for (int i = 0; i < arrObjs.length; ++i) {
                    PdfObject aObj = arrObjs[i];
                    aObj.toPdf(null, baos);
                    if (aObj instanceof PdfLiteral) {
                        baos.write(13);
                        continue;
                    }
                    baos.write(32);
                }
                stream.setData(baos.toByteArray());
                while (!lbq.isEmpty()) {
                    String xfn = (String)lbq.poll();
                    String tmpXfn = xfn.substring(1);
                    if (null == resources) continue;
                    PdfDictionary xobj = resources.getAsDict(PdfName.XOBJECT);
                    PRStream tmpStream = (PRStream)xobj.getAsStream(new PdfName(tmpXfn));
                    PdfDictionary tmpResources = tmpStream.getAsDict(PdfName.RESOURCES);
                    PdfName subTypeName = tmpStream.getAsName(PdfName.SUBTYPE);
                    if (PdfName.IMAGE.equals(subTypeName)) continue;
                    DonePdfSeal.grayPageContents(tmpStream, grayStyle, tableUsedRef, prevName, prntName, tmpResources);
                }
                break block8;
            }
            if (!(pdfObj instanceof PdfArray)) break block8;
            PdfArray pdfArray = (PdfArray)pdfObj;
            int size = pdfArray.size();
            for (int i = 0; i < size; ++i) {
                PRStream stream = (PRStream)pdfArray.getAsStream(i);
                DonePdfSeal.grayPageContents(stream, grayStyle, tableUsedRef, prevName, prntName, resources);
            }
        }
    }

    private static void grayPageResources(PdfDictionary xobject, int grayStyle, IntHashtable tableUsedRef, PdfName prevName, PdfName prntName) throws IOException {
        if (null != xobject) {
            Set<PdfName> xkey = xobject.getKeys();
            PdfName[] currNames = xkey.toArray(new PdfName[0]);
            for (int i = 0; i < currNames.length; ++i) {
                PdfName currName = currNames[i];
                PdfIndirectReference currIRef = xobject.getAsIndirectObject(currName);
                int usedNum = currIRef.getNumber();
                if (tableUsedRef.containsKey(usedNum)) continue;
                tableUsedRef.put(usedNum, 0);
                PRStream stream = (PRStream)PdfReader.getPdfObject(currIRef);
                PdfName subtype = stream.getAsName(PdfName.SUBTYPE);
                if (subtype.equals(PdfName.IMAGE)) {
                    int tmp;
                    int b;
                    int g;
                    int r;
                    int k;
                    int j;
                    byte[] rowBytes;
                    byte[] grayBytes;
                    PdfName csName0;
                    int tmp2;
                    int b2;
                    int g2;
                    int r2;
                    int k2;
                    byte[] tmpBytes;
                    int j2;
                    byte[] rowBytes2;
                    byte[] grayBytes2;
                    int rowLength;
                    int bpc;
                    int columns;
                    int colors;
                    PdfDictionary dpParam;
                    int height;
                    int width;
                    byte[] stmBytes;
                    PdfName csName;
                    if ((grayStyle & 4) == 4 && PdfName.N2.equals(prntName)) {
                        csName = stream.getAsName(PdfName.COLORSPACE);
                        if (!PdfName.DEVICEGRAY.equals(csName)) {
                            stmBytes = PdfReader.getStreamBytes(stream);
                            width = stream.getAsNumber(PdfName.WIDTH).intValue();
                            height = stream.getAsNumber(PdfName.HEIGHT).intValue();
                            dpParam = stream.getAsDict(PdfName.DECODEPARMS);
                            colors = 1;
                            columns = 1;
                            bpc = 1;
                            rowLength = 1;
                            if (dpParam != null) {
                                colors = dpParam.getAsNumber(PdfName.COLORS).intValue();
                                columns = dpParam.getAsNumber(PdfName.COLUMNS).intValue();
                                bpc = dpParam.getAsNumber(PdfName.BITSPERCOMPONENT).intValue();
                                rowLength = colors * columns * bpc / 8;
                                grayBytes2 = new byte[height * (1 + rowLength)];
                                rowBytes2 = new byte[1 + rowLength];
                                for (j2 = 0; j2 < height; ++j2) {
                                    rowBytes2[j2] = 0;
                                    tmpBytes = new byte[rowLength];
                                    System.arraycopy(stmBytes, j2 * rowLength, tmpBytes, 0, rowLength);
                                    for (k2 = 0; k2 < rowLength; k2 += 3) {
                                        r2 = tmpBytes[k2] & 0xFF;
                                        g2 = tmpBytes[k2 + 1] & 0xFF;
                                        b2 = tmpBytes[k2 + 2] & 0xFF;
                                        tmp2 = (r2 * 299 + g2 * 587 + b2 * 114 + 500) / 1000;
                                        byte by = (byte)tmp2;
                                        tmpBytes[k2 + 2] = by;
                                        tmpBytes[k2 + 1] = by;
                                        tmpBytes[k2] = by;
                                    }
                                    System.arraycopy(tmpBytes, 0, rowBytes2, 1, rowLength);
                                    System.arraycopy(rowBytes2, 0, grayBytes2, j2 * (1 + rowLength), 1 + rowLength);
                                }
                                stream.setData(grayBytes2);
                            } else {
                                bpc = stream.getAsNumber(PdfName.BITSPERCOMPONENT).intValue();
                                csName0 = stream.getAsName(PdfName.COLORSPACE);
                                if (null == csName0) {
                                    PdfIndirectReference tIRef;
                                    PRStream tStm;
                                    PdfName altName;
                                    PdfArray csArr = stream.getAsArray(PdfName.COLORSPACE);
                                    csName0 = csArr.getAsName(0);
                                    if (PdfName.CALRGB.equals(csName0)) {
                                        colors = 3;
                                    } else if (PdfName.ICCBASED.equals(csName0) && PdfName.DEVICERGB.equals(altName = (tStm = (PRStream)PdfReader.getPdfObjectRelease(tIRef = csArr.getAsIndirectObject(1))).getAsName(PdfName.ALTERNATE))) {
                                        colors = 3;
                                    }
                                } else if (PdfName.DEVICERGB.equals(csName0)) {
                                    colors = 3;
                                }
                                rowLength = colors * width * bpc / 8;
                                grayBytes = new byte[height * rowLength];
                                rowBytes = new byte[rowLength];
                                for (j = 0; j < height; ++j) {
                                    byte[] tmpBytes2 = new byte[rowLength];
                                    System.arraycopy(stmBytes, j * rowLength, tmpBytes2, 0, rowLength);
                                    for (k = 0; k < rowLength; k += 3) {
                                        r = tmpBytes2[k] & 0xFF;
                                        g = tmpBytes2[k + 1] & 0xFF;
                                        b = tmpBytes2[k + 2] & 0xFF;
                                        tmp = (r * 299 + g * 587 + b * 114 + 500) / 1000;
                                        byte by = (byte)tmp;
                                        tmpBytes2[k + 2] = by;
                                        tmpBytes2[k + 1] = by;
                                        tmpBytes2[k] = by;
                                    }
                                    System.arraycopy(tmpBytes2, 0, rowBytes, 0, rowLength);
                                    System.arraycopy(rowBytes, 0, grayBytes, j * rowLength, rowLength);
                                }
                                stream.setData(grayBytes);
                            }
                        }
                        prevName = currName;
                        continue;
                    }
                    if ((grayStyle & 2) != 2 || PdfName.N2.equals(prevName)) continue;
                    csName = stream.getAsName(PdfName.COLORSPACE);
                    if (!PdfName.DEVICEGRAY.equals(csName)) {
                        stmBytes = PdfReader.getStreamBytes(stream);
                        width = stream.getAsNumber(PdfName.WIDTH).intValue();
                        height = stream.getAsNumber(PdfName.HEIGHT).intValue();
                        dpParam = stream.getAsDict(PdfName.DECODEPARMS);
                        colors = 1;
                        columns = 1;
                        bpc = 1;
                        rowLength = 1;
                        if (dpParam != null) {
                            colors = dpParam.getAsNumber(PdfName.COLORS).intValue();
                            columns = dpParam.getAsNumber(PdfName.COLUMNS).intValue();
                            bpc = dpParam.getAsNumber(PdfName.BITSPERCOMPONENT).intValue();
                            rowLength = colors * columns * bpc / 8;
                            grayBytes2 = new byte[height * (1 + rowLength)];
                            rowBytes2 = new byte[1 + rowLength];
                            for (j2 = 0; j2 < height; ++j2) {
                                rowBytes2[j2] = 0;
                                tmpBytes = new byte[rowLength];
                                System.arraycopy(stmBytes, j2 * rowLength, tmpBytes, 0, rowLength);
                                for (k2 = 0; k2 < rowLength; k2 += 3) {
                                    r2 = tmpBytes[k2] & 0xFF;
                                    g2 = tmpBytes[k2 + 1] & 0xFF;
                                    b2 = tmpBytes[k2 + 2] & 0xFF;
                                    tmp2 = (r2 * 299 + g2 * 587 + b2 * 114 + 500) / 1000;
                                    byte by = (byte)tmp2;
                                    tmpBytes[k2 + 2] = by;
                                    tmpBytes[k2 + 1] = by;
                                    tmpBytes[k2] = by;
                                }
                                System.arraycopy(tmpBytes, 0, rowBytes2, 1, rowLength);
                                System.arraycopy(rowBytes2, 0, grayBytes2, j2 * (1 + rowLength), 1 + rowLength);
                            }
                            stream.setData(grayBytes2);
                        } else {
                            bpc = stream.getAsNumber(PdfName.BITSPERCOMPONENT).intValue();
                            csName0 = stream.getAsArray(PdfName.COLORSPACE).getAsName(0);
                            if (PdfName.CALRGB.equals(csName0)) {
                                colors = 3;
                            }
                            rowLength = colors * width * bpc / 8;
                            grayBytes = new byte[height * rowLength];
                            rowBytes = new byte[rowLength];
                            for (j = 0; j < height; ++j) {
                                byte[] tmpBytes3 = new byte[rowLength];
                                System.arraycopy(stmBytes, j * rowLength, tmpBytes3, 0, rowLength);
                                for (k = 0; k < rowLength; k += 3) {
                                    r = tmpBytes3[k] & 0xFF;
                                    g = tmpBytes3[k + 1] & 0xFF;
                                    b = tmpBytes3[k + 2] & 0xFF;
                                    tmp = (r * 299 + g * 587 + b * 114 + 500) / 1000;
                                    byte by = (byte)tmp;
                                    tmpBytes3[k + 2] = by;
                                    tmpBytes3[k + 1] = by;
                                    tmpBytes3[k] = by;
                                }
                                System.arraycopy(tmpBytes3, 0, rowBytes, 0, rowLength);
                                System.arraycopy(rowBytes, 0, grayBytes, j * rowLength, rowLength);
                            }
                            stream.setData(grayBytes);
                        }
                    }
                    prevName = currName;
                    continue;
                }
                if (!subtype.equals(PdfName.FORM)) continue;
                prevName = currName;
                prntName = currName;
                PdfDictionary resources0 = stream.getAsDict(PdfName.RESOURCES);
                if (null == resources0) continue;
                PdfDictionary xobject0 = resources0.getAsDict(PdfName.XOBJECT);
                DonePdfSeal.grayPageResources(xobject0, grayStyle, tableUsedRef, prevName, prntName);
            }
        }
    }

    public static byte[] grayPdf(PdfReader reader, int[] pages, int grayStyle) throws IOException, DocumentException, InterruptedException {
        int i;
        int numberOfPages;
        PdfDictionary resources;
        PdfDictionary pageN;
        int i2;
        int len;
        byte[] retBytes = null;
        ByteBuffer byteBuffer = new ByteBuffer();
        PdfStamper pdfStamper = new PdfStamper(reader, byteBuffer);
        IntHashtable tableUsedRef = new IntHashtable();
        PdfName prevName = null;
        PdfName prntName = null;
        if ((grayStyle & 2) == 2 || (grayStyle & 4) == 4) {
            PdfDictionary xobject;
            if (pages[0] != -1) {
                len = pages.length;
                for (i2 = 0; i2 < len; ++i2) {
                    pageN = reader.getPageN(pages[i2]);
                    resources = pageN.getAsDict(PdfName.RESOURCES);
                    if (resources == null) continue;
                    xobject = resources.getAsDict(PdfName.XOBJECT);
                    DonePdfSeal.grayPageResources(xobject, grayStyle, tableUsedRef, prevName, prntName);
                }
            }
            if (pages[0] == -1) {
                numberOfPages = reader.getNumberOfPages();
                for (i = 1; i <= numberOfPages; ++i) {
                    pageN = reader.getPageN(i);
                    resources = pageN.getAsDict(PdfName.RESOURCES);
                    if (resources == null) continue;
                    xobject = resources.getAsDict(PdfName.XOBJECT);
                    DonePdfSeal.grayPageResources(xobject, grayStyle, tableUsedRef, prevName, prntName);
                }
            }
        }
        if ((grayStyle & 1) == 1) {
            if (pages[0] != -1) {
                len = pages.length;
                for (i2 = 0; i2 < len; ++i2) {
                    pageN = reader.getPageN(pages[i2]);
                    resources = pageN.getAsDict(PdfName.RESOURCES);
                    DonePdfSeal.grayPageContents(pageN.getDirectObject(PdfName.CONTENTS), grayStyle, tableUsedRef, prevName, prntName, resources);
                }
            }
            if (pages[0] == -1) {
                numberOfPages = reader.getNumberOfPages();
                for (i = 1; i <= numberOfPages; ++i) {
                    pageN = reader.getPageN(i);
                    resources = pageN.getAsDict(PdfName.RESOURCES);
                    DonePdfSeal.grayPageContents(pageN.getDirectObject(PdfName.CONTENTS), grayStyle, tableUsedRef, prevName, prntName, resources);
                }
            }
        }
        pdfStamper.close();
        retBytes = byteBuffer.toByteArray();
        return retBytes;
    }

    public static byte[] createBlankSignature(PdfReader reader, int page, Rectangle rectangle, String fieldName) throws DocumentException, IOException {
        ByteBuffer baos = new ByteBuffer();
        PdfReader workPdfReader = new PdfReader(reader);
        PdfStamper stamper = PdfStamper.createSignature(workPdfReader, (OutputStream)baos, '\u0000', (File)null, true);
        PdfSignatureAppearance appearance = stamper.getSignatureAppearance();
        appearance.setRenderingMode(PdfSignatureAppearance.RenderingMode.DESCRIPTION);
        String tmpFieldName = fieldName + ":" + UUID.randomUUID().toString();
        appearance.setVisibleSignature(rectangle, page, tmpFieldName);
        appearance.setCertificationLevel(0);
        MakeSignature.CryptoStandard sigtype = MakeSignature.CryptoStandard.CMS;
        PdfSignature dic = new PdfSignature(PdfName.ADOBE_PPKLITE, sigtype == MakeSignature.CryptoStandard.CADES ? PdfName.ETSI_CADES_DETACHED : PdfName.ADBE_PKCS7_DETACHED);
        dic.setSignatureCreator(appearance.getSignatureCreator());
        dic.setDate(new PdfDate(appearance.getSignDate()));
        appearance.setCryptoDictionary(dic);
        HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
        appearance.preClose(exc);
        appearance.close(new PdfDictionary());
        byte[] resultBytes = baos.toByteArray();
        return resultBytes;
    }

    public static byte[] createBlankSignature(PdfReader reader, int page, Rectangle rectangle, String fieldName, boolean completeMatch) throws DocumentException, IOException {
        ByteBuffer baos = new ByteBuffer();
        PdfReader workPdfReader = new PdfReader(reader);
        PdfStamper stamper = PdfStamper.createSignature(workPdfReader, (OutputStream)baos, '\u0000', (File)null, true);
        PdfSignatureAppearance appearance = stamper.getSignatureAppearance();
        appearance.setRenderingMode(PdfSignatureAppearance.RenderingMode.DESCRIPTION);
        String tmpFieldName = "";
        tmpFieldName = completeMatch ? fieldName : fieldName + ":" + UUID.randomUUID().toString();
        appearance.setVisibleSignature(rectangle, page, tmpFieldName);
        appearance.setCertificationLevel(0);
        MakeSignature.CryptoStandard sigtype = MakeSignature.CryptoStandard.CMS;
        PdfSignature dic = new PdfSignature(PdfName.ADOBE_PPKLITE, sigtype == MakeSignature.CryptoStandard.CADES ? PdfName.ETSI_CADES_DETACHED : PdfName.ADBE_PKCS7_DETACHED);
        dic.setSignatureCreator(appearance.getSignatureCreator());
        dic.setDate(new PdfDate(appearance.getSignDate()));
        appearance.setCryptoDictionary(dic);
        HashMap<PdfName, Integer> exc = new HashMap<PdfName, Integer>();
        PdfGState gState = new PdfGState();
        appearance.setGState(gState);
        appearance.setSigFlags(1);
        appearance.preClose(exc);
        appearance.close(new PdfDictionary());
        byte[] resultBytes = baos.toByteArray();
        return resultBytes;
    }

    public static byte[] addWaterMark(PdfReader pdfReader, String text, PageRangeOption pageRangeOption, WaterMarkOption waterMarkOption) throws DocumentException, IOException {
        ByteBuffer byteBuffer = new ByteBuffer();
        PdfStamper stamper = new PdfStamper(pdfReader, byteBuffer);
        int step = 1;
        int fromPage = pageRangeOption.getFromPage();
        int toPage = pageRangeOption.getToPage();
        if (fromPage <= 0 && -1 != fromPage) {
            throw new DocumentException("fromPage must be positive or -1!");
        }
        if (toPage <= 0 && -1 != toPage) {
            throw new DocumentException("toPage must be positive or -1!");
        }
        int numberOfPages = pdfReader.getNumberOfPages();
        if (-1 == fromPage) {
            fromPage = 1;
        }
        if (-1 == toPage) {
            toPage = numberOfPages;
        }
        if (fromPage > toPage) {
            int temp = fromPage;
            fromPage = toPage;
            toPage = temp;
        }
        if (0 != pageRangeOption.getSubPageRangeOption()) {
            if (1 == pageRangeOption.getSubPageRangeOption()) {
                if (fromPage % 2 == 0) {
                    ++fromPage;
                }
                step = 2;
            } else if (2 == pageRangeOption.getSubPageRangeOption()) {
                if (fromPage % 2 != 0) {
                    ++fromPage;
                }
                step = 2;
            }
        }
        boolean ifUnderContent = waterMarkOption.ifUnderContent();
        float absoluteX = waterMarkOption.getAbsoluteX();
        float absoluteY = waterMarkOption.getAbsoluteY();
        float rotationDegree = waterMarkOption.getRotationDegree();
        float alpha = waterMarkOption.getAlpha();
        float apartX = waterMarkOption.getApartX();
        float apartY = waterMarkOption.getApartY();
        float pageWidth = pdfReader.getPageSize(fromPage).getWidth();
        float pageHeight = pdfReader.getPageSize(fromPage).getHeight();
        boolean ifBeddingX = false;
        boolean ifBeddingY = false;
        BaseColor baseColor = waterMarkOption.getBaseColor();
        BaseFont baseFont = waterMarkOption.getBaseFont();
        float fontSize = waterMarkOption.getFontSize();
        int alignment = waterMarkOption.getAlignment();
        PdfContentByte pdfContentByte = null;
        PdfGState gs = new PdfGState();
        gs.setFillOpacity(alpha);
        if ((double)Math.abs(1.0f + apartX) > 1.0E-4) {
            ifBeddingX = true;
        }
        if ((double)Math.abs(1.0f + apartY) > 1.0E-4) {
            ifBeddingY = true;
        }
        int textLen = text.length();
        float stretchingX = (float)((double)(fontSize * (float)textLen) * Math.cos((double)rotationDegree * Math.PI / 180.0));
        float stretchingY = (float)((double)(fontSize * (float)textLen) * Math.sin((double)rotationDegree * Math.PI / 180.0));
        for (int i = fromPage; i <= toPage; i += step) {
            float upwardY;
            float downwardY;
            pdfContentByte = ifUnderContent ? stamper.getUnderContent(i) : stamper.getOverContent(i);
            pdfContentByte.setGState(gs);
            if (ifBeddingX) {
                float leftwardX = absoluteX;
                while (true) {
                    float f;
                    leftwardX -= apartX;
                    if (!(f >= -stretchingX)) break;
                    pdfContentByte = DonePdfSeal.addTextToPdfContentByte(pdfContentByte, text, alignment, baseColor, baseFont, fontSize, leftwardX, absoluteY, rotationDegree);
                }
                float rightwardX = absoluteX;
                while (true) {
                    float f;
                    rightwardX += apartX;
                    if (!(f < pageWidth + stretchingX)) break;
                    pdfContentByte = DonePdfSeal.addTextToPdfContentByte(pdfContentByte, text, alignment, baseColor, baseFont, fontSize, rightwardX, absoluteY, rotationDegree);
                }
            }
            if (ifBeddingY) {
                downwardY = absoluteY;
                while (true) {
                    float f;
                    downwardY -= apartY;
                    if (!(f > -stretchingY)) break;
                    pdfContentByte = DonePdfSeal.addTextToPdfContentByte(pdfContentByte, text, alignment, baseColor, baseFont, fontSize, absoluteX, downwardY, rotationDegree);
                }
                upwardY = absoluteY;
                while (true) {
                    float f;
                    upwardY += apartY;
                    if (!(f < pageHeight + stretchingY)) break;
                    pdfContentByte = DonePdfSeal.addTextToPdfContentByte(pdfContentByte, text, alignment, baseColor, baseFont, fontSize, absoluteX, upwardY, rotationDegree);
                }
            }
            if (ifBeddingX && ifBeddingY) {
                downwardY = absoluteY;
                block5: while (true) {
                    float f;
                    downwardY -= apartY;
                    if (!(f >= -stretchingY)) break;
                    float leftwardX = absoluteX;
                    while (true) {
                        float f2;
                        leftwardX -= apartX;
                        if (!(f2 >= -stretchingX)) break;
                        pdfContentByte = DonePdfSeal.addTextToPdfContentByte(pdfContentByte, text, alignment, baseColor, baseFont, fontSize, leftwardX, downwardY, rotationDegree);
                    }
                    float rightwardX = absoluteX;
                    while (true) {
                        float f3;
                        rightwardX += apartX;
                        if (!(f3 < pageWidth + stretchingX)) continue block5;
                        pdfContentByte = DonePdfSeal.addTextToPdfContentByte(pdfContentByte, text, alignment, baseColor, baseFont, fontSize, rightwardX, downwardY, rotationDegree);
                    }
                    break;
                }
                upwardY = absoluteY;
                block8: while (true) {
                    float f;
                    upwardY += apartY;
                    if (!(f < pageHeight + stretchingY)) break;
                    float leftwardX = absoluteX;
                    while (true) {
                        float f4;
                        leftwardX -= apartX;
                        if (!(f4 >= -stretchingX)) break;
                        pdfContentByte = DonePdfSeal.addTextToPdfContentByte(pdfContentByte, text, alignment, baseColor, baseFont, fontSize, leftwardX, upwardY, rotationDegree);
                    }
                    float rightwardX = absoluteX;
                    while (true) {
                        float f5;
                        rightwardX += apartX;
                        if (!(f5 < pageWidth + stretchingX)) continue block8;
                        pdfContentByte = DonePdfSeal.addTextToPdfContentByte(pdfContentByte, text, alignment, baseColor, baseFont, fontSize, rightwardX, upwardY, rotationDegree);
                    }
                    break;
                }
            }
            pdfContentByte = DonePdfSeal.addTextToPdfContentByte(pdfContentByte, text, alignment, baseColor, baseFont, fontSize, absoluteX, absoluteY, rotationDegree);
        }
        stamper.close();
        return byteBuffer.toByteArray();
    }

    private static PdfContentByte addTextToPdfContentByte(PdfContentByte pdfContentByte, String text, int alignment, BaseColor baseColor, BaseFont baseFont, float fontSize, float absoluteX, float absoluteY, float rotationDegree) {
        pdfContentByte.beginText();
        pdfContentByte.setColorFill(baseColor);
        pdfContentByte.setFontAndSize(baseFont, fontSize);
        pdfContentByte.setTextMatrix(absoluteX, absoluteY);
        pdfContentByte.showTextAligned(alignment, text, absoluteX, absoluteY, rotationDegree);
        pdfContentByte.endText();
        return pdfContentByte;
    }

    public static byte[] addWaterMark(PdfReader pdfReader, Image image, PageRangeOption pageRangeOption, WaterMarkOption waterMarkOption) throws DocumentException, IOException {
        ByteBuffer byteBuffer = new ByteBuffer();
        PdfStamper stamper = new PdfStamper(pdfReader, byteBuffer);
        int step = 1;
        int fromPage = pageRangeOption.getFromPage();
        int toPage = pageRangeOption.getToPage();
        if (fromPage <= 0 && -1 != fromPage) {
            throw new DocumentException("fromPage must be positive or -1!");
        }
        if (toPage <= 0 && -1 != toPage) {
            throw new DocumentException("toPage must be positive or -1!");
        }
        int numberOfPages = pdfReader.getNumberOfPages();
        if (-1 == fromPage) {
            fromPage = 1;
        }
        if (-1 == toPage) {
            toPage = numberOfPages;
        }
        if (fromPage > toPage) {
            int temp = fromPage;
            fromPage = toPage;
            toPage = temp;
        }
        if (0 != pageRangeOption.getSubPageRangeOption()) {
            if (1 == pageRangeOption.getSubPageRangeOption()) {
                if (fromPage % 2 == 0) {
                    ++fromPage;
                }
                step = 2;
            } else if (2 == pageRangeOption.getSubPageRangeOption()) {
                if (fromPage % 2 == 1) {
                    ++fromPage;
                }
                step = 2;
            }
        }
        boolean ifUnderContent = waterMarkOption.ifUnderContent();
        float absoluteX = waterMarkOption.getAbsoluteX();
        float absoluteY = waterMarkOption.getAbsoluteY();
        float fitWidth = waterMarkOption.getFitWidth();
        float fitHeight = waterMarkOption.getFitHeight();
        float rotationDegree = waterMarkOption.getRotationDegree();
        float alpha = waterMarkOption.getAlpha();
        float apartX = waterMarkOption.getApartX();
        float apartY = waterMarkOption.getApartY();
        float pageWidth = pdfReader.getPageSize(fromPage).getWidth();
        float pageHeight = pdfReader.getPageSize(fromPage).getHeight();
        boolean ifBeddingX = false;
        boolean ifBeddingY = false;
        image.scaleToFit(fitWidth, fitHeight);
        image.setRotationDegrees(rotationDegree);
        PdfContentByte pdfContentByte = null;
        PdfGState gs = new PdfGState();
        gs.setFillOpacity(alpha);
        gs.put(PdfName.BM, PdfGState.BM_MULTIPLY);
        gs.put(PdfName.TYPE, PdfName.EXTGSTATE);
        if ((double)Math.abs(1.0f + apartX) > 1.0E-4) {
            ifBeddingX = true;
        }
        if ((double)Math.abs(1.0f + apartY) > 1.0E-4) {
            ifBeddingY = true;
        }
        for (int i = fromPage; i <= toPage; i += step) {
            float upwardY;
            float downwardY;
            pdfContentByte = ifUnderContent ? stamper.getUnderContent(i) : stamper.getOverContent(i);
            pdfContentByte.setGState(gs);
            if (ifBeddingX) {
                float leftwardX = absoluteX;
                while (true) {
                    float f;
                    leftwardX -= apartX;
                    if (!(f >= -fitWidth)) break;
                    image.setAbsolutePosition(leftwardX, absoluteY);
                    pdfContentByte.addImage(image);
                }
                float rightwardX = absoluteX;
                while (true) {
                    float f;
                    rightwardX += apartX;
                    if (!(f < pageWidth)) break;
                    image.setAbsolutePosition(rightwardX, absoluteY);
                    pdfContentByte.addImage(image);
                }
            }
            if (ifBeddingY) {
                downwardY = absoluteY;
                while (true) {
                    float f;
                    downwardY -= apartY;
                    if (!(f >= -fitHeight)) break;
                    image.setAbsolutePosition(absoluteX, downwardY);
                    pdfContentByte.addImage(image);
                }
                upwardY = absoluteY;
                while (true) {
                    float f;
                    upwardY += apartY;
                    if (!(f < pageHeight)) break;
                    image.setAbsolutePosition(absoluteX, upwardY);
                    pdfContentByte.addImage(image);
                }
            }
            if (ifBeddingX && ifBeddingY) {
                downwardY = absoluteY;
                block5: while (true) {
                    float f;
                    downwardY -= apartY;
                    if (!(f >= -fitHeight)) break;
                    float leftwardX = absoluteX;
                    while (true) {
                        float f2;
                        leftwardX -= apartX;
                        if (!(f2 >= -fitWidth)) break;
                        image.setAbsolutePosition(leftwardX, downwardY);
                        pdfContentByte.addImage(image);
                    }
                    float rightwardX = absoluteX;
                    while (true) {
                        float f3;
                        rightwardX += apartX;
                        if (!(f3 < pageWidth)) continue block5;
                        image.setAbsolutePosition(rightwardX, downwardY);
                        pdfContentByte.addImage(image);
                    }
                    break;
                }
                upwardY = absoluteY;
                block8: while (true) {
                    float f;
                    upwardY += apartY;
                    if (!(f < pageHeight)) break;
                    float leftwardX = absoluteX;
                    while (true) {
                        float f4;
                        leftwardX -= apartX;
                        if (!(f4 >= -fitWidth)) break;
                        image.setAbsolutePosition(leftwardX, upwardY);
                        pdfContentByte.addImage(image);
                    }
                    float rightwardX = absoluteX;
                    while (true) {
                        float f5;
                        rightwardX += apartX;
                        if (!(f5 < pageWidth)) continue block8;
                        image.setAbsolutePosition(rightwardX, upwardY);
                        pdfContentByte.addImage(image);
                    }
                    break;
                }
            }
            image.setAbsolutePosition(absoluteX, absoluteY);
            pdfContentByte.addImage(image);
        }
        stamper.close();
        return byteBuffer.toByteArray();
    }

    public static byte[] getAPageAsBytes(PdfReader pdfReader, int pageNumber) throws DocumentException, IOException {
        pdfReader.selectPages(String.valueOf(pageNumber));
        ByteBuffer baos = new ByteBuffer();
        PdfStamper pdfStamper = new PdfStamper(pdfReader, baos);
        pdfStamper.close();
        return baos.toByteArray();
    }

    public static byte[] concatenatePdfs(PdfReader[] pdfReaders) throws DocumentException, IOException {
        return DonePdfSeal.concatenatePdfs(pdfReaders, false);
    }

    public static byte[] concatenatePdfs(PdfReader[] pdfReaders, boolean isBlankSignatureIncluded) throws DocumentException, IOException {
        byte[] retBytes = null;
        ByteBuffer baos = new ByteBuffer();
        Document document = new Document();
        if (isBlankSignatureIncluded) {
            PdfCopy pdfCopy = new PdfCopy(document, (OutputStream)baos);
            pdfCopy.setMergeFields();
            document.open();
            for (int i = 0; i < pdfReaders.length; ++i) {
                pdfCopy.addDocument(pdfReaders[i]);
            }
        } else {
            PdfWriter pdfWriter = PdfWriter.getInstance(document, baos);
            document.open();
            PdfContentByte cb = pdfWriter.getDirectContent();
            PdfImportedPage importedPage = null;
            int numberOfPages = 0;
            for (int i = 0; i < pdfReaders.length; ++i) {
                numberOfPages = pdfReaders[i].getNumberOfPages();
                for (int j = 0; j < numberOfPages; ++j) {
                    Rectangle pageSize = pdfReaders[i].getPageSize(j + 1);
                    document.setPageSize(pageSize);
                    document.newPage();
                    importedPage = pdfWriter.getImportedPage(pdfReaders[i], j + 1);
                    cb.addTemplate((PdfTemplate)importedPage, 0.0f, 0.0f);
                }
            }
        }
        baos.flush();
        document.close();
        retBytes = baos.toByteArray();
        baos.close();
        return retBytes;
    }

    public static byte[] splitPdf(PdfReader pdfReader, int fromPage, int toPage) throws DocumentException, IOException {
        return DonePdfSeal.splitPdf(pdfReader, fromPage, toPage, false);
    }

    public static byte[] splitPdf(PdfReader pdfReader, int fromPage, int toPage, boolean isBlankSignatureIncluded) throws DocumentException, IOException {
        byte[] retBytes = null;
        int numberOfPages = pdfReader.getNumberOfPages();
        if (fromPage < 0 && fromPage != -1 || toPage < 0 && toPage != -1) {
            throw new DocumentException("Parameter fromPage or toPage must be positive or -1!");
        }
        if (fromPage == -1) {
            fromPage = 1;
        }
        if (toPage == -1) {
            toPage = numberOfPages;
        }
        if (fromPage > toPage) {
            int tmp = toPage;
            toPage = fromPage;
            fromPage = tmp;
        }
        ByteBuffer baos = new ByteBuffer();
        Document document = new Document();
        if (isBlankSignatureIncluded) {
            PdfCopy pdfCopy = new PdfCopy(document, (OutputStream)baos);
            document.open();
            for (int i = fromPage; i <= toPage; ++i) {
                pdfCopy.addPage(pdfCopy.getImportedPage(pdfReader, i));
            }
            pdfCopy.freeReader(pdfReader);
            pdfReader.close();
            baos.flush();
            document.close();
            retBytes = baos.toByteArray();
            baos.close();
            return retBytes;
        }
        PdfWriter pdfWriter = PdfWriter.getInstance(document, baos);
        document.open();
        PdfContentByte cb = pdfWriter.getDirectContent();
        PdfImportedPage importedPage = null;
        while (fromPage <= toPage) {
            document.newPage();
            importedPage = pdfWriter.getImportedPage(pdfReader, fromPage);
            cb.addTemplate((PdfTemplate)importedPage, 0.0f, 0.0f);
            ++fromPage;
        }
        baos.flush();
        document.close();
        retBytes = baos.toByteArray();
        baos.close();
        return retBytes;
    }

    public static byte[] outputContentText(PdfReader pdfReader) throws IOException {
        int numOfPages = pdfReader.getNumberOfPages();
        StringBuilder strBuilder = new StringBuilder();
        String tmpStr = null;
        for (int i = 1; i <= numOfPages; ++i) {
            tmpStr = PdfTextExtractor.getTextFromPage(pdfReader, i);
            strBuilder.append(System.getProperty("line.separator") + "page: " + i + System.getProperty("line.separator"));
            strBuilder.append(tmpStr);
        }
        return strBuilder.toString().getBytes("UTF-8");
    }

    public static byte[] outputContentStream(PdfReader pdfReader) throws IOException {
        int numOfPages = pdfReader.getNumberOfPages();
        ByteBuffer byteBuffer = new ByteBuffer();
        byte[] pageContentBytes = null;
        for (int i = 1; i <= numOfPages; ++i) {
            byteBuffer.write(("sealsadk info: page: " + i + System.getProperty("line.separator")).getBytes());
            pageContentBytes = pdfReader.getPageContent(i);
            byteBuffer.write(pageContentBytes);
        }
        return byteBuffer.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] createPdfByTemplate(PdfReader templatePdfReader, Map<?, ?> fieldMap) throws DocumentException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PdfStamper pdfStamper = new PdfStamper(templatePdfReader, bos);
        try {
            AcroFields acrofields = pdfStamper.getAcroFields();
            for (String name : fieldMap.keySet()) {
                String value = (String)fieldMap.get(name);
                acrofields.setField(name, value);
            }
            pdfStamper.setFormFlattening(true);
        }
        finally {
            pdfStamper.close();
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] createPdfByTemplate(PdfReader templatePdfReader, Map<?, ?> fieldMap, boolean isFlattening) throws DocumentException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PdfStamper pdfStamper = new PdfStamper(templatePdfReader, bos);
        try {
            AcroFields acrofields = pdfStamper.getAcroFields();
            for (String name : fieldMap.keySet()) {
                String value = (String)fieldMap.get(name);
                acrofields.setField(name, value);
            }
            pdfStamper.setFormFlattening(isFlattening);
        }
        finally {
            pdfStamper.close();
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] createPdfByTemplate(PdfReader templatePdfReader, Map<?, ?> fieldMap, String[] partialFlattening, boolean isFlattening) throws DocumentException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PdfStamper pdfStamper = new PdfStamper(templatePdfReader, bos);
        try {
            AcroFields acrofields = pdfStamper.getAcroFields();
            for (String name : fieldMap.keySet()) {
                String value = (String)fieldMap.get(name);
                acrofields.setField(name, value);
            }
            pdfStamper.setFormFlattening(isFlattening);
            for (int i = 0; i < partialFlattening.length; ++i) {
                pdfStamper.partialFormFlattening(partialFlattening[i]);
            }
        }
        finally {
            pdfStamper.close();
        }
        return bos.toByteArray();
    }

    private boolean canMakeSignature(PdfReader pdfReader) {
        if (!this.prePdfSealExtra.getAdbeSignatureConvention()) {
            return true;
        }
        PdfDictionary catologDict = pdfReader.getCatalog();
        PdfDictionary permsDict = catologDict.getAsDict(PdfName.PERMS);
        return permsDict == null;
    }

    private void createPdfSealByLocation(OutputStream os, LocationInfo locationInfo, TSAClient tsaClient, int certificationLevel) throws DocumentException, IOException, GeneralSecurityException {
        byte[] sealedPdfBytes = null;
        ByteBuffer outByteBuffer = null;
        FileOutputStream fos = null;
        ByteBuffer workByteBuffer = null;
        PrePdfSealExtra.TempFileBufferStrategy tempFileBufferStrategy = null;
        PrePdfSealExtra.BufferStrategy bufferStrategy = this.prePdfSealExtra.getBufferStrategy();
        PrePdfSealExtra.SignatureOpacity signatureOpacity = this.prePdfSealExtra.getSignatureOpacity();
        if (null == bufferStrategy) {
            outByteBuffer = new ByteBuffer(4096);
            workByteBuffer = new ByteBuffer(4096);
        } else if (bufferStrategy instanceof PrePdfSealExtra.TempFileBufferStrategy) {
            tempFileBufferStrategy = (PrePdfSealExtra.TempFileBufferStrategy)bufferStrategy;
            fos = new FileOutputStream(tempFileBufferStrategy.tempFile);
        }
        PdfReader workPdfReader = new PdfReader(this.prePdfReader.getPdfReader());
        byte[] password = workPdfReader.getOwnerPassword();
        int cntSeal = locationInfo.getCntSeal();
        for (int i = 0; i < cntSeal; ++i) {
            PdfStamper stamper = null;
            PdfSignatureAppearance appearance = null;
            if (null == bufferStrategy) {
                stamper = PdfStamper.createSignature(workPdfReader, (OutputStream)outByteBuffer, '\u0000', workByteBuffer, true);
            } else if (bufferStrategy instanceof PrePdfSealExtra.TempFileBufferStrategy) {
                File tempFile = tempFileBufferStrategy.tempFile;
                File stpTempFile = new File(tempFile.getName() + ".stamper");
                stamper = PdfStamper.createSignature(workPdfReader, (OutputStream)fos, '\u0000', stpTempFile, true);
            }
            appearance = stamper.getSignatureAppearance();
            SignatureLandscape signatureLandscape = locationInfo.getLocSignatureLandscapeInfoList().get(i);
            if (this.sealType == 1) {
                this.doBlankSignature(signatureOpacity, appearance, signatureLandscape);
            } else {
                this.visibleRectangle = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
                String userFieldName = this.prePdfSealExtra.getFieldName();
                if (null != userFieldName && !"".equals(userFieldName)) {
                    this.fieldName = userFieldName;
                }
                if (null != signatureOpacity) {
                    this.isVisible = signatureOpacity.getVisible();
                }
                if (this.isVisible) {
                    this.doVisibleSignature(signatureOpacity, i, appearance, signatureLandscape);
                } else {
                    this.doInvisibleSignature(appearance, signatureLandscape);
                }
            }
            String reason = this.prePdfSealExtra.getReason();
            String location = this.prePdfSealExtra.getLocation();
            appearance.setReason(reason);
            appearance.setLocation(location);
            appearance.setCertificationLevel(certificationLevel);
            boolean ifExternalContainer = this.prePdfSeal.IfExternalContainer();
            PrivateKey privateKey = this.prePdfSeal.getPrivateKey();
            if (!ifExternalContainer) {
                this.doInternalContainer(tsaClient, appearance, privateKey);
            } else {
                this.doExternalContainer(tsaClient, appearance);
            }
            if (null == bufferStrategy) {
                byte[] tempSealedPdfBytes = outByteBuffer.toByteArray();
                if (cntSeal - i == 1) {
                    sealedPdfBytes = tempSealedPdfBytes;
                    os.write(sealedPdfBytes);
                    os.close();
                    break;
                }
                outByteBuffer.reset();
                workByteBuffer.reset();
                workPdfReader = new PdfReader(tempSealedPdfBytes, password);
                continue;
            }
            if (!(bufferStrategy instanceof PrePdfSealExtra.TempFileBufferStrategy)) continue;
            File tempFile = tempFileBufferStrategy.tempFile;
            byte[] tempSealedPdfBytes = FileUtils.readFileToByteArray((File)tempFile);
            if (cntSeal - i == 1) {
                sealedPdfBytes = tempSealedPdfBytes;
                os.write(sealedPdfBytes);
                os.close();
                boolean isTempFileTemporal = tempFileBufferStrategy.isTempFileTemporal;
                if (!isTempFileTemporal || tempFile == null) break;
                tempFile.delete();
                break;
            }
            fos = new FileOutputStream(tempFile);
            workPdfReader = new PdfReader(tempSealedPdfBytes, password);
        }
    }

    public void createPdfSeal(OutputStream os, PreExternalTSAClient preExternalTSAClient, int certificationLevel) throws DocumentException, IOException, GeneralSecurityException {
        if (!this.canMakeSignature(this.prePdfReader.getPdfReader())) {
            throw new GeneralSecurityException("Only approval signature allowed to make signature again!");
        }
        this.createPdfSealByLocation(os, this.locationInfo, preExternalTSAClient, certificationLevel);
    }

    public void createReservedPdfSeal(OutputStream os, int certificationLevel, ReservedPdfPKCS7 reservedPdfPKCS7) throws DocumentException, IOException, GeneralSecurityException {
        if (!this.canMakeSignature(this.prePdfReader.getPdfReader())) {
            throw new GeneralSecurityException("Only approval signature allowed to make signature again!");
        }
        this.createReservedPdfSealByLocation(os, this.locationInfo, null, certificationLevel, reservedPdfPKCS7);
    }

    private void createReservedPdfSealByLocation(OutputStream os, LocationInfo locationInfo, TSAClient tsaClient, int certificationLevel, ReservedPdfPKCS7 reservedPdfPKCS7) throws DocumentException, IOException, GeneralSecurityException {
        byte[] sealedPdfBytes = null;
        ByteBuffer outByteBuffer = null;
        FileOutputStream fos = null;
        ByteBuffer workByteBuffer = null;
        PrePdfSealExtra.TempFileBufferStrategy tempFileBufferStrategy = null;
        PrePdfSealExtra.BufferStrategy bufferStrategy = this.prePdfSealExtra.getBufferStrategy();
        PrePdfSealExtra.SignatureOpacity signatureOpacity = this.prePdfSealExtra.getSignatureOpacity();
        if (null == bufferStrategy) {
            outByteBuffer = new ByteBuffer(4096);
            workByteBuffer = new ByteBuffer(4096);
        } else if (bufferStrategy instanceof PrePdfSealExtra.TempFileBufferStrategy) {
            tempFileBufferStrategy = (PrePdfSealExtra.TempFileBufferStrategy)bufferStrategy;
            fos = new FileOutputStream(tempFileBufferStrategy.tempFile);
        }
        PdfReader workPdfReader = new PdfReader(this.prePdfReader.getPdfReader());
        byte[] password = workPdfReader.getOwnerPassword();
        int cntSeal = locationInfo.getCntSeal();
        if (cntSeal > 1) {
            throw new GeneralSecurityException("number of seal must be 1");
        }
        for (int i = 0; i < cntSeal; ++i) {
            PdfStamper stamper = null;
            PdfSignatureAppearance appearance = null;
            if (null == bufferStrategy) {
                stamper = PdfStamper.createSignature(workPdfReader, (OutputStream)outByteBuffer, '\u0000', workByteBuffer, true);
            } else if (bufferStrategy instanceof PrePdfSealExtra.TempFileBufferStrategy) {
                File tempFile = tempFileBufferStrategy.tempFile;
                File stpTempFile = new File(tempFile.getName() + ".stamper");
                stamper = PdfStamper.createSignature(workPdfReader, (OutputStream)fos, '\u0000', stpTempFile, true);
            }
            if (null == appearance) {
                throw new GeneralSecurityException("signature appearance does not exist!");
            }
            appearance = stamper.getSignatureAppearance();
            SignatureLandscape signatureLandscape = locationInfo.getLocSignatureLandscapeInfoList().get(i);
            if (this.sealType == 1) {
                this.doBlankSignature(signatureOpacity, appearance, signatureLandscape);
            } else {
                this.visibleRectangle = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
                String userFieldName = this.prePdfSealExtra.getFieldName();
                if (null != userFieldName && !"".equals(userFieldName)) {
                    this.fieldName = userFieldName;
                }
                if (null != signatureOpacity) {
                    this.isVisible = signatureOpacity.getVisible();
                }
                if (this.isVisible) {
                    this.doVisibleSignature(signatureOpacity, i, appearance, signatureLandscape);
                } else {
                    this.doInvisibleSignature(appearance, signatureLandscape);
                }
            }
            String reason = this.prePdfSealExtra.getReason();
            String location = this.prePdfSealExtra.getLocation();
            appearance.setReason(reason);
            appearance.setLocation(location);
            appearance.setCertificationLevel(certificationLevel);
            boolean ifExternalContainer = this.prePdfSeal.IfExternalContainer();
            PrivateKey privateKey = this.prePdfSeal.getPrivateKey();
            Certificate[] chain = this.prePdfSeal.getCertificateChain();
            int deferredType = this.prePdfSeal.getDeferredType();
            if (!ifExternalContainer) {
                this.doInternalContainerReserved(tsaClient, reservedPdfPKCS7, appearance, privateKey, chain, deferredType);
            } else {
                this.doExternalContainerReserved(tsaClient, appearance);
            }
            if (null == bufferStrategy) {
                byte[] tempSealedPdfBytes = outByteBuffer.toByteArray();
                if (cntSeal - i == 1) {
                    sealedPdfBytes = tempSealedPdfBytes;
                    os.write(sealedPdfBytes);
                    os.close();
                    break;
                }
                outByteBuffer.reset();
                workByteBuffer.reset();
                workPdfReader = new PdfReader(tempSealedPdfBytes, password);
                continue;
            }
            if (!(bufferStrategy instanceof PrePdfSealExtra.TempFileBufferStrategy)) continue;
            File tempFile = tempFileBufferStrategy.tempFile;
            byte[] tempSealedPdfBytes = FileUtils.readFileToByteArray((File)tempFile);
            if (cntSeal - i == 1) {
                sealedPdfBytes = tempSealedPdfBytes;
                os.write(sealedPdfBytes);
                os.close();
                boolean isTempFileTemporal = tempFileBufferStrategy.isTempFileTemporal;
                if (!isTempFileTemporal || tempFile == null) break;
                tempFile.delete();
                break;
            }
            fos = new FileOutputStream(tempFile);
            workPdfReader = new PdfReader(tempSealedPdfBytes, password);
        }
    }

    public void mergeReservedPdfSeal(PdfReader reader, OutputStream os, ReservedPdfPKCS7 reservedPdfPKCS7) throws DocumentException, IOException, GeneralSecurityException {
        ExternalBlankPrivateSignature externalSignature = new ExternalBlankPrivateSignature(null, null, reservedPdfPKCS7.encryptionAlgorithm, reservedPdfPKCS7.hashAlgorithm, null);
        BouncyCastleDigest externalDigest = new BouncyCastleDigest();
        int type = reservedPdfPKCS7.type;
        String encryptionAlgorithm = externalSignature.getEncryptionAlgorithm();
        ExternalReservedSignatureContainer externalSignatureContainer = null;
        if ("RSA".equals(encryptionAlgorithm)) {
            externalSignatureContainer = type != 1 ? new ExternalReservedSignatureContainer(PdfName.ADOBE_PPKLITE, reservedPdfPKCS7.cryptostandard == 1 ? PdfName.ETSI_CADES_DETACHED : PdfName.ADBE_PKCS7_DETACHED, externalDigest, externalSignature, reservedPdfPKCS7) : new ExternalReservedSignatureContainer(PdfName.CFCA_TrustSignPDF, PdfName.RSA_BASE64_SHA1, externalDigest, externalSignature, reservedPdfPKCS7);
        } else if ("SM2".equals(encryptionAlgorithm)) {
            externalSignatureContainer = new ExternalReservedSignatureContainer(PdfName.CFCA_TrustSignPDF, PdfName.CFCA_SM2_PKCS7_DETACHED, externalDigest, externalSignature, reservedPdfPKCS7);
        }
        MakeSignature.signDeferred(reader, reservedPdfPKCS7.fieldName, os, externalSignatureContainer);
    }

    public void mergeReservedPdfSeal(PdfReader reader, OutputStream os, String fieldName, byte[] signedContent) throws DocumentException, IOException {
        MakeSignature.signDeferred(reader, fieldName, os, signedContent);
    }

    public static void addWaterMark(PdfReader pdfReader, OutputStream os, Image image, PageRangeOption pageRangeOption, WaterMarkOption waterMarkOption) throws DocumentException, IOException {
        PdfStamper stamper = new PdfStamper(pdfReader, os);
        int step = 1;
        int fromPage = pageRangeOption.getFromPage();
        int toPage = pageRangeOption.getToPage();
        if (fromPage <= 0 && -1 != fromPage) {
            throw new DocumentException("fromPage must be positive or -1!");
        }
        if (toPage <= 0 && -1 != toPage) {
            throw new DocumentException("toPage must be positive or -1!");
        }
        int numberOfPages = pdfReader.getNumberOfPages();
        if (-1 == fromPage) {
            fromPage = 1;
        }
        if (-1 == toPage) {
            toPage = numberOfPages;
        }
        if (fromPage > toPage) {
            int temp = fromPage;
            fromPage = toPage;
            toPage = temp;
        }
        if (0 != pageRangeOption.getSubPageRangeOption()) {
            if (1 == pageRangeOption.getSubPageRangeOption()) {
                if (fromPage % 2 == 0) {
                    ++fromPage;
                }
                step = 2;
            } else if (2 == pageRangeOption.getSubPageRangeOption()) {
                if (0 != fromPage % 2) {
                    ++fromPage;
                }
                step = 2;
            }
        }
        boolean ifUnderContent = waterMarkOption.ifUnderContent();
        float absoluteX = waterMarkOption.getAbsoluteX();
        float absoluteY = waterMarkOption.getAbsoluteY();
        float fitWidth = waterMarkOption.getFitWidth();
        float fitHeight = waterMarkOption.getFitHeight();
        float rotationDegree = waterMarkOption.getRotationDegree();
        float alpha = waterMarkOption.getAlpha();
        float apartX = waterMarkOption.getApartX();
        float apartY = waterMarkOption.getApartY();
        float pageWidth = pdfReader.getPageSize(fromPage).getWidth();
        float pageHeight = pdfReader.getPageSize(fromPage).getHeight();
        boolean ifBeddingX = false;
        boolean ifBeddingY = false;
        image.scaleToFit(fitWidth, fitHeight);
        image.setRotationDegrees(rotationDegree);
        PdfContentByte pdfContentByte = null;
        PdfGState gs = new PdfGState();
        gs.setFillOpacity(alpha);
        gs.put(PdfName.BM, PdfGState.BM_MULTIPLY);
        gs.put(PdfName.TYPE, PdfName.EXTGSTATE);
        if ((double)Math.abs(1.0f + apartX) > 1.0E-4) {
            ifBeddingX = true;
        }
        if ((double)Math.abs(1.0f + apartY) > 1.0E-4) {
            ifBeddingY = true;
        }
        for (int i = fromPage; i <= toPage; i += step) {
            float upwardY;
            float downwardY;
            pdfContentByte = ifUnderContent ? stamper.getUnderContent(i) : stamper.getOverContent(i);
            pdfContentByte.setGState(gs);
            if (ifBeddingX) {
                float leftwardX = absoluteX;
                while (true) {
                    float f;
                    leftwardX -= apartX;
                    if (!(f >= -fitWidth)) break;
                    image.setAbsolutePosition(leftwardX, absoluteY);
                    pdfContentByte.addImage(image);
                }
                float rightwardX = absoluteX;
                while (true) {
                    float f;
                    rightwardX += apartX;
                    if (!(f < pageWidth)) break;
                    image.setAbsolutePosition(rightwardX, absoluteY);
                    pdfContentByte.addImage(image);
                }
            }
            if (ifBeddingY) {
                downwardY = absoluteY;
                while (true) {
                    float f;
                    downwardY -= apartY;
                    if (!(f >= -fitHeight)) break;
                    image.setAbsolutePosition(absoluteX, downwardY);
                    pdfContentByte.addImage(image);
                }
                upwardY = absoluteY;
                while (true) {
                    float f;
                    upwardY += apartY;
                    if (!(f < pageHeight)) break;
                    image.setAbsolutePosition(absoluteX, upwardY);
                    pdfContentByte.addImage(image);
                }
            }
            if (ifBeddingX && ifBeddingY) {
                downwardY = absoluteY;
                block5: while (true) {
                    float f;
                    downwardY -= apartY;
                    if (!(f >= -fitHeight)) break;
                    float leftwardX = absoluteX;
                    while (true) {
                        float f2;
                        leftwardX -= apartX;
                        if (!(f2 >= -fitWidth)) break;
                        image.setAbsolutePosition(leftwardX, downwardY);
                        pdfContentByte.addImage(image);
                    }
                    float rightwardX = absoluteX;
                    while (true) {
                        float f3;
                        rightwardX += apartX;
                        if (!(f3 < pageWidth)) continue block5;
                        image.setAbsolutePosition(rightwardX, downwardY);
                        pdfContentByte.addImage(image);
                    }
                    break;
                }
                upwardY = absoluteY;
                block8: while (true) {
                    float f;
                    upwardY += apartY;
                    if (!(f < pageHeight)) break;
                    float leftwardX = absoluteX;
                    while (true) {
                        float f4;
                        leftwardX -= apartX;
                        if (!(f4 >= -fitWidth)) break;
                        image.setAbsolutePosition(leftwardX, upwardY);
                        pdfContentByte.addImage(image);
                    }
                    float rightwardX = absoluteX;
                    while (true) {
                        float f5;
                        rightwardX += apartX;
                        if (!(f5 < pageWidth)) continue block8;
                        image.setAbsolutePosition(rightwardX, upwardY);
                        pdfContentByte.addImage(image);
                    }
                    break;
                }
            }
            image.setAbsolutePosition(absoluteX, absoluteY);
            pdfContentByte.addImage(image);
        }
        stamper.close();
    }

    public static void addWaterMark(PdfReader pdfReader, OutputStream os, String text, PageRangeOption pageRangeOption, WaterMarkOption waterMarkOption) throws DocumentException, IOException {
        PdfStamper stamper = new PdfStamper(pdfReader, os);
        int step = 1;
        int fromPage = pageRangeOption.getFromPage();
        int toPage = pageRangeOption.getToPage();
        if (fromPage <= 0 && -1 != fromPage) {
            throw new DocumentException("fromPage must be positive or -1!");
        }
        if (toPage <= 0 && -1 != toPage) {
            throw new DocumentException("toPage must be positive or -1!");
        }
        int numberOfPages = pdfReader.getNumberOfPages();
        if (-1 == fromPage) {
            fromPage = 1;
        }
        if (-1 == toPage) {
            toPage = numberOfPages;
        }
        if (fromPage > toPage) {
            int temp = fromPage;
            fromPage = toPage;
            toPage = temp;
        }
        if (0 != pageRangeOption.getSubPageRangeOption()) {
            if (1 == pageRangeOption.getSubPageRangeOption()) {
                if (fromPage % 2 == 0) {
                    ++fromPage;
                }
                step = 2;
            } else if (2 == pageRangeOption.getSubPageRangeOption()) {
                if (0 != fromPage % 2) {
                    ++fromPage;
                }
                step = 2;
            }
        }
        boolean ifUnderContent = waterMarkOption.ifUnderContent();
        float absoluteX = waterMarkOption.getAbsoluteX();
        float absoluteY = waterMarkOption.getAbsoluteY();
        float rotationDegree = waterMarkOption.getRotationDegree();
        float alpha = waterMarkOption.getAlpha();
        float apartX = waterMarkOption.getApartX();
        float apartY = waterMarkOption.getApartY();
        float pageWidth = pdfReader.getPageSize(fromPage).getWidth();
        float pageHeight = pdfReader.getPageSize(fromPage).getHeight();
        boolean ifBeddingX = false;
        boolean ifBeddingY = false;
        BaseColor baseColor = waterMarkOption.getBaseColor();
        BaseFont baseFont = waterMarkOption.getBaseFont();
        float fontSize = waterMarkOption.getFontSize();
        int alignment = waterMarkOption.getAlignment();
        PdfContentByte pdfContentByte = null;
        PdfGState gs = new PdfGState();
        gs.setFillOpacity(alpha);
        if ((double)Math.abs(1.0f + apartX) > 1.0E-4) {
            ifBeddingX = true;
        }
        if ((double)Math.abs(1.0f + apartY) > 1.0E-4) {
            ifBeddingY = true;
        }
        int textLen = text.length();
        float stretchingX = (float)((double)(fontSize * (float)textLen) * Math.cos((double)rotationDegree * Math.PI / 180.0));
        float stretchingY = (float)((double)(fontSize * (float)textLen) * Math.sin((double)rotationDegree * Math.PI / 180.0));
        for (int i = fromPage; i <= toPage; i += step) {
            float upwardY;
            float downwardY;
            pdfContentByte = ifUnderContent ? stamper.getUnderContent(i) : stamper.getOverContent(i);
            pdfContentByte.setGState(gs);
            if (ifBeddingX) {
                float leftwardX = absoluteX;
                while (true) {
                    float f;
                    leftwardX -= apartX;
                    if (!(f >= -stretchingX)) break;
                    pdfContentByte = DonePdfSeal.addTextToPdfContentByte(pdfContentByte, text, alignment, baseColor, baseFont, fontSize, leftwardX, absoluteY, rotationDegree);
                }
                float rightwardX = absoluteX;
                while (true) {
                    float f;
                    rightwardX += apartX;
                    if (!(f < pageWidth + stretchingX)) break;
                    pdfContentByte = DonePdfSeal.addTextToPdfContentByte(pdfContentByte, text, alignment, baseColor, baseFont, fontSize, rightwardX, absoluteY, rotationDegree);
                }
            }
            if (ifBeddingY) {
                downwardY = absoluteY;
                while (true) {
                    float f;
                    downwardY -= apartY;
                    if (!(f > -stretchingY)) break;
                    pdfContentByte = DonePdfSeal.addTextToPdfContentByte(pdfContentByte, text, alignment, baseColor, baseFont, fontSize, absoluteX, downwardY, rotationDegree);
                }
                upwardY = absoluteY;
                while (true) {
                    float f;
                    upwardY += apartY;
                    if (!(f < pageHeight + stretchingY)) break;
                    pdfContentByte = DonePdfSeal.addTextToPdfContentByte(pdfContentByte, text, alignment, baseColor, baseFont, fontSize, absoluteX, upwardY, rotationDegree);
                }
            }
            if (ifBeddingX && ifBeddingY) {
                downwardY = absoluteY;
                block5: while (true) {
                    float f;
                    downwardY -= apartY;
                    if (!(f >= -stretchingY)) break;
                    float leftwardX = absoluteX;
                    while (true) {
                        float f2;
                        leftwardX -= apartX;
                        if (!(f2 >= -stretchingX)) break;
                        pdfContentByte = DonePdfSeal.addTextToPdfContentByte(pdfContentByte, text, alignment, baseColor, baseFont, fontSize, leftwardX, downwardY, rotationDegree);
                    }
                    float rightwardX = absoluteX;
                    while (true) {
                        float f3;
                        rightwardX += apartX;
                        if (!(f3 < pageWidth + stretchingX)) continue block5;
                        pdfContentByte = DonePdfSeal.addTextToPdfContentByte(pdfContentByte, text, alignment, baseColor, baseFont, fontSize, rightwardX, downwardY, rotationDegree);
                    }
                    break;
                }
                upwardY = absoluteY;
                block8: while (true) {
                    float f;
                    upwardY += apartY;
                    if (!(f < pageHeight + stretchingY)) break;
                    float leftwardX = absoluteX;
                    while (true) {
                        float f4;
                        leftwardX -= apartX;
                        if (!(f4 >= -stretchingX)) break;
                        pdfContentByte = DonePdfSeal.addTextToPdfContentByte(pdfContentByte, text, alignment, baseColor, baseFont, fontSize, leftwardX, upwardY, rotationDegree);
                    }
                    float rightwardX = absoluteX;
                    while (true) {
                        float f5;
                        rightwardX += apartX;
                        if (!(f5 < pageWidth + stretchingX)) continue block8;
                        pdfContentByte = DonePdfSeal.addTextToPdfContentByte(pdfContentByte, text, alignment, baseColor, baseFont, fontSize, rightwardX, upwardY, rotationDegree);
                    }
                    break;
                }
            }
            pdfContentByte = DonePdfSeal.addTextToPdfContentByte(pdfContentByte, text, alignment, baseColor, baseFont, fontSize, absoluteX, absoluteY, rotationDegree);
        }
        stamper.close();
    }

    public static interface GrayStyle {
        public static final int GRAY_TEXT = 1;
        public static final int GRAY_IMAGE_XIF = 2;
        public static final int GRAY_IMAGE_N2 = 4;
    }

    static interface SealType {
        public static final int COORDINATE = 0;
        public static final int BLANKSIGNATURE = 1;
        public static final int KEYWORD = 2;
        public static final int CROSSPAGE = 3;
    }
}

