/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.tools.subsetter;

import cfca.sadk.com.google.typography.font.sfntly.Font;
import cfca.sadk.com.google.typography.font.sfntly.FontFactory;
import cfca.sadk.com.google.typography.font.sfntly.Tag;
import cfca.sadk.com.google.typography.font.sfntly.table.FontDataTable;
import cfca.sadk.com.google.typography.font.sfntly.table.core.CMap;
import cfca.sadk.com.google.typography.font.sfntly.table.core.CMapTable;
import cfca.sadk.com.google.typography.font.tools.subsetter.TableSubsetter;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Subsetter {
    protected final Font font;
    private FontFactory fontFactory;
    protected Set<TableSubsetter> tableSubsetters;
    private Set<Integer> removeTables;
    private List<Integer> newToOldGlyphs;
    private List<CMapTable.CMapId> cmapIds;
    private Map<Integer, Integer> oldToNewGlyphs = null;

    protected Subsetter(Font font, FontFactory fontFactory) {
        this.font = font;
        this.fontFactory = fontFactory;
    }

    public void setGlyphs(List<Integer> glyphs) {
        this.newToOldGlyphs = new ArrayList<Integer>(glyphs);
    }

    public void setCMaps(List<CMapTable.CMapId> cmapIds, int number) {
        this.cmapIds = new ArrayList<CMapTable.CMapId>();
        CMapTable cmapTable = (CMapTable)this.font.getTable(Tag.cmap);
        if (cmapTable == null) {
            throw new InvalidParameterException("Font has no cmap table.");
        }
        for (CMapTable.CMapId cmapId : cmapIds) {
            CMap cmap = cmapTable.cmap(cmapId);
            if (cmap == null) continue;
            this.cmapIds.add(cmap.cmapId());
            if (--number > 0) continue;
            break;
        }
        if (this.cmapIds.size() == 0) {
            this.cmapIds = null;
            throw new InvalidParameterException("CMap Id settings would generate font with no cmap sub-table.");
        }
    }

    public void setRemoveTables(Set<Integer> removeTables) {
        this.removeTables = new HashSet<Integer>(removeTables);
    }

    public Font.Builder subset() throws IOException {
        Font.Builder fontBuilder = this.fontFactory.newFontBuilder();
        this.setUpTables(fontBuilder);
        TreeSet<Integer> tableTags = new TreeSet<Integer>(this.font.tableMap().keySet());
        if (this.removeTables != null) {
            tableTags.removeAll(this.removeTables);
        }
        for (TableSubsetter tableSubsetter : this.tableSubsetters) {
            boolean handled = tableSubsetter.subset(this, this.font, fontBuilder);
            if (!handled) continue;
            tableTags.removeAll(tableSubsetter.tagsHandled());
        }
        for (Integer tag : tableTags) {
            Object table = this.font.getTable(tag);
            if (table == null) continue;
            fontBuilder.newTableBuilder(tag, ((FontDataTable)table).readFontData());
        }
        return fontBuilder;
    }

    List<Integer> glyphMappingTable() {
        return this.newToOldGlyphs;
    }

    Map<Integer, Integer> getInverseMapping() {
        if (this.oldToNewGlyphs == null) {
            this.oldToNewGlyphs = new HashMap<Integer, Integer>();
            List<Integer> mapping = this.glyphMappingTable();
            for (int i = 0; i < mapping.size(); ++i) {
                this.oldToNewGlyphs.put(mapping.get(i), i);
            }
        }
        return this.oldToNewGlyphs;
    }

    List<CMapTable.CMapId> cmapId() {
        return this.cmapIds;
    }

    protected void setUpTables(Font.Builder fontBuilder) {
    }
}

