/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.transaction.util;

import cfca.paperless.base.bean.FieldBean;
import cfca.paperless.base.bean.ImageBean;
import cfca.paperless.base.bean.ImageInfoBean;
import cfca.paperless.base.bean.PdfBean;
import cfca.paperless.base.bean.SynthesizeMultiDataBean;
import cfca.paperless.base.bean.TextBean;
import cfca.paperless.base.client.requestBody.AddWaterMarkToPdfRequestBody;
import cfca.paperless.base.client.requestBody.ConcatPdfListRequestBody;
import cfca.paperless.base.client.requestBody.MakeSquareSealImageRequestBody;
import cfca.paperless.base.client.requestBody.SynthesizeBusinessDataRequestBody;
import cfca.paperless.base.client.requestBody.SynthesizeMultiDataRequestBody;
import cfca.paperless.base.client.requestBody.TransformImageToPdfRequestBody;
import cfca.paperless.base.client.requestBody.TransformPdfToImageRequestBody;
import cfca.paperless.base.client.requestBody.VerifyPdfSealRequestBody;
import cfca.paperless.base.exception.CodeException;
import cfca.paperless.base.strategy.ImageStrategy;
import cfca.paperless.base.strategy.WaterMarkStrategy;
import cfca.paperless.base.transaction.bean.RequestHeadBean;
import cfca.paperless.base.util.FileUtil;
import cfca.paperless.base.util.JsonUtil;
import cfca.paperless.base.util.StringUtil;
import cfca.paperless.base.util.validity.ValidityUtil;
import cfca.sadk.util.Base64;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JosonParseObjectUtil {
    private static final Logger log = LoggerFactory.getLogger(JosonParseObjectUtil.class);

    public static RequestHeadBean jsonParseHeadJsonStr(String headJsonStr) throws CodeException, IOException {
        if (StringUtil.isEmpty(headJsonStr)) {
            log.info("headJsonStr is empty");
            throw new CodeException("600401", "headJsonStr is empty");
        }
        RequestHeadBean headBean = JsonUtil.json2Obj(headJsonStr, RequestHeadBean.class);
        if (headBean == null) {
            log.info("headJsonStr is empty");
            throw new CodeException("600401", "headJsonStr is empty");
        }
        if (StringUtil.isEmpty(headBean.getTransactionNo())) {
            log.info("transactionNo is empty");
            throw new CodeException("600401", "transactionNo is empty");
        }
        if (StringUtil.isContainChinese(headBean.getTransactionNo())) {
            log.info("transactionNo has Chinese character");
            throw new CodeException("", " transactionNo has Chinese character");
        }
        if (!StringUtil.validateStrMaxLength(headBean.getTransactionNo(), 32)) {
            log.info("transactionNo is longer than 32");
            throw new CodeException("", "transactionNo is longer than 32");
        }
        if (StringUtil.isEmpty(headBean.getOrganizationCode())) {
            log.info("organizationCode is empty");
            throw new CodeException("600401", "organizationCode is empty");
        }
        if (StringUtil.isContainChinese(headBean.getOrganizationCode())) {
            log.info("organizationCode has Chinese character");
            throw new CodeException("", " organizationCode has Chinese character");
        }
        if (!StringUtil.validateStrMaxLength(headBean.getOrganizationCode(), 32)) {
            log.info("organizationCode is longer than 32");
            throw new CodeException("", "organizationCode is longer than 32");
        }
        if (StringUtil.isNotEmpty(headBean.getOperatorCode())) {
            if (StringUtil.isContainChinese(headBean.getOperatorCode())) {
                log.info("operatorCode has Chinese character");
                throw new CodeException("", " operatorCode has Chinese character");
            }
            if (!StringUtil.validateStrMaxLength(headBean.getOperatorCode(), 32)) {
                log.info("operatorCode longer than 32");
                throw new CodeException("", "operatorCode longer than 32");
            }
        }
        if (StringUtil.isNotEmpty(headBean.getChannelCode())) {
            if (StringUtil.isContainChinese(headBean.getChannelCode())) {
                log.info("channelCode has Chinese character");
                throw new CodeException("", " channelCode has Chinese character");
            }
            if (!StringUtil.validateStrMaxLength(headBean.getChannelCode(), 32)) {
                log.info("channelCode longer than 32");
                throw new CodeException("", "channelCode longer than 32");
            }
        }
        if (StringUtil.isNotEmpty(headBean.getRemark()) && !StringUtil.validateStrMaxLength(headBean.getRemark(), 128)) {
            log.info("remark is longer than 128");
            throw new CodeException("", "remark is longer than 128");
        }
        return headBean;
    }

    public static SynthesizeBusinessDataRequestBody parseSynthesizeBusinessDataJsonStr(String bodyJsonStr, List<byte[]> fileDataList) throws CodeException, IOException {
        if (StringUtil.isEmpty(bodyJsonStr)) {
            log.info("bodyJsonStr is empty");
            throw new CodeException("600401", "bodyJsonStr is empty");
        }
        SynthesizeBusinessDataRequestBody requestData = JsonUtil.json2Obj(bodyJsonStr, SynthesizeBusinessDataRequestBody.class);
        if (!("1".equals(requestData.getInputType()) || "2".equals(requestData.getInputType()) || "3".equals(requestData.getInputType()))) {
            log.info("inputType is error");
            throw new CodeException("inputType is error");
        }
        if ("1".equals(requestData.getInputType())) {
            if (StringUtil.isEmpty(requestData.getInputSource())) {
                log.info("inputSource is empty");
                throw new CodeException("600401", " inputSource is empty");
            }
            byte[] pdfData = FileUtil.getBytesFromFile(requestData.getInputSource());
            requestData.setPdfData(pdfData);
        } else if ("2".equals(requestData.getInputType())) {
            if (null == fileDataList || fileDataList.size() == 0) {
                log.info("inputSource is empty");
                throw new CodeException("600401", " inputSource is empty");
            }
            requestData.setPdfData(fileDataList.get(0));
        }
        List<FieldBean> fieldBeans = requestData.getFieldBeans();
        for (FieldBean fieldBean : fieldBeans) {
            String fieldType = fieldBean.getFieldType();
            if ("text".equals(fieldType) || "checkbox".equals(fieldType)) continue;
            log.info("fieldType is error,not text or checkbox");
            throw new CodeException("fieldType is error,not text or checkbox");
        }
        List<TextBean> textBeans = requestData.getTextBeans();
        for (TextBean textBean : textBeans) {
            if ("2".equals(textBean.getType()) || "3".equals(textBean.getType())) continue;
            log.info("type is not 2 or 3");
            throw new CodeException("type is not 2 or 3");
        }
        List<ImageInfoBean> list = requestData.getImageBeans();
        for (ImageInfoBean imageBean : list) {
            if (!"1".equals(imageBean.getImageType()) && !"2".equals(imageBean.getImageType())) {
                log.info("inputType is not 1 or 2");
                throw new CodeException("inputType is not 1 or 2");
            }
            if ("1".equals(imageBean.getImageType())) {
                if (StringUtil.isEmpty(imageBean.getImageSource())) {
                    log.info("imageSource is empty");
                    throw new CodeException("600401", " imageSource is empty");
                }
                byte[] imageData = FileUtil.getBytesFromFile(imageBean.getImageSource());
                imageBean.setImageData(imageData);
            } else if ("2".equals(imageBean.getImageType())) {
                String ImageDataStr = imageBean.getImageSource();
                byte[] imageData = Base64.decode((byte[])ImageDataStr.getBytes("UTF-8"));
                imageBean.setImageData(imageData);
            }
            if ("2".equals(imageBean.getType()) || "3".equals(imageBean.getType())) continue;
            log.info("type is not 2 or 3");
            throw new CodeException("type is not 2 or 3");
        }
        return requestData;
    }

    public static SynthesizeMultiDataRequestBody parseSynthesizeMultiDataJsonStr(String bodyJsonStr, List<byte[]> fileDataList) throws CodeException, IOException {
        if (StringUtil.isEmpty(bodyJsonStr)) {
            log.info("bodyJsonStr is empty");
            throw new CodeException("600401", "bodyJsonStr is empty");
        }
        SynthesizeMultiDataRequestBody requestData = JsonUtil.json2Obj(bodyJsonStr, SynthesizeMultiDataRequestBody.class);
        if (!("1".equals(requestData.getInputType()) || "2".equals(requestData.getInputType()) || "3".equals(requestData.getInputType()))) {
            log.info("inputType is not 1 or 2 or 3");
            throw new CodeException("inputType is not 1 or 2 or 3");
        }
        if ("1".equals(requestData.getInputType())) {
            if (StringUtil.isEmpty(requestData.getInputSource())) {
                log.info("inputSource is empty");
                throw new CodeException("600401", " inputSource is empty");
            }
            byte[] pdfData = FileUtil.getBytesFromFile(requestData.getInputSource());
            requestData.setPdfData(pdfData);
        } else if ("2".equals(requestData.getInputType())) {
            if (null == fileDataList || fileDataList.size() == 0) {
                log.info("inputSource is empty");
                throw new CodeException("600401", " inputSource  is empty");
            }
            requestData.setPdfData(fileDataList.get(0));
        }
        List<SynthesizeMultiDataBean> multiDataBeans = requestData.getMultiDataBeans();
        if (multiDataBeans == null || multiDataBeans.size() == 0) {
            log.info("multiDataBeans is empty");
            throw new CodeException("600401", "multiDataBeans is empty");
        }
        for (SynthesizeMultiDataBean multiDataBean : multiDataBeans) {
            if (StringUtil.isEmpty(multiDataBean.getFileName())) {
                log.info("fileName is empty");
                throw new CodeException("600401", "fileName is empty");
            }
            if (StringUtil.isEmpty(multiDataBean.getFileDataHash())) {
                log.info("fileDataHash is empty");
                throw new CodeException("600401", "fileDataHash is empty");
            }
            if (!StringUtil.isNotEmpty(multiDataBean.getFileData())) continue;
            String fileDataStr = multiDataBean.getFileData();
            byte[] fileData = Base64.decode((byte[])fileDataStr.getBytes("UTF-8"));
            multiDataBean.setFileDataByte(fileData);
        }
        return requestData;
    }

    public static ConcatPdfListRequestBody parseConcatPdfListRequestDataJsonStr(String bodyJsonStr, List<byte[]> fileDataList) throws CodeException, IOException {
        if (StringUtil.isEmpty(bodyJsonStr)) {
            log.info("bodyJsonStr is empty");
            throw new CodeException("600401", "bodyJsonStr is empty");
        }
        ConcatPdfListRequestBody requestData = JsonUtil.json2Obj(bodyJsonStr, ConcatPdfListRequestBody.class);
        List<PdfBean> pdfBeans = requestData.getPdfBeans();
        if (pdfBeans == null || pdfBeans.size() == 0) {
            log.info("pdfBeans is empty");
            throw new CodeException("600401", "pdfBeans is empty");
        }
        int i = 0;
        for (PdfBean pdfBean : pdfBeans) {
            if (!"1".equals(pdfBean.getInputType()) && !"2".equals(pdfBean.getInputType())) {
                log.info("inputType is not 1 or 2");
                throw new CodeException("", "inputType is not 1 or 2");
            }
            if ("1".equals(pdfBean.getInputType())) {
                if (StringUtil.isEmpty(pdfBean.getInputSource())) {
                    log.info("inputSource is  empty");
                    throw new CodeException("600401", " inputSource is empty");
                }
                byte[] pdfData = FileUtil.getBytesFromFile(pdfBean.getInputSource());
                pdfBean.setPdfData(pdfData);
                continue;
            }
            if (!"2".equals(pdfBean.getInputType())) continue;
            if (null == fileDataList || fileDataList.size() == 0) {
                log.info("inputSource is empty");
                throw new CodeException("600401", " inputSource  is empty");
            }
            pdfBean.setPdfData(fileDataList.get(i++));
        }
        return requestData;
    }

    public static AddWaterMarkToPdfRequestBody parseAddWaterMarkToPdfRequestDataJsonStr(String bodyJsonStr, List<byte[]> fileDataList) throws CodeException, IOException {
        if (StringUtil.isEmpty(bodyJsonStr)) {
            log.info("bodyJsonStr is empty");
            throw new CodeException("600401", "bodyJsonStr is empty");
        }
        AddWaterMarkToPdfRequestBody requestData = JsonUtil.json2Obj(bodyJsonStr, AddWaterMarkToPdfRequestBody.class);
        if (!("1".equals(requestData.getInputType()) || "2".equals(requestData.getInputType()) || "3".equals(requestData.getInputType()))) {
            log.info("inputType is not 1 or 2 or 3");
            throw new CodeException("", "inputType is not 1 or 2 or 3");
        }
        if ("1".equals(requestData.getInputType())) {
            if (StringUtil.isEmpty(requestData.getInputSource())) {
                log.info("inputSource is empty");
                throw new CodeException("600401", " inputSource is empty");
            }
            byte[] pdfData = FileUtil.getBytesFromFile(requestData.getInputSource());
            requestData.setPdfData(pdfData);
        } else if ("2".equals(requestData.getInputType())) {
            if (null == fileDataList || fileDataList.size() == 0) {
                log.info("inputSource is empty");
                throw new CodeException("600401", " inputSource is empty");
            }
            requestData.setPdfData(fileDataList.get(0));
        }
        WaterMarkStrategy waterMarkStrategy = requestData.getWaterMarkStrategy();
        String fromPageStr = waterMarkStrategy.getFromPage();
        ValidityUtil.checkNotNegativeRangeAndNotEmpty(fromPageStr, "\u8d77\u59cb\u9875", 0);
        int fromPage = Integer.parseInt(fromPageStr);
        ValidityUtil.checkNotNegativeRangeAndNotEmpty(waterMarkStrategy.getToPage(), "\u7ed3\u675f\u9875", fromPage);
        if (waterMarkStrategy.getFitWidth() <= 0.0f) {
            log.info("fitWidth is less than 0");
            throw new CodeException("", " fitWidth is less than 0");
        }
        if (waterMarkStrategy.getFitHeight() <= 0.0f) {
            log.info("fitHeight is less than 0");
            throw new CodeException("", " fitHeight is less than 0 ");
        }
        if (StringUtil.isNotEmpty(waterMarkStrategy.getWaterMarkImage())) {
            String waterMarkImageStr = waterMarkStrategy.getWaterMarkImage();
            byte[] waterMarkImage = Base64.decode((byte[])waterMarkImageStr.getBytes("UTF-8"));
            waterMarkStrategy.setWaterMarkImageData(waterMarkImage);
        }
        return requestData;
    }

    public static MakeSquareSealImageRequestBody parseMakeRectangleSealImageRequestDataJsonStr(String bodyJsonStr) throws IOException, CodeException {
        if (StringUtil.isEmpty(bodyJsonStr)) {
            log.info("bodyJsonStr is empty");
            throw new CodeException("600401", "bodyJsonStr is empty");
        }
        MakeSquareSealImageRequestBody requestData = JsonUtil.json2Obj(bodyJsonStr, MakeSquareSealImageRequestBody.class);
        if (!"1".equals(requestData.getCustomerType()) && !"2".equals(requestData.getCustomerType())) {
            log.info("customerType is not 1 or 2");
            throw new CodeException("", "customerType is not 1 or 2");
        }
        ImageStrategy imageStrategy = requestData.getImageStrategy();
        if (imageStrategy == null) {
            log.info("imageStrategy is empty");
            throw new CodeException("600401", "imageStrategy is empty");
        }
        if (StringUtil.isEmpty(imageStrategy.getImageName())) {
            log.info("imageName is empty");
            throw new CodeException("600401", "imageName is empty");
        }
        if (!StringUtil.validateStrMaxLength(imageStrategy.getImageName(), 128)) {
            log.info("imageName is longer than 128");
            throw new CodeException("", "imageName is longer than 128");
        }
        if (!("1".equals(imageStrategy.getImageShape()) || "11".equals(imageStrategy.getImageShape()) || "2".equals(imageStrategy.getImageShape()) || "21".equals(imageStrategy.getImageShape()) || "3".equals(imageStrategy.getImageShape()) || "4".equals(imageStrategy.getImageShape()))) {
            log.info("imageShape is invalid");
            throw new CodeException("", "imageShape is invalid");
        }
        return requestData;
    }

    public static TransformImageToPdfRequestBody parseTransformImageToPdfRequestDataJsonStr(String bodyJsonStr) throws CodeException, IOException {
        if (StringUtil.isEmpty(bodyJsonStr)) {
            log.info("bodyJsonStr is empty");
            throw new CodeException("600401", "bodyJsonStr is empty");
        }
        TransformImageToPdfRequestBody requestData = JsonUtil.json2Obj(bodyJsonStr, TransformImageToPdfRequestBody.class);
        List<ImageBean> imageBeans = requestData.getImages();
        if (imageBeans == null || imageBeans.size() == 0) {
            log.info("images is empty");
            throw new CodeException("600401", "images is empty");
        }
        for (ImageBean imageBean : imageBeans) {
            String imageStr = imageBean.getImage();
            byte[] imageData = Base64.decode((byte[])imageStr.getBytes("UTF-8"));
            imageBean.setImageData(imageData);
        }
        return requestData;
    }

    public static TransformPdfToImageRequestBody parseTransformPdfToImageRequestDataJsonStr(String bodyJsonStr, List<byte[]> fileDataList) throws CodeException, IOException {
        if (StringUtil.isEmpty(bodyJsonStr)) {
            log.info("bodyJsonStr is empty");
            throw new CodeException("600401", "bodyJsonStr is empty");
        }
        TransformPdfToImageRequestBody requestData = JsonUtil.json2Obj(bodyJsonStr, TransformPdfToImageRequestBody.class);
        if (!"1".equals(requestData.getInputType()) && !"2".equals(requestData.getInputType())) {
            log.info("inputType is nto 1 or 2");
            throw new CodeException("", "inputType is nto 1 or 2");
        }
        if ("1".equals(requestData.getInputType())) {
            if (StringUtil.isEmpty(requestData.getInputSource())) {
                log.info(" inputSource is empty ");
                throw new CodeException("600401", " inputSource is empty ");
            }
            byte[] pdfData = FileUtil.getBytesFromFile(requestData.getInputSource());
            requestData.setPdfData(pdfData);
        } else if ("2".equals(requestData.getInputType())) {
            if (null == fileDataList || fileDataList.size() == 0) {
                log.info(" inputSource is empty ");
                throw new CodeException("600401", " inputSource  is empty");
            }
            requestData.setPdfData(fileDataList.get(0));
        }
        ValidityUtil.checkIntegerAndNotEmpty(requestData.getPageNo(), "pageNo");
        return requestData;
    }

    public static VerifyPdfSealRequestBody parseVerifyPdfSealRequestData(String bodyJsonStr, List<byte[]> fileDataList) throws CodeException, IOException {
        if (StringUtil.isEmpty(bodyJsonStr)) {
            log.info("bodyJsonStr is empty");
            throw new CodeException("600401", "bodyJsonStr is empty");
        }
        VerifyPdfSealRequestBody requestData = JsonUtil.json2Obj(bodyJsonStr, VerifyPdfSealRequestBody.class);
        if (!"1".equals(requestData.getInputType()) && !"2".equals(requestData.getInputType())) {
            log.info("inputType is empty");
            throw new CodeException("600401", "inputType is empty");
        }
        if ("1".equals(requestData.getInputType())) {
            if (StringUtil.isEmpty(requestData.getInputSource())) {
                log.info("inputSource is empty");
                throw new CodeException("600401", "inputSource is empty");
            }
            byte[] pdfData = FileUtil.getBytesFromFile(requestData.getInputSource());
            requestData.setPdfData(pdfData);
        } else if ("2".equals(requestData.getInputType())) {
            if (null == fileDataList || fileDataList.size() == 0) {
                log.info(" inputSource is empty");
                throw new CodeException("600401", " inputSource is empty");
            }
            requestData.setPdfData(fileDataList.get(0));
        }
        if (!"1".equals(requestData.getSealVerifyType()) && !"2".equals(requestData.getSealVerifyType())) {
            log.info("sealVerifyType is not 1 or 2");
            throw new CodeException("", "sealVerifyType is not 1 or 2");
        }
        return requestData;
    }
}

