/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.tls.javax.net.ssl.CFCASNIHostName;
import cfca.sadk.tls.javax.net.ssl.CFCASNIServerName;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.sec.RSAHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sun.net.util.IPAddressUtil;

public final class Utilities {
    private static final Logger logger = LoggerFactory.getLogger(RSAHelper.class);

    private Utilities() {
    }

    public static <T> T requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        byte[] copy = new byte[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static void fill(byte[] a, byte val) {
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            a[i] = val;
        }
    }

    public static boolean equals(byte[] a, byte[] a2) {
        if (a == a2) {
            return true;
        }
        if (a == null || a2 == null) {
            return false;
        }
        int length = a.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (a[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static List<CFCASNIServerName> addToSNIServerNameList(List<CFCASNIServerName> serverNames, String hostname) {
        CFCASNIHostName sniHostName = Utilities.rawToSNIHostName(hostname);
        if (sniHostName == null) {
            return serverNames;
        }
        int size = serverNames.size();
        ArrayList<CFCASNIServerName> sniList = size != 0 ? new ArrayList<CFCASNIServerName>(serverNames) : new ArrayList(1);
        boolean reset = false;
        for (int i = 0; i < size; ++i) {
            CFCASNIServerName serverName = (CFCASNIServerName)sniList.get(i);
            if (serverName.getType() != 0) continue;
            sniList.set(i, sniHostName);
            if (Debugger.check.isDebugEnabled()) {
                Debugger.check.debug("the previous server name in SNI ({}) was replaced with ({})", (Object)serverName, (Object)sniHostName);
            }
            reset = true;
            break;
        }
        if (!reset) {
            sniList.add(sniHostName);
        }
        return Collections.unmodifiableList(sniList);
    }

    private static CFCASNIHostName rawToSNIHostName(String hostname) {
        CFCASNIHostName sniHostName;
        block7: {
            if (logger.isInfoEnabled()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("rawToSNIHostName>>>>>>Running");
                buffer.append("\n hostname: ");
                buffer.append(SADKDebugger.dump((String)hostname));
                logger.info(buffer.toString());
            }
            sniHostName = null;
            if (!(hostname == null || hostname.indexOf(46) <= 0 || hostname.endsWith(".") || IPAddressUtil.isIPv4LiteralAddress(hostname) || IPAddressUtil.isIPv6LiteralAddress(hostname))) {
                try {
                    sniHostName = new CFCASNIHostName(hostname);
                }
                catch (IllegalArgumentException e) {
                    if (Debugger.check.isDebugEnabled()) {
                        Debugger.check.debug("{} is not a legal HostName for  server name indication", (Object)hostname);
                    }
                }
                catch (Exception e) {
                    if (!Debugger.check.isDebugEnabled()) break block7;
                    Debugger.check.debug("{} is not a legal HostName for  server name indication", (Object)hostname);
                }
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("rawToSNIHostName<<<<<<sniHostName: " + sniHostName);
        }
        return sniHostName;
    }
}

