/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.tool.xml.pipeline.end;

import cfca.com.itextpdf.text.Document;
import cfca.com.itextpdf.text.DocumentException;
import cfca.com.itextpdf.text.Element;
import cfca.com.itextpdf.text.log.Logger;
import cfca.com.itextpdf.text.log.LoggerFactory;
import cfca.com.itextpdf.text.pdf.PdfWriter;
import cfca.com.itextpdf.tool.xml.Pipeline;
import cfca.com.itextpdf.tool.xml.PipelineException;
import cfca.com.itextpdf.tool.xml.ProcessObject;
import cfca.com.itextpdf.tool.xml.Tag;
import cfca.com.itextpdf.tool.xml.WorkerContext;
import cfca.com.itextpdf.tool.xml.Writable;
import cfca.com.itextpdf.tool.xml.exceptions.LocaleMessages;
import cfca.com.itextpdf.tool.xml.pipeline.AbstractPipeline;
import cfca.com.itextpdf.tool.xml.pipeline.WritableElement;
import cfca.com.itextpdf.tool.xml.pipeline.ctx.MapContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfWriterPipeline
extends AbstractPipeline<MapContext> {
    private static final Logger LOG = LoggerFactory.getLogger(PdfWriterPipeline.class);
    private Document doc;
    private PdfWriter writer;
    public static final String DOCUMENT = "DOCUMENT";
    public static final String WRITER = "WRITER";
    public static final String CONTINUOUS = "CONTINUOUS";
    private Boolean continiously;

    public PdfWriterPipeline() {
        super(null);
    }

    public PdfWriterPipeline(Pipeline<?> next) {
        super(next);
    }

    public PdfWriterPipeline(Document doc, PdfWriter writer) {
        super(null);
        this.doc = doc;
        this.writer = writer;
        this.continiously = true;
    }

    @Override
    public Pipeline<?> init(WorkerContext context) throws PipelineException {
        MapContext mc = new MapContext();
        this.continiously = Boolean.TRUE;
        mc.put(CONTINUOUS, this.continiously);
        if (null != this.doc) {
            mc.put(DOCUMENT, this.doc);
        }
        if (null != this.writer) {
            mc.put(WRITER, this.writer);
        }
        context.put(this.getContextKey(), mc);
        return super.init(context);
    }

    private void write(WorkerContext context, ProcessObject po) throws PipelineException {
        MapContext mp = (MapContext)this.getLocalContext(context);
        if (po.containsWritable()) {
            Document doc = (Document)mp.get(DOCUMENT);
            boolean continuousWrite = (Boolean)mp.get(CONTINUOUS);
            Writable writable = null;
            while (null != (writable = po.poll())) {
                if (!(writable instanceof WritableElement)) continue;
                for (Element e : ((WritableElement)writable).elements()) {
                    try {
                        if (doc.add(e)) continue;
                        LOG.trace(String.format(LocaleMessages.getInstance().getMessage("pipeline.pdfwriter.elemnotadded"), e.toString()));
                    }
                    catch (DocumentException e1) {
                        if (!continuousWrite) {
                            throw new PipelineException(e1);
                        }
                        LOG.error(LocaleMessages.getInstance().getMessage("pipeline.pdfwriter.elemnotaddedexc"), e1);
                    }
                }
            }
        }
    }

    @Override
    public Pipeline<?> open(WorkerContext context, Tag t, ProcessObject po) throws PipelineException {
        this.write(context, po);
        return this.getNext();
    }

    @Override
    public Pipeline<?> content(WorkerContext context, Tag currentTag, String text, ProcessObject po) throws PipelineException {
        this.write(context, po);
        return this.getNext();
    }

    @Override
    public Pipeline<?> close(WorkerContext context, Tag t, ProcessObject po) throws PipelineException {
        this.write(context, po);
        return this.getNext();
    }

    public void setDocument(Document document) {
        this.doc = document;
    }

    public void setWriter(PdfWriter writer) {
        this.writer = writer;
    }
}

