/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.socket;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.util.Args;

public final class TscSocketFactory
extends SSLSocketFactory {
    private final String[] defaultCipherSuites;
    private final String[] supportedCipherSuites;
    private final SSLSocketFactory sslSocketDelegate;

    public TscSocketFactory(SSLSocketFactory sslSocketDelegate) {
        this.sslSocketDelegate = (SSLSocketFactory)Args.notNull((Object)sslSocketDelegate, (String)"sslSocketDelegate");
        if (sslSocketDelegate.getClass().getName().startsWith("cfca")) {
            String cipherSuite = "TLS_SM2PKEA_SM2DSA_WITH_SM4_CBC_SM3";
            String[] cipherSuites = sslSocketDelegate.getDefaultCipherSuites();
            ArrayList<String> suitesList = new ArrayList<String>(Arrays.asList(cipherSuites));
            suitesList.remove("TLS_SM2PKEA_SM2DSA_WITH_SM4_CBC_SM3");
            suitesList.add(0, "TLS_SM2PKEA_SM2DSA_WITH_SM4_CBC_SM3");
            cipherSuites = suitesList.toArray(new String[suitesList.size()]);
            this.defaultCipherSuites = (String[])cipherSuites.clone();
            this.supportedCipherSuites = (String[])cipherSuites.clone();
        } else {
            this.defaultCipherSuites = (String[])sslSocketDelegate.getDefaultCipherSuites().clone();
            this.supportedCipherSuites = (String[])sslSocketDelegate.getSupportedCipherSuites().clone();
        }
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.defaultCipherSuites;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.supportedCipherSuites;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket socket = this.sslSocketDelegate.createSocket(host, port);
        socket.bind(new InetSocketAddress(0));
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = this.sslSocketDelegate.createSocket(host, port);
        socket.bind(new InetSocketAddress(0));
        return socket;
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.sslSocketDelegate.createSocket(s, host, port, autoClose);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.sslSocketDelegate.createSocket(host, port, localAddress, localPort);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.sslSocketDelegate.createSocket(address, port, localAddress, localPort);
    }
}

