/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.signatures;

import cfca.sadk.com.itextpdf.io.codec.Base64;
import cfca.sadk.com.itextpdf.io.util.SystemUtil;
import cfca.sadk.com.itextpdf.kernel.PdfException;
import cfca.sadk.com.itextpdf.signatures.DigestAlgorithms;
import cfca.sadk.com.itextpdf.signatures.ITSAClient;
import cfca.sadk.com.itextpdf.signatures.ITSAInfoBouncyCastle;
import cfca.sadk.com.itextpdf.signatures.SignUtils;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.cmp.PKIFailureInfo;
import cfca.sadk.org.bouncycastle.tsp.TSPException;
import cfca.sadk.org.bouncycastle.tsp.TimeStampRequest;
import cfca.sadk.org.bouncycastle.tsp.TimeStampRequestGenerator;
import cfca.sadk.org.bouncycastle.tsp.TimeStampResponse;
import cfca.sadk.org.bouncycastle.tsp.TimeStampToken;
import cfca.sadk.org.bouncycastle.tsp.TimeStampTokenInfo;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSAClientBouncyCastle
implements ITSAClient {
    public static final String DEFAULTHASHALGORITHM = "SHA-256";
    public static final int DEFAULTTOKENSIZE = 4096;
    private static final Logger LOGGER = LoggerFactory.getLogger(TSAClientBouncyCastle.class);
    protected String tsaURL;
    protected String tsaUsername;
    protected String tsaPassword;
    protected ITSAInfoBouncyCastle tsaInfo;
    protected int tokenSizeEstimate;
    protected String digestAlgorithm;
    private String tsaReqPolicy;

    public TSAClientBouncyCastle(String url) {
        this(url, null, null, 4096, DEFAULTHASHALGORITHM);
    }

    public TSAClientBouncyCastle(String url, String username, String password) {
        this(url, username, password, 4096, DEFAULTHASHALGORITHM);
    }

    public TSAClientBouncyCastle(String url, String username, String password, int tokSzEstimate, String digestAlgorithm) {
        this.tsaURL = url;
        this.tsaUsername = username;
        this.tsaPassword = password;
        this.tokenSizeEstimate = tokSzEstimate;
        this.digestAlgorithm = digestAlgorithm;
    }

    public void setTSAInfo(ITSAInfoBouncyCastle tsaInfo) {
        this.tsaInfo = tsaInfo;
    }

    @Override
    public int getTokenSizeEstimate() {
        return this.tokenSizeEstimate;
    }

    public String getTSAReqPolicy() {
        return this.tsaReqPolicy;
    }

    public void setTSAReqPolicy(String tsaReqPolicy) {
        this.tsaReqPolicy = tsaReqPolicy;
    }

    @Override
    public MessageDigest getMessageDigest() throws GeneralSecurityException {
        return SignUtils.getMessageDigest(this.digestAlgorithm);
    }

    @Override
    public byte[] getTimeStampToken(byte[] imprint) throws IOException, TSPException {
        int value;
        byte[] respBytes = null;
        TimeStampRequestGenerator tsqGenerator = new TimeStampRequestGenerator();
        tsqGenerator.setCertReq(true);
        if (this.tsaReqPolicy != null && this.tsaReqPolicy.length() > 0) {
            tsqGenerator.setReqPolicy(new ASN1ObjectIdentifier(this.tsaReqPolicy));
        }
        BigInteger nonce = BigInteger.valueOf(SystemUtil.getSystemTimeMillis());
        TimeStampRequest request = tsqGenerator.generate(new ASN1ObjectIdentifier(DigestAlgorithms.getAllowedDigest(this.digestAlgorithm)), imprint, nonce);
        byte[] requestBytes = request.getEncoded();
        respBytes = this.getTSAResponse(requestBytes);
        TimeStampResponse response = new TimeStampResponse(respBytes);
        response.validate(request);
        PKIFailureInfo failure = response.getFailInfo();
        int n = value = failure == null ? 0 : failure.intValue();
        if (value != 0) {
            throw new PdfException("Invalid TSA {0} response code {1}.").setMessageParams(this.tsaURL, String.valueOf(value));
        }
        TimeStampToken tsToken = response.getTimeStampToken();
        if (tsToken == null) {
            throw new PdfException("TSA {0} failed to return time stamp token: {1}.").setMessageParams(this.tsaURL, response.getStatusString());
        }
        TimeStampTokenInfo tsTokenInfo = tsToken.getTimeStampInfo();
        byte[] encoded = tsToken.getEncoded();
        LOGGER.info("Timestamp generated: " + tsTokenInfo.getGenTime());
        if (this.tsaInfo != null) {
            this.tsaInfo.inspectTimeStampTokenInfo(tsTokenInfo);
        }
        this.tokenSizeEstimate = encoded.length + 32;
        return encoded;
    }

    protected byte[] getTSAResponse(byte[] requestBytes) throws IOException {
        SignUtils.TsaResponse response = SignUtils.getTsaResponseForUserRequest(this.tsaURL, requestBytes, this.tsaUsername, this.tsaPassword);
        InputStream inp = response.tsaResponseStream;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = inp.read(buffer, 0, buffer.length)) >= 0) {
            baos.write(buffer, 0, bytesRead);
        }
        byte[] respBytes = baos.toByteArray();
        if (response.encoding != null && response.encoding.toLowerCase().equals("base64".toLowerCase())) {
            respBytes = Base64.decode(new String(respBytes, "US-ASCII"));
        }
        return respBytes;
    }
}

