/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.text;

import cfca.com.itextpdf.text.AccessibleElementId;
import cfca.com.itextpdf.text.Chunk;
import cfca.com.itextpdf.text.Element;
import cfca.com.itextpdf.text.Font;
import cfca.com.itextpdf.text.Image;
import cfca.com.itextpdf.text.List;
import cfca.com.itextpdf.text.ListItem;
import cfca.com.itextpdf.text.Phrase;
import cfca.com.itextpdf.text.api.Indentable;
import cfca.com.itextpdf.text.api.Spaceable;
import cfca.com.itextpdf.text.pdf.PdfName;
import cfca.com.itextpdf.text.pdf.PdfObject;
import cfca.com.itextpdf.text.pdf.PdfPTable;
import cfca.com.itextpdf.text.pdf.interfaces.IAccessibleElement;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Paragraph
extends Phrase
implements Indentable,
Spaceable,
IAccessibleElement {
    private static final long serialVersionUID = 7852314969733375514L;
    protected int alignment = -1;
    protected float indentationLeft;
    protected float indentationRight;
    private float firstLineIndent = 0.0f;
    protected float spacingBefore;
    protected float spacingAfter;
    private float extraParagraphSpace = 0.0f;
    protected boolean keeptogether = false;
    protected PdfName role = PdfName.P;
    protected HashMap<PdfName, PdfObject> accessibleAttributes = null;
    private AccessibleElementId id = null;

    public Paragraph() {
    }

    public Paragraph(float leading) {
        super(leading);
    }

    public Paragraph(Chunk chunk) {
        super(chunk);
    }

    public Paragraph(float leading, Chunk chunk) {
        super(leading, chunk);
    }

    public Paragraph(String string) {
        super(string);
    }

    public Paragraph(String string, Font font) {
        super(string, font);
    }

    public Paragraph(float leading, String string) {
        super(leading, string);
    }

    public Paragraph(float leading, String string, Font font) {
        super(leading, string, font);
    }

    public Paragraph(Phrase phrase) {
        super(phrase);
        if (phrase instanceof Paragraph) {
            Paragraph p = (Paragraph)phrase;
            this.setAlignment(p.alignment);
            this.setIndentationLeft(p.getIndentationLeft());
            this.setIndentationRight(p.getIndentationRight());
            this.setFirstLineIndent(p.getFirstLineIndent());
            this.setSpacingAfter(p.getSpacingAfter());
            this.setSpacingBefore(p.getSpacingBefore());
            this.setExtraParagraphSpace(p.getExtraParagraphSpace());
            this.setRole(p.role);
            this.id = p.getId();
            if (p.accessibleAttributes != null) {
                this.accessibleAttributes = new HashMap<PdfName, PdfObject>(p.accessibleAttributes);
            }
        }
    }

    public Paragraph cloneShallow(boolean spacingBefore) {
        Paragraph copy = new Paragraph();
        copy.setFont(this.getFont());
        copy.setAlignment(this.getAlignment());
        copy.setLeading(this.getLeading(), this.multipliedLeading);
        copy.setIndentationLeft(this.getIndentationLeft());
        copy.setIndentationRight(this.getIndentationRight());
        copy.setFirstLineIndent(this.getFirstLineIndent());
        copy.setSpacingAfter(this.getSpacingAfter());
        if (spacingBefore) {
            copy.setSpacingBefore(this.getSpacingBefore());
        }
        copy.setExtraParagraphSpace(this.getExtraParagraphSpace());
        copy.setRole(this.role);
        copy.id = this.getId();
        if (this.accessibleAttributes != null) {
            copy.accessibleAttributes = new HashMap<PdfName, PdfObject>(this.accessibleAttributes);
        }
        copy.setTabSettings(this.getTabSettings());
        copy.setKeepTogether(this.getKeepTogether());
        return copy;
    }

    public java.util.List<Element> breakUp() {
        ArrayList<Element> list = new ArrayList<Element>();
        ArrayList tmp = null;
        for (Element e : this) {
            if (e.type() == 14 || e.type() == 23 || e.type() == 12) {
                if (tmp != null && tmp.size() > 0) {
                    ((Paragraph)tmp).setSpacingAfter(0.0f);
                    list.add((Element)((Object)tmp));
                    tmp = this.cloneShallow(false);
                }
                if (list.size() == 0) {
                    switch (e.type()) {
                        case 23: {
                            ((PdfPTable)e).setSpacingBefore(this.getSpacingBefore());
                            break;
                        }
                        case 12: {
                            ((Paragraph)e).setSpacingBefore(this.getSpacingBefore());
                            break;
                        }
                        case 14: {
                            ListItem firstItem = ((List)e).getFirstItem();
                            if (firstItem == null) break;
                            firstItem.setSpacingBefore(this.getSpacingBefore());
                            break;
                        }
                    }
                }
                list.add(e);
                continue;
            }
            if (tmp == null) {
                tmp = this.cloneShallow(list.size() == 0);
            }
            ((Paragraph)tmp).add(e);
        }
        if (tmp != null && tmp.size() > 0) {
            list.add((Element)((Object)tmp));
        }
        if (list.size() != 0) {
            Element lastElement = (Element)list.get(list.size() - 1);
            switch (lastElement.type()) {
                case 23: {
                    ((PdfPTable)lastElement).setSpacingAfter(this.getSpacingAfter());
                    break;
                }
                case 12: {
                    ((Paragraph)lastElement).setSpacingAfter(this.getSpacingAfter());
                    break;
                }
                case 14: {
                    ListItem lastItem = ((List)lastElement).getLastItem();
                    if (lastItem == null) break;
                    lastItem.setSpacingAfter(this.getSpacingAfter());
                    break;
                }
            }
        }
        return list;
    }

    @Override
    public int type() {
        return 12;
    }

    @Override
    public boolean add(Element o) {
        if (o instanceof List) {
            List list = (List)o;
            list.setIndentationLeft(list.getIndentationLeft() + this.indentationLeft);
            list.setIndentationRight(this.indentationRight);
            return super.add(list);
        }
        if (o instanceof Image) {
            super.addSpecial(o);
            return true;
        }
        if (o instanceof Paragraph) {
            super.addSpecial(o);
            return true;
        }
        return super.add(o);
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    @Override
    public void setIndentationLeft(float indentation) {
        this.indentationLeft = indentation;
    }

    @Override
    public void setIndentationRight(float indentation) {
        this.indentationRight = indentation;
    }

    public void setFirstLineIndent(float firstLineIndent) {
        this.firstLineIndent = firstLineIndent;
    }

    @Override
    public void setSpacingBefore(float spacing) {
        this.spacingBefore = spacing;
    }

    @Override
    public void setSpacingAfter(float spacing) {
        this.spacingAfter = spacing;
    }

    public void setKeepTogether(boolean keeptogether) {
        this.keeptogether = keeptogether;
    }

    public boolean getKeepTogether() {
        return this.keeptogether;
    }

    public int getAlignment() {
        return this.alignment;
    }

    @Override
    public float getIndentationLeft() {
        return this.indentationLeft;
    }

    @Override
    public float getIndentationRight() {
        return this.indentationRight;
    }

    public float getFirstLineIndent() {
        return this.firstLineIndent;
    }

    @Override
    public float getSpacingBefore() {
        return this.spacingBefore;
    }

    @Override
    public float getSpacingAfter() {
        return this.spacingAfter;
    }

    public float getExtraParagraphSpace() {
        return this.extraParagraphSpace;
    }

    public void setExtraParagraphSpace(float extraParagraphSpace) {
        this.extraParagraphSpace = extraParagraphSpace;
    }

    @Deprecated
    public float spacingBefore() {
        return this.getSpacingBefore();
    }

    @Deprecated
    public float spacingAfter() {
        return this.spacingAfter;
    }

    @Override
    public PdfObject getAccessibleAttribute(PdfName key) {
        if (this.accessibleAttributes != null) {
            return this.accessibleAttributes.get(key);
        }
        return null;
    }

    @Override
    public void setAccessibleAttribute(PdfName key, PdfObject value) {
        if (this.accessibleAttributes == null) {
            this.accessibleAttributes = new HashMap();
        }
        this.accessibleAttributes.put(key, value);
    }

    @Override
    public HashMap<PdfName, PdfObject> getAccessibleAttributes() {
        return this.accessibleAttributes;
    }

    @Override
    public PdfName getRole() {
        return this.role;
    }

    @Override
    public void setRole(PdfName role) {
        this.role = role;
    }

    @Override
    public AccessibleElementId getId() {
        if (this.id == null) {
            this.id = new AccessibleElementId();
        }
        return this.id;
    }

    @Override
    public void setId(AccessibleElementId id) {
        this.id = id;
    }

    @Override
    public boolean isInline() {
        return false;
    }
}

