/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client.sdk;

import cfca.paperless.base.util.Pdf2ImageUtil;
import cfca.paperless.base.util.StringUtil;
import cfca.paperless.client.util.CheckPdfUtil;
import cfca.paperless.dto.ResponseHead;
import cfca.paperless.dto.request.requestbody.tx30.TransformPdfToImageRequestBody;
import cfca.paperless.dto.request.tx30.TransformPdfToImageRequest;
import cfca.paperless.dto.response.responsebody.tx30.TransformPdfToImageResponseBody;
import cfca.paperless.dto.response.tx30.TransformPdfToImageResponse;
import cfca.sadk.seal.base.util.PDFUtil;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformPdfToImageProcess {
    private static final Logger logger = LoggerFactory.getLogger(TransformPdfToImageProcess.class);

    public TransformPdfToImageResponse process(TransformPdfToImageRequest requestBean) throws Exception {
        long start = System.currentTimeMillis();
        logger.info("TransformPdfToImageProcess.process start.");
        TransformPdfToImageRequestBody requestBody = requestBean.getBody();
        byte[] pdfData = new byte[]{};
        if (!"1".equals(requestBody.getInputType()) && !"2".equals(requestBody.getInputType())) {
            throw new Exception("invalid inputType");
        }
        if ("1".equals(requestBody.getInputType())) {
            if (StringUtil.isEmpty((String)requestBody.getInputSource())) {
                throw new Exception("inputSource is null");
            }
            pdfData = FileUtils.readFileToByteArray((File)new File(requestBody.getInputSource()));
        } else if ("2".equals(requestBody.getInputType())) {
            if (requestBody.getPdfData() == null) {
                throw new Exception("pdfData is null");
            }
            if (StringUtil.isEmpty((String)requestBody.getPdfFileDataHash())) {
                logger.error(" pdfFileDataHash is empty");
                throw new Exception(" pdfFileDataHash is empty");
            }
            pdfData = requestBody.getPdfData();
        }
        CheckPdfUtil.checkPdfData(pdfData, false);
        int pageCount = PDFUtil.getPageNums((byte[])pdfData);
        logger.info("PDF\u6587\u4ef6\u9875\u6570\uff1a" + pageCount);
        String outputFolder = System.getProperty("java.io.tmpdir");
        logger.info("outFolder: " + outputFolder);
        int pageNo = Integer.parseInt(requestBody.getPageNo());
        logger.info("pageNo: " + pageNo);
        if (pageNo > pageCount) {
            throw new Exception("PDF\u7b7e\u7ae0\u9875\u7801\u8d85\u51faPDF\u9875\u6570\u9519\u8bef");
        }
        String imageBase64String = Pdf2ImageUtil.pdf2Image((byte[])pdfData, (int)pageNo, (int)pageCount, (String)outputFolder);
        ResponseHead head = new ResponseHead();
        head.setTransactionNo(requestBean.getHead().getTransactionNo());
        TransformPdfToImageResponseBody body = new TransformPdfToImageResponseBody();
        body.setImage(imageBase64String);
        TransformPdfToImageResponse responseBean = new TransformPdfToImageResponse();
        responseBean.setHead(head);
        responseBean.setBody(body);
        long end = System.currentTimeMillis();
        logger.info("TransformPdfToImageProcess.process end. time-taken={}ms", (Object)(end - start));
        return responseBean;
    }
}

